/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.mbeans.DomainStatusMBean;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;

public class DomainStatus
extends NotificationBroadcasterSupport
implements DomainStatusMBean {
    private static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final StringManager localStrings = StringManager.getManager(DomainStatus.class);
    private Map m = Collections.synchronizedMap(new HashMap());

    public int getstate(String serverName) throws Exception {
        sLogger.log(Level.FINE, "DomainStatus.getstate for " + serverName);
        if (serverName != null && serverName.length() > 0) {
            if (this.m.containsKey(serverName)) {
                return (Integer)this.m.get(serverName);
            }
            throw new Exception(localStrings.getString("admin.mbeans.domainStatus.serverNotFound", serverName));
        }
        return 4;
    }

    public void setstate(String serverName, Integer state) throws Exception {
        sLogger.log(Level.FINE, "DomainStatus.setstate for " + serverName);
        if (serverName == null || serverName.length() <= 0) {
            throw new Exception(localStrings.getString("admin.mbeans.domainStatus.serverNotFound", serverName));
        }
        this.m.put(serverName, state);
        this.sendServerStatusChangedNotification(serverName);
    }

    public MBeanServerConnection getServerMBeanServerConnection(String serverName) throws Exception {
        sLogger.log(Level.FINE, "DomainStatus.getServerMBeanServerConnection for " + serverName);
        ConfigContext configContext = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        MBeanServerConnection mbsc = null;
        mbsc = ServerHelper.isDAS(configContext, serverName) ? MBeanServerFactory.getMBeanServer() : ServerHelper.connect(configContext, serverName);
        return mbsc;
    }

    private void sendServerStatusChangedNotification(String serverName) {
        sLogger.log(Level.FINE, "DomainStatus.sendServerStatusChangedNotification for " + serverName);
        Map<String, String> m = Collections.synchronizedMap(new HashMap());
        m.put("ServerName", serverName);
        Notification notification = new Notification("com.sun.appserv.management.status.ServerStatusChanged", (Object)this, 0L, serverName);
        notification.setUserData(m);
        this.sendNotification(notification);
    }
}

