/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.server.core.channel.AdminChannel;
import com.sun.enterprise.admin.server.core.channel.RMIClient;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RRPersistenceHelper {
    private static final Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");

    public void setRestartRequiredForServer(AdminEvent event, AdminEventResult result) {
        if (AdminService.getAdminService() == null) {
            return;
        }
        String resCode = null;
        try {
            if (result != null) {
                resCode = result.getResultCode();
            }
            if (!(resCode != null && resCode.equals("success") || event == null)) {
                this.setRestartRequired(event.getInstanceName(), true);
            }
        }
        catch (Throwable t) {
            _logger.log(Level.INFO, "event.exception_during_restart_reset", t);
        }
    }

    public void setRestartRequired(String inst, boolean restart) {
        try {
            RMIClient client = AdminChannel.getRMIClient(inst);
            if (client == null) {
                _logger.log(Level.INFO, "event.rmi_client_not_found");
            } else {
                client.setRestartNeeded(restart);
            }
        }
        catch (Throwable t) {
            _logger.log(Level.INFO, "event.exception_during_restart_reset", t);
        }
    }

    public void setRestartRequired(boolean restart) {
        String inst = null;
        ServerContext svrCtx = ApplicationServer.getServerContext();
        if (svrCtx != null) {
            inst = svrCtx.getInstanceName();
        }
        this.setRestartRequired(inst, restart);
    }
}

