/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.io;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.base.io.AbstractSerializableS1ASEJBReference;
import com.sun.ejb.containers.BaseContainer;
import com.sun.enterprise.Switch;
import com.sun.enterprise.iiop.SFSBClientVersionManager;
import java.io.IOException;
import java.rmi.Remote;
import java.util.logging.Level;

final class SerializableS1ASEJBObjectReference
extends AbstractSerializableS1ASEJBReference {
    private byte[] instanceKey;
    private Object sfsbKey;
    protected long sfsbClientVersion;
    protected boolean haEnabled;
    private String remoteBusinessInterface;

    SerializableS1ASEJBObjectReference(long containerId, byte[] objKey, int keySize, String remoteBusinessInterfaceName) {
        super(containerId);
        BaseContainer container = (BaseContainer)Switch.getSwitch().getContainerFactory().getContainer(containerId);
        if (container != null) {
            this.haEnabled = container.isHAEnabled();
        }
        this.remoteBusinessInterface = remoteBusinessInterfaceName;
        this.instanceKey = new byte[keySize];
        System.arraycopy(objKey, 12, this.instanceKey, 0, keySize);
    }

    void setSFSBClientVersion(Object key, long val) {
        this.sfsbKey = key;
        this.sfsbClientVersion = val;
    }

    boolean isHAEnabled() {
        return this.haEnabled;
    }

    public Object createObject() throws IOException {
        Object result = null;
        BaseContainer container = (BaseContainer)Switch.getSwitch().getContainerFactory().getContainer(this.containerId);
        if (container == null) {
            _ejbLogger.log(Level.WARNING, "ejb.base.io.EJBOutputStream.null_container: " + this.debugStr);
            result = null;
        } else {
            try {
                if (this.remoteBusinessInterface == null) {
                    Remote reference = container.createRemoteReferenceWithId(this.instanceKey, null);
                    result = AbstractSerializableS1ASEJBReference.doRemoteRefClassLoaderConversion(reference);
                } else {
                    String generatedRemoteIntfName = EJBUtils.getGeneratedRemoteIntfName(this.remoteBusinessInterface);
                    Remote remoteRef = container.createRemoteReferenceWithId(this.instanceKey, generatedRemoteIntfName);
                    Remote newRemoteRef = AbstractSerializableS1ASEJBReference.doRemoteRefClassLoaderConversion(remoteRef);
                    Thread currentThread = Thread.currentThread();
                    ClassLoader contextClassLoader = currentThread.getContextClassLoader();
                    result = EJBUtils.createRemoteBusinessObject(contextClassLoader, this.remoteBusinessInterface, newRemoteRef);
                }
                if (this.haEnabled) {
                    SFSBClientVersionManager.setClientVersion(this.containerId, this.sfsbKey, this.sfsbClientVersion);
                }
            }
            catch (Exception e) {
                IOException ioex = new IOException("remote ref create error");
                ioex.initCause(e);
                throw ioex;
            }
        }
        return result;
    }
}

