/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.oa.poa;

import com.sun.corba.ee.impl.logging.POASystemException;
import com.sun.corba.ee.impl.oa.poa.POAFactory;
import com.sun.corba.ee.impl.oa.poa.POAImpl;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.spi.orbutil.generic.MultiSet;
import com.sun.corba.ee.spi.protocol.PIHandler;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;

public class POAManagerImpl
extends LocalObject
implements POAManager {
    private final POAFactory factory;
    private PIHandler pihandler;
    private State state;
    private Set poas = new HashSet(4);
    private int nInvocations = 0;
    private int nWaiters = 0;
    private int myId = 0;
    private boolean debug;
    private boolean explicitStateChange;
    private static final boolean AM_DEBUG = false;
    private static ThreadLocal<MultiSet<POAManagerImpl>> activeManagers = new ThreadLocal<MultiSet<POAManagerImpl>>(){

        @Override
        public MultiSet<POAManagerImpl> initialValue() {
            return new MultiSet<POAManagerImpl>();
        }
    };

    private String stateToString(State state) {
        switch (state.value()) {
            case 0: {
                return "HOLDING";
            }
            case 1: {
                return "ACTIVE";
            }
            case 2: {
                return "DISCARDING";
            }
            case 3: {
                return "INACTIVE";
            }
        }
        return "State[UNKNOWN]";
    }

    public String toString() {
        return "POAManagerImpl[" + this.myId + "," + this.stateToString(this.state) + ",nInvocations=" + this.nInvocations + ",nWaiters=" + this.nWaiters + "]";
    }

    POAFactory getFactory() {
        return this.factory;
    }

    PIHandler getPIHandler() {
        return this.pihandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void countedWait() {
        try {
            if (this.debug) {
                ORBUtility.dprint((Object)this, "Calling countedWait on POAManager " + (Object)((Object)this) + " nWaiters=" + this.nWaiters);
            }
            ++this.nWaiters;
            ((Object)((Object)this)).wait();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            --this.nWaiters;
            if (this.debug) {
                ORBUtility.dprint((Object)this, "Exiting countedWait on POAManager " + (Object)((Object)this) + " nWaiters=" + this.nWaiters);
            }
        }
    }

    private void notifyWaiters() {
        if (this.debug) {
            ORBUtility.dprint((Object)this, "Calling notifyWaiters on POAManager " + (Object)((Object)this) + " nWaiters=" + this.nWaiters);
        }
        if (this.nWaiters > 0) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    public int getManagerId() {
        return this.myId;
    }

    POAManagerImpl(POAFactory factory, PIHandler pihandler) {
        this.factory = factory;
        factory.addPoaManager(this);
        this.pihandler = pihandler;
        this.myId = factory.newPOAManagerId();
        this.state = State.HOLDING;
        this.debug = factory.getORB().poaDebugFlag;
        this.explicitStateChange = false;
        if (this.debug) {
            ORBUtility.dprint((Object)this, "Creating POAManagerImpl " + (Object)((Object)this));
        }
    }

    synchronized void addPOA(POA poa) {
        if (this.state.value() == 3) {
            POASystemException wrapper = this.factory.getWrapper();
            throw wrapper.addPoaInactive(CompletionStatus.COMPLETED_NO);
        }
        this.poas.add(poa);
    }

    synchronized void removePOA(POA poa) {
        this.poas.remove(poa);
        if (this.poas.isEmpty()) {
            this.factory.removePoaManager(this);
        }
    }

    public short getORTState() {
        switch (this.state.value()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 2: {
                return 2;
            }
        }
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void activate() throws AdapterInactive {
        this.explicitStateChange = true;
        if (this.debug) {
            ORBUtility.dprint((Object)this, "Calling activate on POAManager " + (Object)((Object)this));
        }
        try {
            if (this.state.value() == 3) {
                throw new AdapterInactive();
            }
            this.state = State.ACTIVE;
            this.pihandler.adapterManagerStateChanged(this.myId, this.getORTState());
            this.notifyWaiters();
        }
        finally {
            if (this.debug) {
                ORBUtility.dprint((Object)this, "Exiting activate on POAManager " + (Object)((Object)this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void hold_requests(boolean wait_for_completion) throws AdapterInactive {
        this.explicitStateChange = true;
        if (this.debug) {
            ORBUtility.dprint((Object)this, "Calling hold_requests on POAManager " + (Object)((Object)this));
        }
        try {
            if (this.state.value() == 3) {
                throw new AdapterInactive();
            }
            this.state = State.HOLDING;
            this.pihandler.adapterManagerStateChanged(this.myId, this.getORTState());
            this.notifyWaiters();
            if (wait_for_completion) {
                while (this.state.value() == 0 && this.nInvocations > 0) {
                    this.countedWait();
                }
            }
        }
        finally {
            if (this.debug) {
                ORBUtility.dprint((Object)this, "Exiting hold_requests on POAManager " + (Object)((Object)this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void discard_requests(boolean wait_for_completion) throws AdapterInactive {
        this.explicitStateChange = true;
        if (this.debug) {
            ORBUtility.dprint((Object)this, "Calling hold_requests on POAManager " + (Object)((Object)this));
        }
        try {
            if (this.state.value() == 3) {
                throw new AdapterInactive();
            }
            this.state = State.DISCARDING;
            this.pihandler.adapterManagerStateChanged(this.myId, this.getORTState());
            this.notifyWaiters();
            if (wait_for_completion) {
                while (this.state.value() == 2 && this.nInvocations > 0) {
                    this.countedWait();
                }
            }
        }
        finally {
            if (this.debug) {
                ORBUtility.dprint((Object)this, "Exiting hold_requests on POAManager " + (Object)((Object)this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(boolean etherealize_objects, boolean wait_for_completion) throws AdapterInactive {
        POAManagerImpl pOAManagerImpl;
        this.explicitStateChange = true;
        try {
            pOAManagerImpl = this;
            synchronized (pOAManagerImpl) {
                if (this.debug) {
                    ORBUtility.dprint((Object)this, "Calling deactivate on POAManager " + (Object)((Object)this));
                }
                if (this.state.value() == 3) {
                    throw new AdapterInactive();
                }
                this.state = State.INACTIVE;
                this.pihandler.adapterManagerStateChanged(this.myId, this.getORTState());
                this.notifyWaiters();
            }
            POAManagerDeactivator deactivator = new POAManagerDeactivator(this, etherealize_objects, this.debug);
            if (wait_for_completion) {
                deactivator.run();
            } else {
                Thread thr = new Thread(deactivator);
                thr.start();
            }
        }
        finally {
            pOAManagerImpl = this;
            synchronized (pOAManagerImpl) {
                if (this.debug) {
                    ORBUtility.dprint((Object)this, "Exiting deactivate on POAManager " + (Object)((Object)this));
                }
            }
        }
    }

    public State get_state() {
        return this.state;
    }

    private void checkState() {
        MultiSet<POAManagerImpl> am = activeManagers.get();
        block5: while (this.state.value() != 1) {
            switch (this.state.value()) {
                case 0: {
                    if (am.contains(this)) {
                        return;
                    }
                    if (am.size() == 0) {
                        while (this.state.value() == 0) {
                            this.countedWait();
                        }
                        continue block5;
                    }
                    throw this.factory.getWrapper().poaManagerMightDeadlock();
                }
                case 2: {
                    throw this.factory.getWrapper().poaDiscarding();
                }
                case 3: {
                    throw this.factory.getWrapper().poaInactive();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void enter() {
        try {
            if (this.debug) {
                ORBUtility.dprint((Object)this, "Calling enter for POAManagerImpl " + (Object)((Object)this));
            }
            this.checkState();
            ++this.nInvocations;
            activeManagers.get().add(this);
        }
        finally {
            if (this.debug) {
                ORBUtility.dprint((Object)this, "Exiting enter for POAManagerImpl " + (Object)((Object)this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void exit() {
        try {
            if (this.debug) {
                ORBUtility.dprint((Object)this, "Calling exit for POAManagerImpl " + (Object)((Object)this));
            }
            activeManagers.get().remove(this);
            --this.nInvocations;
            if (this.nInvocations == 0) {
                this.notifyWaiters();
            }
        }
        finally {
            if (this.debug) {
                ORBUtility.dprint((Object)this, "Exiting exit for POAManagerImpl " + (Object)((Object)this));
            }
        }
    }

    public synchronized void implicitActivation() {
        if (!this.explicitStateChange) {
            try {
                this.activate();
            }
            catch (AdapterInactive adapterInactive) {
                // empty catch block
            }
        }
    }

    private class POAManagerDeactivator
    implements Runnable {
        private boolean etherealize_objects;
        private POAManagerImpl pmi;
        private boolean debug;

        POAManagerDeactivator(POAManagerImpl pmi, boolean etherealize_objects, boolean debug) {
            this.etherealize_objects = etherealize_objects;
            this.pmi = pmi;
            this.debug = debug;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block24: {
                POAManagerImpl pOAManagerImpl;
                try {
                    pOAManagerImpl = this.pmi;
                    synchronized (pOAManagerImpl) {
                        if (this.debug) {
                            ORBUtility.dprint(this, "Calling run with etherealize_objects=" + this.etherealize_objects + " pmi=" + (Object)((Object)this.pmi));
                        }
                        while (this.pmi.nInvocations > 0) {
                            POAManagerImpl.this.countedWait();
                        }
                    }
                    if (!this.etherealize_objects) break block24;
                    Iterator iterator = null;
                    POAManagerImpl pOAManagerImpl2 = this.pmi;
                    synchronized (pOAManagerImpl2) {
                        if (this.debug) {
                            ORBUtility.dprint(this, "run: Preparing to etherealize with pmi=" + (Object)((Object)this.pmi));
                        }
                        iterator = new HashSet(this.pmi.poas).iterator();
                    }
                    while (iterator.hasNext()) {
                        ((POAImpl)iterator.next()).etherealizeAll();
                    }
                    pOAManagerImpl2 = this.pmi;
                    synchronized (pOAManagerImpl2) {
                        if (this.debug) {
                            ORBUtility.dprint(this, "run: removing POAManager and clearing poas with pmi=" + (Object)((Object)this.pmi));
                        }
                        POAManagerImpl.this.factory.removePoaManager(this.pmi);
                        POAManagerImpl.this.poas.clear();
                    }
                }
                finally {
                    if (this.debug) {
                        pOAManagerImpl = this.pmi;
                        synchronized (pOAManagerImpl) {
                            ORBUtility.dprint(this, "Exiting run");
                        }
                    }
                }
            }
        }
    }
}

