/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding.fast;

import com.sun.corba.ee.impl.encoding.fast.Codes;
import com.sun.corba.ee.impl.encoding.fast.FastInputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;

public class FastOutputStream {
    private List<ByteBuffer> data = new ArrayList<ByteBuffer>();
    private ByteBuffer current;
    private List<Object> indirections;
    private int currentIndirection;
    private IdentityHashMap<Object, Integer> indirMap;
    private static final int DATA_SIZE = 4096;

    private void allocate() {
        ByteBuffer buff = ByteBuffer.allocate(4096);
        buff.order(ByteOrder.nativeOrder());
        this.data.add(buff);
        this.current = buff;
    }

    public FastOutputStream() {
        this.allocate();
        this.indirections = new ArrayList<Object>(100);
        this.currentIndirection = -1;
        this.indirMap = new IdentityHashMap();
    }

    public FastInputStream getInputStream() {
        for (ByteBuffer buf : this.data) {
            buf.flip();
        }
        return new FastInputStream(this.data);
    }

    public void close() {
        this.data = null;
        this.current = null;
        this.indirections = null;
        this.currentIndirection = -1;
        this.indirMap = null;
    }

    private void put(Codes code) {
        this.put((byte)code.ordinal());
    }

    private void put(boolean value) {
        try {
            this.current.put((byte)(value ? Codes.BOOL_TRUE.ordinal() : Codes.BOOL_FALSE.ordinal()));
        }
        catch (BufferOverflowException exc) {
            this.allocate();
            this.current.put((byte)(value ? Codes.BOOL_TRUE.ordinal() : Codes.BOOL_FALSE.ordinal()));
        }
    }

    private void put(byte value) {
        try {
            this.current.put(value);
        }
        catch (BufferOverflowException exc) {
            this.allocate();
            this.current.put(value);
        }
    }

    private void put(char value) {
        try {
            this.current.putChar(value);
        }
        catch (BufferOverflowException exc) {
            this.allocate();
            this.current.putChar(value);
        }
    }

    private void put(short value) {
        try {
            this.current.putShort(value);
        }
        catch (BufferOverflowException exc) {
            this.allocate();
            this.current.putShort(value);
        }
    }

    private void put(int value) {
        try {
            this.current.putInt(value);
        }
        catch (BufferOverflowException exc) {
            this.allocate();
            this.current.putInt(value);
        }
    }

    private void put(long value) {
        try {
            this.current.putLong(value);
        }
        catch (BufferOverflowException exc) {
            this.allocate();
            this.current.putLong(value);
        }
    }

    private void put(float value) {
        try {
            this.current.putFloat(value);
        }
        catch (BufferOverflowException exc) {
            this.allocate();
            this.current.putFloat(value);
        }
    }

    private void put(double value) {
        try {
            this.current.putDouble(value);
        }
        catch (BufferOverflowException exc) {
            this.allocate();
            this.current.putDouble(value);
        }
    }

    public void writeBoolean(boolean value) {
        this.put(value);
    }

    public void writeChar(char value) {
        this.put(Codes.CHAR);
        this.put(value);
    }

    public void writeByte(byte value) {
        this.put(Codes.BYTE);
        this.put(value);
    }

    public void writeShort(short value) {
        this.put(Codes.SHORT);
        this.put(value);
    }

    public void writeInt(int value) {
        this.put(Codes.INT);
        this.put(value);
    }

    public void writeLong(long value) {
        this.put(Codes.LONG);
        this.put(value);
    }

    public void writeFloat(float value) {
        this.put(Codes.FLOAT);
        this.put(value);
    }

    public void writeDouble(double value) {
        this.put(Codes.DOUBLE);
        this.put(value);
    }

    public void indirectReference(int label) {
        this.put(Codes.REF);
        this.put(label);
    }

    public void writeBooleanArray(boolean[] value) {
        if (!this.primArrayHeader(Codes.BOOL_ARR, value, value.length)) {
            for (int ctr = 0; ctr < value.length; ++ctr) {
                this.put(value[ctr]);
            }
        }
    }

    public void writeCharArray(char[] value) {
        if (!this.primArrayHeader(Codes.CHAR_ARR, value, value.length)) {
            for (int ctr = 0; ctr < value.length; ++ctr) {
                this.put(value[ctr]);
            }
        }
    }

    public void writeByteArray(byte[] value) {
        if (!this.primArrayHeader(Codes.BYTE_ARR, value, value.length)) {
            for (int ctr = 0; ctr < value.length; ++ctr) {
                this.put(value[ctr]);
            }
        }
    }

    public void writeShortArray(short[] value) {
        if (!this.primArrayHeader(Codes.SHORT_ARR, value, value.length)) {
            for (int ctr = 0; ctr < value.length; ++ctr) {
                this.put(value[ctr]);
            }
        }
    }

    public void writeIntArray(int[] value) {
        if (!this.primArrayHeader(Codes.INT_ARR, value, value.length)) {
            for (int ctr = 0; ctr < value.length; ++ctr) {
                this.put(value[ctr]);
            }
        }
    }

    public void writeLongArray(long[] value) {
        if (!this.primArrayHeader(Codes.LONG_ARR, value, value.length)) {
            for (int ctr = 0; ctr < value.length; ++ctr) {
                this.put(value[ctr]);
            }
        }
    }

    public void writeFloatArray(float[] value) {
        if (!this.primArrayHeader(Codes.FLOAT_ARR, value, value.length)) {
            for (int ctr = 0; ctr < value.length; ++ctr) {
                this.put(value[ctr]);
            }
        }
    }

    public void writeDoubleArray(double[] value) {
        if (!this.primArrayHeader(Codes.DOUBLE_ARR, value, value.length)) {
            for (int ctr = 0; ctr < value.length; ++ctr) {
                this.put(value[ctr]);
            }
        }
    }

    public int startReference(String className) {
        this.put(Codes.REF);
        this.writeCharArray(className.toCharArray());
        int label = this.currentIndirection--;
        this.put(label);
        return label;
    }

    public void endReference() {
        this.put(Codes.END);
    }

    private Integer handleIndirection(Object value) {
        if (value == null) {
            this.put(Codes.NULL);
            return null;
        }
        Integer label = this.indirMap.get(value);
        if (label == null) {
            label = this.currentIndirection--;
            this.indirMap.put(value, label);
            return label;
        }
        this.indirectReference(label);
        return null;
    }

    private boolean primArrayHeader(Codes code, Object value, int size) {
        Integer label = this.handleIndirection(value);
        if (label != null) {
            this.put(code);
            this.put(label);
            this.put(size);
            return true;
        }
        return false;
    }

    public void writeReference(Object value) {
        Integer label = this.handleIndirection(value);
        if (label != null) {
            this.put(Codes.REF);
            this.writeCharArray(value.getClass().getName().toCharArray());
            this.put(label);
        }
        this.put(Codes.END);
    }

    public void startReferenceArray(Object value, String className, int size) {
        Integer label = this.handleIndirection(value);
        if (label != null) {
            this.put(Codes.REF_ARR);
            this.writeCharArray(value.getClass().getComponentType().getName().toCharArray());
            this.put(label);
            this.put(size);
        }
    }
}

