/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.ejb.spi.sfsb.store.SFSBStoreManager;
import com.sun.enterprise.admin.event.AdminEventListener;
import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.event.availability.AvailabilityServiceEvent;
import com.sun.enterprise.admin.event.availability.AvailabilityServiceEventListener;
import com.sun.enterprise.ee.web.sessmgmt.CleanupCapable;
import com.sun.enterprise.ee.web.sessmgmt.ConfigChangeElement;
import com.sun.enterprise.ee.web.sessmgmt.EEAvailabilityServiceEventListener;
import com.sun.enterprise.security.store.IdentityManager;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.web.HealthChecker;
import com.sun.enterprise.web.SchemaUpdater;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebContainerStartStopOperation;
import com.sun.hadb.dbstate.DbState;
import com.sun.logging.LogDomains;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LifecycleException;

public class EEHADBHealthChecker
implements HealthChecker,
Runnable {
    private static Logger _logger = null;
    private static boolean _hadbOperationalFlag = true;
    private BooleanWrapper _healthCheckEnabledFlag = new BooleanWrapper();
    private static EEHADBHealthChecker _soleInstance = null;
    private static int _sleepIntervalSeconds = 5;
    protected boolean started = false;
    protected Thread thread = null;
    protected boolean threadDone = false;
    protected String _threadName = "EEHADBHealthChecker";
    protected static final Hashtable _containerId2StoreManager = new Hashtable();
    protected WebContainer _webContainer = null;
    protected static boolean runtimeHealthCheckExceptionReported = false;
    protected String hadbAgentConnectionUrl = null;
    protected boolean hadbAgentConnectionUrlErrorReported = false;
    protected String hadbDatabaseName = null;
    protected boolean hadbDatabaseNameErrorReported = false;
    protected String hadbAgentPassword = null;
    protected boolean hadbAgentPasswordErrorReported = false;
    protected String hadbAgentHosts = null;
    protected boolean hadbAgentHostsErrorReported = false;
    protected String hadbAgentPort = null;
    protected boolean hadbAgentPortErrorReported = false;
    protected int haStoreHealthcheckIntervalInSeconds = -1;
    protected AvailabilityServiceEventListener adminListener = null;
    protected static final String HEALTH_CHECK_INTERVAL = "ha-store-healthcheck-interval-in-seconds";
    protected static final String HEALTH_CHECK_ENABLED = "ha-store-healthcheck-enabled";
    protected static final String HA_AGENT_HOSTS = "ha-agent-hosts";
    protected static final String HA_AGENT_PORT = "ha-agent-port";
    protected static final String HA_AGENT_CONNECTION_URL = "ha-agent-connection-url";
    protected static final String HA_STORE_NAME = "ha-store-name";

    public String getThreadName() {
        return this._threadName;
    }

    public EEHADBHealthChecker(WebContainer webContainer) {
        this._webContainer = webContainer;
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
    }

    public static EEHADBHealthChecker createInstance(WebContainer webContainer) {
        if (_soleInstance == null) {
            _soleInstance = new EEHADBHealthChecker(webContainer);
        }
        return _soleInstance;
    }

    public static EEHADBHealthChecker getInstance() {
        return _soleInstance;
    }

    public void registerAdminEvents() {
        this.adminListener = new EEAvailabilityServiceEventListener(this);
        AdminEventListenerRegistry.addEventListener((String)AvailabilityServiceEvent.eventType, (AdminEventListener)this.adminListener);
    }

    public void unregisterAdminEvents() {
        AdminEventListenerRegistry.removeEventListener((AdminEventListener)this.adminListener);
        this.adminListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetConfigAttributes(ArrayList changedAttributes) {
        if (changedAttributes.size() == 0) {
            return;
        }
        EEHADBHealthChecker eEHADBHealthChecker = this;
        synchronized (eEHADBHealthChecker) {
            for (int i = 0; i < changedAttributes.size(); ++i) {
                int newInterval;
                ConfigChangeElement nextElement = (ConfigChangeElement)changedAttributes.get(i);
                String nextAttrName = nextElement.getName();
                if (nextAttrName.equals(HA_STORE_NAME)) {
                    this.hadbDatabaseName = (String)nextElement.getValue();
                    this.hadbDatabaseNameErrorReported = false;
                    if (!_logger.isLoggable(Level.FINEST)) continue;
                    _logger.finest("EEHADBHealthChecker:resetting ha database name = " + this.hadbDatabaseName);
                    continue;
                }
                if (nextAttrName.equals(HA_AGENT_HOSTS)) {
                    this.hadbAgentHosts = (String)nextElement.getValue();
                    this.hadbAgentHostsErrorReported = false;
                    this.hadbAgentConnectionUrl = null;
                    this.hadbAgentConnectionUrlErrorReported = false;
                    if (!_logger.isLoggable(Level.FINEST)) continue;
                    _logger.finest("EEHADBHealthChecker:resetting ha agent hosts = " + this.hadbAgentHosts);
                    continue;
                }
                if (nextAttrName.equals(HA_AGENT_PORT)) {
                    this.hadbAgentPort = (String)nextElement.getValue();
                    this.hadbAgentPortErrorReported = false;
                    this.hadbAgentConnectionUrl = null;
                    this.hadbAgentConnectionUrlErrorReported = false;
                    if (!_logger.isLoggable(Level.FINEST)) continue;
                    _logger.finest("EEHADBHealthChecker:resetting ha agent port = " + this.hadbAgentPort);
                    continue;
                }
                if (nextAttrName.equals(HA_AGENT_CONNECTION_URL)) {
                    this.hadbAgentConnectionUrl = (String)nextElement.getValue();
                    this.hadbAgentConnectionUrlErrorReported = false;
                    if (!_logger.isLoggable(Level.FINEST)) continue;
                    _logger.finest("EEHADBHealthChecker:resetting ha agent connection url = " + this.hadbAgentConnectionUrl);
                    continue;
                }
                if (nextAttrName.equals(HEALTH_CHECK_ENABLED)) {
                    this.getHealthCheckEnabledWrapper().setValue((Boolean)nextElement.getValue());
                    if (!_logger.isLoggable(Level.FINEST)) continue;
                    _logger.finest("EEHADBHealthChecker:resetting healthCheckEnabled = " + this.getHealthCheckEnabledWrapper().getValue());
                    continue;
                }
                if (!nextAttrName.equals(HEALTH_CHECK_INTERVAL) || (newInterval = ((Integer)nextElement.getValue()).intValue()) <= 0) continue;
                this.haStoreHealthcheckIntervalInSeconds = newInterval;
                if (!_logger.isLoggable(Level.FINEST)) continue;
                _logger.finest("EEHADBHealthChecker:resetting haStoreHealthcheckIntervalInSeconds = " + newInterval);
            }
        }
    }

    public void start() throws LifecycleException {
        EEHADBHealthChecker.initializeHealthCheckEnabledFlag();
        if (this.started) {
            return;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("HADB health checking enabled");
        }
        this.registerAdminEvents();
        this.threadStart();
        this.started = true;
    }

    protected void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        this.thread = new Thread((Runnable)this, this.getThreadName());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.unregisterAdminEvents();
        this.threadStop();
        this.started = false;
    }

    boolean isStarted() {
        return this.started;
    }

    Thread getThread() {
        return this.thread;
    }

    protected void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    protected void threadSleep() {
        _sleepIntervalSeconds = this.getHaStoreHealthcheckIntervalInSeconds();
        try {
            Thread.sleep((long)_sleepIntervalSeconds * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.doHADBHealthCheck();
        }
    }

    protected boolean doHADBHealthCheck() {
        return this.doHADBHealthCheck(false);
    }

    protected boolean doHADBHealthCheck(boolean quickCheck) {
        boolean healthyWithTables;
        if (!EEHADBHealthChecker.isHealthCheckingEnabled()) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("health check disabled - skipping");
            }
            return true;
        }
        if (runtimeHealthCheckExceptionReported) {
            return true;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("health check enabled - entering isDatabaseOk()()");
        }
        boolean hadbAlive = this.isDatabaseOk();
        boolean lastHADBState = EEHADBHealthChecker.isHADBOperational();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("HADBHealthCheck: HADB is alive: " + hadbAlive);
        }
        if (runtimeHealthCheckExceptionReported || this.hasAgentConfigErrorOccurred()) {
            return true;
        }
        boolean tablesExist = true;
        if (!lastHADBState && hadbAlive) {
            tablesExist = EEHADBHealthChecker.doHADBTablesExist();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("HADBHealthCheck: HADB tables exist: " + tablesExist);
            }
        }
        boolean bl = healthyWithTables = hadbAlive && tablesExist;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("HADBHealthCheck: HADB healthyWithTables: " + healthyWithTables);
        }
        EEHADBHealthChecker.setHADBOperational(healthyWithTables);
        this.issueHealthWarning(lastHADBState, hadbAlive, tablesExist);
        if (lastHADBState && !hadbAlive && !quickCheck) {
            this.doHADBShutdownCleanup();
        }
        return EEHADBHealthChecker.isHADBOperational();
    }

    private void issueHealthWarning(boolean lastHADBState, boolean hadbAlive, boolean tablesExist) {
        if (lastHADBState && !hadbAlive) {
            _logger.log(Level.WARNING, "hadbhealthchecker.hadbUnhealthy");
        }
        if (!lastHADBState && hadbAlive) {
            _logger.log(Level.WARNING, "hadbhealthchecker.hadbHealthy");
            if (!tablesExist) {
                _logger.log(Level.WARNING, "hadbhealthchecker.hadbTablesMissing");
            }
        }
    }

    public static boolean doHADBTablesExist() {
        boolean result = true;
        ServerContext serverContext = ApplicationServer.getServerContext();
        SchemaUpdater updater = serverContext.getPluggableFeatureFactory().getSchemaUpdater();
        try {
            result = updater.doTablesExist();
        }
        catch (SQLException ex) {
            result = false;
        }
        catch (ClassNotFoundException ex1) {
            result = false;
        }
        return result;
    }

    public static boolean doQuickHADBHealthCheck() {
        boolean result = true;
        if (!EEHADBHealthChecker.isHADBOperational()) {
            result = false;
        } else if (EEHADBHealthChecker.getInstance() != null) {
            result = EEHADBHealthChecker.getInstance().doHADBHealthCheck();
        }
        return result;
    }

    private void doHADBShutdownCleanup() {
        if (this.getWebContainer() != null) {
            WebContainerStartStopOperation startStopOperation = this.getWebContainer().getWebContainerStartStopOperation();
            ArrayList shutdownCleanupCapablesList = startStopOperation.doPreStop();
            startStopOperation.doPostStop(shutdownCleanupCapablesList);
        }
        Collection haSFSBStoreManagers = this.getHASFSBStoreManagers();
        this.closeCachedConnections(haSFSBStoreManagers);
    }

    private void closeCachedConnections(Collection sfsbStoreManagers) {
        if (sfsbStoreManagers == null) {
            return;
        }
        for (Object nextMgr : sfsbStoreManagers) {
            if (!(nextMgr instanceof CleanupCapable)) continue;
            ((CleanupCapable)nextMgr).doCleanup();
        }
    }

    public static void addHASFSBStoreManager(String contId, SFSBStoreManager storeManager) {
        _containerId2StoreManager.put(contId, storeManager);
    }

    public static SFSBStoreManager removeHASFSBStoreManager(String contId) {
        return (SFSBStoreManager)_containerId2StoreManager.remove(contId);
    }

    private static SFSBStoreManager getHASFSBStoreManager(String containerId) {
        return (SFSBStoreManager)_containerId2StoreManager.get(containerId);
    }

    private static Collection getHASFSBStoreManagers() {
        Collection storeManagers = null;
        if (_containerId2StoreManager != null) {
            storeManagers = _containerId2StoreManager.values();
        }
        return storeManagers;
    }

    public boolean isDatabaseOk() {
        boolean result;
        block8: {
            result = true;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("isDatabaseOk() begin:runtimeHealthCheckExceptionReported: " + runtimeHealthCheckExceptionReported);
            }
            if (runtimeHealthCheckExceptionReported) {
                return result;
            }
            String connURL = this.getHadbAgentConnectionURL();
            String hadbDBName = this.getHadbDatabaseName();
            String hadbAgentPassword = this.getHadbAgentPassword();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("isDatabaseOk():HADB Connection URL: " + connURL);
                _logger.finest("isDatabaseOk():HADB DB Name: " + hadbDBName);
                _logger.finest("isDatabaseOk():HADB Agent Password: " + hadbAgentPassword);
            }
            if (connURL == null || hadbDBName == null || hadbAgentPassword == null) {
                return true;
            }
            try {
                DbState dbstate = new DbState(connURL, hadbDBName, hadbAgentPassword);
                int state = dbstate.getState();
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("dbstate reports state = " + state);
                }
                if (state == -20) {
                    _logger.log(Level.WARNING, "hadbhealthchecker.generalConfigurationError");
                    runtimeHealthCheckExceptionReported = true;
                    return true;
                }
                result = dbstate.isAvailable();
            }
            catch (Exception ex) {
                if (runtimeHealthCheckExceptionReported) break block8;
                _logger.log(Level.WARNING, "hadbhealthchecker.generalConfigurationError");
                runtimeHealthCheckExceptionReported = true;
                ex.printStackTrace();
            }
        }
        return result;
    }

    protected boolean hasAgentConfigErrorOccurred() {
        return this.hadbAgentHostsErrorReported || this.hadbAgentPasswordErrorReported || this.hadbAgentPortErrorReported || this.hadbDatabaseNameErrorReported || this.hadbAgentConnectionUrlErrorReported;
    }

    protected String getHadbAgentConnectionURL() {
        if (this.hadbAgentConnectionUrl != null) {
            return this.hadbAgentConnectionUrl;
        }
        this.hadbAgentConnectionUrl = this.getHadbAgentConnectionURLFromConfig();
        if (this.hadbAgentConnectionUrl == null && !this.hadbAgentConnectionUrlErrorReported) {
            _logger.log(Level.WARNING, "hadbhealthchecker.agentConnUrlError");
            this.hadbAgentConnectionUrlErrorReported = true;
        } else if (this.hadbAgentConnectionUrl != null) {
            this.hadbAgentConnectionUrlErrorReported = false;
        }
        return this.hadbAgentConnectionUrl;
    }

    public String getHadbAgentConnectionURLFromConfig() {
        String url = null;
        StringBuffer sb = new StringBuffer();
        String hostsString = this.getHadbAgentHosts();
        String portString = this.getHadbAgentPort();
        if (hostsString != null && portString != null) {
            sb.append(hostsString);
            sb.append(":");
            sb.append(portString);
            url = sb.toString();
        } else {
            url = null;
        }
        return url;
    }

    protected String getDASAdminPassword() {
        return IdentityManager.getPassword();
    }

    protected String getHadbAgentPassword() {
        if (this.hadbAgentPassword != null) {
            return this.hadbAgentPassword;
        }
        this.hadbAgentPassword = this.getHadbAgentPasswordFromConfig();
        if (this.hadbAgentPassword == null) {
            this.hadbAgentPassword = this.getDASAdminPassword();
        }
        if (this.hadbAgentPassword == null && !this.hadbAgentPasswordErrorReported) {
            _logger.log(Level.WARNING, "hadbhealthchecker.agentPasswordError");
            this.hadbAgentPasswordErrorReported = true;
        } else if (this.hadbAgentPassword != null) {
            this.hadbAgentPasswordErrorReported = false;
        }
        return this.hadbAgentPassword;
    }

    protected String getHadbAgentPasswordFromConfig() {
        ServerConfigLookup config = new ServerConfigLookup();
        return config.getHadbAgentPasswordFromConfig();
    }

    protected String getHadbAgentPort() {
        if (this.hadbAgentPort != null) {
            return this.hadbAgentPort;
        }
        this.hadbAgentPort = this.getHadbAgentPortFromConfig();
        if (this.hadbAgentPort == null && !this.hadbAgentPortErrorReported) {
            _logger.log(Level.WARNING, "hadbhealthchecker.agentPortError");
            this.hadbAgentPortErrorReported = true;
        } else if (this.hadbAgentPort != null) {
            this.hadbAgentPortErrorReported = false;
        }
        return this.hadbAgentPort;
    }

    protected String getHadbAgentPortFromConfig() {
        ServerConfigLookup config = new ServerConfigLookup();
        return config.getHadbAgentPortFromConfig();
    }

    protected int getHaStoreHealthcheckIntervalInSecondsFromConfig() {
        ServerConfigLookup config = new ServerConfigLookup();
        return config.getHaStoreHealthcheckIntervalInSecondsFromConfig();
    }

    protected int getHaStoreHealthcheckIntervalInSeconds() {
        if (this.haStoreHealthcheckIntervalInSeconds > 0) {
            return this.haStoreHealthcheckIntervalInSeconds;
        }
        this.haStoreHealthcheckIntervalInSeconds = this.getHaStoreHealthcheckIntervalInSecondsFromConfig();
        return this.haStoreHealthcheckIntervalInSeconds;
    }

    protected String getHadbAgentHosts() {
        if (this.hadbAgentHosts != null) {
            return this.hadbAgentHosts;
        }
        this.hadbAgentHosts = this.getHadbAgentHostsFromConfig();
        if (this.hadbAgentHosts == null && !this.hadbAgentHostsErrorReported) {
            _logger.log(Level.WARNING, "hadbhealthchecker.agentHostsError");
            this.hadbAgentHostsErrorReported = true;
        } else if (this.hadbAgentHosts != null) {
            this.hadbAgentHostsErrorReported = false;
        }
        return this.hadbAgentHosts;
    }

    protected String getHadbAgentHostsFromConfig() {
        ServerConfigLookup config = new ServerConfigLookup();
        return config.getHadbAgentHostsFromConfig();
    }

    protected String getHadbDatabaseName() {
        if (this.hadbDatabaseName != null) {
            return this.hadbDatabaseName;
        }
        this.hadbDatabaseName = this.getHadbDatabaseNameFromConfig();
        if (this.hadbDatabaseName == null && !this.hadbDatabaseNameErrorReported) {
            _logger.log(Level.WARNING, "hadbhealthchecker.agentDatabaseNameError");
            this.hadbDatabaseNameErrorReported = true;
        } else if (this.hadbDatabaseName != null) {
            this.hadbDatabaseNameErrorReported = false;
        }
        return this.hadbDatabaseName;
    }

    protected String getHadbDatabaseNameFromConfig() {
        ServerConfigLookup config = new ServerConfigLookup();
        return config.getHadbDatabaseNameFromConfig();
    }

    private static void initializeHealthCheckEnabledFlag() {
        ServerConfigLookup config = new ServerConfigLookup();
        BooleanWrapper healthCheckEnabledWrapper = EEHADBHealthChecker.getInstance().getHealthCheckEnabledWrapper();
        if (healthCheckEnabledWrapper != null) {
            healthCheckEnabledWrapper.setValue(config.getHadbHealthCheckFromConfig());
        }
    }

    BooleanWrapper getHealthCheckEnabledWrapper() {
        return this._healthCheckEnabledFlag;
    }

    private static boolean isHealthCheckingEnabled() {
        if (EEHADBHealthChecker.getInstance() == null) {
            return false;
        }
        BooleanWrapper healthCheckEnabledWrapper = EEHADBHealthChecker.getInstance().getHealthCheckEnabledWrapper();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("isHealthCheckingEnabled() reporting: " + EEHADBHealthChecker.getInstance().getHealthCheckEnabledWrapper().getValue());
        }
        return healthCheckEnabledWrapper.getValue();
    }

    public static boolean isOkToProceed() {
        if (!EEHADBHealthChecker.isHealthCheckingEnabled()) {
            return true;
        }
        return EEHADBHealthChecker.isHADBOperational();
    }

    public static boolean isHADBOperational() {
        return _hadbOperationalFlag;
    }

    public static void setHADBOperational(boolean value) {
        _hadbOperationalFlag = value;
    }

    protected WebContainer getWebContainer() {
        return this._webContainer;
    }

    public void setWebContainer(WebContainer webContainer) {
        this._webContainer = webContainer;
    }

    class BooleanWrapper {
        Boolean _value = null;

        public BooleanWrapper() {
        }

        public BooleanWrapper(boolean value) {
            this._value = new Boolean(value);
        }

        synchronized boolean getValue() {
            if (!this.isInitialized()) {
                return false;
            }
            return this._value;
        }

        synchronized void setValue(boolean value) {
            this._value = new Boolean(value);
        }

        boolean isInitialized() {
            return this._value != null;
        }
    }
}

