/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.xml;

import com.sun.jsftemplating.layout.LayoutDefinitionException;
import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.descriptors.LayoutDefinition;
import com.sun.jsftemplating.layout.template.TemplateParser;
import com.sun.jsftemplating.layout.xml.XMLLayoutDefinitionReader;
import com.sun.jsftemplating.util.ClasspathEntityResolver;
import com.sun.jsftemplating.util.FileUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import javax.faces.context.FacesContext;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLLayoutDefinitionManager
extends LayoutDefinitionManager {
    private static LayoutDefinitionManager instance = null;
    public static final String ENTITY_RESOLVER = "entityResolver";
    public static final String ERROR_HANDLER = "errorHandler";
    public static final String BASE_URI = "baseURI";

    protected XMLLayoutDefinitionManager() {
        try {
            this.setErrorHandler(new XMLErrorHandler(new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.err, "UTF-8"), true)));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        this.setEntityResolver(new ClasspathEntityResolver());
    }

    public static LayoutDefinitionManager getInstance() {
        if (instance == null) {
            instance = new XMLLayoutDefinitionManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accepts(String key) {
        URL url = FileUtil.searchForFile(key, ".jsf");
        if (url == null) {
            return false;
        }
        TemplateParser parser = new TemplateParser(url);
        try {
            parser.open();
            parser.readUntil("<layoutDefinition>", true);
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            parser.close();
        }
        return true;
    }

    public LayoutDefinition getLayoutDefinition(String key) throws LayoutDefinitionException {
        while (key.startsWith("/")) {
            key = key.substring(1);
        }
        LayoutDefinition ld = XMLLayoutDefinitionManager.getCachedLayoutDefinition(key);
        if (ld == null) {
            URL url = FileUtil.searchForFile(key, ".jsf");
            if (url == null) {
                throw new LayoutDefinitionException("Unable to locate '" + key + "'");
            }
            String baseURI = this.getBaseURI();
            try {
                ld = new XMLLayoutDefinitionReader(url, this.getEntityResolver(), this.getErrorHandler(), baseURI).read();
            }
            catch (IOException ex) {
                throw new LayoutDefinitionException("Unable to process '" + url + "'.  EntityResolver: '" + this.getEntityResolver() + "'.  ErrorHandler: '" + this.getErrorHandler() + "'.  baseURI: '" + baseURI + "'.", ex);
            }
            XMLLayoutDefinitionManager.putCachedLayoutDefinition(key, ld);
        }
        ld.dispatchInitPageHandlers(FacesContext.getCurrentInstance(), ld);
        return ld;
    }

    public EntityResolver getEntityResolver() {
        return (EntityResolver)this.getAttribute(ENTITY_RESOLVER);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.setAttribute(ENTITY_RESOLVER, entityResolver);
    }

    public ErrorHandler getErrorHandler() {
        return (ErrorHandler)this.getAttribute(ERROR_HANDLER);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.setAttribute(ERROR_HANDLER, errorHandler);
    }

    public String getBaseURI() {
        String baseURI = (String)this.getAttribute(BASE_URI);
        if (baseURI == null) {
            baseURI = FileUtil.getResource("").toString();
        }
        return baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.setAttribute(BASE_URI, baseURI);
    }

    private static class XMLErrorHandler
    implements ErrorHandler {
        private PrintWriter out;

        XMLErrorHandler(PrintWriter outWriter) {
            this.out = outWriter;
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        public void warning(SAXParseException spe) throws SAXException {
            this.out.println("Warning: " + this.getParseExceptionInfo(spe));
        }

        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message, spe);
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message, spe);
        }
    }
}

