/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.AllTypesMapper;
import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.ObjectUtil;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import com.sun.enterprise.management.support.TypeData;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeInfo {
    private final TypeData mTypeData;
    private final Set<String> mChildJ2EETypes;
    private final Set<String> mNonChildJ2EETypes;
    private final Class mInterface;
    private final Class mImplClass;
    private static final String[] IMPL_PACKAGES = new String[]{"com.sun.enterprise.management.config", "com.sun.enterprise.management.monitor", "com.sun.enterprise.management.j2ee", "com.sun.enterprise.management.support", "com.sun.enterprise.management.ext.lb", "com.sun.enterprise.management.ext.wsmgmt", "com.sun.enterprise.management.ext.logging", "com.sun.enterprise.management.deploy", "com.sun.enterprise.management.ext", "com.sun.enterprise.management"};
    private static final String IMPL = "Impl";
    private static final Map<String, String> INTERFACE_TO_IMPL = TypeInfo.getInterfaceToImplMap();

    public TypeInfo(TypeData typeData) throws ClassNotFoundException {
        this.mTypeData = typeData;
        this.mInterface = TypeInfo.deriveInterface(typeData.getJ2EEType());
        this.mImplClass = TypeInfo.deriveImplClass(this.mInterface);
        this.mChildJ2EETypes = new HashSet<String>();
        this.mNonChildJ2EETypes = new HashSet<String>();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String PR = "\n  ";
        buf.append(this.getJ2EEType() + ": ");
        buf.append("\n  parent type = " + SmartStringifier.toString(this.getLegalParentJ2EETypes()));
        buf.append("\n  child types = " + SmartStringifier.toString(this.mChildJ2EETypes));
        buf.append("\n  mbean = " + this.mInterface.getName());
        buf.append("\n  impl = " + this.mImplClass.getName());
        buf.append("\n");
        return buf.toString();
    }

    private static Class deriveInterface(String j2eeType) throws ClassNotFoundException {
        return AllTypesMapper.getInstance().getInterfaceForType(j2eeType);
    }

    private static String getBaseName(String mbeanClassName) {
        String classname;
        String baseName = classname = ClassUtil.stripPackageName(mbeanClassName);
        return baseName;
    }

    private static Class locateImplClass(String packageName, String baseName) {
        if (!packageName.startsWith("com.sun.enterprise.management")) {
            throw new RuntimeException("Illegal implementation package for AMX");
        }
        String implClassname = packageName + "." + baseName + IMPL;
        Class implClass = null;
        try {
            implClass = ClassUtil.getClassFromName(implClassname);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        return implClass;
    }

    private static Map<String, String> getInterfaceToImplMap() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("com.sun.appserv.management.DomainRoot", "com.sun.enterprise.management.DomainRootImpl");
        m.put("com.sun.appserv.management.ext.logging.Logging", "com.sun.enterprise.management.ext.logging.LoggingImpl");
        m.put("com.sun.appserv.management.deploy.DeploymentMgr", "com.sun.enterprise.management.deploy.DeploymentMgrImpl");
        m.put("com.sun.appserv.management.ext.lb.LoadBalancer", "com.sun.enterprise.management.ext.lb.LoadBalancerImpl");
        m.put("com.sun.appserv.management.ext.wsmgmt.WebServiceMgr", "com.sun.enterprise.management.ext.wsmgmt.WebServiceMgrImpl");
        m.put("com.sun.appserv.management.ext.update.UpdateStatus", "com.sun.enterprise.management.ext.update.UpdateStatusImpl");
        return Collections.unmodifiableMap(m);
    }

    private static Class deriveImplClass(Class mbeanInterface) throws ClassNotFoundException {
        String fullyQualifiedName = mbeanInterface.getName();
        String shortName = TypeInfo.getBaseName(fullyQualifiedName);
        Class implClass = null;
        if (fullyQualifiedName.startsWith("com.sun.appserv.management.config")) {
            implClass = TypeInfo.locateImplClass("com.sun.enterprise.management.config", shortName);
        } else if (fullyQualifiedName.startsWith("com.sun.appserv.management.monitor")) {
            implClass = TypeInfo.locateImplClass("com.sun.enterprise.management.monitor", shortName);
        } else if (fullyQualifiedName.startsWith("com.sun.appserv.management.j2ee")) {
            implClass = TypeInfo.locateImplClass("com.sun.enterprise.management.j2ee", shortName);
        } else if (fullyQualifiedName.startsWith("com.sun.appserv.management.base")) {
            implClass = TypeInfo.locateImplClass("com.sun.enterprise.management.support", shortName);
        } else if (INTERFACE_TO_IMPL.containsKey(fullyQualifiedName)) {
            implClass = ClassUtil.getClassFromName(INTERFACE_TO_IMPL.get(fullyQualifiedName));
        }
        if (implClass == null) {
            for (int i = 0; i < IMPL_PACKAGES.length && (implClass = TypeInfo.locateImplClass(IMPL_PACKAGES[i], shortName)) == null; ++i) {
            }
        }
        if (implClass == null) {
            throw new ClassNotFoundException("Expected to find implementation class " + shortName + IMPL);
        }
        return implClass;
    }

    public void addChildJ2EEType(String j2eeType) {
        assert (!j2eeType.equals(this.getJ2EEType()));
        assert (!this.mNonChildJ2EETypes.contains(j2eeType));
        this.mChildJ2EETypes.add(j2eeType);
    }

    public void addContaineeJ2EEType(String j2eeType) {
        assert (!j2eeType.equals(this.getJ2EEType()));
        assert (!this.mChildJ2EETypes.contains(j2eeType));
        this.mNonChildJ2EETypes.add(j2eeType);
    }

    public String getJ2EEType() {
        return this.mTypeData.getJ2EEType();
    }

    public Set<String> getLegalParentJ2EETypes() {
        return this.mTypeData.getLegalParentJ2EETypes();
    }

    public String getContainedByJ2EEType() {
        return this.mTypeData.getContaineeByJ2EEType();
    }

    public boolean isSubType() {
        return this.mTypeData.isSubType();
    }

    public Class getInterface() {
        return this.mInterface;
    }

    public Class getImplClass() {
        return this.mImplClass;
    }

    public String getParentJ2EEType() {
        Set<String> legalParentJ2EETypes = this.getLegalParentJ2EETypes();
        if (legalParentJ2EETypes == null) {
            throw new IllegalArgumentException("no legal parent types for: " + this.getJ2EEType());
        }
        if (legalParentJ2EETypes.size() != 1) {
            throw new IllegalArgumentException("expecting single parent for " + this.getJ2EEType() + ", have: " + TypeInfo.toString(legalParentJ2EETypes));
        }
        return GSetUtil.getSingleton(legalParentJ2EETypes);
    }

    public Set<String> getChildJ2EETypes() {
        return Collections.unmodifiableSet(this.mChildJ2EETypes);
    }

    public Set<String> getNonChildJ2EETypes() {
        return Collections.unmodifiableSet(this.mNonChildJ2EETypes);
    }

    public Set<String> getContaineeJ2EETypes() {
        Set<String> all = GSetUtil.newSet(this.mChildJ2EETypes, this.mNonChildJ2EETypes);
        return Collections.unmodifiableSet(all);
    }

    public int hashCode() {
        return ObjectUtil.hashCode(this.mTypeData, this.mInterface, this.mChildJ2EETypes, this.mNonChildJ2EETypes);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeInfo)) {
            return false;
        }
        TypeInfo rhs = (TypeInfo)o;
        boolean equals = false;
        if (this.mTypeData.equals(rhs.mTypeData) && this.mInterface == rhs.mInterface && this.mImplClass == rhs.mImplClass && ((Object)this.mChildJ2EETypes).equals(rhs.mChildJ2EETypes) && ((Object)this.getLegalParentJ2EETypes()).equals(rhs.getLegalParentJ2EETypes())) {
            equals = true;
        }
        return equals;
    }

    private static String toString(Object o) {
        return SmartStringifier.toString(o);
    }
}

