/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.ArrayConversion;
import com.sun.appserv.management.util.misc.CollectionUtil;
import com.sun.enterprise.management.support.AMXAttributeNameMapper;
import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.DelegateBase;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;

public class MappedDelegate
extends DelegateBase {
    private final Delegate mDelegate;
    private final MBeanInfo mUnmappedMBeanInfo;
    private final MBeanInfo mMappedMBeanInfo;
    private final Set<String> mUnmappedAttributeNames;
    private final AMXAttributeNameMapper mAttributeNameMapper;

    public MappedDelegate(Delegate delegate, AMXAttributeNameMapper mapper) {
        super("MappedDelegate." + (delegate == null ? "null" : delegate.getID()), null);
        this.mDelegate = delegate;
        this.mUnmappedMBeanInfo = this.getUnmappedMBeanInfoFresh();
        String[] unmappedAttributeNames = JMXUtil.getAttributeNames(this.mUnmappedMBeanInfo.getAttributes());
        this.mUnmappedAttributeNames = ArrayConversion.arrayToSet(unmappedAttributeNames);
        this.mAttributeNameMapper = mapper;
        this.mMappedMBeanInfo = this.mapMBeanInfo(this.mDelegate.getMBeanInfo());
    }

    protected String derivedToOriginal(String mappedName) {
        return this.mAttributeNameMapper.derivedToOriginal(mappedName);
    }

    private Attribute derivedToOriginal(Attribute mappedAttr) {
        String unmappedName = this.derivedToOriginal(mappedAttr.getName());
        return new Attribute(unmappedName, mappedAttr.getValue());
    }

    protected String[] derivedToOriginal(String[] mappedNames) {
        String[] unmappedNames = new String[mappedNames.length];
        for (int i = 0; i < unmappedNames.length; ++i) {
            unmappedNames[i] = this.derivedToOriginal(mappedNames[i]);
        }
        return unmappedNames;
    }

    private String originalToDerived(String unmappedName) {
        return this.mAttributeNameMapper.originalToDerived(unmappedName);
    }

    private Attribute originalToDerived(Attribute unmappedAttr) {
        String mappedName = this.originalToDerived(unmappedAttr.getName());
        return new Attribute(mappedName, unmappedAttr.getValue());
    }

    protected AttributeList derivedToOriginal(AttributeList mappedAttrs) {
        int numAttrs = mappedAttrs.size();
        AttributeList unmappedAttrs = new AttributeList();
        for (int i = 0; i < numAttrs; ++i) {
            unmappedAttrs.add(this.derivedToOriginal((Attribute)mappedAttrs.get(i)));
        }
        return unmappedAttrs;
    }

    protected AttributeList originalToDerived(AttributeList unmappedAttrs) {
        int numAttrs = unmappedAttrs.size();
        AttributeList mappedAttrs = new AttributeList();
        for (int i = 0; i < numAttrs; ++i) {
            mappedAttrs.add(this.originalToDerived((Attribute)unmappedAttrs.get(i)));
        }
        return unmappedAttrs;
    }

    public boolean supportsAttribute(String mappedName) {
        return this.mAttributeNameMapper.getDerivedNames().contains(mappedName);
    }

    private void checkSupported(String mappedName) throws AttributeNotFoundException {
        if (!this.supportsAttribute(mappedName)) {
            this.debug("Attribute " + mappedName + " is not supported, have: " + CollectionUtil.toString(this.mAttributeNameMapper.getDerivedNames(), ", "));
            throw new AttributeNotFoundException(mappedName);
        }
    }

    public Object getAttribute(String mappedName) throws AttributeNotFoundException {
        this.checkSupported(mappedName);
        String unmappedName = this.mAttributeNameMapper.derivedToOriginal(mappedName);
        return this.mDelegate.getAttribute(unmappedName);
    }

    public AttributeList getAttributes(String[] mappedNames) {
        AttributeList unmappedResults = this.mDelegate.getAttributes(this.derivedToOriginal(mappedNames));
        return this.originalToDerived(unmappedResults);
    }

    public void setAttribute(Attribute mappedAttr) throws AttributeNotFoundException, InvalidAttributeValueException {
        this.checkSupported(mappedAttr.getName());
        Attribute unmappedAttr = this.derivedToOriginal(mappedAttr);
        this.mDelegate.setAttribute(unmappedAttr);
    }

    public AttributeList setAttributes(AttributeList mappedAttrs) {
        AttributeList unmappedAttrs = this.derivedToOriginal(mappedAttrs);
        AttributeList unmappedResults = this.mDelegate.setAttributes(unmappedAttrs);
        return this.originalToDerived(unmappedResults);
    }

    protected MBeanInfo getUnmappedMBeanInfoFresh() {
        return this.mDelegate.getMBeanInfo();
    }

    protected MBeanInfo getUnmappedMBeanInfo() {
        return this.mUnmappedMBeanInfo;
    }

    private MBeanAttributeInfo mapAttributeInfo(MBeanAttributeInfo unmappedInfo) {
        String mappedName = this.originalToDerived(unmappedInfo.getName());
        if (mappedName == null) {
            mappedName = unmappedInfo.getName();
        }
        MBeanAttributeInfo mappedInfo = new MBeanAttributeInfo(mappedName, unmappedInfo.getType(), unmappedInfo.getDescription(), unmappedInfo.isReadable(), unmappedInfo.isWritable(), unmappedInfo.isIs());
        return mappedInfo;
    }

    private MBeanAttributeInfo[] mapAttributeInfos(MBeanAttributeInfo[] unmappedInfos) {
        MBeanAttributeInfo[] mappedInfos = new MBeanAttributeInfo[unmappedInfos.length];
        for (int i = 0; i < unmappedInfos.length; ++i) {
            String attrName = unmappedInfos[i].getName();
            assert (attrName != null);
            mappedInfos[i] = this.mapAttributeInfo(unmappedInfos[i]);
            assert (mappedInfos[i].getName() != null);
            this.debug("Mapped " + unmappedInfos[i].getName() + " to " + mappedInfos[i].getName());
        }
        return mappedInfos;
    }

    private MBeanInfo mapMBeanInfo(MBeanInfo unmappedMBeanInfo) {
        MBeanAttributeInfo[] mappedAttributeInfos = this.mapAttributeInfos(unmappedMBeanInfo.getAttributes());
        MBeanInfo mappedInfo = new MBeanInfo(unmappedMBeanInfo.getClassName(), unmappedMBeanInfo.getDescription(), mappedAttributeInfos, unmappedMBeanInfo.getConstructors(), unmappedMBeanInfo.getOperations(), unmappedMBeanInfo.getNotifications());
        return mappedInfo;
    }

    protected MBeanInfo getMappedMBeanInfo() {
        return this.mMappedMBeanInfo;
    }

    public MBeanInfo getMBeanInfo() {
        return this.getMappedMBeanInfo();
    }

    public String[] getAttributeNames() {
        String[] names = JMXUtil.getAttributeNames(this.getMBeanInfo().getAttributes());
        return names;
    }

    public final Object invoke(String operationName, Object[] args, String[] types) {
        Object result = this.mDelegate.invoke(operationName, args, types);
        return result;
    }

    protected final String _getDefaultValue(String mappedName) throws AttributeNotFoundException {
        this.checkSupported(mappedName);
        String unmappedName = this.mAttributeNameMapper.derivedToOriginal(mappedName);
        return this.mDelegate.getDefaultValue(unmappedName);
    }
}

