/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.monitor;

import com.sun.appserv.management.base.AMXDebug;
import com.sun.appserv.management.j2ee.statistics.MapStatistic;
import com.sun.appserv.management.j2ee.statistics.MapStatisticImpl;
import com.sun.appserv.management.j2ee.statistics.StatisticFactory;
import com.sun.appserv.management.j2ee.statistics.StatsImpl;
import com.sun.appserv.management.monitor.MonitoringStats;
import com.sun.appserv.management.util.j2ee.J2EEUtil;
import com.sun.appserv.management.util.jmx.AttributeNameMapper;
import com.sun.appserv.management.util.jmx.AttributeNameMapperImpl;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.ArrayUtil;
import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.enterprise.management.monitor.MonitoringImplBase;
import com.sun.enterprise.management.support.Delegate;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MonitoringStatsImplBase
extends MonitoringImplBase {
    private MBeanInfo mMBeanInfo = null;
    private final AttributeNameMapper mFieldNameMapper;
    private final AttributeNameMapper mStatisticNameMapper;
    private Set<String> mStatisticNames = null;
    private static final String GET = "get";
    private static final String STATISTIC_DELIM = "_";
    private static final Set<String> IGNORE_MISSING_SUFFIXES = Collections.unmodifiableSet(GSetUtil.newSet(new String[]{"current", "count", "description", "name", "lowwatermark", "highwatermark", "unit", "lastsampletime", "starttime", "lowerbound", "upperbound", "maxtime", "mintime", "totaltime", "average", "children"}));
    protected static final String[] STD_FIELDS = new String[0];
    protected static final String[] STD_STATISTICS = new String[]{"id", "ID", "Id", "ID"};
    private static final boolean BUG_STATISTIC_NAMES = true;
    private final Class[] STATS_IMPL_INTERFACES = new Class[]{Serializable.class, Stats.class};
    private static final Set<String> LONG_FIELDS = GSetUtil.newUnmodifiableStringSet("Count", "LastSampleTime", "StartTime", "LowerBound", "UpperBound", "HighWaterMark", "LowWaterMark", "MaxTime", "MinTime", "TotalTime");
    private static final MBeanInfo EMPTY_MBEAN_INFO = new MBeanInfo("Empty", "Failed to create MBeanInfo", null, null, null, null);

    public MonitoringStatsImplBase(String j2eeType, Delegate delegate) {
        super(j2eeType, delegate);
        this.mFieldNameMapper = new AttributeNameMapperImpl();
        this.mStatisticNameMapper = new AttributeNameMapperImpl();
    }

    public MonitoringStatsImplBase(String j2eeType) {
        this(j2eeType, null);
    }

    protected OldMonitoringMBean getMonitoringMBeanDelegate() {
        return (OldMonitoringMBean)this.getDelegateProxy(OldMonitoringMBean.class);
    }

    @Override
    protected void handleMissingOriginals(Set<String> missingOriginals) {
        HashSet<String> stillMissing = new HashSet<String>();
        for (String name : missingOriginals) {
            int idx;
            String suffix = name.substring((idx = name.lastIndexOf(45)) + 1, name.length());
            if (IGNORE_MISSING_SUFFIXES.contains(suffix)) continue;
            stillMissing.add(name);
        }
        super.handleMissingOriginals(stillMissing);
    }

    protected final AttributeNameMapper getFieldNameMapper() {
        return this.mFieldNameMapper;
    }

    protected final AttributeNameMapper getStatisticNameMapper() {
        return this.mStatisticNameMapper;
    }

    protected void initFieldNameMapper() {
        AttributeNameMapper m = this.getFieldNameMapper();
        assert (STD_FIELDS.length % 2 == 0);
        for (int i = 0; i < STD_FIELDS.length - 1; ++i) {
            m.addMapping(STD_FIELDS[i], STD_FIELDS[i + 1]);
        }
    }

    protected void initStatisticNameMapper() {
        AttributeNameMapper m = this.getStatisticNameMapper();
        String[] mappings = STD_STATISTICS;
        for (int i = 0; i < mappings.length - 1; ++i) {
            m.addMapping(mappings[i], mappings[i + 1]);
        }
    }

    protected Object getAttributeFromStatistic(String statisticName, String fieldName) throws AttributeNotFoundException {
        try {
            Statistic s = this.getStatistic(statisticName);
            assert (s instanceof MapStatistic);
            String methodName = GET + fieldName;
            Method m = s.getClass().getMethod(methodName, null);
            Object result = m.invoke((Object)s, (Object[])null);
            return result;
        }
        catch (Exception e) {
            this.debug("getAttributeFromStatistic: exception getting statistic " + statisticName + e + "\n" + ExceptionUtil.getStackTrace(ExceptionUtil.getRootCause(e)));
            throw new AttributeNotFoundException(statisticName);
        }
    }

    @Override
    protected Object getAttributeManually(String name) throws AttributeNotFoundException {
        int idx = name.indexOf(STATISTIC_DELIM);
        Object result = null;
        if (idx > 0) {
            String statisticName = name.substring(0, idx);
            String fieldName = name.substring(idx + 1, name.length());
            result = this.getAttributeFromStatistic(statisticName, fieldName);
        } else {
            result = super.getAttributeManually(name);
        }
        return result;
    }

    private String[] originalToDerivedStatisticNames(String[] names) {
        String[] derived = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            derived[i] = this.originalToDerivedStatisticName(names[i]);
        }
        return derived;
    }

    private void checkUnderlyingMBean() {
        Delegate delegate = this.getDelegate();
        if (delegate == null) {
            return;
        }
        String[] claimedNames = this.getMonitoringMBeanDelegate().getStatisticNames();
        if (claimedNames == null) {
            throw new RuntimeException("Delegate  used by AMX MBean " + this.getObjectName() + " returned null StatisticNames array");
        }
        if (claimedNames.length == 0) {
            throw new RuntimeException("Delegate  used by AMX MBean " + this.getObjectName() + " returned empty StatisticNames array");
        }
        Statistic[] statistics = this.getMonitoringMBeanDelegate().getStatistics();
        if (statistics == null) {
            throw new RuntimeException("Delegate  used by AMX MBean " + this.getObjectName() + " returned null Statistics array");
        }
        if (statistics.length == 0) {
            throw new RuntimeException("Delegate  used by AMX MBean " + this.getObjectName() + " returned empty Statistics array");
        }
        try {
            HashSet<String> actualSet = new HashSet<String>();
            String[] namesFromGetStatistics = new String[statistics.length];
            for (int i = 0; i < statistics.length; ++i) {
                String name;
                namesFromGetStatistics[i] = name = StringUtil.upperCaseFirstLetter(statistics[i].getName());
                if (!actualSet.contains(name)) {
                    actualSet.add(name);
                    continue;
                }
                this.logWarning("MBean delegate  for " + this.getObjectName() + " returns Statistic with duplicate name: " + name + " from getStatistics() call.\n");
            }
            Set<String> claimedSet = GSetUtil.newStringSet(claimedNames);
            if (!((Object)claimedSet).equals(actualSet)) {
                HashSet<String> missing = new HashSet<String>(claimedSet);
                missing.removeAll(actualSet);
                String msg = "\nMBean delegate  for " + this.getObjectName() + " does not provide Statistic(s): " + missing + " from getStatistics() call, " + "\ngetStatisticNames() = " + MonitoringStatsImplBase.toString(claimedSet) + "\nnames from getStatistics() = " + MonitoringStatsImplBase.toString(namesFromGetStatistics) + "\n";
                AMXDebug.getInstance().getOutput("MonitoringStatsImplBase.checkUnderlyingMBean").println(msg);
                this.logFine(msg);
            }
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtil.getRootCause(e);
            this.logWarning("MBean delegate  doesn't work, used by AMX MBean: " + this.getObjectName() + "\n" + rootCause.getClass().getName() + "\n" + ExceptionUtil.getStackTrace(rootCause));
        }
    }

    private final String[] initStatisticNames() {
        String[] names = null;
        names = this.getStats().getStatisticNames();
        if (names == null || names.length == 0) {
            throw new RuntimeException("Stats are null or empty for: " + this.getObjectName());
        }
        return names;
    }

    public String[] getStatisticNames() {
        return GSetUtil.toStringArray(this.mStatisticNames);
    }

    public CompositeDataSupport getOpenStatistic(String name) {
        Statistic statistic = this.getStatistic(name);
        try {
            return J2EEUtil.statisticToCompositeData(statistic);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public CompositeDataSupport[] getOpenStatistics(String[] names) {
        CompositeDataSupport[] result = new CompositeDataSupport[names.length];
        for (int i = 0; i < names.length; ++i) {
            result[i] = this.getOpenStatistic(names[i]);
        }
        return result;
    }

    public CompositeDataSupport getOpenStats() {
        Stats stats = this.getStats();
        CompositeDataSupport result = null;
        if (stats.getStatisticNames().length != 0) {
            try {
                result = J2EEUtil.statsToCompositeData(stats);
            }
            catch (OpenDataException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.logWarning("No Statistics available for: " + this.getObjectName());
        }
        return result;
    }

    public Statistic getStatistic(String name) {
        Stats stats = this.getStats();
        return stats.getStatistic(name);
    }

    public Statistic[] getStatistics(String[] desiredNames) {
        Stats stats = this.getStats();
        Statistic[] result = new Statistic[desiredNames.length];
        for (int i = 0; i < desiredNames.length; ++i) {
            Statistic statistic;
            result[i] = statistic = stats.getStatistic(desiredNames[i]);
        }
        return result;
    }

    protected String originalToDerivedStatisticName(String underlyingName) {
        String result = this.getStatisticNameMapper().originalToDerived(underlyingName);
        result = StringUtil.upperCaseFirstLetter(result);
        return result;
    }

    protected String derivedToOriginalStatisticName(String derivedName) {
        return this.getStatisticNameMapper().derivedToOriginal(derivedName);
    }

    protected final Statistic[] getStatisticsFromDelegate() {
        if (this.getDelegate() == null) {
            throw new NullPointerException();
        }
        return this.getStatisticsFromDelegate(this.getDelegate());
    }

    protected final Statistic[] checkDuplicateStatistics(Delegate d, Statistic[] statistics) {
        HashSet<String> actualNames = new HashSet<String>();
        for (int i = 0; i < statistics.length; ++i) {
            String name = statistics[i].getName();
            if (actualNames.contains(name)) {
                throw new RuntimeException("MonitoringStatsImplBase.checkDuplicateStatistics: " + this.getObjectName() + "Statistic " + StringUtil.quote(name) + " is duplicated in getStatistics(): " + " as supplied from Delegate of " + StringUtil.quote(this.getObjectName()) + ", please see bug #6179364");
            }
            actualNames.add(name);
        }
        if (actualNames.size() != statistics.length) {
            String[] claimedNames = (String[])d.invoke("getStatisticNames", null, null);
            Set<String> missingNames = GSetUtil.newStringSet(claimedNames);
            missingNames.removeAll(actualNames);
            throw new RuntimeException("MonitoringStatsImplBase.getStatisticsFromDelegateRaw: " + missingNames.size() + " Statistic names as found in Statistics from getStatistics() are missing: {" + MonitoringStatsImplBase.toString(missingNames) + "} from Delegate of " + StringUtil.quote(this.getObjectName()) + ", please see bug #6179364");
        }
        return statistics;
    }

    protected Statistic[] getStatisticsFromDelegateRaw(Delegate d) {
        try {
            Statistic[] statistics = (Statistic[])d.invoke("getStatistics", null, null);
            this.checkDuplicateStatistics(d, statistics);
            return statistics;
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtil.getRootCause(e);
            this.logWarning("MonitoringStatsImplBase: the com.sun.appserv Delegate MBean for AMX MBean " + this.getObjectName() + " threw an exception: " + rootCause + ", stack = \n" + ExceptionUtil.getStackTrace(rootCause));
            return new Statistic[0];
        }
    }

    private void debug(String s) {
        System.out.println(s);
    }

    protected Statistic[] getStatisticsFromDelegate(Delegate d) {
        try {
            Statistic[] statistics = this.getStatisticsFromDelegateRaw(d);
            for (int i = 0; i < statistics.length; ++i) {
                Statistic origStatistic = statistics[i];
                MapStatisticImpl m = new MapStatisticImpl(origStatistic);
                String convertedName = this.originalToDerivedStatisticName(origStatistic.getName());
                if (!convertedName.equals(origStatistic.getName())) {
                    m.setName(convertedName);
                }
                Class<? extends Statistic> theClass = StatisticFactory.getInterface(origStatistic);
                assert (theClass != null);
                statistics[i] = StatisticFactory.create(theClass, m.asMap());
                assert (theClass.isAssignableFrom(statistics[i].getClass()));
            }
            return statistics;
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtil.getRootCause(e);
            if (!(rootCause instanceof InstanceNotFoundException)) {
                this.logWarning("Can't get Statistics from delegate for " + this.getObjectName() + "\n" + rootCause.getMessage() + "\n" + ExceptionUtil.getStackTrace(rootCause));
            }
            throw new RuntimeException(e);
        }
    }

    protected abstract Class getStatsInterface();

    protected StatsImpl createStatsImpl() {
        return new StatsImpl(this.getStatisticsFromDelegate());
    }

    public String getStatsInterfaceName() {
        return this.getStatsInterface().getName();
    }

    public Stats getStats() {
        Class statsInterface = this.getStatsInterface();
        assert (statsInterface == null || Stats.class.isAssignableFrom(statsInterface));
        Class[] implementedInterfaces = null;
        if (statsInterface == null) {
            implementedInterfaces = this.STATS_IMPL_INTERFACES;
            this.logInfo("getStats: no Stats interface found for " + this.getObjectName());
        } else {
            implementedInterfaces = ArrayUtil.newArray(this.STATS_IMPL_INTERFACES, statsInterface);
        }
        StatsImpl impl = this.createStatsImpl();
        ClassLoader classLoader = this.getClass().getClassLoader();
        Stats stats = (Stats)Proxy.newProxyInstance(classLoader, implementedInterfaces, (InvocationHandler)impl);
        return stats;
    }

    public final boolean refresh() {
        this.mMBeanInfo = null;
        this.clearAttributeInfos();
        return true;
    }

    private String makeAttributeName(String statisticName, String fieldName) {
        String attributeName = statisticName + STATISTIC_DELIM + fieldName;
        return attributeName;
    }

    private Class determineFieldType(String fieldName, Object value) {
        Class<Long> theClass = String.class;
        if (value != null) {
            theClass = ClassUtil.ObjectClassToPrimitiveClass(value.getClass());
        } else if (LONG_FIELDS.contains(fieldName)) {
            theClass = Long.TYPE;
        }
        return theClass;
    }

    private Map<String, MBeanAttributeInfo> statisticToMBeanAttributeInfos(Statistic s) {
        Map<String, Object> src = new MapStatisticImpl(s).asMap();
        String statisticName = s.getName();
        HashMap<String, MBeanAttributeInfo> result = new HashMap<String, MBeanAttributeInfo>();
        for (String fieldName : src.keySet()) {
            Object value = src.get(fieldName);
            String type = this.determineFieldType(fieldName, value).getName();
            String attributeName = this.makeAttributeName(statisticName, fieldName);
            MBeanAttributeInfo attributeInfo = new MBeanAttributeInfo(attributeName, type, "", true, false, false);
            result.put(attributeName, attributeInfo);
        }
        return result;
    }

    private synchronized MBeanInfo createMBeanInfo() {
        MBeanInfo baseMBeanInfo;
        MBeanInfo mbeanInfo = baseMBeanInfo = super.getMBeanInfo();
        if (this.getMBeanServer() != null && this.getDelegate() != null) {
            MBeanAttributeInfo[] attrInfos;
            assert (this.getDelegate() != null) : "null delegate for: " + this.getObjectName();
            HashMap newAttrs = new HashMap();
            Statistic[] statistics = this.getStats().getStatistics();
            for (int i = 0; i < statistics.length; ++i) {
                attrInfos = this.statisticToMBeanAttributeInfos(statistics[i]);
                newAttrs.putAll(attrInfos);
            }
            MBeanAttributeInfo[] dynamicAttrInfos = new MBeanAttributeInfo[newAttrs.keySet().size()];
            newAttrs.values().toArray(dynamicAttrInfos);
            attrInfos = JMXUtil.mergeMBeanAttributeInfos(dynamicAttrInfos, baseMBeanInfo.getAttributes());
            mbeanInfo = JMXUtil.newMBeanInfo(baseMBeanInfo, attrInfos);
        }
        return mbeanInfo;
    }

    @Override
    protected ObjectName preRegisterHook(ObjectName objectName) {
        this.initFieldNameMapper();
        this.initStatisticNameMapper();
        this.refresh();
        assert (MonitoringStats.class.isAssignableFrom(this.getInterface())) : "MBean extends MonitoringStatsImpl but does not have MonitoringStats interface: " + this.getObjectName();
        this.checkUnderlyingMBean();
        this.mStatisticNames = GSetUtil.newUnmodifiableStringSet(this.initStatisticNames());
        return objectName;
    }

    @Override
    public synchronized MBeanInfo getMBeanInfo() {
        if (this.mMBeanInfo == null) {
            try {
                this.mMBeanInfo = this.createMBeanInfo();
            }
            catch (Throwable t) {
                Throwable rootCause = ExceptionUtil.getRootCause(t);
                if (!(rootCause instanceof InstanceNotFoundException)) {
                    this.getMBeanLogger().warning("can't create MBeanInfo for: " + this.getObjectName() + "\n" + rootCause.getClass() + ": " + rootCause.getMessage() + ":\n" + ExceptionUtil.getStackTrace(rootCause));
                }
                this.mMBeanInfo = EMPTY_MBEAN_INFO;
            }
        }
        return this.mMBeanInfo;
    }

    private static interface OldMonitoringMBean {
        public String[] getStatisticNames();

        public Statistic[] getStatistics();
    }
}

