/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.validation.AttrClassName;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import com.sun.enterprise.config.serverbeans.validation.tests.JvmOptionsTest;
import com.sun.enterprise.config.serverbeans.validation.tests.StaticTest;
import java.util.StringTokenizer;

public class JavaConfigTest
extends GenericValidator {
    public JavaConfigTest(ValidationDescriptor desc) {
        super(desc);
    }

    public Result validate(ConfigContextEvent cce) {
        String name;
        Result result = super.validate(cce);
        if (cce.getChoice().equals("VALIDATE")) {
            StaticTest.setJavaHomeCheck(true);
            JavaConfig javaConfig = (JavaConfig)cce.getObject();
            if (javaConfig.getJavaHome().indexOf("${") < 0) {
                this.validateAttribute("java-home", javaConfig.getJavaHome(), result);
            }
            this.validateAttribute("debug-options", javaConfig.getDebugOptions(), result);
            this.validateAttribute("rmic-options", javaConfig.getRmicOptions(), result);
            this.validateAttribute("javac-options", javaConfig.getJavacOptions(), result);
            this.validateAttribute("classpath-prefix", javaConfig.getClasspathPrefix(), result);
            this.validateAttribute("classpath-suffix", javaConfig.getClasspathSuffix(), result);
            this.validateAttribute("native-library-path-prefix", javaConfig.getNativeLibraryPathPrefix(), result);
            this.validateAttribute("native-library-path-suffix", javaConfig.getNativeLibraryPathSuffix(), result);
            this.validateAttribute("bytecode-preprocessors", javaConfig.getBytecodePreprocessors(), result);
            JvmOptionsTest.validateJvmOptions(javaConfig.getJvmOptions(), result);
        }
        if (cce.getChoice().equals("UPDATE")) {
            this.validateAttribute(cce.getName(), (String)cce.getObject(), result);
        } else if (cce.getChoice().equals("SET") && (name = cce.getName()).equals("JvmOptions")) {
            JvmOptionsTest.validateJvmOptions((String[])cce.getObject(), result);
        }
        return result;
    }

    public void validateAttribute(String name, String value, Result result) {
        if (value == null || value.equals("")) {
            return;
        }
        if (name.equals("debug-options")) {
            if (!StaticTest.isOptionsValid(value)) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidDebugOption", "{0} : Invalid Java Debug options should start with -", new Object[]{value}));
            }
            this.validateRunJDWP(value, result);
        }
        if (name.equals("rmic-options") && !StaticTest.isOptionsValid(value)) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidRmicOption", "{0} : Invalid RMIC options should start with -", new Object[]{value}));
        }
        if (name.equals("javac-options") && !StaticTest.isOptionsValid(value)) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidJavacOptions", "{0} : Invalid javac options should start with -", new Object[]{value}));
        }
        if ((name.equals("classpath-prefix") || name.equals("classpath-suffix") || name.equals("native-library-path-prefix") || name.equals("native-library-path-suffix")) && !StaticTest.isClassPathValid(value)) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidClasspath", "{0} Classpath contains invalid path : Check the path", new Object[]{name}));
        }
        if (name.equals("java-home") && !StaticTest.isJavaHomeValid(value)) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidJavaHome", "Warning : (java-home={0}), JDK does not exists in java home", new Object[]{value}));
        }
        if (name.equals("bytecode-preprocessors")) {
            StringTokenizer tokens = new StringTokenizer(value, ".");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                if (AttrClassName.isValidClassName(token)) continue;
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidClassName", "Attribute (bytecode-preprocessors={0}), {1} Invalid Class Name", new Object[]{value, token}));
            }
        }
    }

    public void validateRunJDWP(String value, Result result) {
        String runjdwp = value.substring(value.indexOf("jdwp:") + 5);
        int index = 0;
        try {
            if (runjdwp != null) {
                index = runjdwp.indexOf("-X");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String debugStr = null;
        debugStr = index > 0 ? runjdwp.substring(0, index) : runjdwp;
        if (debugStr != null) {
            String[] tokens = debugStr.split(",");
            for (int i = 0; i < tokens.length; ++i) {
                if (tokens[i].indexOf("=") >= 0) continue;
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidJDWPDebugOption", "{0} : Invalid -Xrunjdwp option, please check syntax", new Object[]{debugStr}));
                break;
            }
        }
    }
}

