/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.stats.impl;

import com.sun.enterprise.admin.wsmgmt.stats.spi.WebServiceEndpointStatsProvider;

public class WebServiceEndpointStatsProviderImpl
implements WebServiceEndpointStatsProvider {
    String faultActor = null;
    String faultString = null;
    String faultCode = null;
    String clientHost = null;
    String clientUser = null;
    int responseSize = 0;
    int requestSize = 0;
    int totalFaults = 0;
    int totalSuccess = 0;
    int totalAuthFailures = 0;
    int totalAuthSuccess = 0;
    long responseTime = 0L;
    long totalResponseTime = 0L;
    long avgResponseTime = 0L;
    long minResponseTime = -1L;
    long maxResponseTime = 0L;
    double throughput = 0.0;
    long enterTime = 0L;
    long resetTime = System.currentTimeMillis();
    int reqSize = 0;
    String cHost = null;
    String cUser = null;

    public void setRequestTimeStamp(long t, String host, String user, int rSize) {
        this.enterTime = t;
        this.reqSize = rSize;
        this.cHost = host;
        this.cUser = user;
    }

    public void setSuccess(int resSize, long exitTime, long respTime) {
        this.precheck();
        this.responseTime = respTime;
        this.calculateResponseTimes(this.responseTime);
        this.clientHost = this.cHost;
        this.clientUser = this.cUser;
        this.requestSize = this.reqSize;
        this.responseSize = resSize;
        ++this.totalSuccess;
        ++this.totalAuthSuccess;
        this.faultActor = null;
        this.faultString = null;
        this.faultCode = null;
        this.cleanup();
    }

    void calculateResponseTimes(long curRespTime) {
        if (curRespTime > this.maxResponseTime) {
            this.maxResponseTime = curRespTime;
        }
        if (this.minResponseTime < 0L) {
            this.minResponseTime = curRespTime;
        } else if (curRespTime < this.minResponseTime) {
            this.minResponseTime = curRespTime;
        }
        this.totalResponseTime += curRespTime;
    }

    public void setFault(int resSize, long exitTime, long rTime, String fCode, String fString, String fActor) {
        this.precheck();
        this.responseTime = rTime;
        this.calculateResponseTimes(this.responseTime);
        this.clientHost = this.cHost;
        this.clientUser = this.cUser;
        this.requestSize = this.reqSize;
        this.responseSize = resSize;
        ++this.totalFaults;
        ++this.totalAuthSuccess;
        this.faultCode = fCode;
        this.faultString = fString;
        this.faultActor = fActor;
        this.cleanup();
    }

    public void setAuthFailure(long t) {
        this.clientHost = this.cHost;
        this.clientUser = this.cUser;
        this.requestSize = this.reqSize;
        ++this.totalFaults;
        ++this.totalAuthFailures;
        this.faultActor = null;
        this.faultString = null;
        this.faultCode = null;
        this.cleanup();
    }

    public void precheck() {
        if (this.enterTime == 0L) {
            throw new RuntimeException("Request method should also update the request stats");
        }
    }

    public void cleanup() {
        this.enterTime = 0L;
        this.cUser = null;
        this.cHost = null;
    }

    public void reset() {
        this.clientUser = null;
        this.clientHost = null;
        this.faultCode = null;
        this.faultString = null;
        this.faultActor = null;
        this.totalAuthSuccess = 0;
        this.totalAuthFailures = 0;
        this.totalSuccess = 0;
        this.totalFaults = 0;
        this.requestSize = 0;
        this.responseSize = 0;
        this.avgResponseTime = 0L;
        this.maxResponseTime = 0L;
        this.totalResponseTime = 0L;
        this.responseTime = 0L;
        this.resetTime = System.currentTimeMillis();
        this.throughput = 0.0;
        this.minResponseTime = -1L;
    }

    public long getLastResetTime() {
        return this.resetTime;
    }

    public long getAverageResponseTime() {
        int totalInv = this.totalSuccess + this.totalFaults;
        if (totalInv == 0) {
            return 0L;
        }
        return this.totalResponseTime / (long)totalInv;
    }

    public long getMinResponseTime() {
        if (this.minResponseTime < 0L) {
            return 0L;
        }
        return this.minResponseTime;
    }

    public long getMaxResponseTime() {
        return this.maxResponseTime;
    }

    public long getResponseTime() {
        return this.responseTime;
    }

    public int getTotalFailures() {
        return this.totalFaults;
    }

    public int getTotalSuccesses() {
        return this.totalSuccess;
    }

    public int getTotalAuthFailures() {
        return this.totalAuthFailures;
    }

    public int getTotalAuthSuccesses() {
        return this.totalAuthSuccess;
    }

    public double getThroughput() {
        long avgRespTime = this.getAverageResponseTime();
        double dValue = avgRespTime;
        if (avgRespTime == 0L) {
            return 0.0;
        }
        return 1000.0 / dValue;
    }

    public int getRequestSize() {
        return this.requestSize;
    }

    public int getResponseSize() {
        return this.responseSize;
    }

    public String getClientHost() {
        return this.clientHost;
    }

    public String getClientUser() {
        return this.clientUser;
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public String getFaultString() {
        return this.faultString;
    }

    public String getFaultActor() {
        return this.faultActor;
    }
}

