/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.repository.impl.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class J2eeApplication {
    String _name = null;
    List _ejbBundles = null;
    List _webBundles = null;
    static final String DELIM = ",";
    static final String EJB_KEY = "EJB_";
    static final String WEB_KEY = "WEB_";

    J2eeApplication(String name, List ejb, List web) {
        this._name = name;
        this._ejbBundles = ejb;
        this._webBundles = web;
    }

    J2eeApplication(String key, String val) {
        this._name = key;
        this._ejbBundles = new ArrayList();
        this._webBundles = new ArrayList();
        StringTokenizer st = new StringTokenizer(val, DELIM);
        while (st.hasMoreTokens()) {
            String m = st.nextToken();
            if (m.startsWith(EJB_KEY)) {
                int ejbKeyLength = EJB_KEY.length();
                String ejbModule = m.substring(ejbKeyLength);
                this.addEjbBundle(ejbModule);
                continue;
            }
            if (!m.startsWith(WEB_KEY)) continue;
            int webKeyLength = WEB_KEY.length();
            String webModule = m.substring(webKeyLength);
            this.addWebBundle(webModule);
        }
    }

    public String getName() {
        return this._name;
    }

    String getPersistentValue() {
        StringBuffer sb = new StringBuffer();
        for (String ejb : this._ejbBundles) {
            sb.append(EJB_KEY);
            sb.append(ejb);
            sb.append(DELIM);
        }
        for (String web : this._webBundles) {
            sb.append(WEB_KEY);
            sb.append(web);
            sb.append(DELIM);
        }
        String persistentValue = null;
        int length = sb.length();
        if (length > 0) {
            String val = sb.toString();
            persistentValue = val.substring(0, length - 1);
        }
        return persistentValue;
    }

    public List getEjbBundles() {
        return this._ejbBundles;
    }

    void addEjbBundle(String name) {
        this._ejbBundles.add(name);
    }

    boolean removeEjbBundle(String name) {
        return this._ejbBundles.remove(name);
    }

    public List getWebBundles() {
        return this._webBundles;
    }

    void addWebBundle(String name) {
        this._webBundles.add(name);
    }

    boolean removeWebBundle(String name) {
        return this._webBundles.remove(name);
    }
}

