/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.lifecycle;

import com.sun.enterprise.admin.monitor.WSMonitorLifeCycleProvider;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;
import com.sun.enterprise.admin.wsmgmt.WebServiceMgrBackEnd;
import com.sun.enterprise.admin.wsmgmt.config.impl.WebServiceConfigImpl;
import com.sun.enterprise.admin.wsmgmt.config.spi.ConfigFactory;
import com.sun.enterprise.admin.wsmgmt.config.spi.ConfigProvider;
import com.sun.enterprise.admin.wsmgmt.lifecycle.MonitoringLifeCycleImpl;
import com.sun.enterprise.admin.wsmgmt.msg.MessageTraceMgr;
import com.sun.enterprise.admin.wsmgmt.transform.TransformMgr;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.config.serverbeans.WebServiceEndpoint;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;

public class AppServWSMonitorLifeCycleProvider
implements WSMonitorLifeCycleProvider {
    private AppsManager appsMgr = null;
    private ConfigProvider cfgProv = null;
    private static final StringManager _stringMgr = StringManager.getManager(AppServWSMonitorLifeCycleProvider.class);
    private static final Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");

    public AppServWSMonitorLifeCycleProvider() {
        try {
            this.cfgProv = ConfigFactory.getConfigFactory().getConfigProvider();
            InstanceEnvironment ienv = ApplicationServer.getServerContext().getInstanceEnvironment();
            this.appsMgr = new AppsManager(ienv);
        }
        catch (Exception e) {
            _logger.fine(" Exception during initialization of AppServWSMonitorLifeCycleProvider " + e.getMessage());
        }
    }

    public String getProviderID() {
        return "com.sun.enterprise.admin.wsmgmt.lifecycle.AppServWSMonitorLifeCycleProvider";
    }

    void instrumentWebServiceEndpoints(String appId, BundleDescriptor bd, boolean shouldRegister) {
        String vs;
        String ctxRoot;
        String modName;
        boolean isStandAlone;
        boolean isEjb;
        block12: {
            isEjb = false;
            isStandAlone = false;
            modName = null;
            ctxRoot = null;
            vs = "server";
            Server server = null;
            try {
                ServerContext sCtx = ApplicationServer.getServerContext();
                server = ServerHelper.getServerByName((ConfigContext)sCtx.getConfigContext(), (String)sCtx.getInstanceName());
                ApplicationRef aRef = server.getApplicationRefByRef(appId);
                if (aRef != null) {
                    vs = aRef.getVirtualServers();
                    if (vs == null || vs.length() == 0) {
                        vs = "server";
                    }
                    break block12;
                }
                throw new IllegalArgumentException();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        modName = bd.getModuleDescriptor().getArchiveUri();
        if (bd instanceof EjbBundleDescriptor) {
            isEjb = true;
        } else if (bd instanceof WebBundleDescriptor) {
            isEjb = false;
            ctxRoot = ((WebBundleDescriptor)bd).getContextRoot();
        } else {
            return;
        }
        Application app = bd.getApplication();
        if (app == null) {
            String msg = _stringMgr.getString("Application_NotFound", (Object)appId);
            throw new RuntimeException(msg);
        }
        isStandAlone = app.isVirtual();
        Collection wsCollec = bd.getWebServices().getWebServices();
        HashSet wsSet = new HashSet();
        for (WebService ws : wsCollec) {
            wsSet.addAll(ws.getEndpoints());
        }
        for (com.sun.enterprise.deployment.WebServiceEndpoint wse : wsSet) {
            String epName = wse.getEndpointName();
            if (shouldRegister) {
                this.instrument(epName, modName, ctxRoot, isStandAlone, appId, isEjb, vs);
                continue;
            }
            this.uninstrument(epName, modName, ctxRoot, isStandAlone, appId, isEjb, vs);
        }
    }

    public void unregisterWebServiceEndpoints(String appId, BundleDescriptor bd) {
        this.instrumentWebServiceEndpoints(appId, bd, false);
    }

    public void registerWebServiceEndpoints(String appId, BundleDescriptor bd) {
        this.instrumentWebServiceEndpoints(appId, bd, true);
    }

    void instrument(String endpoint, String modName, String ctxRoot, boolean isStandAlone, String appId, boolean isEjbModule, String vs) {
        WebServiceConfigImpl wsConfig = (WebServiceConfigImpl)this.cfgProv.getWebServiceConfig(appId, modName, isStandAlone, endpoint);
        if (wsConfig == null) {
            return;
        }
        if (isStandAlone) {
            modName = appId;
            appId = null;
        }
        TransformMgr.getInstance().init(appId, wsConfig);
        try {
            new MonitoringLifeCycleImpl().initializeMonitoring(appId, modName, ctxRoot, isStandAlone, isEjbModule, vs, wsConfig);
        }
        catch (Exception e) {
            _logger.fine("Exception during monitoring initialization " + e.getMessage());
        }
    }

    void uninstrument(String endpoint, String modName, String ctxRoot, boolean isStandAlone, String appId, boolean isEjbModule, String vs) {
        try {
            MessageTraceMgr.getInstance().disable(appId, endpoint);
        }
        catch (Exception e) {
            _logger.fine("Exception while disabling trace" + e.getMessage());
        }
        WebServiceConfigImpl wsConfig = (WebServiceConfigImpl)this.cfgProv.getWebServiceConfig(appId, modName, isStandAlone, endpoint);
        if (wsConfig == null) {
            return;
        }
        if (isStandAlone) {
            modName = appId;
            appId = null;
        }
        TransformMgr.getInstance().stop(appId, wsConfig);
        try {
            new MonitoringLifeCycleImpl().uninitializeMonitoring(appId, modName, ctxRoot, isStandAlone, isEjbModule, vs, wsConfig);
        }
        catch (Exception e) {
            _logger.fine("Exception during monitoring shutdown " + e.getMessage());
        }
    }

    public void reconfigureMonitoring(WebServiceEndpoint ep, String appId, MonitoringLevel oldLevel, MonitoringLevel newLevel) throws MonitoringRegistrationException {
        if (oldLevel != MonitoringLevel.OFF && newLevel != MonitoringLevel.OFF) {
            return;
        }
        if (ep == null) {
            return;
        }
        boolean isEjb = false;
        boolean isStandAlone = false;
        String modName = null;
        String ctxRoot = null;
        String appName = null;
        String epName = null;
        String vs = "server";
        ConfigBean parent = (ConfigBean)ep.parent();
        if (parent instanceof J2eeApplication) {
            isStandAlone = false;
            appName = appId;
            modName = WebServiceMgrBackEnd.getManager().getModuleName(ep.getName());
            if (modName.endsWith("jar")) {
                isEjb = true;
            } else if (this.appsMgr != null) {
                WebBundleDescriptor wbd;
                Application app = null;
                try {
                    app = this.appsMgr.getDescriptor(appId);
                }
                catch (ConfigException ce) {
                    // empty catch block
                }
                if (app != null && (wbd = app.getWebBundleDescriptorByUri(modName)) != null) {
                    ctxRoot = wbd.getContextRoot();
                }
            }
        } else if (parent instanceof WebModule) {
            isStandAlone = true;
            appName = null;
            modName = appId;
            ctxRoot = ((WebModule)parent).getContextRoot();
        } else if (parent instanceof EjbModule) {
            isStandAlone = true;
            isEjb = true;
            appName = null;
            modName = appId;
        }
        epName = WebServiceMgrBackEnd.getManager().getEndpointName(ep.getName());
        new MonitoringLifeCycleImpl().instrumentMonitoring(epName, modName, ctxRoot, isStandAlone, vs, appName, oldLevel, newLevel, isEjb);
    }
}

