/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.callflow;

import com.sun.enterprise.admin.monitor.callflow.DbAccessObject;
import com.sun.enterprise.admin.monitor.callflow.EndTimeAccessObjectImpl;
import com.sun.enterprise.admin.monitor.callflow.EndTimeTO;
import com.sun.enterprise.admin.monitor.callflow.MethodEndAccessObjectImpl;
import com.sun.enterprise.admin.monitor.callflow.MethodEndTO;
import com.sun.enterprise.admin.monitor.callflow.MethodStartAccessObjectImpl;
import com.sun.enterprise.admin.monitor.callflow.MethodStartTO;
import com.sun.enterprise.admin.monitor.callflow.RequestEndAccessObjectImpl;
import com.sun.enterprise.admin.monitor.callflow.RequestEndTO;
import com.sun.enterprise.admin.monitor.callflow.RequestStartAccessObjectImpl;
import com.sun.enterprise.admin.monitor.callflow.RequestStartTO;
import com.sun.enterprise.admin.monitor.callflow.StartTimeAccessObjectImpl;
import com.sun.enterprise.admin.monitor.callflow.StartTimeTO;
import com.sun.enterprise.admin.monitor.callflow.TableAccessObject;
import com.sun.enterprise.admin.monitor.callflow.TraceOnHelper;
import com.sun.enterprise.admin.monitor.callflow.TransferObject;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbAccessObjectImpl
implements DbAccessObject {
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static DbAccessObject _singleton = new DbAccessObjectImpl();
    private static final String CALLFLOW_POOL_JNDI_NAME = "jdbc/__CallFlowPool__pm";
    private TableAccessObject reqStart = RequestStartAccessObjectImpl.getInstance();
    private TableAccessObject reqEnd = RequestEndAccessObjectImpl.getInstance();
    private TableAccessObject methStart = MethodStartAccessObjectImpl.getInstance();
    private TableAccessObject methEnd = MethodEndAccessObjectImpl.getInstance();
    private TableAccessObject startTime = StartTimeAccessObjectImpl.getInstance();
    private TableAccessObject endTime = EndTimeAccessObjectImpl.getInstance();
    private Connection connection = null;
    private PreparedStatement pstmtRS = null;
    private PreparedStatement pstmtRE = null;
    private PreparedStatement pstmtMS = null;
    private PreparedStatement pstmtME = null;
    private PreparedStatement pstmtST = null;
    private PreparedStatement pstmtET = null;
    private String serverName = null;
    private boolean traceOn = TraceOnHelper.isTraceOn();
    private int SECURITY_ID_INDEX_CSI = 13;
    private int TRANSACTION_ID_INDEX_CSI = 12;
    private int THREAD_ID_INDEX_CSI = 11;
    private int MODULE_NAME_INDEX_CSI = 10;
    private int METHOD_NAME_INDEX_CSI = 9;
    private int APP_NAME_INDEX_CSI = 8;
    private int COMPONENT_NAME_INDEX_CSI = 7;
    private int CONTAINER_TYPE_INDEX_CSI = 6;
    private int EXCEPTION_NAME_INDEX_CSI = 5;
    private int REQUEST_TYPE_INDEX_CSI = 4;
    private int TIMESTAMP_INDEX_CSI = 3;
    private int TABLE_TYPE_INDEX_CSI = 1;
    private int TIMESTAMP_MILLIS_INDEX_CSI = 14;

    private DbAccessObjectImpl() {
    }

    private TableAccessObject[] getAccessObjectsAsArray() {
        TableAccessObject[] tao = new TableAccessObject[]{this.reqStart, this.reqEnd, this.methStart, this.methEnd, this.startTime, this.endTime};
        return tao;
    }

    @Override
    public boolean enable() {
        this.setupConnection();
        boolean result = this.enable(this.connection);
        if (result) {
            try {
                this.createPreparedStatements();
            }
            catch (SQLException sqe) {
                logger.log(Level.SEVERE, "callflow.enable_failed", sqe);
                RuntimeException re = new RuntimeException("Cannot create SQL Statements to connect to Callflow DB. Is database up?");
                re.initCause(sqe);
                throw re;
            }
            finally {
                this.closeConnection();
            }
        } else if (!result) {
            logger.log(Level.SEVERE, "callflow.enable_failed");
            this.closeConnection();
            throw new RuntimeException("Error creating tables");
        }
        return result;
    }

    private boolean enable(Connection connection) {
        boolean rs = this.reqStart.createTable(connection);
        if (!rs) {
            return false;
        }
        boolean re = this.reqEnd.createTable(connection);
        if (!re) {
            return false;
        }
        boolean ms = this.methStart.createTable(connection);
        if (!ms) {
            return false;
        }
        boolean me = this.methEnd.createTable(connection);
        if (!me) {
            return false;
        }
        boolean st = this.startTime.createTable(connection);
        if (!st) {
            return false;
        }
        boolean et = this.endTime.createTable(connection);
        return et;
    }

    @Override
    public boolean disable() {
        this.closePreparedStatements();
        this.closeConnection();
        return true;
    }

    public static synchronized DbAccessObject getInstance() {
        return _singleton;
    }

    @Override
    public boolean clearData() {
        if (!this.setupConnection()) {
            return false;
        }
        boolean result = this.clearData(this.connection);
        this.closeConnection();
        return result;
    }

    private boolean clearData(Connection connection) {
        boolean rs = this.reqStart.dropTable(connection);
        boolean re = this.reqEnd.dropTable(connection);
        boolean ms = this.methStart.dropTable(connection);
        boolean me = this.methEnd.dropTable(connection);
        boolean st = this.startTime.dropTable(connection);
        boolean et = this.endTime.dropTable(connection);
        return rs && re && ms && me && st && et;
    }

    private boolean setupConnection() {
        try {
            boolean standaloneDb = Boolean.valueOf(System.getProperty("callflow.db.standalone"));
            if (!standaloneDb) {
                InitialContext ic = new InitialContext();
                DataSource ds = (DataSource)ic.lookup(CALLFLOW_POOL_JNDI_NAME);
                this.connection = ds.getConnection();
            } else {
                String url = "jdbc:derby://localhost:1527/sun-callflow;retrieveMessagesFromServerOnGetMessage=true;create=true;";
                Class.forName("org.apache.derby.jdbc.ClientDriver").newInstance();
                this.connection = DriverManager.getConnection(url, "APP", "APP");
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "callflow.connection_obtain_failed", e);
            logger.log(Level.SEVERE, "callflow.enable_failed");
            RuntimeException re = new RuntimeException("Error obtaining connection to callflow database. Is database started?. Refer logs for exact cause.", e.getCause());
            throw re;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Cannot close connection to CallFlow DB", e);
        }
        finally {
            this.connection = null;
        }
    }

    private void createPreparedStatements() throws SQLException {
        if (this.connection == null && !this.setupConnection()) {
            return;
        }
        this.pstmtRS = this.connection.prepareStatement(this.reqStart.getInsertSQL());
        this.pstmtRE = this.connection.prepareStatement(this.reqEnd.getInsertSQL());
        this.pstmtMS = this.connection.prepareStatement(this.methStart.getInsertSQL());
        this.pstmtME = this.connection.prepareStatement(this.methEnd.getInsertSQL());
        this.pstmtST = this.connection.prepareStatement(this.startTime.getInsertSQL());
        this.pstmtET = this.connection.prepareStatement(this.endTime.getInsertSQL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closePreparedStatements() {
        try {
            if (this.pstmtRS != null) {
                this.pstmtRS.close();
            }
        }
        catch (SQLException s) {
            logger.log(Level.FINE, "Could not close RequestStart SQL Statement", s);
        }
        finally {
            this.pstmtRS = null;
        }
        try {
            if (this.pstmtRE != null) {
                this.pstmtRE.close();
            }
        }
        catch (SQLException e) {
            logger.log(Level.FINE, "Could not close RequestEnd SQL Statement", e);
        }
        finally {
            this.pstmtRE = null;
        }
        try {
            if (this.pstmtMS != null) {
                this.pstmtMS.close();
            }
        }
        catch (SQLException se) {
            logger.log(Level.FINE, "Could not close MethodStart SQL Statement", se);
        }
        finally {
            this.pstmtMS = null;
        }
        try {
            if (this.pstmtME != null) {
                this.pstmtME.close();
            }
        }
        catch (SQLException sqe) {
            logger.log(Level.FINE, "Could not close MethodEnd SQL Statement", sqe);
        }
        finally {
            this.pstmtME = null;
        }
        try {
            if (this.pstmtST != null) {
                this.pstmtST.close();
            }
        }
        catch (SQLException sqe) {
            logger.log(Level.FINE, "Could not close StartTime SQL Statement", sqe);
        }
        finally {
            this.pstmtST = null;
        }
        try {
            if (this.pstmtET != null) {
                this.pstmtET.close();
            }
        }
        catch (SQLException sqe) {
            logger.log(Level.FINE, "Could not close EndTime SQL Statement", sqe);
        }
        finally {
            this.pstmtET = null;
        }
    }

    @Override
    public List<Map<String, String>> getRequestInformation() {
        if (this.connection == null) {
            this.setupConnection();
        }
        if (this.traceOn) {
            logger.log(Level.INFO, "Callflow: getRequestInfo");
        }
        assert (this.connection != null);
        ArrayList list = null;
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
            String query = this.generateQuerySQL(" SELECT REQUEST_START_TBL.REQUEST_ID , REQUEST_START_TBL.TIME_STAMP , REQUEST_START_TBL.TIME_STAMP_MILLIS , REQUEST_START_TBL.IP_ADDRESS , REQUEST_START_TBL.REQUEST_TYPE , METHOD_START_TBL.METHOD_NAME , METHOD_START_TBL.APP_NAME , METHOD_START_TBL.SECURITY_ID , METHOD_END_TBL.EXCEPTION_NAME , REQUEST_END_TBL.TIME_STAMP - REQUEST_START_TBL.TIME_STAMP FROM REQUEST_START_TBL , REQUEST_END_TBL , METHOD_START_TBL , METHOD_END_TBL WHERE REQUEST_START_TBL.REQUEST_ID = REQUEST_END_TBL.REQUEST_ID AND REQUEST_START_TBL.REQUEST_ID = METHOD_START_TBL.REQUEST_ID AND REQUEST_START_TBL.REQUEST_ID = METHOD_END_TBL.REQUEST_ID GROUP BY REQUEST_START_TBL.REQUEST_ID , REQUEST_START_TBL.TIME_STAMP , REQUEST_START_TBL.REQUEST_TYPE , REQUEST_START_TBL.TIME_STAMP_MILLIS , REQUEST_START_TBL.IP_ADDRESS , METHOD_START_TBL.TIME_STAMP , METHOD_START_TBL.METHOD_NAME , METHOD_START_TBL.APP_NAME , METHOD_START_TBL.SECURITY_ID , METHOD_END_TBL.EXCEPTION_NAME , REQUEST_END_TBL.TIME_STAMP , METHOD_END_TBL.TIME_STAMP HAVING METHOD_START_TBL.TIME_STAMP =  (  SELECT  MIN  ( METHOD_START_TBL.TIME_STAMP )  FROM METHOD_START_TBL WHERE METHOD_START_TBL.REQUEST_ID = REQUEST_START_TBL.REQUEST_ID ) AND METHOD_END_TBL.TIME_STAMP =  (  SELECT  MAX  ( METHOD_END_TBL.TIME_STAMP )  FROM METHOD_END_TBL WHERE METHOD_END_TBL.REQUEST_ID = REQUEST_START_TBL.REQUEST_ID )");
            stmt.executeQuery(query);
            ResultSet rs = stmt.getResultSet();
            list = new ArrayList();
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                String request_id = rs.getString("REQUEST_ID");
                map.put("RequestID", request_id);
                long time_stamp = rs.getLong("TIME_STAMP_MILLIS");
                map.put("TimeStampMillis", String.valueOf(time_stamp));
                String ip_address = rs.getString("IP_ADDRESS");
                map.put("ClientHost", ip_address);
                String request_type = rs.getString("REQUEST_TYPE");
                map.put("RequestType", request_type);
                String method_name = rs.getString("METHOD_NAME");
                map.put("MethodName", method_name);
                String app_name = rs.getString("APP_NAME");
                map.put("ApplicationName", app_name);
                String security_id = rs.getString("SECURITY_ID");
                map.put("User", security_id);
                String exception_name = rs.getString("EXCEPTION_NAME");
                map.put("Exception", exception_name);
                long time_taken = rs.getLong(10);
                map.put("ResponseTime", String.valueOf(time_taken));
                if (this.traceOn) {
                    logger.log(Level.INFO, "Callflow: getRequestInfo: ReqId =" + request_id + " , appname = " + app_name);
                }
                list.add(map);
            }
        }
        catch (SQLException se) {
            logger.log(Level.WARNING, "callflow.error_get_request_info");
            logger.log(Level.FINE, "callflow.error_sql_execute", se);
        }
        this.closeConnection();
        return list;
    }

    private String generateQuerySQL(String sql) {
        String newsql = new String(sql);
        String table = "REQUEST_START_TBL";
        String tableWithServerName = this.getTableWithServerName(table);
        newsql = newsql.replaceAll(table, tableWithServerName);
        table = "REQUEST_END_TBL";
        tableWithServerName = this.getTableWithServerName(table);
        newsql = newsql.replaceAll(table, tableWithServerName);
        table = "METHOD_START_TBL";
        tableWithServerName = this.getTableWithServerName(table);
        newsql = newsql.replaceAll(table, tableWithServerName);
        table = "METHOD_END_TBL";
        tableWithServerName = this.getTableWithServerName(table);
        newsql = newsql.replaceAll(table, tableWithServerName);
        if (this.traceOn) {
            logger.log(Level.INFO, "Callflow: Query = \n[ " + newsql + " ]");
        }
        return newsql;
    }

    private String getTableWithServerName(String oldTableName) {
        if (this.serverName == null) {
            this.serverName = this.reqStart.getServerInstanceName();
        }
        return oldTableName + this.serverName;
    }

    @Override
    public List<Map<String, String>> getCallStackInformation(String requestId) {
        if (this.connection == null && !this.setupConnection()) {
            return null;
        }
        assert (this.connection != null);
        ArrayList<HashMap<String, String>> list = null;
        PreparedStatement stmt = null;
        try {
            String sql = this.generateQuerySQL(" SELECT 'RequestStart' , REQUEST_START_TBL.REQUEST_ID , REQUEST_START_TBL.TIME_STAMP AS  TIMESTAMP  , REQUEST_START_TBL.REQUEST_TYPE , '' , '' , '' , '' , '' , '' , '' , '' , '' , REQUEST_START_TBL.TIME_STAMP_MILLIS FROM REQUEST_START_TBL WHERE REQUEST_START_TBL.REQUEST_ID =? UNION  (  SELECT 'MethodStart' , METHOD_START_TBL.REQUEST_ID , METHOD_START_TBL.TIME_STAMP AS  TIMESTAMP  , '' , '' , METHOD_START_TBL.COMPONENT_TYPE , METHOD_START_TBL.COMPONENT_NAME , METHOD_START_TBL.APP_NAME , METHOD_START_TBL.METHOD_NAME , METHOD_START_TBL.MODULE_NAME , METHOD_START_TBL.THREAD_ID , METHOD_START_TBL.TRANSACTION_ID , METHOD_START_TBL.SECURITY_ID , 0 FROM METHOD_START_TBL WHERE METHOD_START_TBL.REQUEST_ID = ? )  UNION  (  SELECT 'MethodEnd' , METHOD_END_TBL.REQUEST_ID , METHOD_END_TBL.TIME_STAMP AS  TIMESTAMP  , '' , METHOD_END_TBL.EXCEPTION_NAME , '' , '' , '' , '' , '' , '' , '' , '' , 0 FROM METHOD_END_TBL WHERE METHOD_END_TBL.REQUEST_ID = ? )  UNION  (  SELECT 'RequestEnd' , REQUEST_END_TBL.REQUEST_ID , REQUEST_END_TBL.TIME_STAMP AS  TIMESTAMP  , '' , '' , '' , '' , '' , '' , '' , '' , '' , '' , 0 FROM REQUEST_END_TBL WHERE REQUEST_END_TBL.REQUEST_ID = ? )  ORDER BY  TIMESTAMP ");
            stmt = this.connection.prepareStatement(sql);
            stmt.setString(1, requestId);
            stmt.setString(2, requestId);
            stmt.setString(3, requestId);
            stmt.setString(4, requestId);
            ResultSet rs = stmt.executeQuery();
            list = new ArrayList<HashMap<String, String>>();
            while (rs.next()) {
                Map<String, String> map = new HashMap<String, String>();
                String table_type = rs.getString(this.TABLE_TYPE_INDEX_CSI);
                table_type = table_type.trim();
                map.put("CallStackRowType", table_type);
                if ("RequestStart".equals(table_type)) {
                    map = this.getCallStackRequestStartInformation(rs, map);
                } else if ("RequestEnd".equals(table_type)) {
                    map = this.getCallStackRequestEndInformation(rs, map);
                } else if ("MethodEnd".equals(table_type)) {
                    map = this.getCallStackMethodEndInformation(rs, map);
                } else if ("MethodStart".equals(table_type)) {
                    map = this.getCallStackMethodStartInformation(rs, map);
                }
                list.add((HashMap<String, String>)map);
            }
            stmt.close();
        }
        catch (SQLException se) {
            logger.log(Level.FINE, "callflow.error_get_callstack_info", se);
        }
        this.closeConnection();
        return list;
    }

    private Map<String, String> getCallStackCommonInformation(ResultSet rs, Map<String, String> map) throws SQLException {
        String request_id = rs.getString("REQUEST_ID");
        map.put("RequestID", request_id);
        long time_stamp = rs.getLong(this.TIMESTAMP_INDEX_CSI);
        map.put("TimeStamp", String.valueOf(time_stamp));
        long time_stamp_millis = rs.getLong(this.TIMESTAMP_MILLIS_INDEX_CSI);
        map.put("TimeStampMillis", String.valueOf(time_stamp_millis));
        return map;
    }

    private Map<String, String> getCallStackRequestEndInformation(ResultSet rs, Map<String, String> map) throws SQLException {
        map = this.getCallStackCommonInformation(rs, map);
        return map;
    }

    private Map<String, String> getCallStackRequestStartInformation(ResultSet rs, Map<String, String> map) throws SQLException {
        map = this.getCallStackCommonInformation(rs, map);
        String request_type = rs.getString(this.REQUEST_TYPE_INDEX_CSI);
        map.put("RequestType", request_type);
        return map;
    }

    private Map<String, String> getCallStackMethodEndInformation(ResultSet rs, Map<String, String> map) throws SQLException {
        map = this.getCallStackCommonInformation(rs, map);
        String exception_name = rs.getString(this.EXCEPTION_NAME_INDEX_CSI);
        map.put("Exception", exception_name);
        String status2 = exception_name == null ? String.valueOf(Boolean.TRUE) : String.valueOf(Boolean.FALSE);
        map.put("Status", status2);
        return map;
    }

    private Map<String, String> getCallStackMethodStartInformation(ResultSet rs, Map<String, String> map) throws SQLException {
        map = this.getCallStackCommonInformation(rs, map);
        String container_type = rs.getString(this.CONTAINER_TYPE_INDEX_CSI);
        map.put("ContainerType", container_type);
        String component_name = rs.getString(this.COMPONENT_NAME_INDEX_CSI);
        map.put("ComponentName", component_name);
        String app_name = rs.getString(this.APP_NAME_INDEX_CSI);
        map.put("ApplicationName", app_name);
        String method_name = rs.getString(this.METHOD_NAME_INDEX_CSI);
        map.put("MethodName", method_name);
        String module_name = rs.getString(this.MODULE_NAME_INDEX_CSI);
        map.put("ModuleName", module_name);
        String thread_id = rs.getString(this.THREAD_ID_INDEX_CSI);
        map = this.getCallStackCommonInformation(rs, map);
        String exception_name = rs.getString(this.EXCEPTION_NAME_INDEX_CSI);
        map.put("Exception", exception_name);
        String status2 = exception_name == null ? String.valueOf(Boolean.TRUE) : String.valueOf(Boolean.FALSE);
        map.put("Status", status2);
        return map;
    }

    @Override
    public boolean insert(TransferObject[] transferObject) {
        boolean result = false;
        if (transferObject.length == 0) {
            return true;
        }
        if (transferObject[0] instanceof RequestStartTO) {
            result = this.pstmtRS == null ? false : this.reqStart.insert(this.pstmtRS, transferObject);
        } else if (transferObject[0] instanceof RequestEndTO) {
            result = this.pstmtRE == null ? false : this.reqEnd.insert(this.pstmtRE, transferObject);
        } else if (transferObject[0] instanceof MethodStartTO) {
            result = this.pstmtMS == null ? false : this.methStart.insert(this.pstmtMS, transferObject);
        } else if (transferObject[0] instanceof MethodEndTO) {
            result = this.pstmtME == null ? false : this.methEnd.insert(this.pstmtME, transferObject);
        } else if (transferObject[0] instanceof StartTimeTO) {
            result = this.pstmtST == null ? false : this.startTime.insert(this.pstmtST, transferObject);
        } else if (transferObject[0] instanceof EndTimeTO) {
            result = this.pstmtET == null ? false : this.endTime.insert(this.pstmtET, transferObject);
        }
        return result;
    }

    @Override
    public Map<String, String> getPieInformation(String requestId) {
        this.closeConnection();
        this.connection = null;
        if (this.connection == null && !this.setupConnection()) {
            return null;
        }
        HashMap<String, String> mapST = null;
        HashMap<String, String> mapET = null;
        HashMap<String, String> retMap = null;
        PreparedStatement st = null;
        PreparedStatement et = null;
        try {
            String startSql = this.generateQuerySQLForStartTimeAndEndTime(" SELECT START_TIME_TBL.CONT_TYPE_OR_APP_TYPE ,  SUM  ( START_TIME_TBL.TIME_STAMP )  FROM START_TIME_TBL WHERE START_TIME_TBL.REQUEST_ID =  ?  GROUP BY START_TIME_TBL.CONT_TYPE_OR_APP_TYPE");
            st = this.connection.prepareStatement(startSql);
            st.setString(1, requestId);
            ResultSet rs = st.executeQuery();
            mapST = new HashMap<String, String>();
            while (rs.next()) {
                String container_type = rs.getString(1);
                long time_taken = rs.getLong(2);
                mapST.put(container_type, String.valueOf(time_taken));
            }
            st.close();
            String endSql = this.generateQuerySQLForStartTimeAndEndTime(" SELECT END_TIME_TBL.CONT_TYPE_OR_APP_TYPE ,  SUM  ( END_TIME_TBL.TIME_STAMP )  FROM END_TIME_TBL WHERE END_TIME_TBL.REQUEST_ID =  ?  GROUP BY END_TIME_TBL.CONT_TYPE_OR_APP_TYPE");
            et = this.connection.prepareStatement(endSql);
            et.setString(1, requestId);
            rs = et.executeQuery();
            mapET = new HashMap<String, String>();
            while (rs.next()) {
                String container_type = rs.getString(1);
                long time_taken = rs.getLong(2);
                mapET.put(container_type, String.valueOf(time_taken));
            }
            et.close();
            retMap = new HashMap<String, String>();
            for (String key : mapST.keySet()) {
                String stime = (String)mapST.get(key);
                if (stime == null) continue;
                long startTime = Long.valueOf(stime);
                String etime = (String)mapET.get(key);
                if (etime == null) continue;
                long endTime = Long.valueOf(etime);
                long time_taken = endTime - startTime;
                retMap.put(key, String.valueOf(time_taken));
            }
        }
        catch (SQLException se) {
            logger.log(Level.FINE, "callflow.error_get_pie_info", se);
        }
        this.closeConnection();
        return retMap;
    }

    private String generateQuerySQLForStartTimeAndEndTime(String sql) {
        String newsql = new String(sql);
        String table = "START_TIME_TBL";
        String tableWithServerName = this.getTableWithServerName(table);
        newsql = newsql.replaceAll(table, tableWithServerName);
        table = "END_TIME_TBL";
        tableWithServerName = this.getTableWithServerName(table);
        newsql = newsql.replaceAll(table, tableWithServerName);
        return newsql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteRequestIds(String[] requestIds) {
        if (requestIds.length <= 0) {
            return true;
        }
        boolean resultRS = false;
        boolean resultRE = false;
        boolean resultMS = false;
        boolean resultME = false;
        boolean resultCS = false;
        boolean resultCE = false;
        PreparedStatement rs = null;
        PreparedStatement re = null;
        PreparedStatement ms = null;
        PreparedStatement me = null;
        PreparedStatement st = null;
        PreparedStatement et = null;
        if (this.connection == null && !this.setupConnection()) {
            return false;
        }
        try {
            rs = this.connection.prepareStatement(this.reqStart.getDeleteSQL());
            boolean bl = resultRS = rs == null ? false : this.reqStart.delete(rs, requestIds);
            if (!resultRS) {
                logger.log(Level.FINE, "Error deleting requests from Request Start Table");
            }
        }
        catch (SQLException se) {
            logger.log(Level.FINE, "Error deleting requests from Request Start Table", se);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException se) {
                }
                finally {
                    rs = null;
                }
            }
        }
        try {
            re = this.connection.prepareStatement(this.reqEnd.getDeleteSQL());
            boolean bl = resultRE = re == null ? false : this.reqEnd.delete(re, requestIds);
            if (!resultRE) {
                logger.log(Level.FINE, "Error deleting requests from Request End Table");
            }
        }
        catch (SQLException se) {
            logger.log(Level.FINE, "Error deleting requests from Request End Table", se);
        }
        finally {
            if (re != null) {
                try {
                    re.close();
                }
                catch (SQLException se) {
                }
                finally {
                    re = null;
                }
            }
        }
        try {
            ms = this.connection.prepareStatement(this.methStart.getDeleteSQL());
            boolean bl = resultMS = ms == null ? false : this.methStart.delete(ms, requestIds);
            if (!resultMS) {
                logger.log(Level.FINE, "Error deleting requests from Method Start Table");
            }
        }
        catch (SQLException se) {
            logger.log(Level.FINE, "Error deleting requests from Method Start Table", se);
        }
        finally {
            if (ms != null) {
                try {
                    ms.close();
                }
                catch (SQLException se) {
                }
                finally {
                    ms = null;
                }
            }
        }
        try {
            me = this.connection.prepareStatement(this.methEnd.getDeleteSQL());
            boolean bl = resultME = me == null ? false : this.methEnd.delete(me, requestIds);
            if (!resultME) {
                logger.log(Level.FINE, "Error deleting requests from Method End Table");
            }
        }
        catch (SQLException se) {
            logger.log(Level.FINE, "Error deleting requests from MethodEnd Table", se);
        }
        finally {
            if (me != null) {
                try {
                    me.close();
                }
                catch (SQLException se) {
                }
                finally {
                    me = null;
                }
            }
        }
        try {
            st = this.connection.prepareStatement(this.startTime.getDeleteSQL());
            boolean bl = resultCS = st == null ? false : this.startTime.delete(st, requestIds);
            if (!resultCS) {
                logger.log(Level.FINE, "Error deleting requests from Container Start Table");
            }
        }
        catch (SQLException se) {
            logger.log(Level.FINE, "Error deleting requests from Container Start Table", se);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException se) {
                }
                finally {
                    st = null;
                }
            }
        }
        try {
            et = this.connection.prepareStatement(this.endTime.getDeleteSQL());
            boolean bl = resultCE = et == null ? false : this.endTime.delete(et, requestIds);
            if (!resultCE) {
                logger.log(Level.FINE, "Error deleting requests from Container End Table");
            }
        }
        catch (SQLException se) {
            logger.log(Level.FINE, "Error deleting requests from End time Table", se);
        }
        finally {
            if (et != null) {
                try {
                    et.close();
                }
                catch (SQLException se) {
                }
                finally {
                    et = null;
                }
            }
        }
        return resultRS && resultRE && resultMS && resultME && resultCS && resultCE;
    }

    @Override
    public Map getNumOfRequestsProcessed() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        TableAccessObject[] tao = this.getAccessObjectsAsArray();
        for (int i = 0; i < tao.length && tao[i] != null; ++i) {
            map.put(tao[i].getName(), tao[i].getTotalEntriesProcessed());
        }
        return map;
    }

    @Override
    public String getNumOfRequestsProcessedAsString() {
        Map map = this.getNumOfRequestsProcessed();
        Set keys = map.keySet();
        StringBuffer sb = new StringBuffer();
        for (String key : keys) {
            sb.append(" " + key + " : " + map.get(key));
        }
        return sb.toString();
    }
}

