/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote.server.servlet;

import com.sun.enterprise.admin.jmx.remote.server.MBeanServerRequestHandler;
import com.sun.enterprise.admin.jmx.remote.streams.JMXChunkedInputStream;
import com.sun.enterprise.admin.jmx.remote.streams.JMXChunkedOutputStream;
import com.sun.enterprise.admin.jmx.remote.streams.JMXInbandStream;
import com.sun.enterprise.admin.jmx.remote.streams.StreamMBeanServerRequestMessage;
import com.sun.enterprise.admin.jmx.remote.streams.StreamMBeanServerResponseMessage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.management.remote.message.MBeanServerRequestMessage;
import javax.management.remote.message.MBeanServerResponseMessage;
import javax.management.remote.message.Message;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RemoteJmxConnectorServlet
extends HttpServlet {
    private MBeanServerRequestHandler requestHandler;
    private final String BINARY_DATA_TYPE = "application/octet-stream";
    private static final Logger logger = Logger.getLogger("com.sun.logging.enterprise.system.admin.jmx.connector");

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.requestHandler = new MBeanServerRequestHandler(config);
    }

    public void destroy() {
        this.requestHandler.getNotificationManager().close();
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String pathInfo = request.getPathInfo();
            if (pathInfo != null && pathInfo.trim().equals("/NotificationManager")) {
                this.requestHandler.getNotificationManager().getNotifications(request, response);
                return;
            }
            Message requestMessage = this.readRequestMessage(request);
            MBeanServerResponseMessage responseMessage = this.requestHandler.handle((MBeanServerRequestMessage)requestMessage);
            this.drainInputStream();
            JMXInbandStream.setIncomingStream(null);
            MBeanServerResponseMessage tempMsg = responseMessage;
            StreamMBeanServerResponseMessage resmsg = new StreamMBeanServerResponseMessage(tempMsg.getMessageId(), tempMsg.getWrappedResult(), tempMsg.isException());
            InputStream in = JMXInbandStream.getOutgoingStream();
            if (in != null) {
                resmsg.setStreamAvailable(true);
            }
            ServletOutputStream out = response.getOutputStream();
            this.sendResponseMessage(response, (Message)resmsg, (OutputStream)out);
            if (in != null) {
                this.sendStream(in, (OutputStream)out, this.getContentLength((Serializable)resmsg));
            }
        }
        catch (ClassNotFoundException ce) {
            String message = "Detailed Message: Error in calling in Servlet:processRequest, actual exception is attached";
            throw new ServletException("Detailed Message: Error in calling in Servlet:processRequest, actual exception is attached", (Throwable)ce);
        }
    }

    private void drainInputStream() {
        InputStream in = JMXInbandStream.getInputStream();
        if (in != null) {
            byte[] bytes = new byte[8192];
            try {
                while (in.read(bytes) != -1) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void sendStream(InputStream in, OutputStream out, int padLen) throws IOException {
        JMXChunkedOutputStream o = new JMXChunkedOutputStream(out);
        byte[] bytes = new byte[8192];
        int len = 0;
        while ((len = in.read(bytes)) != -1) {
            o.write(bytes, 0, len);
        }
        JMXInbandStream.setOutputStream(null, (long)0L);
        o.flush();
        o.writeEOF(padLen);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    private Message readRequestMessage(HttpServletRequest request) throws IOException, ClassNotFoundException {
        JMXInbandStream.setOutputStream(null, (long)0L);
        ServletInputStream in = request.getInputStream();
        ObjectInputStream ois = new ObjectInputStream((InputStream)in);
        MBeanServerRequestMessage m = (MBeanServerRequestMessage)ois.readObject();
        StreamMBeanServerRequestMessage streamm = (StreamMBeanServerRequestMessage)m;
        if (streamm.isStreamAvailable()) {
            JMXInbandStream.setIncomingStream((InputStream)new JMXChunkedInputStream((InputStream)in));
        }
        logger.fine("Method id is: " + m.getMethodId());
        return m;
    }

    private void sendResponseMessage(HttpServletResponse response, Message message, OutputStream out) throws IOException {
        this.configureResponse(response, message);
        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(out));
        oos.writeObject(message);
        oos.flush();
    }

    private void configureResponse(HttpServletResponse response, Message message) {
        response.setContentType("application/octet-stream");
        int reslen = this.getContentLength((Serializable)message);
        if (JMXInbandStream.getOutgoingStream() != null) {
            int len = (int)JMXInbandStream.getOutgoingStreamLength();
            int chunks = len / 8192 + 2;
            reslen += len + chunks * 4;
        }
        response.setContentLength(reslen);
        response.setHeader("Connection", "Keep-Alive");
        response.setStatus(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getContentLength(Serializable serObject) {
        int size = 0;
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(serObject);
            size = baos.size();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }
}

