/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.common;

import com.sun.enterprise.admin.common.ByteChunk;
import java.io.File;
import java.io.Serializable;

public class DownloadRequestInfo
implements Serializable {
    private String _downloadFilePath;
    private int _numChunks;
    private long _numBytesSent;
    private boolean _isPrepared;
    private int _chunkIndex;
    private ByteChunk _chunk;
    private long _totalFileSize;

    private DownloadRequestInfo() {
        this._downloadFilePath = null;
        this._numChunks = 0;
        this._numBytesSent = 0L;
        this._isPrepared = false;
        this._chunkIndex = -1;
        this._chunk = null;
    }

    public DownloadRequestInfo(File f) {
        if (f.exists()) {
            this._downloadFilePath = f.getAbsolutePath();
            this._totalFileSize = f.length();
            this._numChunks = (int)(this._totalFileSize / 0xA00000L);
            if ((long)this._numChunks * 0xA00000L < this._totalFileSize) {
                ++this._numChunks;
            }
            this._isPrepared = true;
            this._chunkIndex = 0;
        }
    }

    public String getDownloadFilePath() {
        return this._downloadFilePath;
    }

    void setDownloadFilePath(String f) {
        this._downloadFilePath = f;
    }

    public int getNumberOfChunks() {
        return this._numChunks;
    }

    void setNumberOfChunks(int n) {
        this._numChunks = n;
    }

    public boolean isPrepared() {
        return this._isPrepared;
    }

    void setPrepared(boolean p) {
        this._isPrepared = p;
    }

    public int getChunkIndex() {
        return this._chunkIndex;
    }

    void setChunkIndex(int i) {
        this._chunkIndex = i;
        this._chunk = null;
    }

    public long getNumberOfBytesSent() {
        return this._numBytesSent;
    }

    public void incrementNumberOfBytesSent(int bytesRead) {
        this._numBytesSent += (long)bytesRead;
    }

    public boolean isFirstChunk() {
        return this._chunkIndex == 0;
    }

    public boolean isLastChunk() {
        return this._chunkIndex == this._numChunks - 1;
    }

    public ByteChunk getChunk() {
        return this._chunk;
    }

    public void setChunk(ByteChunk chunk) {
        this._chunk = chunk;
    }

    public long getTotalFileSize() {
        return this._totalFileSize;
    }
}

