/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.JbiTargetTask;
import com.sun.jbi.ui.common.JBIManagementMessage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbiListConfigurationTask
extends JbiTargetTask {
    private static final String SUCCESS_STATUS_KEY = "jbi.ui.ant.list.configuration.successful";
    private static final String FAILED_STATUS_KEY = "jbi.ui.ant.list.configuration.failed";
    private static final String INSTANCE_ERROR_PROP = "com.sun.jbi.cluster.instance.error";
    private String mComponentName = null;

    public String getComponentName() {
        return this.mComponentName;
    }

    public void setComponentName(String componentName) {
        this.mComponentName = componentName;
    }

    private void executeListRuntimeConfiguration() throws BuildException {
        this.logDebug("Executing List Runtime Configuration ....");
        String target = this.getValidTarget();
        try {
            Properties params = this.getJBIAdminCommands().getRuntimeConfiguration(target);
            this.printRuntimeConfiguration(params);
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    private void executeListComponentConfiguration(String componentName) throws BuildException {
        this.logDebug("Executing List Component Configuration ....");
        String target = this.getValidTarget();
        try {
            Map<String, Properties> paramsMap = this.getJBIAdminCommands().getComponentConfiguration(componentName, target);
            this.printComponentConfiguration(componentName, paramsMap, target);
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    @Override
    public void executeTask() throws BuildException {
        this.logDebug("Executing List Configuration Task....");
        String compName = this.getComponentName();
        if (compName != null && compName.trim().length() > 0) {
            this.executeListComponentConfiguration(compName);
        } else {
            this.executeListRuntimeConfiguration();
        }
    }

    @Override
    protected String getTaskFailedStatusI18NKey() {
        return FAILED_STATUS_KEY;
    }

    @Override
    protected String getTaskSuccessStatusI18NKey() {
        return SUCCESS_STATUS_KEY;
    }

    protected String getEmptyQueryResultI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.config.info.empty" : "jbi.ui.ant.print.jbi.comp.config.info.empty";
    }

    protected String getQueryResultHeaderI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.config.info.header" : "jbi.ui.ant.print.jbi.comp.config.info.header";
    }

    protected String getQueryResultHeaderSeparatorI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.config.info.header.separator" : "jbi.ui.ant.print.jbi.comp.config.info.header.separator";
    }

    protected String getQueryResultPageSeparatorI18NKey(boolean isRuntime) {
        return isRuntime ? "jbi.ui.ant.print.jbi.config.info.separator" : "jbi.ui.ant.print.jbi.comp.config.info.separator";
    }

    protected void printRuntimeConfiguration(Properties params) {
        this.logDebug("Printing Rimtime Configuration ....");
        if (params == null) {
            this.logDebug("List Runtime Configuration params returns NULL");
        } else {
            this.logDebug("Size of Runtime configuration Parameters " + params.size());
        }
        boolean isRuntime = true;
        String header = this.getI18NBundle().getMessage(this.getQueryResultHeaderI18NKey(isRuntime), this.getValidTarget());
        String headerSeparator = this.getI18NBundle().getMessage(this.getQueryResultHeaderSeparatorI18NKey(isRuntime));
        String pageSeparator = this.getI18NBundle().getMessage(this.getQueryResultPageSeparatorI18NKey(isRuntime));
        String emptyResult = this.getI18NBundle().getMessage(this.getEmptyQueryResultI18NKey(isRuntime));
        StringWriter stringWriter = new StringWriter();
        PrintWriter msgWriter = new PrintWriter(stringWriter);
        msgWriter.println(headerSeparator);
        msgWriter.println(header);
        msgWriter.println(headerSeparator);
        if (params == null || params.size() <= 0) {
            msgWriter.println(emptyResult);
            msgWriter.println(pageSeparator);
        } else {
            TreeSet<Object> keys = new TreeSet<Object>(params.keySet());
            for (Object e : keys) {
                String name = (String)e;
                String value = params.getProperty(name, "");
                String param = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.config.param", name, value);
                msgWriter.println(param);
            }
            msgWriter.println(pageSeparator);
        }
        msgWriter.close();
        this.printMessage(stringWriter.getBuffer().toString());
    }

    protected void printComponentConfiguration(String compName, Map<String, Properties> paramsMap, String target) {
        this.logDebug("Printing Component Configuration .... for component=" + compName + " on target=" + target);
        if (paramsMap == null) {
            this.logDebug("List Component Configuration params Map is NULL");
        } else {
            this.logDebug("List Component Configuration params Map size " + paramsMap.size());
        }
        boolean isRuntime = false;
        String header = this.getI18NBundle().getMessage(this.getQueryResultHeaderI18NKey(isRuntime), new String[]{compName, target});
        String headerSeparator = this.getI18NBundle().getMessage(this.getQueryResultHeaderSeparatorI18NKey(isRuntime));
        String pageSeparator = this.getI18NBundle().getMessage(this.getQueryResultPageSeparatorI18NKey(isRuntime));
        String emptyResult = this.getI18NBundle().getMessage(this.getEmptyQueryResultI18NKey(isRuntime));
        StringWriter stringWriter = new StringWriter();
        PrintWriter msgWriter = new PrintWriter(stringWriter);
        msgWriter.println(headerSeparator);
        msgWriter.println(header);
        msgWriter.println(headerSeparator);
        if (paramsMap == null || paramsMap.size() <= 0) {
            msgWriter.println(emptyResult);
            msgWriter.println(pageSeparator);
        } else {
            TreeSet<String> instanceSet = new TreeSet<String>(paramsMap.keySet());
            for (String instance : instanceSet) {
                msgWriter.println(this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.comp.config.instance", instance));
                Properties params = paramsMap.get(instance);
                TreeSet<Object> keys = new TreeSet<Object>(params.keySet());
                String instanceErrorXml = params.getProperty(INSTANCE_ERROR_PROP, null);
                if (instanceErrorXml != null) {
                    JBIManagementMessage errMsg = JBIManagementMessage.createJBIManagementMessage(instanceErrorXml);
                    String string = errMsg != null ? errMsg.getMessage() : instanceErrorXml;
                    msgWriter.println(string);
                    msgWriter.println(pageSeparator);
                    continue;
                }
                for (Object e : keys) {
                    String name = (String)e;
                    String value = params.getProperty(name, "");
                    String param = this.getI18NBundle().getMessage("jbi.ui.ant.print.jbi.comp.config.param", name, value);
                    msgWriter.println(param);
                }
                msgWriter.println(pageSeparator);
            }
        }
        msgWriter.close();
        this.printMessage(stringWriter.getBuffer().toString());
    }
}

