/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.lifecycle;

import com.sun.mfwk.agent.appserv.ASServerManager;
import com.sun.mfwk.agent.appserv.ASServerManagerRegistry;
import com.sun.mfwk.agent.appserv.connection.ConnectionRegistry;
import com.sun.mfwk.agent.appserv.discovery.ASMBeanDiscoveryService;
import com.sun.mfwk.agent.appserv.discovery.ASMBeanDiscoveryServiceFactory;
import com.sun.mfwk.agent.appserv.discovery.CMMMBeanDiscoveryService;
import com.sun.mfwk.agent.appserv.discovery.CMMMBeanDiscoveryServiceFactory;
import com.sun.mfwk.agent.appserv.logging.LogDomains;
import com.sun.mfwk.agent.appserv.mapping.AS_ObjectNameNotFoundException;
import com.sun.mfwk.agent.appserv.mapping.MappingQueryService;
import com.sun.mfwk.agent.appserv.mapping.MappingQueryServiceFactory;
import com.sun.mfwk.agent.appserv.modeler.ObjectNameHelper;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ListenerImpl
implements NotificationListener {
    private String server;
    private String domain;
    private ASServerManager mediator;
    private Logger logger;
    private static final String REGISTER_EVENT = "JMX.mbean.registered";
    private static final String UNREGISTER_EVENT = "JMX.mbean.unregistered";
    private static final String OBJECT_NAME = "objectName";
    private static final String CMM_OBJECT_TYPE = "core";

    public ListenerImpl(String server, String domain) throws IOException {
        this.server = server;
        this.domain = domain;
        ASServerManagerRegistry serverManagerRegistry = ASServerManagerRegistry.getInstance();
        this.mediator = serverManagerRegistry.getASServerManager(server, domain);
    }

    public void handleNotification(Notification notification, Object handback) {
        if (notification.getClass().getName().equals("javax.management.MBeanServerNotification")) {
            MBeanServerNotification mbeanServerNotification = (MBeanServerNotification)notification;
            ObjectName asObjectName = (ObjectName)mbeanServerNotification.getUserData();
            Object monitoringASMBean = null;
            if (asObjectName != null && this.server != null) {
                if (REGISTER_EVENT.equals(notification.getType())) {
                    this.loadCmmMbean(asObjectName);
                }
                if (UNREGISTER_EVENT.equals(notification.getType())) {
                    this.unloadCmmMbean(asObjectName);
                }
            }
        }
    }

    private void loadCmmMbeans(ObjectName objectName) {
        block4: {
            ASServerManager mediator;
            this.logger = this.getLogger();
            if (this.logger != null) {
                this.logger.log(Level.FINE, "Loading CMM objects for " + objectName);
            }
            if ((mediator = new ASServerManager(this.server, this.domain)) == null || objectName == null) {
                throw new IllegalArgumentException();
            }
            try {
                ConnectionRegistry registry = ConnectionRegistry.getInstance();
                MBeanServerConnection connection = registry.getConnection(this.server, this.domain);
                ASMBeanDiscoveryServiceFactory dicoveryServiceFactory = ASMBeanDiscoveryServiceFactory.getInstance();
                ASMBeanDiscoveryService discoveryService = dicoveryServiceFactory.getASMBeanDiscoveryService(connection);
                Set asMbeans = discoveryService.discoverASMBeans(objectName);
                mediator.load(asMbeans);
            }
            catch (Exception e) {
                if (this.logger == null) break block4;
                this.logger.log(Level.SEVERE, "Error while loading AS mbeans", e);
            }
        }
    }

    private void loadCmmMbean(ObjectName objectName) {
        block4: {
            this.logger = this.getLogger();
            if (this.logger != null) {
                this.logger.log(Level.FINE, "Loading CMM object for " + objectName);
            }
            if (this.mediator == null || objectName == null) {
                throw new IllegalArgumentException();
            }
            try {
                this.mediator.load(objectName);
            }
            catch (Exception e) {
                if (this.logger == null) break block4;
                this.logger.log(Level.SEVERE, "Error while loading AS mbeans", e);
            }
        }
    }

    private void unloadCmmMbeans(ObjectName asObjectName) {
        block10: {
            this.logger = this.getLogger();
            if (this.logger != null) {
                this.logger.log(Level.FINE, "unloading CMM objects for " + asObjectName);
            }
            try {
                ASServerManager mediator = new ASServerManager(this.server, this.domain);
                if (mediator == null || asObjectName == null) {
                    throw new IllegalArgumentException();
                }
                String cmmObjectNameTemplate = this.getCMMObjectName(asObjectName.toString(), CMM_OBJECT_TYPE);
                if (cmmObjectNameTemplate != null) {
                    Hashtable<String, String> tokenMap = new Hashtable<String, String>();
                    tokenMap.put("server.name", this.server);
                    tokenMap.put("domain.name", this.domain);
                    String cmmObjectName = ObjectNameHelper.tokenizeON(asObjectName, cmmObjectNameTemplate, tokenMap);
                    CMMMBeanDiscoveryServiceFactory dicoveryServiceFactory = CMMMBeanDiscoveryServiceFactory.getInstance();
                    CMMMBeanDiscoveryService discoveryService = dicoveryServiceFactory.getCMMMBeanDiscoveryService();
                    if (discoveryService != null) {
                        Set cmmMBeans = discoveryService.discoverCMMMBeans(new ObjectName(cmmObjectName));
                        mediator.unload(cmmMBeans);
                    } else if (this.logger != null) {
                        this.logger.log(Level.SEVERE, "Error - Not able to get hold of Discovery Service");
                    }
                } else if (this.logger != null) {
                    this.logger.log(Level.SEVERE, "Error - Not able to get hold of core CMM Object");
                }
            }
            catch (Exception exception) {
                if (this.logger == null) break block10;
                this.logger.log(Level.SEVERE, "Error while unloading AS mbeans", exception);
            }
        }
    }

    private void unloadCmmMbean(ObjectName asObjectName) {
        block8: {
            this.logger = this.getLogger();
            if (this.logger != null) {
                this.logger.log(Level.FINE, "unloading CMM objects for " + asObjectName);
            }
            try {
                if (this.mediator == null || asObjectName == null) {
                    throw new IllegalArgumentException();
                }
                Set cmmObjectNameTemplates = this.getCMMObjectNames(asObjectName.toString());
                if (cmmObjectNameTemplates != null) {
                    Hashtable<String, String> tokenMap = new Hashtable<String, String>();
                    tokenMap.put("server.name", this.server);
                    tokenMap.put("domain.name", this.domain);
                    String cmmObjectName = null;
                    HashSet<ObjectName> cmmMBeans = new HashSet<ObjectName>();
                    Iterator iterator = cmmObjectNameTemplates.iterator();
                    while (iterator.hasNext()) {
                        cmmObjectName = ObjectNameHelper.tokenizeON(asObjectName, (String)iterator.next(), tokenMap);
                        cmmMBeans.add(new ObjectName(cmmObjectName));
                    }
                    this.mediator.unload(cmmMBeans);
                } else if (this.logger != null) {
                    this.logger.log(Level.SEVERE, "Error - Not able to get hold of CMM Object Names");
                }
            }
            catch (Exception exception) {
                if (this.logger == null) break block8;
                this.logger.log(Level.SEVERE, "Error while unloading AS mbeans", exception);
            }
        }
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = LogDomains.getLogger();
        }
        return this.logger;
    }

    private String getCMMObjectName(String AS_ObjectName, String type) throws AS_ObjectNameNotFoundException, IOException {
        String cmmObjectNameTemplate = null;
        MappingQueryServiceFactory mqsf = MappingQueryServiceFactory.getInstance();
        MappingQueryService queryService = mqsf.getMappingQueryService(this.server, this.domain);
        NodeList nodeList = queryService.getCMM_Mbeans(AS_ObjectName, type);
        Element cmmElement = null;
        if (nodeList.getLength() == 1) {
            cmmElement = (Element)nodeList.item(0);
            if (cmmElement == null) {
                throw new AS_ObjectNameNotFoundException(AS_ObjectName);
            }
            cmmObjectNameTemplate = cmmElement.getAttribute(OBJECT_NAME);
        }
        return cmmObjectNameTemplate;
    }

    private Set getCMMObjectNames(String AS_ObjectName) throws AS_ObjectNameNotFoundException, IOException {
        HashSet<String> cmmObjectNameTemplates = new HashSet<String>();
        MappingQueryServiceFactory mqsf = MappingQueryServiceFactory.getInstance();
        MappingQueryService queryService = mqsf.getMappingQueryService(this.server, this.domain);
        NodeList nodeList = queryService.getCMM_Mbeans(AS_ObjectName);
        Element cmmElement = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            cmmElement = (Element)nodeList.item(i);
            if (cmmElement == null) {
                throw new AS_ObjectNameNotFoundException(AS_ObjectName);
            }
            cmmObjectNameTemplates.add(cmmElement.getAttribute(OBJECT_NAME));
        }
        return cmmObjectNameTemplates;
    }
}

