/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.discovery;

import com.sun.mfwk.agent.appserv.discovery.CMMMBeanDiscoveryService;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;

class CMMMBeanDiscoveryServiceImpl
implements CMMMBeanDiscoveryService {
    MBeanServer mbeanServer;
    public static final String TYPE = "type";
    public static final String APPLICATION = "CMM_J2eeApplication";
    public static final String APPLICATION_KEY = "application";
    public static final String STANDALONE_WEB_MODULE = "CMM_J2eeWebModule";
    public static final String STANDALONE_WEB_MODULE_KEY = "standalone-web-module";
    public static final String STANDALONE_EJB_MODULE = "CMM_J2eeEJBModule";
    public static final String STANDALONE_EJB_MODULE_KEY = "standalone-ejb-module";
    public static final String DOMAIN_KEY = "domain";
    public static final String SERVER_KEY = "server";
    public static final String NAME_KEY = "name";
    public static final String NAME = "name";
    public static final String SERVER = "server";
    public static final String DOMAIN = "domain";
    public static final String CLUSTER = "CMM_J2eeCluster";
    public static final String INSTALLED_PRODUCT = "CMM_InstalledProduct";

    public CMMMBeanDiscoveryServiceImpl(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public Set discoverCMMMBeans() throws Exception {
        HashSet mbeans = new HashSet();
        return mbeans;
    }

    public Set discoverCMMMBeans(String serverName, String domainName) throws Exception {
        HashSet<ObjectName> mbeans = new HashSet<ObjectName>();
        String serverPattern = "com.sun.cmm.as:*,server=" + serverName + "," + "domain" + "=" + domainName;
        ObjectName sp = new ObjectName(serverPattern);
        mbeans.addAll(this.mbeanServer.queryNames(sp, null));
        String runtimePattern = "com.sun.cmm.as:*,name=" + serverName + "," + "domain" + "=" + domainName;
        ObjectName rp = new ObjectName(runtimePattern);
        Set<ObjectName> runtimeObjects = this.mbeanServer.queryNames(rp, null);
        HashSet<ObjectName> filteredRuntimeObjects = new HashSet<ObjectName>();
        Iterator<ObjectName> iterator = runtimeObjects.iterator();
        ObjectName runtimeObjectName = null;
        while (iterator.hasNext()) {
            runtimeObjectName = iterator.next();
            try {
                if (null != runtimeObjectName.getKeyProperty("server")) continue;
                filteredRuntimeObjects.add(runtimeObjectName);
            }
            catch (NullPointerException npe) {}
        }
        mbeans.addAll(filteredRuntimeObjects);
        String domainPattern = "com.sun.cmm.as:*,name=" + domainName;
        ObjectName dp = new ObjectName(domainPattern);
        mbeans.addAll(this.mbeanServer.queryNames(dp, null));
        return mbeans;
    }

    public Set discoverClusterCMMMBeans() throws Exception {
        String clusterPattern = "com.sun.cmm.as:*,type=CMM_J2eeCluster";
        return this.mbeanServer.queryNames(new ObjectName(clusterPattern), null);
    }

    public Set discoverInstalledProductCMMMBeans() throws Exception {
        String installedProductPattern = "com.sun.cmm.as:*,type=CMM_InstalledProduct";
        return this.mbeanServer.queryNames(new ObjectName(installedProductPattern), null);
    }

    public Set discoverCMMMBeans(ObjectName objectName) throws Exception {
        HashSet<ObjectName> mbeans = new HashSet<ObjectName>();
        mbeans.add(objectName);
        String type = objectName.getKeyProperty(TYPE);
        String key = this.getKey(type);
        if (key != null) {
            String name = objectName.getKeyProperty("name");
            String serverName = objectName.getKeyProperty("server");
            String domainName = objectName.getKeyProperty("domain");
            String patternString = "com.sun.cmm.as:*," + key + "=" + name + "," + "server" + "=" + serverName + "," + "domain" + "=" + domainName;
            ObjectName pattern = new ObjectName(patternString);
            mbeans.addAll(this.mbeanServer.queryNames(pattern, null));
        }
        return mbeans;
    }

    public ObjectName discoverCMMMBean(String name) throws Exception {
        ObjectName objectName = new ObjectName(name);
        if (this.mbeanServer.isRegistered(objectName)) {
            return objectName;
        }
        return null;
    }

    private String getKey(String cmmType) {
        if (APPLICATION.equals(cmmType)) {
            return APPLICATION_KEY;
        }
        if (STANDALONE_WEB_MODULE.equals(cmmType)) {
            return STANDALONE_WEB_MODULE_KEY;
        }
        if (STANDALONE_EJB_MODULE.equals(cmmType)) {
            return STANDALONE_EJB_MODULE_KEY;
        }
        return null;
    }
}

