/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.delegate;

import com.sun.mfwk.agent.appserv.delegate.BaseHandler;
import com.sun.mfwk.agent.appserv.delegate.HandlerException;
import com.sun.mfwk.agent.appserv.util.Utils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class ServerURLHandler
extends BaseHandler {
    public Object handleAttribute(ObjectName peer, String attribute, MBeanServerConnection mbs) throws HandlerException, AttributeNotFoundException, MBeanException, ReflectionException, InstanceNotFoundException, IOException {
        try {
            String serverName = peer.getKeyProperty("name");
            ObjectName serverObjectName = new ObjectName("com.sun.appserv:type=server,name=" + serverName + ",category=config");
            String configRef = (String)mbs.getAttribute(serverObjectName, "config-ref");
            ObjectName listenersObjectName = new ObjectName("com.sun.appserv:type=virtual-server,id=" + serverName + ",config=" + configRef + ",category=config");
            String listeners = (String)mbs.getAttribute(listenersObjectName, "http-listeners");
            List listenerList = this.parseStringList(listeners, " ,");
            ArrayList<String> urls = new ArrayList<String>(listenerList.size());
            StringBuffer url = null;
            Iterator iterator = listenerList.iterator();
            while (iterator.hasNext()) {
                ObjectName listenerObjectName = new ObjectName("com.sun.appserv:type=http-listener,id=" + iterator.next() + ",config=" + configRef + ",category=config");
                url = new StringBuffer("http");
                if (mbs.getAttribute(listenerObjectName, "security-enabled").toString().equals("true")) {
                    url.append("s");
                }
                url.append("://");
                url.append(this.getHost(serverObjectName, mbs));
                url.append(":");
                url.append((String)mbs.getAttribute(listenerObjectName, "port"));
                urls.add(url.toString());
            }
            for (String uri : urls) {
                if (!uri.startsWith("http:")) continue;
                Utils.log(Level.FINE, "Server URL = " + url);
                return uri;
            }
            if (!urls.isEmpty()) {
                return (String)urls.get(0);
            }
            Utils.log(Level.SEVERE, "Not able to get hold of Server URL");
            return "";
        }
        catch (Exception ex) {
            throw new HandlerException(ex);
        }
    }

    private String getHost(ObjectName serverInstance, MBeanServerConnection mbs) {
        String hostName = null;
        try {
            String nodeAgentRef = (String)mbs.getAttribute(serverInstance, "node-agent-ref");
            if (nodeAgentRef == null || nodeAgentRef.equals("")) {
                return this.getDefaultHostName();
            }
            ObjectName jmxConnector = (ObjectName)mbs.invoke(new ObjectName("com.sun.appserv:type=node-agent,name=" + nodeAgentRef + ",category=config"), "getJmxConnector", null, null);
            if (jmxConnector == null) {
                return this.getDefaultHostName();
            }
            AttributeList properties = (AttributeList)mbs.invoke(jmxConnector, "getProperties", null, null);
            for (Attribute att : properties) {
                if (!att.getName().equals("client-hostname")) continue;
                hostName = (String)att.getValue();
                break;
            }
            if (hostName == null || hostName.equals("") || hostName.equals("0.0.0.0")) {
                return this.getDefaultHostName();
            }
        }
        catch (Exception ex) {
            Utils.log(Level.SEVERE, "Not able to get Host name.");
            return "";
        }
        return hostName;
    }

    private String getDefaultHostName() {
        String defaultHostName = "localhost";
        try {
            InetAddress host = InetAddress.getLocalHost();
            defaultHostName = host.getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            Utils.log(Level.INFO, "UnknownHostException: " + uhe);
        }
        return defaultHostName;
    }

    private List parseStringList(String line) {
        return this.parseStringList(line, null);
    }

    private List parseStringList(String line, String sep) {
        if (line == null) {
            return null;
        }
        StringTokenizer st = sep == null ? new StringTokenizer(line) : new StringTokenizer(line, sep);
        Vector<String> tokens = new Vector<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.length() <= 0) continue;
            tokens.add(token);
        }
        return tokens;
    }
}

