/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.delegate;

import com.sun.mfwk.agent.appserv.delegate.BaseHandler;
import com.sun.mfwk.agent.appserv.delegate.HandlerException;
import com.sun.mfwk.agent.appserv.util.Utils;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class FailedOutboundAssociationsHandler
extends BaseHandler {
    public Object handleAttribute(ObjectName peer, String attribute, MBeanServerConnection mbs) throws HandlerException, AttributeNotFoundException, MBeanException, ReflectionException, InstanceNotFoundException, IOException {
        Set<ObjectName> objectNames;
        long failedOutboundAssociations = 0L;
        try {
            String serverName = peer.getKeyProperty("name");
            ObjectName connectorConnectionPoolPattern = new ObjectName("com.sun.appserv:*,category=monitor,type=connector-connection-pool,server=" + serverName);
            objectNames = mbs.queryNames(connectorConnectionPoolPattern, null);
            failedOutboundAssociations = Utils.getAttributeSum(mbs, objectNames, "numconntimedout-count");
            ObjectName jdbcConnectionPoolPattern = new ObjectName("com.sun.appserv:*,category=monitor,type=jdbc-connection-pool,server=" + serverName);
            objectNames = mbs.queryNames(jdbcConnectionPoolPattern, null);
        }
        catch (Exception exception) {
            Utils.log(Level.SEVERE, "Error while getting Failed Outbound Associations", exception);
            throw new HandlerException(exception);
        }
        return new Long(failedOutboundAssociations += Utils.getAttributeSum(mbs, objectNames, "numconntimedout-count"));
    }
}

