/*
 * Decompiled with CFR 0.152.
 */
package samples.webapps.simple.servlet.compressionFilters;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class CompressionResponseStream
extends ServletOutputStream {
    protected int compressionThreshold = 0;
    private int debug = 0;
    protected byte[] buffer = null;
    protected int bufferCount = 0;
    protected GZIPOutputStream gzipstream = null;
    protected boolean closed = false;
    protected int length = -1;
    protected HttpServletResponse response = null;
    protected ServletOutputStream output = null;

    public CompressionResponseStream(HttpServletResponse httpServletResponse) throws IOException {
        this.response = httpServletResponse;
        this.output = httpServletResponse.getOutputStream();
    }

    public void setDebugLevel(int n) {
        this.debug = n;
    }

    protected void setBuffer(int n) {
        this.compressionThreshold = n;
        this.buffer = new byte[this.compressionThreshold];
        if (this.debug > 1) {
            System.out.println("buffer is set to " + this.compressionThreshold);
        }
    }

    public void close() throws IOException {
        if (this.debug > 1) {
            System.out.println("close() @ CompressionResponseStream");
        }
        if (this.closed) {
            throw new IOException("This output stream has already been closed");
        }
        if (this.gzipstream != null) {
            this.flushToGZip();
            this.gzipstream.close();
            this.gzipstream = null;
        } else if (this.bufferCount > 0) {
            if (this.debug > 2) {
                System.out.print("output.write(");
                System.out.write(this.buffer, 0, this.bufferCount);
                System.out.println(")");
            }
            this.output.write(this.buffer, 0, this.bufferCount);
            this.bufferCount = 0;
        }
        this.output.close();
        this.closed = true;
    }

    public void flush() throws IOException {
        if (this.debug > 1) {
            System.out.println("flush() @ CompressionResponseStream");
        }
        if (this.closed) {
            throw new IOException("Cannot flush a closed output stream");
        }
        if (this.gzipstream != null) {
            this.gzipstream.flush();
        }
    }

    public void flushToGZip() throws IOException {
        if (this.debug > 1) {
            System.out.println("flushToGZip() @ CompressionResponseStream");
        }
        if (this.bufferCount > 0) {
            if (this.debug > 1) {
                System.out.println("flushing out to GZipStream, bufferCount = " + this.bufferCount);
            }
            this.writeToGZip(this.buffer, 0, this.bufferCount);
            this.bufferCount = 0;
        }
    }

    public void write(int n) throws IOException {
        if (this.debug > 1) {
            System.out.println("write " + n + " in CompressionResponseStream ");
        }
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        if (this.bufferCount >= this.buffer.length) {
            this.flushToGZip();
        }
        this.buffer[this.bufferCount++] = (byte)n;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.debug > 1) {
            System.out.println("write, bufferCount = " + this.bufferCount + " len = " + n2 + " off = " + n);
        }
        if (this.debug > 2) {
            System.out.print("write(");
            System.out.write(byArray, n, n2);
            System.out.println(")");
        }
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        if (n2 == 0) {
            return;
        }
        if (n2 <= this.buffer.length - this.bufferCount) {
            System.arraycopy(byArray, n, this.buffer, this.bufferCount, n2);
            this.bufferCount += n2;
            return;
        }
        this.flushToGZip();
        if (n2 <= this.buffer.length - this.bufferCount) {
            System.arraycopy(byArray, n, this.buffer, this.bufferCount, n2);
            this.bufferCount += n2;
            return;
        }
        this.writeToGZip(byArray, n, n2);
    }

    public void writeToGZip(byte[] byArray, int n, int n2) throws IOException {
        if (this.debug > 1) {
            System.out.println("writeToGZip, len = " + n2);
        }
        if (this.debug > 2) {
            System.out.print("writeToGZip(");
            System.out.write(byArray, n, n2);
            System.out.println(")");
        }
        if (this.gzipstream == null) {
            if (this.debug > 1) {
                System.out.println("new GZIPOutputStream");
            }
            this.gzipstream = new GZIPOutputStream((OutputStream)this.output);
            this.response.addHeader("Content-Encoding", "gzip");
        }
        this.gzipstream.write(byArray, n, n2);
    }

    public boolean closed() {
        return this.closed;
    }
}

