/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.outbound;

import com.sun.genericra.outbound.AbstractManagedConnectionFactory;
import com.sun.genericra.outbound.ConnectionHandle;
import com.sun.genericra.outbound.DestinationAdapter;
import com.sun.genericra.outbound.MessageProducerProxy;
import com.sun.genericra.outbound.ProxyMessage;
import com.sun.genericra.outbound.QueueProxy;
import com.sun.genericra.outbound.TopicProxy;
import com.sun.genericra.util.LogUtils;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class SessionAdapter
implements Session,
TopicSession,
QueueSession {
    private static Logger logger = LogUtils.getLogger();
    private Session physicalSession;
    private Session swappedSession;
    private boolean isClosed;
    private boolean isValid = true;
    private ConnectionHandle ch;
    private boolean isInUse = false;
    private ArrayList messageConsumers = new ArrayList();
    private ArrayList messageProducers = new ArrayList();
    private ArrayList queueBrowsers = new ArrayList();

    public SessionAdapter(Session physicalSession, ConnectionHandle ch) {
        this.physicalSession = physicalSession;
        this.ch = ch;
    }

    public int getAcknowledgeMode() throws JMSException {
        this.checkIfClosed();
        return this.physicalSession.getAcknowledgeMode();
    }

    public void setInUse() {
        this.isInUse = true;
    }

    public void setInvalid() throws JMSException {
        this.debug("setinvalid - closeAllJMSEntities");
        this.isValid = false;
        this.closeAllJMSEntities();
    }

    public boolean isInUse() {
        return this.isInUse;
    }

    private void checkIfClosed() throws JMSException {
        if (this.isClosed) {
            throw new IllegalStateException("JMS Session closed");
        }
        if (!this.isValid) {
            throw new IllegalStateException("JMS Session invalid");
        }
    }

    public void close() throws JMSException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.isInUse = false;
        this.debug(" close() called - txinprogress " + this.ch.getManagedConnection().isTransactionInProgress());
        this.closeAllJMSEntities();
        this.ch.getManagedConnection()._closeSession(this.physicalSession);
    }

    private void closeAllJMSEntities() throws JMSException {
        this.debug("closeAllJMSEntities");
        this.debug("closing message consumers " + this.messageConsumers.size());
        Iterator iter = this.messageConsumers.iterator();
        while (iter.hasNext()) {
            MessageConsumer mc = (MessageConsumer)iter.next();
            this.debug("closing message consumer " + mc);
            mc.close();
        }
        this.debug("closing message producers " + this.messageProducers.size());
        iter = this.messageProducers.iterator();
        while (iter.hasNext()) {
            MessageProducer mp = (MessageProducer)iter.next();
            this.debug("closing message producer " + mp);
            mp.close();
        }
        this.debug("closing queue browsers " + this.queueBrowsers.size());
        iter = this.queueBrowsers.iterator();
        while (iter.hasNext()) {
            QueueBrowser qp = (QueueBrowser)iter.next();
            this.debug("closing Queue browser " + qp);
            qp.close();
        }
        try {
            this.physicalSession.setMessageListener(null);
        }
        catch (JMSException jmse) {
            this.debug("Failed setting Null messagelistener on session");
        }
        this.messageConsumers.clear();
        this.messageProducers.clear();
        this.queueBrowsers.clear();
        this.ch.getSessions().remove(this);
    }

    public void commit() throws JMSException {
        this.checkIfClosed();
        this.physicalSession.commit();
    }

    public void recover() throws JMSException {
        this.checkIfClosed();
        this.physicalSession.recover();
    }

    public void rollback() throws JMSException {
        this.checkIfClosed();
        this.physicalSession.rollback();
    }

    public void run() {
        try {
            this.checkIfClosed();
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
        this.physicalSession.run();
    }

    public boolean getTransacted() throws JMSException {
        this.checkIfClosed();
        return this.physicalSession.getTransacted();
    }

    public void unsubscribe(String name) throws JMSException {
        this.checkIfClosed();
        this.physicalSession.unsubscribe(name);
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkIfClosed();
        return (BytesMessage)this.createProxyMessage((Message)this.physicalSession.createBytesMessage());
    }

    public MapMessage createMapMessage() throws JMSException {
        this.checkIfClosed();
        return (MapMessage)this.createProxyMessage((Message)this.physicalSession.createMapMessage());
    }

    public Message createMessage() throws JMSException {
        this.checkIfClosed();
        return (Message)this.createProxyMessage(this.physicalSession.createMessage());
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkIfClosed();
        return this.physicalSession.getMessageListener();
    }

    public void setMessageListener(MessageListener ml) throws JMSException {
        this.checkIfClosed();
        this.physicalSession.setMessageListener(ml);
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkIfClosed();
        return (ObjectMessage)this.createProxyMessage((Message)this.physicalSession.createObjectMessage());
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.checkIfClosed();
        return (StreamMessage)this.createProxyMessage((Message)this.physicalSession.createStreamMessage());
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkIfClosed();
        TemporaryQueue q = this.physicalSession.createTemporaryQueue();
        this.ch._addTemporaryDest((Destination)q);
        return q;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkIfClosed();
        TemporaryTopic t = this.physicalSession.createTemporaryTopic();
        this.ch._addTemporaryDest((Destination)t);
        return t;
    }

    public TextMessage createTextMessage() throws JMSException {
        this.checkIfClosed();
        return (TextMessage)this.createProxyMessage((Message)this.physicalSession.createTextMessage());
    }

    public MessageConsumer createConsumer(Destination dest) throws JMSException {
        this.checkIfClosed();
        MessageConsumer mc = this.physicalSession.createConsumer(this.getWrappedDestination(dest));
        this.messageConsumers.add(mc);
        return mc;
    }

    public MessageProducer createProducer(Destination dest) throws JMSException {
        logger.log(Level.FINEST, "Creating producer with " + dest);
        logger.log(Level.FINEST, "Physical Session " + this.physicalSession);
        this.checkIfClosed();
        MessageProducer mp = this.physicalSession.createProducer(this.getWrappedDestination(dest));
        MessageProducerProxy wrappedMp = new MessageProducerProxy(mp);
        this.messageProducers.add(wrappedMp);
        return wrappedMp;
    }

    public ObjectMessage createObjectMessage(Serializable ser) throws JMSException {
        this.checkIfClosed();
        return (ObjectMessage)this.createProxyMessage((Message)this.physicalSession.createObjectMessage(ser));
    }

    public Queue createQueue(String name) throws JMSException {
        this.checkIfClosed();
        return this.physicalSession.createQueue(name);
    }

    public QueueBrowser createBrowser(Queue name) throws JMSException {
        this.checkIfClosed();
        QueueBrowser qb = this.physicalSession.createBrowser(this.getWrappedQueue(name));
        this.queueBrowsers.add(qb);
        return qb;
    }

    public TextMessage createTextMessage(String msg) throws JMSException {
        this.checkIfClosed();
        return (TextMessage)this.createProxyMessage((Message)this.physicalSession.createTextMessage(msg));
    }

    public Topic createTopic(String name) throws JMSException {
        this.checkIfClosed();
        return this.physicalSession.createTopic(name);
    }

    public MessageConsumer createConsumer(Destination dest, String msgSel) throws JMSException {
        this.checkIfClosed();
        MessageConsumer mc = this.physicalSession.createConsumer(this.getWrappedDestination(dest), msgSel);
        this.messageConsumers.add(mc);
        return mc;
    }

    public MessageConsumer createConsumer(Destination dest, String msgSel, boolean noLocal) throws JMSException {
        this.checkIfClosed();
        MessageConsumer mc = this.physicalSession.createConsumer(this.getWrappedDestination(dest), msgSel, noLocal);
        this.messageConsumers.add(mc);
        return mc;
    }

    public QueueBrowser createBrowser(Queue queue, String msgSel) throws JMSException {
        this.checkIfClosed();
        this.debug("PhysicalSession class is " + this.physicalSession.getClass().getName());
        QueueBrowser qb = this.physicalSession.createBrowser(this.getWrappedQueue(queue), msgSel);
        this.queueBrowsers.add(qb);
        return qb;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        this.checkIfClosed();
        TopicSubscriber ts = this.physicalSession.createDurableSubscriber(this.getWrappedTopic(topic), name);
        this.messageConsumers.add(ts);
        return ts;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String msgSel, boolean noLocal) throws JMSException {
        this.checkIfClosed();
        TopicSubscriber ts = this.physicalSession.createDurableSubscriber(this.getWrappedTopic(topic), name, msgSel, noLocal);
        this.messageConsumers.add(ts);
        return ts;
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.checkIfClosed();
        TopicPublisher tp = ((TopicSession)this.physicalSession).createPublisher(this.getWrappedTopic(topic));
        MessageProducerProxy wrappedTp = new MessageProducerProxy((MessageProducer)tp);
        this.messageProducers.add(wrappedTp);
        return wrappedTp;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.checkIfClosed();
        TopicSubscriber ts = ((TopicSession)this.physicalSession).createSubscriber(this.getWrappedTopic(topic));
        this.messageConsumers.add(ts);
        return ts;
    }

    public TopicSubscriber createSubscriber(Topic topic, String msgSel, boolean noLocal) throws JMSException {
        this.checkIfClosed();
        TopicSubscriber ts = ((TopicSession)this.physicalSession).createSubscriber(this.getWrappedTopic(topic), msgSel, noLocal);
        this.messageConsumers.add(ts);
        return ts;
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        this.checkIfClosed();
        QueueReceiver qr = ((QueueSession)this.physicalSession).createReceiver(this.getWrappedQueue(queue));
        this.messageConsumers.add(qr);
        return qr;
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        this.checkIfClosed();
        QueueSender qs = ((QueueSession)this.physicalSession).createSender(this.getWrappedQueue(queue));
        MessageProducerProxy wrappedQs = new MessageProducerProxy((MessageProducer)qs);
        this.messageProducers.add(wrappedQs);
        return wrappedQs;
    }

    public QueueReceiver createReceiver(Queue queue, String msgSel) throws JMSException {
        this.checkIfClosed();
        QueueReceiver qr = ((QueueSession)this.physicalSession).createReceiver(this.getWrappedQueue(queue), msgSel);
        this.messageConsumers.add(qr);
        return qr;
    }

    private Topic getWrappedTopic(Topic topic) throws JMSException {
        if (topic instanceof TopicProxy) {
            return (Topic)((TopicProxy)topic)._getPhysicalDestination();
        }
        return topic;
    }

    private Queue getWrappedQueue(Queue queue) throws JMSException {
        if (queue instanceof QueueProxy) {
            return (Queue)((QueueProxy)queue)._getPhysicalDestination();
        }
        return queue;
    }

    private Destination getWrappedDestination(Destination dest) throws JMSException {
        if (dest instanceof DestinationAdapter) {
            return ((DestinationAdapter)dest)._getPhysicalDestination();
        }
        return dest;
    }

    void _swapPhysicalSession(Session in) {
        if (in != this.physicalSession) {
            this.swappedSession = this.physicalSession;
            this.physicalSession = in;
        }
    }

    void _swapPhysicalSession() {
        if (this.swappedSession != null) {
            this.physicalSession = this.swappedSession;
            this.swappedSession = null;
        }
    }

    private void debug(String s) {
        logger.log(Level.FINEST, "[SessionAdapter] " + s);
    }

    private Object createProxyMessage(Message msg) {
        Object mcf = this.ch.getManagedConnection().getManagedConnectionFactory();
        boolean wrap = ((AbstractManagedConnectionFactory)mcf).getUseProxyMessages();
        if (wrap) {
            ProxyMessage ih = new ProxyMessage(msg);
            Class[] intfcs = new Class[]{Message.class, BytesMessage.class, MapMessage.class, ObjectMessage.class, StreamMessage.class, TextMessage.class};
            return Proxy.newProxyInstance(this.getClass().getClassLoader(), intfcs, (InvocationHandler)ih);
        }
        return msg;
    }
}

