/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.discovery.DiscoveryMsg;
import com.sun.jdmk.internal.ClassLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;

abstract class DiscoveryCommon
extends MulticastSocket
implements Runnable {
    protected String localClassName = "com.sun.jdmk.discovery.DiscoveryCommon";
    private final ClassLogger logger = new ClassLogger("com.sun.jdmk.discovery", "DiscoveryCommon");
    protected int multicastPort;
    protected InetAddress multicastGroup;
    protected InetAddress localHost;
    protected String localHostName;
    protected InetAddress selectedHost;
    protected String selectedHostName;

    public DiscoveryCommon(String multicastGroup, int multicastPort) throws IOException {
        super(multicastPort);
        if (this.logger.finerOn()) {
            this.logger.finer("constructor ", "group = " + multicastGroup + ", " + "port  = " + multicastPort);
        }
        this.multicastGroup = InetAddress.getByName(multicastGroup);
        this.multicastPort = multicastPort;
        this.localHostName = System.getProperty("jdmk.hostname");
        if (this.localHostName != null) {
            this.selectedHost = this.localHost = InetAddress.getByName(this.localHostName);
            this.selectedHostName = this.localHostName;
        } else {
            this.localHost = InetAddress.getLocalHost();
            this.localHostName = InetAddress.getLocalHost().getHostName();
            this.selectedHost = this.localHost;
            this.selectedHostName = this.localHostName;
        }
    }

    public void connectToGroup() throws IOException {
        if (this.logger.finerOn()) {
            this.logger.finer("connectToGroup", "join Group " + this.multicastGroup);
        }
        this.joinGroup(this.multicastGroup);
    }

    void disconnectFromGroup() throws IOException {
        if (this.logger.finerOn()) {
            this.logger.finer("disconnectFromGroup", "leave Group " + this.multicastGroup);
        }
        this.leaveGroup(this.multicastGroup);
    }

    public void run() {
    }

    public String getLocalHostName() {
        return this.localHostName;
    }

    public InetAddress getLocalHostAddr() {
        return this.localHost;
    }

    public String getHostName() {
        return this.selectedHostName;
    }

    public InetAddress getHostAddr() {
        return this.selectedHost;
    }

    protected synchronized void sendMsg(DiscoveryMsg msg, InetAddress receiverInetAddr, int receiverPort) throws IOException {
        byte[] msgToSend = null;
        try {
            msgToSend = this.objectSerialization(msg);
        }
        catch (IOException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("sendMsg ", e);
            }
            throw e;
        }
        if (this.logger.finerOn()) {
            this.logger.finer("sendMsg", "destination address = " + receiverInetAddr + " Port = " + receiverPort);
            this.logger.finer("sendMsg", "Send msg '" + msg.printState() + "'");
        }
        DatagramPacket packet = new DatagramPacket(msgToSend, msgToSend.length, receiverInetAddr, receiverPort);
        this.setTimeToLive(msg.getTimeToLive());
        this.send(packet);
    }

    protected synchronized DiscoveryMsg receiveMsg(DatagramSocket socket) throws IOException, ClassNotFoundException, InvalidClassException, InterruptedIOException {
        byte[] recvData;
        DiscoveryMsg msg;
        InetAddress emittedGroup;
        byte[] buf = new byte[65536];
        DatagramPacket packet = new DatagramPacket(buf, buf.length);
        if (this.logger.finerOn()) {
            this.logger.finer("receiveMsg ", "Start waiting");
        }
        socket.receive(packet);
        if (this.logger.finerOn()) {
            this.logger.finer("receiveMsg ", "We Receive something");
        }
        if (!(emittedGroup = (msg = (DiscoveryMsg)this.objectDeserialization(recvData = packet.getData())).getEmittedGroup()).equals(this.multicastGroup)) {
            if (this.logger.finerOn()) {
                this.logger.finer("receiveMsg ", "Receive a msg for another group");
            }
            throw new IOException();
        }
        if (this.logger.finerOn()) {
            this.logger.finer("receiveMsg ", "Receive a msg");
        }
        return msg;
    }

    private Object objectDeserialization(byte[] entityBody) throws IOException, ClassNotFoundException {
        if (entityBody == null) {
            return null;
        }
        if (entityBody.length == 0) {
            return null;
        }
        try {
            ByteArrayInputStream bIn = new ByteArrayInputStream(entityBody);
            ObjectInputStream objIn = new ObjectInputStream(bIn);
            Object result = objIn.readObject();
            return result;
        }
        catch (ClassNotFoundException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("objectDeserialization", e);
            }
            throw e;
        }
        catch (OptionalDataException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("objectDeserialization", e);
            }
            throw new IOException(e.getMessage());
        }
    }

    private byte[] objectSerialization(Object obj) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(bOut);
        objOut.writeObject(obj);
        return bOut.toByteArray();
    }
}

