/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.internal.ClassLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class TimedURLConnection {
    private static final int MAKE_URLCONNECTION_OPS = 1;
    private static final int GET_OUTPUTSTREAM_OPS = 2;
    private static final int GET_INPUTSTREAM_OPS = 3;
    private static final int GET_RESPONSECODE_OPS = 4;
    private static final int GET_ERRORSTREAM_OPS = 5;
    private static final String urlConnTimeoutString = new String("operation timed out for URLConnection");
    private long timeOut;
    private URLConnection urlConn = null;
    private static final String dbgTag = "TimedURLConnection";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.comm.timer", "TimedURLConnection");

    public TimedURLConnection(URL url, long timeout) throws IOException, SecurityException {
        if (logger.traceOn()) {
            logger.trace(dbgTag, "new TimedURLConnection with timeout: " + timeout);
        }
        this.timeOut = timeout;
        this.urlConn = this.make(url);
    }

    public URLConnection getURLConnection() {
        return this.urlConn;
    }

    private Object runTimeoutOperation(TimeoutOperation curThread, long timeOut) throws IOException {
        long endTime = 0L;
        long curTime = 0L;
        boolean threadFinished = false;
        Object retObject = null;
        if (timeOut <= 0L) {
            if (logger.debugOn()) {
                logger.debug("runTimeoutOperation", "bad timeout");
            }
            throw new CommunicationException("bad balue for timeout");
        }
        endTime = System.currentTimeMillis() + timeOut;
        curThread.start();
        curTime = System.currentTimeMillis();
        while (curTime < endTime) {
            if (curThread.isAlive()) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                    if (curThread.gotResult()) {
                        break;
                    }
                }
                catch (Exception e) {
                    if (logger.debugOn()) {
                        logger.debug("runTimeoutOperation", "got Exception while sleeping");
                    }
                    throw new CommunicationException("run runTimeoutOperation, sleep failed");
                }
                curTime = System.currentTimeMillis();
                continue;
            }
            threadFinished = true;
            break;
        }
        if (curThread.gotResult()) {
            retObject = curThread.getReturnObject();
        } else if (!threadFinished) {
            if (logger.debugOn()) {
                logger.debug("runTimeoutOperation", "openConnection timed out");
            }
            curThread.setTimeoutOccurred(true);
            curThread.interrupt();
            throw new CommunicationException(urlConnTimeoutString);
        }
        return retObject;
    }

    public OutputStream getOutputStream() throws IOException {
        OutputStream tempOut = null;
        if (logger.debugOn()) {
            logger.debug("getOutputStream", "Entering");
        }
        if (this.urlConn == null) {
            if (logger.debugOn()) {
                logger.debug("getOutputThread", "urlConn null !");
            }
            throw new CommunicationException("Failed to get inputStream, no connection");
        }
        TimeoutOperation getOutputThread = new TimeoutOperation(2, this.urlConn);
        tempOut = (OutputStream)this.runTimeoutOperation(getOutputThread, this.timeOut);
        if (logger.debugOn()) {
            logger.debug("getOutputStream", "returning" + tempOut);
        }
        return tempOut;
    }

    public InputStream getInputStream() throws IOException {
        InputStream tempIn = null;
        if (logger.debugOn()) {
            logger.debug("getInputStream", "Entering");
        }
        if (this.urlConn == null) {
            if (logger.debugOn()) {
                logger.debug("getInputThread", "urlConn null !");
            }
            throw new CommunicationException("Failed to get inputStream, no connection");
        }
        TimeoutOperation getInputThread = new TimeoutOperation(3, this.urlConn);
        tempIn = (InputStream)this.runTimeoutOperation(getInputThread, this.timeOut);
        if (logger.debugOn()) {
            logger.debug("getInputStream", "returning: " + tempIn);
        }
        return tempIn;
    }

    public int getResponseCode() throws IOException {
        Integer tempResponseCode = null;
        if (logger.debugOn()) {
            logger.debug("getResponseCode", "Entering");
        }
        if (this.urlConn == null) {
            if (logger.debugOn()) {
                logger.debug("getResponseCodeThread", "urlConn null !");
            }
            throw new CommunicationException("Failed to get RespondCode, no connection");
        }
        TimeoutOperation getResponseCodeThread = new TimeoutOperation(4, this.urlConn);
        tempResponseCode = (Integer)this.runTimeoutOperation(getResponseCodeThread, this.timeOut);
        if (logger.debugOn()) {
            logger.debug("getResponseCodeThread", "returning: " + tempResponseCode);
        }
        return tempResponseCode;
    }

    public InputStream getErrorStream() throws IOException {
        InputStream tempErr = null;
        if (logger.debugOn()) {
            logger.debug("getErrorStream", "Entering");
        }
        if (this.urlConn == null) {
            if (logger.debugOn()) {
                logger.debug("getErrorThread", "urlConn null !");
            }
            throw new CommunicationException("Failed to get errorStream, no connection");
        }
        TimeoutOperation getErrorThread = new TimeoutOperation(5, this.urlConn);
        tempErr = (InputStream)this.runTimeoutOperation(getErrorThread, this.timeOut);
        if (logger.debugOn()) {
            logger.debug("getErrorStream", "returning: " + tempErr);
        }
        return tempErr;
    }

    private URLConnection make(URL url) throws IOException {
        URLConnection tempUrlConn = null;
        if (logger.debugOn()) {
            logger.debug("make", "Entering");
        }
        TimeoutOperation makeThread = new TimeoutOperation(1, url);
        tempUrlConn = (URLConnection)this.runTimeoutOperation(makeThread, this.timeOut);
        if (logger.debugOn()) {
            logger.debug("make", "returning: " + tempUrlConn);
        }
        return tempUrlConn;
    }

    private class TimeoutOperation
    extends Thread {
        private int currentOperartion;
        private Object returnObject = null;
        private boolean gotResult = false;
        private URL url = null;
        private URLConnection tmpUrlConn = null;
        private boolean resultGiven = false;
        private boolean timeoutOccurred = false;

        public TimeoutOperation(int operation, URL url) {
            this.currentOperartion = operation;
            this.url = url;
        }

        public TimeoutOperation(int operation, URLConnection urlConn) {
            this.currentOperartion = operation;
            this.tmpUrlConn = urlConn;
        }

        public void run() {
            switch (this.currentOperartion) {
                case 1: {
                    this.gotResult = false;
                    if (this.url == null) break;
                    try {
                        this.returnObject = this.url.openConnection();
                        this.gotResult = true;
                    }
                    catch (InterruptedIOException ie) {
                        this.checkTimeout(ie, "creating URLConnection", "MAKE_URLCONNECTION_OPS");
                    }
                    catch (Exception e) {
                        if (!logger.debugOn()) break;
                        logger.debug("TimeoutOperation:run", "MAKE_URLCONNECTION_OPS, got Exception");
                        e.printStackTrace();
                    }
                    break;
                }
                case 3: {
                    this.gotResult = false;
                    if (TimedURLConnection.this.urlConn == null) break;
                    try {
                        this.returnObject = TimedURLConnection.this.urlConn.getInputStream();
                        this.gotResult = true;
                    }
                    catch (InterruptedIOException ie) {
                        this.checkTimeout(ie, "getting InputStream of an URLConnection", "GET_INPUTSTREAM_OPS");
                    }
                    catch (Exception e) {
                        if (!logger.debugOn()) break;
                        logger.debug("TimeoutOperation:run", "GET_INPUTSTREAM_OPS, got Exception");
                        e.printStackTrace();
                    }
                    break;
                }
                case 2: {
                    this.gotResult = false;
                    if (TimedURLConnection.this.urlConn == null) break;
                    try {
                        this.returnObject = TimedURLConnection.this.urlConn.getOutputStream();
                        this.gotResult = true;
                    }
                    catch (InterruptedIOException ie) {
                        this.checkTimeout(ie, "getting OutputStream of an URLConnection", "GET_OUTPUTSTREAM_OPS");
                    }
                    catch (Exception e) {
                        if (!logger.debugOn()) break;
                        logger.debug("TimeoutOperation:run", "GET_OUTPUTSTREAM_OPS, got Exception");
                        e.printStackTrace();
                    }
                    break;
                }
                case 4: {
                    this.gotResult = false;
                    if (TimedURLConnection.this.urlConn == null) break;
                    try {
                        int tmpInt = 0;
                        tmpInt = ((HttpURLConnection)TimedURLConnection.this.urlConn).getResponseCode();
                        this.returnObject = new Integer(tmpInt);
                        this.gotResult = true;
                    }
                    catch (InterruptedIOException ie) {
                        this.checkTimeout(ie, "getting RespondCode of an Http", "GET_RESPONSECODE_OPS");
                    }
                    catch (IOException ioe) {
                        this.returnObject = new Integer(-1);
                        this.gotResult = true;
                        if (!logger.debugOn()) break;
                        logger.debug("TimeoutOperation:run", "GET_RESPONSECODE_OPS, got IOException, setting dummy response code");
                        ioe.printStackTrace();
                    }
                    catch (Exception e) {
                        if (!logger.debugOn()) break;
                        logger.debug("TimeoutOperation:run", "GET_RESPONSECODE_OPS, got Exception");
                        e.printStackTrace();
                    }
                    break;
                }
                case 5: {
                    this.gotResult = false;
                    if (TimedURLConnection.this.urlConn == null) break;
                    try {
                        this.returnObject = ((HttpURLConnection)TimedURLConnection.this.urlConn).getErrorStream();
                        this.gotResult = true;
                    }
                    catch (Exception e) {
                        if (!logger.debugOn()) break;
                        logger.debug("TimeoutOperation:run", "GET_ERRORSTREAM_OPS, got Exception");
                        e.printStackTrace();
                    }
                    break;
                }
            }
            while (!this.resultGiven) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    if (logger.debugOn()) {
                        logger.debug("TimeoutOperation:run", "got Exception while sleeping");
                    }
                    throw new CommunicationException("run TimeoutOperation, sleep failed");
                }
            }
        }

        public boolean gotResult() {
            return this.gotResult;
        }

        public Object getReturnObject() {
            this.resultGiven = true;
            return this.returnObject;
        }

        public boolean hasTimeoutOccurred() {
            return this.timeoutOccurred;
        }

        public void setTimeoutOccurred(boolean occurred) {
            this.timeoutOccurred = occurred;
        }

        private void checkTimeout(Exception ie, String msg1, String msg2) {
            if (this.hasTimeoutOccurred()) {
                logger.trace("TimeoutOperation:run", "Timeout while " + msg1);
                this.setTimeoutOccurred(false);
            }
            if (logger.debugOn()) {
                logger.debug("TimeoutOperation:run", msg2 + ", got Exception");
                ie.printStackTrace();
            }
        }
    }
}

