/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.ClientNotificationDispatcher;
import com.sun.jdmk.comm.GenericHttpConnectorClient;
import com.sun.jdmk.comm.GenericHttpNotificationReceiver;
import com.sun.jdmk.comm.GenericHttpSocket;
import com.sun.jdmk.comm.HttpsSocket;

class HttpsNotificationReceiver
extends GenericHttpNotificationReceiver {
    private int timeout = 60000;
    private boolean needClientAuth = true;

    public HttpsNotificationReceiver(GenericHttpConnectorClient connector, ClientNotificationDispatcher dispatcher, boolean needClientAuth) {
        super(5, 0, connector, dispatcher);
        this.needClientAuth = needClientAuth;
    }

    GenericHttpSocket createSocket() {
        HttpsSocket https_socket = new HttpsSocket(0, null, this.needClientAuth);
        https_socket.setTimeout(this.getTimeout());
        return https_socket;
    }

    public String getProtocol() {
        return "https";
    }

    public int getTimeout() {
        if (this.sockListen != null) {
            return this.sockListen.getTimeout();
        }
        return this.timeout;
    }

    public void setTimeout(int value) throws IllegalStateException {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException("Stop server before carrying out this operation");
        }
        this.timeout = value;
        if (this.sockListen != null) {
            this.sockListen.setTimeout(value);
        }
    }

    protected String makeDebugTag() {
        return "HttpsNotificationReceiver[" + this.getProtocol() + ":" + this.getPort() + "]";
    }
}

