/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.DefaultMBeanInterceptor;
import com.sun.jdmk.MBeanInstantiator;
import com.sun.jdmk.MBeanInterceptor;
import com.sun.jdmk.MBeanServerDelegateImpl;
import com.sun.jdmk.MBeanServerInt;
import com.sun.jdmk.MetaData;
import com.sun.jdmk.MetaDataImpl;
import com.sun.jdmk.ModifiableClassLoaderRepository;
import com.sun.jdmk.defaults.Utils;
import com.sun.jdmk.interceptor.MBeanServerInterceptor;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

public class MBeanServerImpl
implements MBeanServer,
MBeanServerInt {
    private transient MBeanInterceptor interceptor = null;
    private final String dbgTag = "MBeanServer";
    private MBeanInstantiator instantiator = null;
    private MetaData meta = null;
    private transient MBeanServerDelegate MBeanServerDelegateObject = null;
    private transient ObjectName MBeanServerDelegateObjectName = null;
    private transient SecureClassLoaderRepository secureClr = null;

    public MBeanServerImpl(MBeanInstantiator instantiator) {
        this(instantiator, null);
    }

    public MBeanServerImpl(MBeanInstantiator instantiator, String domain) {
        this(instantiator, null, domain);
    }

    public MBeanServerImpl(MBeanInstantiator instantiator, MetaData metadata, String domain) {
        this.initialize(instantiator, metadata, domain);
    }

    public MBeanInstantiator getMBeanInstantiator() {
        return this.instantiator;
    }

    public MetaData getMetaData() {
        return this.meta;
    }

    public synchronized MBeanInterceptor getDefaultMBeanInterceptor() {
        return this.interceptor;
    }

    public synchronized void setDefaultMBeanInterceptor(MBeanInterceptor mbi) throws IllegalArgumentException {
        if (mbi == null) {
            throw new IllegalArgumentException("Null MBeanInterceptor");
        }
        this.interceptor = mbi;
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.interceptor.createMBean(className, name, null, null);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.interceptor.createMBean(className, name, loaderName, null, null);
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.interceptor.createMBean(className, name, params, signature);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.interceptor.createMBean(className, name, loaderName, params, signature);
    }

    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.interceptor.registerMBean(object, name);
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        this.interceptor.unregisterMBean(name);
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.interceptor.getObjectInstance(name);
    }

    public Set queryMBeans(ObjectName name, QueryExp query) {
        return this.interceptor.queryMBeans(name, query);
    }

    public Set queryNames(ObjectName name, QueryExp query) {
        return this.interceptor.queryNames(name, query);
    }

    public boolean isRegistered(ObjectName name) {
        return this.interceptor.isRegistered(name);
    }

    public Integer getMBeanCount() {
        return this.interceptor.getMBeanCount();
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return this.interceptor.getAttribute(name, attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        return this.interceptor.getAttributes(name, attributes);
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.interceptor.setAttribute(name, attribute);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        return this.interceptor.setAttributes(name, attributes);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.interceptor.invoke(name, operationName, params, signature);
    }

    public String getDefaultDomain() {
        return this.interceptor.getDefaultDomain();
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.interceptor.addNotificationListener(name, listener, filter, handback);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.interceptor.addNotificationListener(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.interceptor.removeNotificationListener(name, listener);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.interceptor.removeNotificationListener(name, listener);
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.interceptor.getMBeanInfo(name);
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        return this.instantiator.instantiate(className);
    }

    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.instantiator.instantiate(className, loaderName, this.getClass().getClassLoader());
    }

    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        return this.instantiator.instantiate(className, params, signature, this.getClass().getClassLoader());
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.instantiator.instantiate(className, loaderName, params, signature, this.getClass().getClassLoader());
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        return this.interceptor.isInstanceOf(name, className);
    }

    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        return this.instantiator.deserialize(name, data);
    }

    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        return this.instantiator.deserialize(className, data);
    }

    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        return this.instantiator.deserialize(className, loaderName, data, this.getClass().getClassLoader());
    }

    public ClassLoader getMBeanClassLoader(ObjectName name) throws InstanceNotFoundException {
        return this.interceptor.getMBeanClassLoader(name);
    }

    private void initialize(MBeanInstantiator instantiator, MetaData meta, String domain) {
        this.instantiator = instantiator;
        if (instantiator == null) {
            throw new IllegalArgumentException("instantiator must not be null.");
        }
        this.meta = meta == null ? new MetaDataImpl(instantiator) : meta;
        this.secureClr = new SecureClassLoaderRepository(instantiator.getClassLoaderRepository());
        this.interceptor = domain != null ? new DefaultMBeanInterceptor(this, domain) : new DefaultMBeanInterceptor(this);
        try {
            this.MBeanServerDelegateObject = new MBeanServerDelegateImpl(new MBeanServerDelegate());
            this.MBeanServerDelegateObjectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            this.interceptor.registerMBean(this.MBeanServerDelegateObject, this.MBeanServerDelegateObjectName);
        }
        catch (JMException e) {
            RuntimeException r = new RuntimeException("Unexpected JMException: " + e);
            Utils.initCause(r, e);
            throw r;
        }
        ClassLoader myLoader = this.getClass().getClassLoader();
        ModifiableClassLoaderRepository loaders = instantiator.getClassLoaderRepository();
        if (loaders != null && myLoader != null) {
            loaders.addClassLoader(myLoader);
        }
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        return this.secureClr;
    }

    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        return this.interceptor.getMBeanClassLoader(mbeanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        ClassLoader loader;
        if (this.interceptor instanceof MBeanServerInterceptor) {
            return ((MBeanServerInterceptor)this.interceptor).getClassLoader(loaderName);
        }
        ModifiableClassLoaderRepository loaders = this.instantiator.getClassLoaderRepository();
        MBeanInstantiator mBeanInstantiator = this.instantiator;
        synchronized (mBeanInstantiator) {
            loader = loaders.getClassLoader(loaderName);
        }
        if (loader == null) {
            throw new InstanceNotFoundException("The loader named " + loaderName + " is not registered in the MBeanServer");
        }
        return loader;
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        if (this.interceptor instanceof MBeanServerInterceptor) {
            ((MBeanServerInterceptor)this.interceptor).removeNotificationListener(name, listener, filter, handback);
            return;
        }
        String unsupported = "Operation not supported in this implementation";
        throw new UnsupportedOperationException("Operation not supported in this implementation");
    }

    public void removeNotificationListener(ObjectName name, ObjectName listenerName, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        if (this.interceptor instanceof MBeanServerInterceptor) {
            ((MBeanServerInterceptor)this.interceptor).removeNotificationListener(name, listenerName, filter, handback);
            return;
        }
        String unsupported = "Operation not supported in this implementation";
        throw new UnsupportedOperationException("Operation not supported in this implementation");
    }

    public String[] getDomains() {
        if (this.interceptor instanceof MBeanServerInterceptor) {
            return ((MBeanServerInterceptor)this.interceptor).getDomains();
        }
        Set names = this.interceptor.queryNames(null, null);
        HashSet<String> tmpSet = new HashSet<String>(1);
        Iterator i = names.iterator();
        while (i.hasNext()) {
            ObjectName x = (ObjectName)i.next();
            String domain = x.getDomain();
            if (tmpSet.contains(domain)) continue;
            tmpSet.add(domain);
        }
        String[] result = new String[tmpSet.size()];
        return tmpSet.toArray(result);
    }

    public MBeanServerDelegate getMBeanServerDelegate() {
        return this.MBeanServerDelegateObject;
    }

    static final class SecureClassLoaderRepository
    implements ClassLoaderRepository {
        private final ClassLoaderRepository clr;

        public SecureClassLoaderRepository(ClassLoaderRepository clr) {
            this.clr = clr;
        }

        public final Class loadClass(String className) throws ClassNotFoundException {
            return this.clr.loadClass(className);
        }

        public final Class loadClassWithout(ClassLoader loader, String className) throws ClassNotFoundException {
            return this.clr.loadClassWithout(loader, className);
        }

        public final Class loadClassBefore(ClassLoader loader, String className) throws ClassNotFoundException {
            return this.clr.loadClassBefore(loader, className);
        }
    }
}

