/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.CompatibleClassLoaderRepositorySupport;
import com.sun.jdmk.JdmkMBeanServer;
import com.sun.jdmk.MBeanInstantiator;
import com.sun.jdmk.MBeanInstantiatorImpl;
import com.sun.jdmk.MBeanInterceptor;
import com.sun.jdmk.MBeanServerInt;
import com.sun.jdmk.MetaData;
import com.sun.jdmk.MetaDataImpl;
import com.sun.jdmk.ProxyHandler;
import com.sun.jdmk.interceptor.CompatibleMBeanInterceptor;
import com.sun.jdmk.interceptor.DefaultMBeanServerInterceptor;
import com.sun.jdmk.interceptor.MBeanServerInterceptor;
import java.io.ObjectInputStream;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

final class JdmkMBeanServerImpl
implements MBeanServerInterceptor,
JdmkMBeanServer,
MBeanServerInt,
ProxyHandler {
    private final String dbgTag = "JdmkMBeanServerImpl";
    private MBeanInstantiator instantiator = null;
    private MetaData meta = null;
    private final transient MBeanServer outerMBeanServer;
    private transient MBeanServerInterceptor mbsInterceptor = null;
    private transient MBeanServer innerMBeanServer = null;
    private final transient MBeanServerDelegate mbsDelegate;

    JdmkMBeanServerImpl(String domain, MBeanServer outer, MBeanServerDelegate delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("MBeanServerDelegate is null");
        }
        if (outer == null) {
            outer = this;
        }
        this.mbsDelegate = delegate;
        this.outerMBeanServer = outer;
    }

    void initialize(MBeanServer inner) {
        this.innerMBeanServer = inner;
        if (this.innerMBeanServer == null) {
            throw new IllegalStateException("JdmkMBeanServer not initialized");
        }
        this.mbsInterceptor = new DefaultMBeanServerInterceptor(this.outerMBeanServer, this.mbsDelegate, inner);
    }

    public MBeanServer getOuterMBeanServer() {
        return this.outerMBeanServer;
    }

    public synchronized MBeanInterceptor getDefaultMBeanInterceptor() {
        if (this.mbsInterceptor == null) {
            return null;
        }
        if (this.mbsInterceptor instanceof CompatibleMBeanInterceptor) {
            return ((CompatibleMBeanInterceptor)this.mbsInterceptor).getNextInterceptor();
        }
        return this.mbsInterceptor;
    }

    public synchronized void setDefaultMBeanInterceptor(MBeanInterceptor interceptor) throws IllegalArgumentException {
        if (interceptor == null) {
            throw new IllegalArgumentException("Null MBeanInterceptor");
        }
        if (interceptor instanceof MBeanServerInterceptor) {
            this.setMBeanServerInterceptor((MBeanServerInterceptor)interceptor);
        } else {
            this.setMBeanServerInterceptor(new CompatibleMBeanInterceptor(interceptor));
        }
    }

    public synchronized MBeanServerInterceptor getMBeanServerInterceptor() {
        return this.mbsInterceptor;
    }

    public synchronized void setMBeanServerInterceptor(MBeanServerInterceptor interceptor) throws IllegalArgumentException {
        if (interceptor == null) {
            throw new IllegalArgumentException("Null MBeanServerInterceptor");
        }
        this.mbsInterceptor = interceptor;
    }

    public MBeanInstantiator getMBeanInstantiator() {
        if (this.innerMBeanServer == null) {
            throw new IllegalStateException("JdmkMBeanServer not initialized");
        }
        if (this.instantiator == null) {
            CompatibleClassLoaderRepositorySupport clr = new CompatibleClassLoaderRepositorySupport(this.innerMBeanServer);
            this.instantiator = new MBeanInstantiatorImpl(clr);
        }
        return this.instantiator;
    }

    public MetaData getMetaData() {
        if (this.meta == null) {
            MBeanInstantiator mbsi = this.getMBeanInstantiator();
            this.meta = new MetaDataImpl(mbsi);
        }
        return this.meta;
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.mbsInterceptor.createMBean(className, name, null, null);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.mbsInterceptor.createMBean(className, name, loaderName, null, null);
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.mbsInterceptor.createMBean(className, name, params, signature);
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.mbsInterceptor.createMBean(className, name, loaderName, params, signature);
    }

    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.mbsInterceptor.registerMBean(object, name);
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        this.mbsInterceptor.unregisterMBean(name);
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.mbsInterceptor.getObjectInstance(name);
    }

    public Set queryMBeans(ObjectName name, QueryExp query) {
        return this.mbsInterceptor.queryMBeans(name, query);
    }

    public Set queryNames(ObjectName name, QueryExp query) {
        return this.mbsInterceptor.queryNames(name, query);
    }

    public boolean isRegistered(ObjectName name) {
        return this.mbsInterceptor.isRegistered(name);
    }

    public Integer getMBeanCount() {
        return this.mbsInterceptor.getMBeanCount();
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return this.mbsInterceptor.getAttribute(name, attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        return this.mbsInterceptor.getAttributes(name, attributes);
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.mbsInterceptor.setAttribute(name, attribute);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        return this.mbsInterceptor.setAttributes(name, attributes);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.mbsInterceptor.invoke(name, operationName, params, signature);
    }

    public String getDefaultDomain() {
        return this.mbsInterceptor.getDefaultDomain();
    }

    public String[] getDomains() {
        return this.mbsInterceptor.getDomains();
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.mbsInterceptor.addNotificationListener(name, listener, filter, handback);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        this.mbsInterceptor.addNotificationListener(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbsInterceptor.removeNotificationListener(name, listener);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbsInterceptor.removeNotificationListener(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbsInterceptor.removeNotificationListener(name, listener);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.mbsInterceptor.removeNotificationListener(name, listener, filter, handback);
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.mbsInterceptor.getMBeanInfo(name);
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        return this.innerMBeanServer.instantiate(className);
    }

    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.innerMBeanServer.instantiate(className, loaderName);
    }

    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        return this.innerMBeanServer.instantiate(className, params, signature);
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.innerMBeanServer.instantiate(className, loaderName, params, signature);
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        return this.mbsInterceptor.isInstanceOf(name, className);
    }

    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        return this.innerMBeanServer.deserialize(name, data);
    }

    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        return this.innerMBeanServer.deserialize(className, data);
    }

    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        return this.innerMBeanServer.deserialize(className, loaderName, data);
    }

    public MBeanServerDelegate getMBeanServerDelegate() {
        return this.mbsDelegate;
    }

    public final ClassLoader getMBeanClassLoader(ObjectName name) throws InstanceNotFoundException {
        return this.getClassLoaderFor(name);
    }

    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        return this.mbsInterceptor.getClassLoaderFor(mbeanName);
    }

    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        if (this.mbsInterceptor instanceof CompatibleMBeanInterceptor) {
            try {
                return this.innerMBeanServer.getClassLoader(loaderName);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                // empty catch block
            }
        }
        return this.mbsInterceptor.getClassLoader(loaderName);
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        return this.innerMBeanServer.getClassLoaderRepository();
    }
}

