/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.MBeanInstantiator;
import com.sun.jdmk.MetaData;
import com.sun.jdmk.internal.ClassLogger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public class DynamicMetaDataImpl
implements MetaData {
    private static final String dbgTag = "DynamicMetaDataImpl";
    protected final MBeanInstantiator instantiator;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.mbeanserver", "DynamicMetaDataImpl");

    DynamicMetaDataImpl(MBeanInstantiator instantiator) {
        this.instantiator = instantiator;
        if (instantiator == null) {
            throw new IllegalArgumentException("instantiator must not be null.");
        }
    }

    public void testCompliance(Class c) throws NotCompliantMBeanException {
        if (DynamicMBean.class.isAssignableFrom(c)) {
            return;
        }
        throw new NotCompliantMBeanException("Only DynamicMBeans are supported by this implementation");
    }

    public ObjectName preRegisterInvoker(Object moi, ObjectName name, MBeanServer mbs) throws InstanceAlreadyExistsException, MBeanRegistrationException {
        if (!(moi instanceof MBeanRegistration)) {
            return name;
        }
        ObjectName logicalName = null;
        ObjectName newName = null;
        try {
            newName = ((MBeanRegistration)moi).preRegister(mbs, name);
        }
        catch (RuntimeException e) {
            throw new RuntimeMBeanException(e, "RuntimeException thrown in preRegister method");
        }
        catch (Error er) {
            throw new RuntimeErrorException(er, "Error thrown in preRegister method");
        }
        catch (MBeanRegistrationException r) {
            throw r;
        }
        catch (Exception ex) {
            throw new MBeanRegistrationException(ex, "Exception thrown in preRegister method");
        }
        logicalName = name != null ? name : newName;
        return logicalName;
    }

    public void postRegisterInvoker(Object moi, boolean registrationDone) {
        if (!(moi instanceof MBeanRegistration)) {
            return;
        }
        try {
            ((MBeanRegistration)moi).postRegister(new Boolean(registrationDone));
        }
        catch (RuntimeException e) {
            throw new RuntimeMBeanException(e, "RuntimeException thrown in postRegister method");
        }
        catch (Error er) {
            throw new RuntimeErrorException(er, "Error thrown in postRegister method");
        }
    }

    public void preDeregisterInvoker(Object moi) throws MBeanRegistrationException {
        if (!(moi instanceof MBeanRegistration)) {
            return;
        }
        try {
            ((MBeanRegistration)moi).preDeregister();
        }
        catch (RuntimeException e) {
            throw new RuntimeMBeanException(e, "RuntimeException thrown in preDeregister method");
        }
        catch (Error er) {
            throw new RuntimeErrorException(er, "Error thrown in preDeregister method");
        }
        catch (MBeanRegistrationException t) {
            throw t;
        }
        catch (Exception ex) {
            throw new MBeanRegistrationException(ex, "Exception thrown in preDeregister method");
        }
    }

    public void postDeregisterInvoker(Object moi) {
        if (!(moi instanceof MBeanRegistration)) {
            return;
        }
        try {
            ((MBeanRegistration)moi).postDeregister();
        }
        catch (RuntimeException e) {
            throw new RuntimeMBeanException(e, "RuntimeException thrown in postDeregister method");
        }
        catch (Error er) {
            throw new RuntimeErrorException(er, "Error thrown in postDeregister method");
        }
    }

    public String getMBeanClassName(Object moi) throws IntrospectionException, NotCompliantMBeanException {
        MBeanInfo mbi = this.getMBeanInfo(moi);
        if (mbi == null) {
            throw new NotCompliantMBeanException("The MBeanInfo returned is null");
        }
        String className = mbi.getClassName();
        if (className == null) {
            throw new IntrospectionException("The class Name returned is null");
        }
        return className;
    }

    public MBeanInfo getMBeanInfo(Object moi) throws IntrospectionException {
        try {
            return ((DynamicMBean)moi).getMBeanInfo();
        }
        catch (RuntimeException r) {
            logger.finest("getMBeanInfo", r);
            throw new RuntimeMBeanException(r, "Runtime Exception thrown by getMBeanInfo method of Dynamic MBean");
        }
        catch (Error e) {
            logger.finest("getMBeanInfo", e);
            throw new RuntimeErrorException(e, "Error thrown by getMBeanInfo method of Dynamic MBean");
        }
    }

    public Object getAttribute(Object instance, String attribute) throws MBeanException, AttributeNotFoundException, ReflectionException {
        if (attribute == null) {
            IllegalArgumentException r = new IllegalArgumentException("Attribute name cannot be null");
            throw new RuntimeOperationsException(r, "Exception occurred trying to invoke the getter on the MBean");
        }
        try {
            return ((DynamicMBean)instance).getAttribute(attribute);
        }
        catch (RuntimeException e) {
            logger.finest("getAttribute", e);
            throw new RuntimeOperationsException(e, "RuntimeException thrown by the getAttribute method of the DynamicMBean for the attribute " + attribute);
        }
        catch (Error e) {
            logger.finest("getAttribute", e);
            throw new RuntimeErrorException(e, "Error thrown by the getAttribute method of the DynamicMBean  for the attribute " + attribute);
        }
    }

    public AttributeList getAttributes(Object instance, String[] attributes) throws ReflectionException {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attributes cannot be null"), "Exception occurred trying to invoke the getter on the MBean");
        }
        try {
            return ((DynamicMBean)instance).getAttributes(attributes);
        }
        catch (RuntimeException e) {
            logger.finest("getAttributes", e);
            throw new RuntimeOperationsException(e, "RuntimeException thrown by the getAttributes method of the DynamicMBean");
        }
        catch (Error e) {
            logger.finest("getAttributes", e);
            throw new RuntimeErrorException(e, "Error thrown by the getAttributes method of the DynamicMBean");
        }
    }

    public AttributeList setAttributes(Object instance, AttributeList attributes) throws ReflectionException {
        Class<?> objClass = instance.getClass();
        ClassLoader aLoader = objClass.getClassLoader();
        try {
            AttributeList attlist = this.instantiator.checkTransferAttributeList(aLoader, attributes);
            return ((DynamicMBean)instance).setAttributes(attlist);
        }
        catch (RuntimeException e) {
            logger.finest("setAttributes", e);
            throw new RuntimeOperationsException(e, "RuntimeException thrown by the setAttributes method of the Dynamic MBean");
        }
        catch (Error e) {
            logger.finest("setAttributes", e);
            throw new RuntimeErrorException(e, "Error thrown by the setAttributes method of the Dynamic MBean");
        }
    }

    public Object setAttribute(Object instance, Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (attribute == null) {
            IllegalArgumentException r = new IllegalArgumentException("Attribute name cannot be null");
            throw new RuntimeOperationsException(r, "Exception occurred trying to invoke the setter on the MBean");
        }
        Class<?> objClass = instance.getClass();
        ClassLoader aLoader = objClass.getClassLoader();
        try {
            Attribute attr = this.instantiator.checkTransferAttribute(aLoader, attribute);
            ((DynamicMBean)instance).setAttribute(attr);
            return attr.getValue();
        }
        catch (RuntimeException e) {
            logger.finest("setAttribute", e);
            throw new RuntimeOperationsException(e, "RuntimeException thrown by the setAttribute " + attribute + "method of the Dynamic MBean");
        }
        catch (Error e) {
            logger.finest("setAttribute", e);
            throw new RuntimeErrorException(e, "Error thrown by the setAttribute " + attribute + "method of the Dynamic MBean");
        }
    }

    public Object invoke(Object instance, String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (operationName == null) {
            IllegalArgumentException r = new IllegalArgumentException("Operation name  cannot be null");
            throw new RuntimeOperationsException(r, "Exception occurred trying to invoke the operation on the MBean");
        }
        Class<?> objClass = instance.getClass();
        ClassLoader aLoader = objClass.getClassLoader();
        try {
            Object[] args = this.instantiator.checkTransferParameters(aLoader, params);
            return ((DynamicMBean)instance).invoke(operationName, args, signature);
        }
        catch (RuntimeException e) {
            logger.finest("invoke", e);
            throw new RuntimeOperationsException(e, "RuntimeException thrown by the invoke method of the Dynamic MBean");
        }
        catch (Error e) {
            logger.finest("invoke", e);
            throw new RuntimeErrorException(e, "Error thrown by the invoke method of the Dynamic MBean");
        }
        catch (ReflectionException e) {
            logger.finest("invoke", e);
            throw e;
        }
        catch (MBeanException e) {
            logger.finest("invoke", e);
            throw e;
        }
    }

    public boolean isInstanceOf(Object instance, String className) throws ReflectionException {
        try {
            String cn = this.getMBeanClassName(instance);
            if (cn != null) {
                return cn.equals(className);
            }
            throw new IntrospectionException("Can't obtain MBean class name for " + instance.getClass().getName());
        }
        catch (IntrospectionException x) {
            logger.finest("isInstanceOf", x);
            throw new ReflectionException(x, x.getMessage());
        }
        catch (NotCompliantMBeanException x) {
            logger.finest("isInstanceOf", x);
            throw new ReflectionException(x, x.getMessage());
        }
    }
}

