/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.util;

import com.sun.jbi.jsf.bean.ArchiveBean;
import com.sun.jbi.jsf.util.BeanUtilities;
import com.sun.jbi.jsf.util.JBILogger;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import com.sun.org.apache.xpath.internal.XPathAPI;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ValidationUtilities {
    private static Logger sLog = JBILogger.getInstance();
    public static final String GLASSFISH_INSTALL_ROOT = "com.sun.aas.installRoot";
    public static final String SCAF_JBI_SCHEMA_LOC = "../generated/xml/j2ee-modules/admin-jsf/WEB-INF/classes/com/sun/jbi/jsf/scaf/jbi.xsd";
    private static final String JBI_MANIFEST = "META-INF/jbi.xml";
    private static final String XPATH_BC_NAME = "/jbi/component[@type='binding-component']/identification/name";
    private static final String XPATH_BC_DESCR = "/jbi/component[@type='binding-component']/identification/description";
    private static final String XPATH_SA_NAME = "/jbi/service-assembly/identification/name";
    private static final String XPATH_SA_DESCR = "/jbi/service-assembly/identification/description";
    private static final String XPATH_SE_NAME = "/jbi/component[@type='service-engine']/identification/name";
    private static final String XPATH_SE_DESCR = "/jbi/component[@type='service-engine']/identification/description";
    private static final String XPATH_SL_NAME = "/jbi/shared-library/identification/name";
    private static final String XPATH_SL_DESCR = "/jbi/shared-library/identification/description";

    public static Document getJbiDocument() {
        Document doc;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(false);
            docBuilderFactory.setValidating(false);
            docBuilderFactory.setExpandEntityReferences(false);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            doc = docBuilder.parse(ValidationUtilities.getMetaDataEntry());
        }
        catch (ParserConfigurationException pcEx) {
            sLog.fine("getJbiDocument(), caught pcEx.getMessage()=" + pcEx.getMessage());
            doc = null;
        }
        catch (SAXException saXex) {
            sLog.fine("getJbiDocument(), caught saXex.getMessage()=" + saXex.getMessage());
            doc = null;
        }
        catch (IOException ioEx) {
            sLog.fine("getJbiDocument(), caught ioEx.getMessage()=" + ioEx.getMessage());
            doc = null;
        }
        return doc;
    }

    public static String getJbiType(Document aJbiDescriptor) {
        String result = null;
        if (null != aJbiDescriptor) {
            if (ValidationUtilities.tryXpathExpInDescriptor(XPATH_BC_NAME, XPATH_BC_DESCR, aJbiDescriptor)) {
                result = "binding-component";
            } else if (ValidationUtilities.tryXpathExpInDescriptor(XPATH_SA_NAME, XPATH_SA_DESCR, aJbiDescriptor)) {
                result = "service-assembly";
            } else if (ValidationUtilities.tryXpathExpInDescriptor(XPATH_SE_NAME, XPATH_SE_DESCR, aJbiDescriptor)) {
                result = "service-engine";
            } else if (ValidationUtilities.tryXpathExpInDescriptor(XPATH_SL_NAME, XPATH_SL_DESCR, aJbiDescriptor)) {
                result = "shared-library";
            } else {
                sLog.fine("ValidationUtilities.getJbiType() cannot find an expected type in supplied descriptor");
                return "unknown jbi  type";
            }
        }
        sLog.fine("ValidationUtilities.getJbiType(), result=" + result);
        return result;
    }

    private static boolean tryXpathExpInDescriptor(String anXpathNameExpression, String anXpathDescExpression, Document aJbiDescriptor) {
        boolean result = false;
        ArchiveBean archiveBean = BeanUtilities.getArchiveBean();
        sLog.fine("ValidationUtilities.tryXpathExpInDescriptor(" + anXpathNameExpression + ", " + anXpathDescExpression + "," + aJbiDescriptor + ")");
        try {
            NodeList nodeList = XPathAPI.selectNodeList(aJbiDescriptor, anXpathNameExpression);
            if (0 != nodeList.getLength()) {
                NodeList descNodeList = XPathAPI.selectNodeList(aJbiDescriptor, anXpathDescExpression);
                if (null != descNodeList.item(0) && null != descNodeList.item(0).getFirstChild()) {
                    archiveBean.setDescription(descNodeList.item(0).getFirstChild().getNodeValue());
                } else {
                    archiveBean.setDescription("");
                }
                if (null != nodeList.item(0) && null != nodeList.item(0).getFirstChild()) {
                    archiveBean.setJbiName(nodeList.item(0).getFirstChild().getNodeValue());
                    result = true;
                }
            }
        }
        catch (Exception ex) {
            sLog.log(Level.FINE, "ValidationUtilities.tryXpathExpInDescriptor(...), while parsing jbi.xml, caught ex=", ex);
        }
        sLog.fine("ValidationUtilities.tryXpathExpInDescriptor(...), result=" + result);
        return result;
    }

    /*
     * Exception decompiling
     */
    public static InputStream getMetaDataEntry() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean isArchiveEmptyOrInValid() {
        boolean result;
        block10: {
            ArchiveBean archiveBean;
            block9: {
                ZipInputStream zipArchive;
                block8: {
                    archiveBean = BeanUtilities.getArchiveBean();
                    result = false;
                    String filePath = archiveBean.getArchiveAbsolutePath();
                    zipArchive = null;
                    if (null == filePath) break block9;
                    try {
                        zipArchive = new ZipInputStream(new FileInputStream(filePath));
                        boolean done = false;
                        boolean empty = true;
                        while (!done) {
                            ZipEntry entry = zipArchive.getNextEntry();
                            if (null != entry) {
                                empty = false;
                                continue;
                            }
                            done = true;
                        }
                        if (!empty) break block8;
                        result = true;
                    }
                    catch (ZipException zex) {
                        archiveBean.setZipFileReadError(true);
                        sLog.fine("isArchiveEmptyOrInValid() bad archive, zex=" + zex);
                        result = true;
                        ValidationUtilities.close(zipArchive);
                    }
                    catch (IOException ioex) {
                        archiveBean.setFileReadError(true);
                        sLog.fine("isArchiveEmptyOrInValid() bad file, ioex=" + ioex);
                        result = true;
                        {
                            catch (Throwable throwable) {
                                ValidationUtilities.close(zipArchive);
                                throw throwable;
                            }
                        }
                        ValidationUtilities.close(zipArchive);
                    }
                }
                ValidationUtilities.close(zipArchive);
                break block10;
            }
            sLog.fine("isArchiveEmptyOrInValid() no file");
            archiveBean.setFileReadError(true);
            result = true;
        }
        return result;
    }

    public static boolean isJbiXmlWellformed() {
        boolean result = false;
        try {
            DOMParser parser = new DOMParser();
            InputStream istr = ValidationUtilities.getMetaDataEntry();
            InputSource inSrc = new InputSource(istr);
            sLog.fine("Created InputSOurce");
            parser.parse(inSrc);
            istr.close();
            result = true;
        }
        catch (SAXParseException spe) {
            sLog.fine("isJbiXmlWellformed(), caught spe=" + spe);
            result = false;
        }
        catch (Exception e) {
            sLog.fine("isJbiXmlWellformed(), caught e=" + e);
            result = false;
        }
        return result;
    }

    public static boolean isJbiXmlSchemaValid() {
        boolean result = false;
        try {
            Schema schema;
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                String runtimeSchema = System.getProperty(GLASSFISH_INSTALL_ROOT) + File.separator + "jbi" + File.separator + "schemas" + File.separator + "jbi.xsd";
                schema = factory.newSchema(new File(runtimeSchema));
            }
            catch (Exception fnfEx) {
                schema = factory.newSchema(new File(SCAF_JBI_SCHEMA_LOC));
                sLog.fine("using scaffolded JBI schema=" + schema);
            }
            docBuilderFactory.setNamespaceAware(true);
            Validator validator = schema.newValidator();
            InputStream istr = ValidationUtilities.getMetaDataEntry();
            Document doc = docBuilder.parse(istr);
            validator.validate(new DOMSource(doc));
            istr.close();
            result = true;
        }
        catch (SAXParseException spe) {
            sLog.fine("isJbiXmlSchemaValid(), caught spe=" + spe);
            result = false;
        }
        catch (Exception e) {
            sLog.fine("isJbiXmlSchemaValid(), caught e=" + e);
            result = false;
        }
        return result;
    }

    private static void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException ioe) {
                sLog.fine("IO Exception error in closing the zip archive" + ioe.getMessage());
            }
        }
    }
}

