/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.util;

import com.sun.jbi.jsf.util.JBILogger;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;

public final class I18nUtilities {
    public static final String ADMIN_CONSOLE_BUNDLE = "com.sun.enterprise.tools.admingui.resources.Strings";
    public static final String JBI_ADMIN_GUI_BUNDLE = "com.sun.jbi.jsf.resources.Bundle";
    private static Logger sLog = JBILogger.getInstance();

    public static String getResourceString(String aResourceFile, String aResourceString, String aDefaultString) {
        Locale loc = FacesContext.getCurrentInstance().getViewRoot().getLocale();
        String result = null;
        String resourceString = "";
        resourceString = aResourceString == null ? aDefaultString.trim() : aResourceString.trim();
        if (resourceString.length() > 0) {
            try {
                ResourceBundle resource = ResourceBundle.getBundle(aResourceFile, loc);
                result = resource.getString(resourceString);
            }
            catch (MissingResourceException e) {
                result = resourceString;
            }
        }
        return result;
    }

    public static String getResourceString(String aResourceKey, String aDefaultValue) {
        String result = null;
        String resourceFile = JBI_ADMIN_GUI_BUNDLE;
        result = I18nUtilities.getResourceString(resourceFile, aResourceKey, aDefaultValue);
        sLog.fine("I18Utilities.getResourceString(" + aResourceKey + ", " + aDefaultValue + "), " + resourceFile + " result=" + result);
        if (aResourceKey.equals(result) || aDefaultValue.equals(result)) {
            resourceFile = ADMIN_CONSOLE_BUNDLE;
            result = I18nUtilities.getResourceString(resourceFile, aResourceKey, aDefaultValue);
            sLog.fine("I18Utilities.getResourceString(" + aResourceKey + ", " + aDefaultValue + "), " + resourceFile + " result=" + result);
        }
        return result;
    }

    public static String getResourceString(String aResourceString) {
        String resourceFile = ADMIN_CONSOLE_BUNDLE;
        String str = I18nUtilities.getResourceString(aResourceString, "");
        return str;
    }

    public static String getStringPropertyUsingExpression(String anExpression) {
        String result = null;
        FacesContext fCtx = FacesContext.getCurrentInstance();
        ELContext elCtx = fCtx.getELContext();
        ExpressionFactory ef = fCtx.getApplication().getExpressionFactory();
        ValueExpression ve = ef.createValueExpression(elCtx, anExpression, String.class);
        result = (String)ve.getValue(elCtx);
        return result;
    }

    public static void setStringPropertyUsingExpression(String aStringValue, String anExpression) {
        FacesContext fCtx = FacesContext.getCurrentInstance();
        ELContext elCtx = fCtx.getELContext();
        ExpressionFactory ef = fCtx.getApplication().getExpressionFactory();
        ValueExpression ve = ef.createValueExpression(elCtx, anExpression, String.class);
        ve.setValue(elCtx, (Object)aStringValue);
    }
}

