/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.handlers;

import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.jbi.jsf.bean.AlertBean;
import com.sun.jbi.jsf.util.BeanUtilities;
import com.sun.jbi.jsf.util.I18nUtilities;
import com.sun.jbi.jsf.util.JBILogger;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.logging.Logger;

public class AlertHandlers {
    private static Logger sLog = JBILogger.getInstance();

    public static void jbiDecrementAlertCountIfNeeded(HandlerContext handlerCtx) {
        AlertHandlers.jbiDecrementAlertCountIfNeededImpl(handlerCtx);
    }

    public static void jbiDecrementAlertCountIfNeededImpl(HandlerContext handlerCtx) {
        Boolean isAlertNeeded = (Boolean)handlerCtx.getInputValue("isAlertNeeded");
        AlertBean alertBean = BeanUtilities.getAlertBean();
        int alertCount = alertBean.getAlertCount();
        if (null != isAlertNeeded && isAlertNeeded.booleanValue()) {
            alertBean.setAlertCount(--alertCount);
        }
        sLog.fine("AlertHandlers.jbiDecrementAlertCountIfNeededImpl(...),  isAlertNeeded=" + isAlertNeeded + ", alertBean.getAlertCount()=" + alertCount);
    }

    public static void jbiSetDefaultsOrTargetLoadedAlert(HandlerContext handlerCtx) {
        String defaultsOrTarget = (String)handlerCtx.getInputValue("defaultsOrTarget");
        String clusterOrPe = (String)handlerCtx.getInputValue("clusterOrPe");
        String target = (String)handlerCtx.getInputValue("target");
        sLog.fine("AlertHandlers.jbiSetDefaultsOrTargetLoadedAlert(), defaultsOrTarget =" + defaultsOrTarget + ", clusterOrPe=" + clusterOrPe + ", target=" + target);
        AlertBean alertBean = BeanUtilities.getAlertBean();
        Object[] args = new Object[]{target};
        String alertType = "info";
        String alertSummary = GuiUtil.getMessage((String)I18nUtilities.getResourceString("jbi.root.configuration." + defaultsOrTarget + "." + clusterOrPe + ".loaded.summary.message"), (Object[])args);
        String alertDetail = I18nUtilities.getResourceString("jbi.root.configuration." + defaultsOrTarget + "." + clusterOrPe + ".loaded.detail.message");
        alertBean.setAlertType(alertType);
        alertBean.setAlertSummary(alertSummary);
        alertBean.setAlertDetail(alertDetail);
        sLog.fine("AlertHandlers.jbiSetDefaultsOrTargetLoadedAlert(), alertType=" + alertType + ", alertSummary=" + alertSummary + ", alertDetail=" + alertDetail);
    }

    public static void jbiIncrementAlertCountIfNeeded(HandlerContext handlerCtx) {
        Boolean isAlertNeeded = (Boolean)handlerCtx.getInputValue("isAlertNeeded");
        AlertBean alertBean = BeanUtilities.getAlertBean();
        int alertCount = alertBean.getAlertCount();
        if (null != isAlertNeeded && isAlertNeeded.booleanValue()) {
            alertBean.setAlertCount(++alertCount);
        }
        sLog.fine("AlertHandlers.jbiIncrementAlertCountIfNeeded(...),  isAlertNeeded=" + isAlertNeeded + ", alertBean.getAlertCount()=" + alertCount);
    }

    public static void jbiIsAlertNeeded(HandlerContext handlerCtx) {
        AlertHandlers.jbiIsAlertNeededImpl(handlerCtx);
    }

    public static void jbiIsAlertNeededImpl(HandlerContext handlerCtx) {
        AlertBean alertBean = BeanUtilities.getAlertBean();
        int alertCount = alertBean.getAlertCount();
        boolean isAlertNeeded = 0 < alertCount;
        handlerCtx.setOutputValue("isAlertNeeded", (Object)isAlertNeeded);
        sLog.fine("AlertHandlers.jbiIsAlertNeededImpl(...),  isAlertNeeded=" + isAlertNeeded + ", alertBean.getAlertCount()=" + alertCount);
    }
}

