/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.framework.services.administration.providers;

import com.sun.jbi.jsf.framework.common.ComponentInformationParser;
import com.sun.jbi.jsf.framework.common.ServiceAssemblyInformationParser;
import com.sun.jbi.jsf.framework.connectors.ServerConnector;
import com.sun.jbi.jsf.framework.model.JBIComponentStatus;
import com.sun.jbi.jsf.framework.model.JBIComponentStatusDocument;
import com.sun.jbi.jsf.framework.model.JBIServiceAssemblyStatus;
import com.sun.jbi.jsf.framework.model.JBIServiceAssemblyStatusDocument;
import com.sun.jbi.jsf.framework.services.BaseServiceProvider;
import com.sun.jbi.jsf.framework.services.administration.AdministrationService;
import com.sun.jbi.ui.client.JBIAdminCommandsClientFactory;
import com.sun.jbi.ui.common.JBIAdminCommands;
import com.sun.jbi.ui.common.JBIRemoteException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SunAdministrationService
extends BaseServiceProvider
implements AdministrationService,
Serializable {
    private static final String ADMIN_SERVICE_OBJECTNAME = "com.sun.jbi:ServiceName=JbiAdminUiService,ComponentType=System";
    private static String CAM_SERVER_MBEAN_NAME = "com.sun.cam:type=server,name=ServerMBean";
    protected List<JBIComponentStatus> bindingComponentList = new ArrayList<JBIComponentStatus>();
    protected List<JBIComponentStatus> serviceEngineList = new ArrayList<JBIComponentStatus>();
    protected List<JBIComponentStatus> sharedNamespacesList = new ArrayList<JBIComponentStatus>();
    protected List<JBIServiceAssemblyStatus> serviceAssemblyList = new ArrayList<JBIServiceAssemblyStatus>();
    protected String bindingComponents;
    protected String serviceEngines;
    protected String sharedLibraries;
    protected String serviceAssemblies;
    protected String sharedLibraryDependents;
    protected JBIComponentStatusDocument componentDoc = null;
    protected JBIServiceAssemblyStatusDocument serviceAssemblyStatusDoc = null;
    protected String mbeanName = "com.sun.jbi:ServiceName=JbiAdminUiService,ComponentType=System";
    protected ObjectName objectName = null;
    protected String targetName;
    protected Map<String, String> components = new HashMap<String, String>();
    private Logger logger = Logger.getLogger(SunAdministrationService.class.getName());

    public SunAdministrationService(ServerConnector connector, String targetName) {
        super(connector, targetName);
        this.prepare(targetName);
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String target) {
        this.targetName = target;
    }

    @Override
    public void prepare(String targetName) {
        this.targetName = targetName;
        this.initialize();
        this.constructDocumentObject();
        JBIComponentStatusDocument componentDoc = this.getJBIComponentStatusDocument();
        JBIServiceAssemblyStatusDocument assemblyDoc = this.getJBIServiceAssemblyStatusDocument();
        this.organize(componentDoc.getJbiComponentStatusList(), assemblyDoc.getJbiServiceAssemblyStatusList());
    }

    @Override
    public List<JBIComponentStatus> getBindingComponentList() {
        return this.bindingComponentList;
    }

    @Override
    public List<JBIServiceAssemblyStatus> getServiceAssemblyList() {
        return this.serviceAssemblyList;
    }

    @Override
    public List<JBIComponentStatus> getServiceEngineList() {
        return this.serviceEngineList;
    }

    @Override
    public List<JBIComponentStatus> getSharedNamespacesList() {
        return this.sharedNamespacesList;
    }

    @Override
    public String getComponentType(String name) {
        return this.components.get(name);
    }

    private void initialize() {
        JBIAdminCommands commands = null;
        Object set = null;
        Object resultObject = null;
        try {
            this.serverConnection = this.serverConnector.getConnection();
            if (this.serverConnection != null) {
                commands = JBIAdminCommandsClientFactory.getInstance((MBeanServerConnection)this.serverConnection, (boolean)false);
                if (commands != null) {
                    this.bindingComponents = commands.listBindingComponents(this.targetName);
                    this.serviceEngines = commands.listServiceEngines(this.targetName);
                    this.sharedLibraries = commands.listSharedLibraries(this.targetName);
                    this.serviceAssemblies = commands.listServiceAssemblies(this.targetName);
                }
            } else {
                this.logger.severe("Connection Failed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void organize(List<JBIComponentStatus> jbiComponentList, List<JBIServiceAssemblyStatus> jbiServiceAssemblyList) {
        Iterator<JBIComponentStatus> iterator = jbiComponentList.iterator();
        JBIComponentStatus component = null;
        Object assembly = null;
        String type = null;
        while (iterator != null && iterator.hasNext()) {
            component = iterator.next();
            if (component == null || (type = component.getType()) == null) continue;
            if (type.equals("binding-component")) {
                this.bindingComponentList.add(component);
                this.components.put(component.getName(), "binding-component");
            }
            if (type.equals("service-engine")) {
                this.serviceEngineList.add(component);
                this.components.put(component.getName(), "service-engine");
            }
            if (!type.equals("shared-library")) continue;
            this.sharedNamespacesList.add(component);
        }
        if (this.serviceAssemblyList != null) {
            this.serviceAssemblyList.addAll(jbiServiceAssemblyList);
        }
    }

    @Override
    public Object invoke(ObjectName objectName, String operationName, Object[] parameters) {
        String result = operationName + ": ";
        String output = "";
        Object throwable = null;
        String[] signature = this.getSignatures(parameters);
        try {
            if (this.serverConnection != null) {
                output = (String)this.serverConnection.invoke(objectName, operationName, parameters, signature);
            }
            int e = 0;
            int s = 0;
            String pattern = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>";
            e = output.indexOf("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>", s);
            result = e >= 0 ? output : result + output;
        }
        catch (Exception e) {
            result = this.formatException(e, operationName);
            e.printStackTrace();
        }
        return result;
    }

    protected String replace(String str, String pattern, String replace) {
        int s = 0;
        int e = 0;
        StringBuffer result = new StringBuffer();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }

    protected String formatException(Exception e, String operationName) {
        String result = "Failed execution of " + operationName + ". ";
        Throwable throwable = e.getCause();
        result = throwable != null ? result + throwable.getMessage().trim() : result + e.getMessage();
        return result;
    }

    protected JBIComponentStatusDocument getJBIComponentStatusDocument() {
        return this.componentDoc;
    }

    protected JBIServiceAssemblyStatusDocument getJBIServiceAssemblyStatusDocument() {
        return this.serviceAssemblyStatusDoc;
    }

    protected void constructDocumentObject() {
        this.componentDoc = new JBIComponentStatusDocument();
        this.serviceAssemblyStatusDoc = new JBIServiceAssemblyStatusDocument();
        JBIComponentStatusDocument component = null;
        JBIServiceAssemblyStatusDocument serviceAssembly = null;
        try {
            component = ComponentInformationParser.parse(this.bindingComponents);
            if (this.componentDoc != null && component != null) {
                this.componentDoc.addJbiComponentStatusList(component.getJbiComponentStatusList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            serviceAssembly = ServiceAssemblyInformationParser.parse(this.serviceAssemblies);
            if (this.serviceAssemblyStatusDoc != null && serviceAssembly != null) {
                this.serviceAssemblyStatusDoc.addJbiServiceAssemblyStatusList(serviceAssembly.getJbiServiceAssemblyStatusList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            component = ComponentInformationParser.parse(this.serviceEngines);
            if (this.componentDoc != null && component != null) {
                this.componentDoc.addJbiComponentStatusList(component.getJbiComponentStatusList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            component = ComponentInformationParser.parse(this.sharedLibraries);
            if (this.componentDoc != null && component != null) {
                this.componentDoc.addJbiComponentStatusList(component.getJbiComponentStatusList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void printOut() {
        if (this.bindingComponents != null) {
            System.out.println("/////////////////////////////////////////////");
            System.out.println("// -- Binding Components --");
            System.out.println("/////////////////////////////////////////////");
            System.out.println(this.bindingComponents);
        }
        if (this.serviceEngines != null) {
            System.out.println("/////////////////////////////////////////////");
            System.out.println("// -- Engine Components --");
            System.out.println("/////////////////////////////////////////////");
            System.out.println(this.serviceEngines);
        }
        if (this.sharedLibraries != null) {
            System.out.println("/////////////////////////////////////////////");
            System.out.println("// -- Shared Namespace Components --");
            System.out.println("/////////////////////////////////////////////");
            System.out.println(this.sharedLibraries);
        }
        if (this.serviceAssemblies != null) {
            System.out.println("/////////////////////////////////////////////");
            System.out.println("// -- Deployments --");
            System.out.println("/////////////////////////////////////////////");
            System.out.println(this.serviceAssemblies);
        }
    }

    public String installComponent(String zipFilePath, Properties paramProps) {
        String result = "";
        JBIAdminCommands commands = null;
        if (this.serverConnection != null) {
            try {
                commands = JBIAdminCommandsClientFactory.getInstance((MBeanServerConnection)this.serverConnection, (boolean)false);
                if (commands != null) {
                    commands.installComponent(zipFilePath, paramProps, this.targetName);
                }
            }
            catch (JBIRemoteException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public String installComponent(String zipFilePath) {
        String result = "";
        JBIAdminCommands commands = null;
        if (this.serverConnection != null) {
            try {
                commands = JBIAdminCommandsClientFactory.getInstance((MBeanServerConnection)this.serverConnection, (boolean)false);
                if (commands != null) {
                    commands.installComponent(zipFilePath, this.targetName);
                }
            }
            catch (JBIRemoteException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public String uninstallComponent(String componentName) {
        String result = "";
        JBIAdminCommands commands = null;
        if (this.serverConnection != null) {
            try {
                commands = JBIAdminCommandsClientFactory.getInstance((MBeanServerConnection)this.serverConnection, (boolean)false);
                if (commands != null) {
                    commands.uninstallComponent(componentName, this.targetName);
                }
            }
            catch (JBIRemoteException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public String installSharedLibrary(String zipFilePath) {
        String result = "";
        JBIAdminCommands commands = null;
        if (this.serverConnection != null) {
            try {
                commands = JBIAdminCommandsClientFactory.getInstance((MBeanServerConnection)this.serverConnection, (boolean)false);
                if (commands != null) {
                    commands.installSharedLibrary(zipFilePath, this.targetName);
                }
            }
            catch (JBIRemoteException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public String uninstallSharedLibrary(String sharedLibraryName) {
        String result = "";
        JBIAdminCommands commands = null;
        if (this.serverConnection != null) {
            try {
                commands = JBIAdminCommandsClientFactory.getInstance((MBeanServerConnection)this.serverConnection, (boolean)false);
                if (commands != null) {
                    commands.uninstallSharedLibrary(sharedLibraryName, this.targetName);
                }
            }
            catch (JBIRemoteException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public String startComponent(String componentName) {
        String result = "";
        JBIAdminCommands commands = null;
        if (this.serverConnection != null) {
            try {
                commands = JBIAdminCommandsClientFactory.getInstance((MBeanServerConnection)this.serverConnection, (boolean)false);
                if (commands != null) {
                    commands.startComponent(componentName, this.targetName);
                }
            }
            catch (JBIRemoteException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public String stopComponent(String componentName) {
        String result = "";
        JBIAdminCommands commands = null;
        if (this.serverConnection != null) {
            try {
                commands = JBIAdminCommandsClientFactory.getInstance((MBeanServerConnection)this.serverConnection, (boolean)false);
                if (commands != null) {
                    commands.stopComponent(componentName, this.targetName);
                }
            }
            catch (JBIRemoteException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public String shutdownComponent(String componentName) {
        String result = "";
        JBIAdminCommands commands = null;
        if (this.serverConnection != null) {
            try {
                commands = JBIAdminCommandsClientFactory.getInstance((MBeanServerConnection)this.serverConnection, (boolean)false);
                if (commands != null) {
                    commands.shutdownComponent(componentName, this.targetName);
                }
            }
            catch (JBIRemoteException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public String deployServiceAssembly(String zipFilePath) {
        String result = "";
        JBIAdminCommands commands = null;
        if (this.serverConnection != null) {
            try {
                commands = JBIAdminCommandsClientFactory.getInstance((MBeanServerConnection)this.serverConnection, (boolean)false);
                if (commands != null) {
                    commands.deployServiceAssembly(zipFilePath, this.targetName);
                }
            }
            catch (JBIRemoteException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public String startServiceAssembly(String serviceAssemblyName) {
        String result = "";
        JBIAdminCommands commands = null;
        if (this.serverConnection != null) {
            try {
                commands = JBIAdminCommandsClientFactory.getInstance((MBeanServerConnection)this.serverConnection, (boolean)false);
                if (commands != null) {
                    commands.startServiceAssembly(serviceAssemblyName, this.targetName);
                }
            }
            catch (JBIRemoteException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public String stopServiceAssembly(String serviceAssemblyName) {
        String result = "";
        JBIAdminCommands commands = null;
        if (this.serverConnection != null) {
            try {
                commands = JBIAdminCommandsClientFactory.getInstance((MBeanServerConnection)this.serverConnection, (boolean)false);
                if (commands != null) {
                    commands.stopServiceAssembly(serviceAssemblyName, this.targetName);
                }
            }
            catch (JBIRemoteException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public String shutdownServiceAssembly(String serviceAssemblyName) {
        String result = "";
        JBIAdminCommands commands = null;
        if (this.serverConnection != null) {
            try {
                commands = JBIAdminCommandsClientFactory.getInstance((MBeanServerConnection)this.serverConnection, (boolean)false);
                if (commands != null) {
                    commands.shutdownServiceAssembly(serviceAssemblyName, this.targetName);
                }
            }
            catch (JBIRemoteException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public String undeployServiceAssembly(String serviceAssemblyName) {
        String result = "";
        JBIAdminCommands commands = null;
        if (this.serverConnection != null) {
            try {
                commands = JBIAdminCommandsClientFactory.getInstance((MBeanServerConnection)this.serverConnection, (boolean)false);
                if (commands != null) {
                    commands.undeployServiceAssembly(serviceAssemblyName, this.targetName);
                }
            }
            catch (JBIRemoteException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public String listBindingComponents(String state, String sharedLibraryName, String serviceAssemblyName) {
        String result = "";
        return result;
    }

    public String listSharedLibraryDependents(String sharedLibraryName) {
        String result = "";
        return result;
    }

    public String listServiceAssemblies(String componentName) {
        String result = "";
        Object[] params = new String[]{componentName};
        result = (String)this.invoke(this.objectName, "listServiceAssemblies", params);
        return result;
    }

    public String listServiceEngines() {
        String result = "";
        return result;
    }

    @Override
    public String getServiceAssemblyDeploymentDescriptor(String serviceAssemblyName) {
        String result = "";
        JBIAdminCommands commands = null;
        if (this.serverConnection != null) {
            try {
                commands = JBIAdminCommandsClientFactory.getInstance((MBeanServerConnection)this.serverConnection, (boolean)false);
                if (commands != null) {
                    result = commands.getServiceAssemblyDeploymentDescriptor(serviceAssemblyName);
                }
            }
            catch (JBIRemoteException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public String getServiceUnitDeploymentDescriptor(String serviceAssemblyName, String serviceUnitName) {
        String result = "";
        JBIAdminCommands commands = null;
        if (this.serverConnection != null) {
            try {
                commands = JBIAdminCommandsClientFactory.getInstance((MBeanServerConnection)this.serverConnection, (boolean)false);
                if (commands != null) {
                    result = commands.getServiceUnitDeploymentDescriptor(serviceAssemblyName, serviceUnitName);
                }
            }
            catch (JBIRemoteException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }
}

