/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.framework.model;

import com.sun.jbi.jsf.framework.common.XmlUtils;
import com.sun.jbi.jsf.framework.model.JBIConnection;
import com.sun.jbi.jsf.framework.model.JBIDescriptor;
import com.sun.jbi.jsf.framework.model.JBIIdentification;
import com.sun.jbi.jsf.framework.model.JBIServiceUnit;
import com.sun.jbi.jsf.util.JBILogger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBIServiceAssemblyDescriptor
extends JBIDescriptor {
    private JBIIdentification identification;
    private List<JBIServiceUnit> suDescriptorList = new ArrayList<JBIServiceUnit>();
    private List<JBIConnection> connectionList = new ArrayList<JBIConnection>();
    private Logger logger = JBILogger.getInstance();

    public JBIServiceAssemblyDescriptor(String xmlText) {
        super(xmlText);
    }

    @Override
    public void parse() {
        Element saElement;
        super.parse();
        if (this.jbiElement != null && (saElement = XmlUtils.getChildElement(this.jbiElement, "service-assembly")) != null) {
            Element idElement = XmlUtils.getChildElement(saElement, "identification");
            if (idElement != null) {
                this.identification = JBIIdentification.create(idElement);
            }
            this.suDescriptorList.clear();
            NodeList suNodeList = XmlUtils.getChildElements(saElement, "service-unit");
            for (int i = 0; i < suNodeList.getLength(); ++i) {
                Element suElement = (Element)suNodeList.item(i);
                if (suElement == null) continue;
                JBIServiceUnit suDescriptor = JBIServiceUnit.create(suElement);
                this.suDescriptorList.add(suDescriptor);
            }
            Element connectionsElement = XmlUtils.getChildElement(saElement, "connections");
            if (connectionsElement != null) {
                NodeList cList = XmlUtils.getChildElements(connectionsElement, "connection");
                for (int i = 0; i < cList.getLength(); ++i) {
                    Element cElement = (Element)cList.item(i);
                    if (cElement == null) continue;
                    JBIConnection connection = JBIConnection.create(cElement);
                    this.connectionList.add(connection);
                }
            }
        }
    }

    public String getName() {
        return this.identification == null ? null : this.identification.getName();
    }

    public String getDescription() {
        return this.identification == null ? null : this.identification.getDescription();
    }

    public List<JBIServiceUnit> getServiceUnits() {
        return this.suDescriptorList;
    }

    public List<JBIConnection> getConnections() {
        return this.connectionList;
    }

    public static void main(String[] args) {
        String xmlText = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><jbi  xmlns=\"http://java.sun.com/xml/ns/jbi\" xmlns:ns1=\"http://localhost/SynchronousSample/SynchronousSample\"  xmlns:ns2=\"http://enterprise.netbeans.org/bpel/SynchronousSample/SynchronousSample_1\"  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" version=\"1.0\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/jbi ./jbi.xsd\"> <service-assembly> <identification> <name>SynchronousSampleApplication</name> <description>Represents the Service Assembly of SynchronousSampleApplication</description> </identification> <service-unit> <identification>        <name>SynchronousSampleApplication-SynchronousSample</name> <description>Represents this Service Unit</description>   </identification> <target> <artifacts-zip>SynchronousSample.jar</artifacts-zip>       <component-name>sun-bpel-engine</component-name>  </target> </service-unit> <service-unit> <identification>        <name>SynchronousSampleApplication-sun-http-binding</name> <description>Represents this Service Unit</description>     </identification> <target> <artifacts-zip>sun-http-binding.jar</artifacts-zip>        <component-name>sun-http-binding</component-name> </target> </service-unit> <connections> <connection> <consumer  endpoint-name=\"port1\" service-name=\"ns1:service1\"/> <provider endpoint-name=\"partnerlinktyperole1_myRole\" service-name=\"ns2:SynchronousSample\"/> </connection> </connections> </service-assembly> </jbi>";
        JBIServiceAssemblyDescriptor desc = new JBIServiceAssemblyDescriptor(xmlText);
        desc.parse();
        Logger logger = JBILogger.getInstance();
        logger.info("name:" + desc.getName());
        logger.info("desc:" + desc.getDescription());
        List<JBIServiceUnit> list = desc.getServiceUnits();
        for (JBIServiceUnit su : list) {
            logger.info("SU: " + su);
        }
        List<JBIConnection> cList = desc.getConnections();
        for (JBIConnection c : cList) {
            logger.info("Connection: " + c);
        }
    }
}

