/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.queryframework;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.internal.databaseaccess.DatabaseCall;
import oracle.toplink.essentials.internal.databaseaccess.DatasourceCall;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.helper.NonSynchronizedVector;
import oracle.toplink.essentials.internal.queryframework.DatabaseQueryMechanism;
import oracle.toplink.essentials.internal.queryframework.JoinedAttributeManager;
import oracle.toplink.essentials.internal.queryframework.ReportItem;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.DeleteAllQuery;
import oracle.toplink.essentials.queryframework.ReportQuery;
import oracle.toplink.essentials.queryframework.UpdateAllQuery;
import oracle.toplink.essentials.queryframework.WriteObjectQuery;

public class DatasourceCallQueryMechanism
extends DatabaseQueryMechanism {
    protected DatasourceCall call;
    protected Vector calls;

    public DatasourceCallQueryMechanism(DatabaseQuery query) {
        super(query);
    }

    public DatasourceCallQueryMechanism(DatabaseQuery query, DatasourceCall call) {
        super(query);
        this.call = call;
        call.setQuery(query);
    }

    public void addCall(DatasourceCall call) {
        this.getCalls().addElement(call);
        call.setQuery(this.getQuery());
    }

    public DatabaseCall cursorSelectAllRows() throws DatabaseException {
        try {
            return (DatabaseCall)this.executeCall();
        }
        catch (ClassCastException e) {
            throw QueryException.mustUseCursorStreamPolicy();
        }
    }

    public Integer deleteAll() throws DatabaseException {
        if (((DeleteAllQuery)this.getQuery()).isPreparedUsingTempStorage()) {
            return this.deleteAllUsingTempTables();
        }
        if (this.hasMultipleCalls()) {
            Integer returnedRowCount = null;
            for (int index = this.getCalls().size() - 1; index >= 0; --index) {
                DatasourceCall databseCall = (DatasourceCall)this.getCalls().elementAt(index);
                returnedRowCount = (Integer)this.executeCall(databseCall);
            }
            return returnedRowCount;
        }
        return (Integer)this.executeCall();
    }

    public Integer deleteAllUsingTempTables() throws DatabaseException {
        DatasourceCall databseCall;
        DatabaseException ex = null;
        Integer returnedRowCount = null;
        try {
            databseCall = (DatasourceCall)this.getCalls().elementAt(this.getCalls().size() - 1);
            this.executeCall(databseCall);
        }
        catch (DatabaseException databaseEx) {
            // empty catch block
        }
        if (ex == null) {
            try {
                databseCall = (DatasourceCall)this.getCalls().elementAt(this.getCalls().size() - 2);
                this.executeCall(databseCall);
            }
            catch (DatabaseException databaseEx) {
                ex = databaseEx;
            }
        }
        for (int index = this.getCalls().size() - 3; index >= 1 && ex == null; --index) {
            DatasourceCall databseCall2 = (DatasourceCall)this.getCalls().elementAt(index);
            try {
                returnedRowCount = (Integer)this.executeCall(databseCall2);
                continue;
            }
            catch (DatabaseException databaseEx) {
                ex = databaseEx;
            }
        }
        try {
            DatasourceCall databseCall3 = (DatasourceCall)this.getCalls().elementAt(0);
            this.executeCall(databseCall3);
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        if (ex != null) {
            throw ex;
        }
        return returnedRowCount;
    }

    public Integer deleteObject() throws DatabaseException {
        if (this.hasMultipleCalls()) {
            Integer returnedRowCount = null;
            for (int index = this.getCalls().size() - 1; index >= 0; --index) {
                DatasourceCall databseCall = (DatasourceCall)this.getCalls().elementAt(index);
                Integer rowCount = (Integer)this.executeCall(databseCall);
                if (index != this.getCalls().size() - 1 && rowCount > 0) continue;
                returnedRowCount = rowCount;
            }
            return returnedRowCount;
        }
        return (Integer)this.executeCall();
    }

    protected Object executeCall() throws DatabaseException {
        return this.executeCall(this.getCall());
    }

    protected Object executeCall(DatasourceCall databaseCall) throws DatabaseException {
        AbstractSession sessionToUse = this.getSession().getExecutionSession(this.getQuery());
        DatasourceCall clonedCall = (DatasourceCall)databaseCall.clone();
        clonedCall.setQuery(this.getQuery());
        clonedCall.translate(this.getTranslationRow(), this.getModifyRow(), sessionToUse);
        return sessionToUse.executeCall(clonedCall, this.getTranslationRow(), this.getQuery());
    }

    public Integer executeNoSelect() throws DatabaseException {
        return this.executeNoSelectCall();
    }

    public Integer executeNoSelectCall() throws DatabaseException {
        if (this.hasMultipleCalls()) {
            Integer returnedRowCount = null;
            for (int index = 0; index < this.getCalls().size(); ++index) {
                DatasourceCall databseCall = (DatasourceCall)this.getCalls().elementAt(index);
                Integer rowCount = (Integer)this.executeCall(databseCall);
                if (index != 0 && rowCount > 0) continue;
                returnedRowCount = rowCount;
            }
            return returnedRowCount;
        }
        return (Integer)this.executeCall();
    }

    public Vector executeSelect() throws DatabaseException {
        return this.executeSelectCall();
    }

    public Vector executeSelectCall() throws DatabaseException {
        if (this.hasMultipleCalls()) {
            Vector results = new Vector();
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatasourceCall databseCall = (DatasourceCall)callsEnum.nextElement();
                Helper.addAllToVector(results, (Vector)this.executeCall(databseCall));
            }
            return results;
        }
        return (Vector)this.executeCall();
    }

    public DatasourceCall getCall() {
        return this.call;
    }

    public Vector getCalls() {
        if (this.calls == null) {
            this.calls = NonSynchronizedVector.newInstance(3);
        }
        return this.calls;
    }

    public boolean hasMultipleCalls() {
        return this.calls != null && !this.calls.isEmpty();
    }

    public void insertObject() throws DatabaseException {
        Class cls = this.getQuery().getReferenceClass();
        boolean usesSequencing = this.getDescriptor().usesSequenceNumbers();
        boolean shouldAcquireValueAfterInsert = false;
        if (usesSequencing) {
            shouldAcquireValueAfterInsert = this.getSession().getSequencing().shouldAcquireValueAfterInsert(cls);
        }
        Collection returnFields = null;
        if (usesSequencing && !shouldAcquireValueAfterInsert) {
            this.updateObjectAndRowWithSequenceNumber();
        }
        if (this.hasMultipleCalls()) {
            for (int index = 0; index < this.getCalls().size(); ++index) {
                DatasourceCall databseCall = (DatasourceCall)this.getCalls().elementAt(index);
                this.executeCall(databseCall);
                if (returnFields != null) {
                    this.updateObjectAndRowWithReturnRow(returnFields, index == 0);
                }
                if (index != 0 || !usesSequencing || !shouldAcquireValueAfterInsert) continue;
                this.updateObjectAndRowWithSequenceNumber();
            }
        } else {
            this.executeCall();
            if (returnFields != null) {
                this.updateObjectAndRowWithReturnRow(returnFields, true);
            }
            if (usesSequencing && shouldAcquireValueAfterInsert) {
                this.updateObjectAndRowWithSequenceNumber();
            }
        }
        AbstractSession executionSession = this.getSession().getExecutionSession(this.getQuery());
        executionSession.getAccessor().flushSelectCalls(executionSession);
    }

    public boolean isCallQueryMechanism() {
        return true;
    }

    public void prepare() {
        if (!this.hasMultipleCalls() && this.getCall() == null) {
            throw QueryException.sqlStatementNotSetProperly(this.getQuery());
        }
    }

    public void prepareCall() throws QueryException {
        DatabaseQuery query = this.getQuery();
        AbstractSession executionSession = this.getSession().getExecutionSession(query);
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatasourceCall call = (DatasourceCall)callsEnum.nextElement();
                call.prepare(executionSession);
            }
        } else if (this.getCall() != null) {
            this.getCall().prepare(executionSession);
        }
    }

    public void prepareCursorSelectAllRows() throws QueryException {
        this.getCall().returnCursor();
        this.prepareCall();
    }

    public void prepareDeleteAll() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatasourceCall call = (DatasourceCall)callsEnum.nextElement();
                call.returnNothing();
            }
        } else {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    public void prepareDeleteObject() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatasourceCall call = (DatasourceCall)callsEnum.nextElement();
                call.returnNothing();
            }
        } else {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    public void prepareDoesExist(DatabaseField field) {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                ((DatasourceCall)callsEnum.nextElement()).returnOneRow();
            }
        } else {
            this.getCall().returnOneRow();
        }
        this.prepareCall();
    }

    public void prepareExecuteNoSelect() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                ((DatasourceCall)callsEnum.nextElement()).returnNothing();
            }
        } else {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    public void prepareExecuteSelect() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatasourceCall databseCall = (DatasourceCall)callsEnum.nextElement();
                databseCall.returnManyRows();
            }
        } else {
            this.getCall().returnManyRows();
        }
        this.prepareCall();
    }

    public void prepareInsertObject() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                ((DatasourceCall)callsEnum.nextElement()).returnNothing();
            }
        } else {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    protected void prepareReportQueryItems() {
        int itemOffset = 0;
        for (ReportItem item : ((ReportQuery)this.getQuery()).getItems()) {
            item.setResultIndex(itemOffset);
            if (item.getAttributeExpression() == null) continue;
            JoinedAttributeManager joinManager = item.getJoinedAttributeManager();
            if (joinManager.hasJoinedExpressions()) {
                itemOffset = joinManager.computeJoiningMappingIndexes(true, this.getSession(), itemOffset);
                continue;
            }
            if (item.getDescriptor() != null) {
                itemOffset += item.getDescriptor().getAllFields().size();
                continue;
            }
            ++itemOffset;
        }
    }

    public void prepareReportQuerySelectAllRows() {
        this.prepareReportQueryItems();
        this.prepareExecuteSelect();
    }

    public void prepareReportQuerySubSelect() {
        this.prepareReportQueryItems();
        this.prepareCall();
    }

    public void prepareSelectAllRows() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatasourceCall databseCall = (DatasourceCall)callsEnum.nextElement();
                databseCall.returnManyRows();
            }
        } else {
            this.getCall().returnManyRows();
        }
        this.prepareCall();
    }

    public void prepareSelectOneRow() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatasourceCall databseCall = (DatasourceCall)callsEnum.nextElement();
                databseCall.returnOneRow();
            }
        } else {
            this.getCall().returnOneRow();
        }
        this.prepareCall();
    }

    public void prepareUpdateObject() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatasourceCall call = (DatasourceCall)callsEnum.nextElement();
                call.returnNothing();
            }
        } else if (this.getCall() != null) {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    public void prepareUpdateAll() {
        if (this.getCall() != null) {
            this.getCall().returnNothing();
        }
        this.prepareCall();
    }

    public Vector selectAllReportQueryRows() throws DatabaseException {
        return this.executeSelect();
    }

    public Vector selectAllRows() throws DatabaseException {
        return this.executeSelectCall();
    }

    public AbstractRecord selectOneRow() throws DatabaseException {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatasourceCall databaseCall = (DatasourceCall)callsEnum.nextElement();
                AbstractRecord result = (AbstractRecord)this.executeCall(databaseCall);
                if (result == null) continue;
                return result;
            }
            return null;
        }
        return (AbstractRecord)this.executeCall();
    }

    public AbstractRecord selectRowForDoesExist(DatabaseField field) throws DatabaseException {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatasourceCall databaseCall = (DatasourceCall)callsEnum.nextElement();
                AbstractRecord result = (AbstractRecord)this.executeCall(databaseCall);
                if (result == null) continue;
                return result;
            }
            return null;
        }
        return (AbstractRecord)this.executeCall();
    }

    public void setCall(DatasourceCall call) {
        this.call = call;
        if (call != null) {
            call.setQuery(this.getQuery());
        }
    }

    protected void setCalls(Vector calls) {
        this.calls = calls;
    }

    public Integer updateObject() throws DatabaseException {
        Collection returnFields = null;
        Integer returnedRowCount = null;
        if (this.hasMultipleCalls()) {
            for (int index = 0; index < this.getCalls().size(); ++index) {
                DatasourceCall databseCall = (DatasourceCall)this.getCalls().elementAt(index);
                Integer rowCount = (Integer)this.executeCall(databseCall);
                if (index == 0 || rowCount <= 0) {
                    returnedRowCount = rowCount;
                }
                if (returnFields == null) continue;
                this.updateObjectAndRowWithReturnRow(returnFields, false);
            }
        } else {
            returnedRowCount = (Integer)this.executeCall();
            if (returnFields != null) {
                this.updateObjectAndRowWithReturnRow(returnFields, false);
            }
        }
        AbstractSession executionSession = this.getSession().getExecutionSession(this.getQuery());
        executionSession.getAccessor().flushSelectCalls(executionSession);
        return returnedRowCount;
    }

    public Integer updateAll() throws DatabaseException {
        if (((UpdateAllQuery)this.getQuery()).isPreparedUsingTempStorage() && this.getSession().getPlatform().supportsTempTables()) {
            return this.updateAllUsingTempTables();
        }
        Integer rowCount = this.executeNoSelectCall();
        if (((UpdateAllQuery)this.getQuery()).isPreparedUsingTempStorage()) {
            AbstractRecord outputRow = (AbstractRecord)this.getQuery().getProperty("output");
            rowCount = (Integer)outputRow.get("ROW_COUNT");
        }
        return rowCount;
    }

    public Integer updateAllUsingTempTables() throws DatabaseException {
        DatasourceCall databseCall;
        int index;
        int nTables = this.getCalls().size() / 4;
        DatabaseException ex = null;
        Integer returnedRowCount = null;
        for (index = 0; index < nTables; ++index) {
            try {
                databseCall = (DatasourceCall)this.getCalls().elementAt(index);
                this.executeCall(databseCall);
                continue;
            }
            catch (DatabaseException databaseEx) {
                // empty catch block
            }
        }
        for (index = nTables; index < nTables * 2 && ex == null; ++index) {
            try {
                databseCall = (DatasourceCall)this.getCalls().elementAt(index);
                this.executeCall(databseCall);
                continue;
            }
            catch (DatabaseException databaseEx) {
                ex = databaseEx;
            }
        }
        for (index = nTables * 2; index < nTables * 3 && ex == null; ++index) {
            try {
                databseCall = (DatasourceCall)this.getCalls().elementAt(index);
                Integer rowCount = (Integer)this.executeCall(databseCall);
                if (index != nTables * 2 && rowCount > 0) continue;
                returnedRowCount = rowCount;
                continue;
            }
            catch (DatabaseException databaseEx) {
                ex = databaseEx;
            }
        }
        for (index = nTables * 3; index < nTables * 4; ++index) {
            try {
                databseCall = (DatasourceCall)this.getCalls().elementAt(index);
                this.executeCall(databseCall);
                continue;
            }
            catch (DatabaseException databaseEx) {
                // empty catch block
            }
        }
        if (ex != null) {
            throw ex;
        }
        return returnedRowCount;
    }

    protected void updateForeignKeyFieldShallow(WriteObjectQuery writeQuery) {
        AbstractSession sessionToUse = this.getSession().getExecutionSession(this.getQuery());
        Vector calls = ((DatasourceCallQueryMechanism)this.getDescriptor().getQueryManager().getUpdateQuery().getQueryMechanism()).getCalls();
        Enumeration stream = calls.elements();
        while (stream.hasMoreElements()) {
            DatasourceCall call = (DatasourceCall)((DatasourceCall)stream.nextElement()).clone();
            call.setQuery(writeQuery);
            sessionToUse.executeCall(call, this.getTranslationRow(), writeQuery);
        }
    }
}

