/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cli.commands;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.enterprise.cli.commands.GenericCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class GetHealthCommand
extends GenericCommand {
    private static final String HEARTBEAT_ENABLED = "heartbeat-enabled";
    private static final StringManager _strMgr = StringManager.getManager(GetHealthCommand.class);

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        try {
            MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
            String clusterName = (String)this.getOperands().get(0);
            this.verifyTargetCluster(mbsc, clusterName);
            String objectName = this.getObjectName();
            Object[] params = this.getParamsInfo();
            String operationName = this.getOperationName();
            String[] types = this.getTypesInfo();
            boolean gmsEnabled = true;
            gmsEnabled = this.isGMSEnabled(mbsc, clusterName);
            if (!gmsEnabled) {
                CLILogger.getInstance().printMessage(_strMgr.getString("GMSNotEnabled"));
            }
            Object returnValue = mbsc.invoke(new ObjectName(objectName), operationName, params, types);
            this.displayClusterHealth((Map)returnValue, gmsEnabled);
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
    }

    private boolean isGMSEnabled(MBeanServerConnection mbsc, String clusterName) throws Exception {
        ObjectName objName = new ObjectName("com.sun.appserv:type=cluster,name=" + clusterName + ",category=config");
        String isGmsEnabledObj = (String)mbsc.getAttribute(objName, HEARTBEAT_ENABLED);
        return Boolean.valueOf(isGmsEnabledObj);
    }

    private void displayClusterHealth(Map healthMap, boolean gmsEnabled) throws Exception {
        for (Object instanceName : healthMap.keySet()) {
            List instanceHealth = (List)healthMap.get(instanceName);
            long health = (Long)instanceHealth.get(0);
            if (health < 4L && health > -1L) {
                String timestamp = null;
                if (instanceHealth.size() == 2 && (Long)instanceHealth.get(1) != -1L) {
                    timestamp = new Date((Long)instanceHealth.get(1)).toLocaleString();
                }
                String gmsStr = gmsEnabled ? "GMS" : "";
                CLILogger.getInstance().printMessage(_strMgr.getString(gmsStr + "InstanceHealth-" + health, new Object[]{instanceName, timestamp}));
                continue;
            }
            CLILogger.getInstance().printMessage(_strMgr.getString("InstanceHealthUnKnown", new Object[]{instanceName}));
        }
    }

    private void verifyTargetCluster(MBeanServerConnection mbsc, String clusterName) throws CommandException {
        DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServerConnection)mbsc).getDomainRoot();
        boolean isCluster = false;
        isCluster = domainRoot.getDomainConfig().getClusterConfigMap().keySet().contains(clusterName);
        if (!isCluster) {
            throw new CommandException(_strMgr.getString("TargetNotACluster", new Object[]{clusterName}));
        }
    }
}

