/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cli.commands;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.helper.LBConfigHelper;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.ee.cli.commands.BaseHttpLBCommand;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateHttpLBRefCommand
extends BaseHttpLBCommand {
    private static final String CONFIG_OPTION = "config";
    private static final String LBNAME_OPTION = "lbname";

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        Map<String, String> mOptions = this.getLBRefOptions();
        String target = (String)this.getOperands().get(0);
        String configName = this.getOption(CONFIG_OPTION);
        String lbName = this.getOption(LBNAME_OPTION);
        this.checkConfigAndLBNameOptions(configName, lbName);
        try {
            MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
            DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServerConnection)mbsc).getDomainRoot();
            LBConfigHelper lbconfigHelper = new LBConfigHelper(domainRoot);
            lbconfigHelper.createLBRef(lbName, configName, target, mOptions);
            boolean isCluster = domainRoot.getDomainConfig().getClusterConfigMap().keySet().contains(target);
            if (!isCluster) {
                CLILogger.getInstance().printWarning(_strMgr.getString("WeightCannotApplyToNonCluster", new Object[]{target}));
            } else if (this.getOption("lbweight") != null) {
                lbconfigHelper.configureLBWeight(target, this.getInstanceWeightsMap());
            }
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
    }

    private Map<String, String> getLBRefOptions() {
        HashMap<String, String> mLBOptions = new HashMap<String, String>();
        this.addToOptions(mLBOptions, "healthcheckerurl");
        this.addToOptions(mLBOptions, "healthcheckerinterval");
        this.addToOptions(mLBOptions, "healthcheckertimeout");
        this.addToOptions(mLBOptions, "lbpolicy");
        this.addToOptions(mLBOptions, "lbpolicymodule");
        this.addToOptions(mLBOptions, "lbenableallinstances");
        this.addToOptions(mLBOptions, "lbenableallapplications");
        return mLBOptions;
    }
}

