/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.util;

import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.resource.ResourceBundleManager;
import com.sun.jsftemplating.util.Util;
import com.sun.webui.jsf.model.Option;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiUtil {
    public static final String I18N_RESOURCE_BUNDLE = "__i18n_resource_bundle";
    public static final String RESOURCE_NAME = "com.sun.enterprise.tools.admingui.resources.Strings";

    public static boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }

    public static String getMessage(String key, Object[] args) {
        if (key == null) {
            return null;
        }
        String value = GuiUtil.getMessage(key);
        if (args != null) {
            MessageFormat mf = new MessageFormat(value);
            Object[] mfArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                mfArgs[i] = GuiUtil.getMessage(args[i].toString());
            }
            value = mf.format(mfArgs);
        }
        return value;
    }

    public static void setSessionValue(String key, Object value) {
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        sessionMap.put(key, value);
    }

    public static Object getSessionValue(String key) {
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        return sessionMap.get(key);
    }

    public static String encode(String value, String delim, String type) {
        if (value == null || value.equals("")) {
            return value;
        }
        if (type == null || type.equals("")) {
            type = "UTF-8";
        }
        String encdString = "";
        if (delim != null && delim.length() > 0) {
            StringTokenizer st = new StringTokenizer(value, delim, true);
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (delim.indexOf(s) >= 0) {
                    encdString = encdString.concat(s);
                    continue;
                }
                try {
                    encdString = encdString + URLEncoder.encode(s, type);
                }
                catch (UnsupportedEncodingException uex) {
                    try {
                        encdString = encdString + URLEncoder.encode(s, "UTF-8");
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new IllegalArgumentException(ex);
                    }
                }
            }
        } else {
            try {
                encdString = URLEncoder.encode(value, type);
            }
            catch (UnsupportedEncodingException uex) {
                try {
                    encdString = encdString + URLEncoder.encode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
        }
        return encdString;
    }

    public static String getMessage(String key) {
        try {
            String ret;
            ResourceBundle bundle = (ResourceBundle)FacesContext.getCurrentInstance().getExternalContext().getRequestMap().get(I18N_RESOURCE_BUNDLE);
            if (bundle == null) {
                Locale locale = Util.getLocale((FacesContext)FacesContext.getCurrentInstance());
                bundle = ResourceBundleManager.getInstance().getBundle(RESOURCE_NAME, locale);
                FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put(I18N_RESOURCE_BUNDLE, bundle);
            }
            return (ret = bundle.getString(key)) == null ? key : ret;
        }
        catch (NullPointerException ex) {
            return "";
        }
        catch (Exception ex1) {
            return key;
        }
    }

    public static String getMessage(String resourceName, String key) {
        Locale locale = Util.getLocale((FacesContext)FacesContext.getCurrentInstance());
        ResourceBundle bundle = ResourceBundleManager.getInstance().getBundle(resourceName, locale);
        String ret = bundle.getString(key);
        return ret == null ? key : ret;
    }

    public static Locale getLocale() {
        Locale locale = Util.getLocale((FacesContext)FacesContext.getCurrentInstance());
        return locale;
    }

    public static void prepareSuccessful(HandlerContext handlerCtx) {
        GuiUtil.prepareAlert(handlerCtx, "success", GuiUtil.getMessage("msg.saveSuccessful"), null);
    }

    public static void prepareException(HandlerContext handlerCtx, Throwable ex) {
        Throwable rootException = GuiUtil.getRootCause(ex);
        GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.Error"), rootException.getMessage());
        ex.printStackTrace();
    }

    public static void prepareAlert(HandlerContext handlerCtx, String type, String summary, String detail) {
        Map attrMap = handlerCtx.getFacesContext().getExternalContext().getRequestMap();
        if (GuiUtil.isEmpty(type)) {
            attrMap.put("alertType", "information");
        } else {
            if (!(type.equals("information") || type.equals("success") || type.equals("warning") || type.equals("error"))) {
                throw new RuntimeException("GuiUtil:prepareMessage():  type specified is not a valid type");
            }
            attrMap.put("alertType", type);
        }
        if (detail != null && detail.length() > 500) {
            detail = detail.substring(0, 500) + "...";
        }
        try {
            attrMap.put("alertDetail", GuiUtil.isEmpty(detail) ? "" : URLEncoder.encode(detail, "UTF-8"));
            attrMap.put("alertSummary", GuiUtil.isEmpty(summary) ? "" : URLEncoder.encode(summary, "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
    }

    public static void handleException(HandlerContext handlerCtx, Throwable ex) {
        GuiUtil.prepareException(handlerCtx, ex);
        handlerCtx.getFacesContext().renderResponse();
    }

    public static List<Map> getListOfMaps(Map map) {
        ArrayList list = null;
        if (map != null) {
            list = new ArrayList();
            for (Object key : map.keySet()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                Object value = map.get(key);
                row.put("name", key);
                row.put("value", value != null ? value : "");
                list.add(row);
            }
        }
        return list;
    }

    public static void handleError(HandlerContext handlerCtx, String detail) {
        GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.Error"), detail);
        handlerCtx.getFacesContext().renderResponse();
    }

    public static String notNull(String test) {
        return test == null ? "" : test;
    }

    public static Throwable getRootCause(Throwable ex) {
        return ExceptionUtil.getRootCause((Throwable)ex);
    }

    public static List<String> convertListOfStrings(List l) {
        ArrayList<String> arrList = new ArrayList<String>();
        for (Object o : l) {
            arrList.add(o.toString());
        }
        return arrList;
    }

    public static Option[] getSunOptions(Collection<String> c) {
        Option[] sunOptions = c != null ? new Option[c.size()] : null;
        int index = 0;
        for (String str : c) {
            sunOptions[index++] = new Option((Object)str, str);
        }
        return sunOptions;
    }

    public static List parseStringList(String line, String sep) {
        if (line == null) {
            return null;
        }
        StringTokenizer st = sep == null ? new StringTokenizer(line) : new StringTokenizer(line, sep);
        Vector<String> tokens = new Vector<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.length() <= 0) continue;
            tokens.add(token);
        }
        return tokens;
    }

    public static String[] stringToArray(String str, String delimiter) {
        String[] retString = new String[]{};
        if (str != null) {
            if (delimiter == null) {
                delimiter = " ";
            }
            StringTokenizer tokens = new StringTokenizer(str, delimiter);
            retString = new String[tokens.countTokens()];
            int i = 0;
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                retString[i++] = token;
            }
        }
        return retString;
    }

    public static String arrayToString(String[] str, String delimiter) {
        StringBuffer retStr = new StringBuffer();
        if (str != null) {
            for (int i = 0; i < str.length; ++i) {
                String element = str[i];
                if (element == null || element.length() == 0) {
                    throw new IllegalArgumentException();
                }
                retStr.append(element);
                if (i >= str.length - 1) continue;
                retStr.append(delimiter);
            }
        }
        return retStr.toString();
    }
}

