/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.appserv.management.config.AuthRealmConfig;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.NodeAgentConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.SecurityServiceConfig;
import com.sun.enterprise.tools.admingui.handlers.ConfigurationHandlers;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.tools.admingui.util.JMXUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RealmHandlers {
    private static List skipRealmPropsList = new ArrayList();
    private static List realmClassList;

    public static void getRealms(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        SecurityServiceConfig sConfig = config.getSecurityServiceConfig();
        Map realms = sConfig.getAuthRealmConfigMap();
        String[] aRealm = realms.keySet().toArray(new String[realms.size()]);
        if (aRealm != null) {
            SelectItem[] options = ConfigurationHandlers.getOptions(aRealm);
            handlerCtx.setOutputValue("Realms", (Object)options);
        }
    }

    public static void getRealmAttrMap(HandlerContext handlerCtx) {
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        attrMap.put("fileJaax", "fileRealm");
        attrMap.put("ldapJaax", "ldapRealm");
        attrMap.put("solarisJaax", "solarisRealm");
        attrMap.put("jdbcJaax", "jdbcRealm");
        attrMap.put("classname", "com.sun.enterprise.security.auth.realm.file.FileRealm");
        attrMap.put("predefinedClassname", Boolean.TRUE);
        handlerCtx.setOutputValue("attrMap", attrMap);
        handlerCtx.setOutputValue("classnameOption", (Object)"predefine");
        handlerCtx.setOutputValue("realmClasses", (Object)realmClassList);
        handlerCtx.setOutputValue("properties", new HashMap());
    }

    public static void getRealmAttrForEdit(HandlerContext handlerCtx) {
        AuthRealmConfig realm = RealmHandlers.getAuthRealmConfig(handlerCtx, true);
        if (realm == null) {
            return;
        }
        Map origProps = realm.getProperties();
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        attrMap.put("fileJaax", "fileRealm");
        attrMap.put("ldapJaax", "ldapRealm");
        attrMap.put("solarisJaax", "solarisRealm");
        attrMap.put("jdbcJaax", "jdbcRealm");
        String classname = realm.getClassname();
        if (realmClassList.contains(classname)) {
            handlerCtx.setOutputValue("classnameOption", (Object)"predefine");
            attrMap.put("predefinedClassname", Boolean.TRUE);
            attrMap.put("classname", classname);
            Map props = AMXUtil.getNonSkipPropertiesMap((PropertiesAccess)realm, skipRealmPropsList);
            handlerCtx.setOutputValue("properties", (Object)props);
            if (classname.indexOf("FileRealm") != -1) {
                attrMap.put("file", origProps.get("file"));
                attrMap.put("fileJaax", origProps.get("jaas-context"));
                attrMap.put("fileAsGroups", origProps.get("assign-groups"));
            } else if (classname.indexOf("LDAPRealm") != -1) {
                attrMap.put("ldapJaax", origProps.get("jaas-context"));
                attrMap.put("ldapAsGroups", origProps.get("assign-groups"));
                attrMap.put("directory", origProps.get("directory"));
                attrMap.put("baseDn", origProps.get("base-dn"));
            } else if (classname.indexOf("SolarisRealm") != -1) {
                attrMap.put("solarisJaax", origProps.get("jaas-context"));
                attrMap.put("solarisAsGroups", origProps.get("assign-groups"));
            } else if (classname.indexOf("JDBCRealm") != -1) {
                attrMap.put("jdbcJaax", origProps.get("jaas-context"));
                attrMap.put("jdbcAsGroups", origProps.get("assign-groups"));
                attrMap.put("datasourceJndi", origProps.get("datasource-jndi"));
                attrMap.put("userTable", origProps.get("user-table"));
                attrMap.put("userNameColumn", origProps.get("user-name-column"));
                attrMap.put("passwordColumn", origProps.get("password-column"));
                attrMap.put("groupTable", origProps.get("group-table"));
                attrMap.put("groupNameColumn", origProps.get("group-name-column"));
                attrMap.put("dbUser", origProps.get("db-user"));
                attrMap.put("dbPassword", origProps.get("db-password"));
                attrMap.put("digestAlgorithm", origProps.get("digest-algorithm"));
                attrMap.put("encoding", origProps.get("encoding"));
                attrMap.put("charset", origProps.get("charset"));
            } else if (classname.indexOf("CertificateRealm") != -1) {
                attrMap.put("certAsGroups", origProps.get("assign-groups"));
            }
        } else {
            handlerCtx.setOutputValue("classnameOption", (Object)"input");
            attrMap.put("predefinedClassname", Boolean.FALSE);
            attrMap.put("classnameInput", classname);
            handlerCtx.setOutputValue("properties", (Object)origProps);
        }
        handlerCtx.setOutputValue("attrMap", attrMap);
        handlerCtx.setOutputValue("realmClasses", (Object)realmClassList);
    }

    private static AuthRealmConfig getAuthRealmConfig(HandlerContext handlerCtx, boolean getRealmName) {
        String realmName = (String)handlerCtx.getInputValue("realmName");
        String configName = (String)handlerCtx.getInputValue("configName");
        String nodeAgentName = (String)handlerCtx.getInputValue("nodeAgentName");
        if (!GuiUtil.isEmpty(nodeAgentName)) {
            NodeAgentConfig agentConfig = (NodeAgentConfig)AMXUtil.getDomainConfig().getNodeAgentConfigMap().get(nodeAgentName);
            if (getRealmName) {
                handlerCtx.setOutputValue("outName", (Object)agentConfig.getJMXConnectorConfig().getAuthRealmName());
            }
            return (AuthRealmConfig)agentConfig.getContainee("X-AuthRealmConfig");
        }
        if (GuiUtil.isEmpty(realmName) || GuiUtil.isEmpty(configName)) {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("realm.internalError"));
            return null;
        }
        ConfigConfig config = AMXUtil.getConfig(configName);
        if (getRealmName) {
            handlerCtx.setOutputValue("outName", (Object)realmName);
        }
        return (AuthRealmConfig)config.getSecurityServiceConfig().getAuthRealmConfigMap().get(realmName);
    }

    public static void createRealm(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("configName");
        String option = (String)handlerCtx.getInputValue("classnameOption");
        Map newProps = (Map)handlerCtx.getInputValue("newProps");
        Map attrMap = (Map)handlerCtx.getInputValue("attrMap");
        Map convertedMap = AMXUtil.convertToPropertiesOptionMap(newProps, null);
        String classname = "";
        try {
            if (option.equals("predefine")) {
                classname = (String)attrMap.get("classname");
                if (classname.indexOf("FileRealm") != -1) {
                    RealmHandlers.putOptional(attrMap, convertedMap, "file", "file");
                    RealmHandlers.putOptional(attrMap, convertedMap, "jaas-context", "fileJaax");
                    RealmHandlers.putOptional(attrMap, convertedMap, "assign-groups", "fileAsGroups");
                } else if (classname.indexOf("LDAPRealm") != -1) {
                    RealmHandlers.putOptional(attrMap, convertedMap, "jaas-context", "ldapJaax");
                    RealmHandlers.putOptional(attrMap, convertedMap, "base-dn", "baseDn");
                    RealmHandlers.putOptional(attrMap, convertedMap, "directory", "directory");
                    RealmHandlers.putOptional(attrMap, convertedMap, "assign-groups", "ldapAsGroups");
                } else if (classname.indexOf("SolarisRealm") != -1) {
                    RealmHandlers.putOptional(attrMap, convertedMap, "jaas-context", "solarisJaax");
                    RealmHandlers.putOptional(attrMap, convertedMap, "assign-groups", "solarisAsGroups");
                } else if (classname.indexOf("JDBCRealm") != -1) {
                    RealmHandlers.putOptional(attrMap, convertedMap, "jaas-context", "jdbcJaax");
                    RealmHandlers.putOptional(attrMap, convertedMap, "datasource-jndi", "datasourceJndi");
                    RealmHandlers.putOptional(attrMap, convertedMap, "user-table", "userTable");
                    RealmHandlers.putOptional(attrMap, convertedMap, "user-name-column", "userNameColumn");
                    RealmHandlers.putOptional(attrMap, convertedMap, "password-column", "passwordColumn");
                    RealmHandlers.putOptional(attrMap, convertedMap, "group-table", "groupTable");
                    RealmHandlers.putOptional(attrMap, convertedMap, "group-name-column", "groupNameColumn");
                    RealmHandlers.putOptional(attrMap, convertedMap, "db-user", "dbUser");
                    RealmHandlers.putOptional(attrMap, convertedMap, "db-password", "dbPassword");
                    RealmHandlers.putOptional(attrMap, convertedMap, "digest-algorithm", "digestAlgorithm");
                    RealmHandlers.putOptional(attrMap, convertedMap, "encoding", "encoding");
                    RealmHandlers.putOptional(attrMap, convertedMap, "charset", "charset");
                    RealmHandlers.putOptional(attrMap, convertedMap, "assign-groups", "jdbcAsGroups");
                } else if (classname.indexOf("CertificateRealm") != -1) {
                    RealmHandlers.putOptional(attrMap, convertedMap, "assign-groups", "certAsGroups");
                }
            } else {
                classname = (String)attrMap.get("classnameInput");
            }
            AMXUtil.getConfig(configName).getSecurityServiceConfig().createAuthRealmConfig((String)attrMap.get("name"), classname, convertedMap);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static void putOptional(Map<String, String> attrMap, Map convertedMap, String propName, String key) {
        String val = attrMap.get(key);
        if (!GuiUtil.isEmpty(val)) {
            convertedMap.put("property." + propName, val);
        }
    }

    public static void saveRealm(HandlerContext handlerCtx) {
        AuthRealmConfig realm = RealmHandlers.getAuthRealmConfig(handlerCtx, false);
        if (realm == null) {
            return;
        }
        String option = (String)handlerCtx.getInputValue("classnameOption");
        Map newProps = (Map)handlerCtx.getInputValue("newProps");
        Map attrMap = (Map)handlerCtx.getInputValue("attrMap");
        try {
            if (option.equals("predefine")) {
                String oldClassname;
                String classname = (String)attrMap.get("classname");
                if (!classname.equals(oldClassname = realm.getClassname())) {
                    realm.setClassname(classname);
                }
                AMXUtil.updateProperties((PropertiesAccess)realm, newProps, null);
                if (classname.indexOf("FileRealm") != -1) {
                    AMXUtil.changeProperty((PropertiesAccess)realm, "file", (String)attrMap.get("file"));
                    AMXUtil.changeProperty((PropertiesAccess)realm, "jaas-context", (String)attrMap.get("fileJaax"));
                    AMXUtil.changeProperty((PropertiesAccess)realm, "assign-groups", (String)attrMap.get("fileAsGroups"));
                } else if (classname.indexOf("LDAPRealm") != -1) {
                    AMXUtil.changeProperty((PropertiesAccess)realm, "jaas-context", (String)attrMap.get("ldapJaax"));
                    AMXUtil.changeProperty((PropertiesAccess)realm, "assign-groups", (String)attrMap.get("ldapAsGroups"));
                    AMXUtil.changeProperty((PropertiesAccess)realm, "base-dn", (String)attrMap.get("baseDn"));
                    AMXUtil.changeProperty((PropertiesAccess)realm, "directory", (String)attrMap.get("directory"));
                } else if (classname.indexOf("SolarisRealm") != -1) {
                    AMXUtil.changeProperty((PropertiesAccess)realm, "jaas-context", (String)attrMap.get("solarisJaax"));
                    AMXUtil.changeProperty((PropertiesAccess)realm, "assign-groups", (String)attrMap.get("solarisAsGroups"));
                } else if (classname.indexOf("JDBCRealm") != -1) {
                    AMXUtil.changeProperty((PropertiesAccess)realm, "jaas-context", (String)attrMap.get("jdbcJaax"));
                    AMXUtil.changeProperty((PropertiesAccess)realm, "assign-groups", (String)attrMap.get("jdbcAsGroups"));
                    AMXUtil.changeProperty((PropertiesAccess)realm, "datasource-jndi", (String)attrMap.get("datasourceJndi"));
                    AMXUtil.changeProperty((PropertiesAccess)realm, "user-table", (String)attrMap.get("userTable"));
                    AMXUtil.changeProperty((PropertiesAccess)realm, "user-name-column", (String)attrMap.get("userNameColumn"));
                    AMXUtil.changeProperty((PropertiesAccess)realm, "password-column", (String)attrMap.get("passwordColumn"));
                    AMXUtil.changeProperty((PropertiesAccess)realm, "group-table", (String)attrMap.get("groupTable"));
                    AMXUtil.changeProperty((PropertiesAccess)realm, "group-name-column", (String)attrMap.get("groupNameColumn"));
                    AMXUtil.changeProperty((PropertiesAccess)realm, "db-user", (String)attrMap.get("dbUser"));
                    AMXUtil.changeProperty((PropertiesAccess)realm, "db-password", (String)attrMap.get("dbPassword"));
                    AMXUtil.changeProperty((PropertiesAccess)realm, "digest-algorithm", (String)attrMap.get("digestAlgorithm"));
                    AMXUtil.changeProperty((PropertiesAccess)realm, "encoding", (String)attrMap.get("encoding"));
                    AMXUtil.changeProperty((PropertiesAccess)realm, "charset", (String)attrMap.get("charset"));
                } else if (classname.indexOf("CertificateRealm") != -1) {
                    AMXUtil.changeProperty((PropertiesAccess)realm, "assign-groups", (String)attrMap.get("certAsGroups"));
                }
            } else {
                AMXUtil.updateProperties((PropertiesAccess)realm, newProps, null);
                realm.setClassname((String)attrMap.get("classnameInput"));
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    static {
        String[] classnames = (String[])JMXUtil.invoke("com.sun.appserv:category=config,config=server-config,type=security-service", "getPredefinedAuthRealmClassNames", null, null);
        realmClassList = new ArrayList();
        for (int i = 0; i < classnames.length; ++i) {
            realmClassList.add(classnames[i]);
        }
        skipRealmPropsList.add("jaas-context");
        skipRealmPropsList.add("file");
        skipRealmPropsList.add("assign-groups");
        skipRealmPropsList.add("base-dn");
        skipRealmPropsList.add("directory");
        skipRealmPropsList.add("datasource-jndi");
        skipRealmPropsList.add("user-table");
        skipRealmPropsList.add("user-name-column");
        skipRealmPropsList.add("password-column");
        skipRealmPropsList.add("group-table");
        skipRealmPropsList.add("group-name-column");
        skipRealmPropsList.add("db-user");
        skipRealmPropsList.add("db-password");
        skipRealmPropsList.add("digest-algorithm");
        skipRealmPropsList.add("encoding");
        skipRealmPropsList.add("charset");
    }
}

