/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.appserv.management.config.AccessLogConfig;
import com.sun.appserv.management.config.AuditModuleConfig;
import com.sun.appserv.management.config.AuthRealmConfig;
import com.sun.appserv.management.config.AvailabilityServiceConfig;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.ConfigElement;
import com.sun.appserv.management.config.ConnectionPoolConfig;
import com.sun.appserv.management.config.ConnectorServiceConfig;
import com.sun.appserv.management.config.DiagnosticServiceConfig;
import com.sun.appserv.management.config.EJBContainerAvailabilityConfig;
import com.sun.appserv.management.config.HTTPFileCacheConfig;
import com.sun.appserv.management.config.HTTPListenerConfig;
import com.sun.appserv.management.config.HTTPProtocolConfig;
import com.sun.appserv.management.config.HTTPServiceConfig;
import com.sun.appserv.management.config.IIOPListenerConfig;
import com.sun.appserv.management.config.IIOPServiceConfig;
import com.sun.appserv.management.config.JACCProviderConfig;
import com.sun.appserv.management.config.JMSAvailabilityConfig;
import com.sun.appserv.management.config.JMSHostConfig;
import com.sun.appserv.management.config.JMSServiceConfig;
import com.sun.appserv.management.config.KeepAliveConfig;
import com.sun.appserv.management.config.ManagementRuleConfig;
import com.sun.appserv.management.config.ManagementRulesConfig;
import com.sun.appserv.management.config.MessageSecurityConfig;
import com.sun.appserv.management.config.ModuleMonitoringLevelsConfig;
import com.sun.appserv.management.config.MonitoringServiceConfig;
import com.sun.appserv.management.config.ORBConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.ProviderConfig;
import com.sun.appserv.management.config.RequestPolicyConfig;
import com.sun.appserv.management.config.RequestProcessingConfig;
import com.sun.appserv.management.config.ResponsePolicyConfig;
import com.sun.appserv.management.config.SecurityServiceConfig;
import com.sun.appserv.management.config.ThreadPoolConfig;
import com.sun.appserv.management.config.TransactionServiceConfig;
import com.sun.appserv.management.config.VirtualServerConfig;
import com.sun.appserv.management.config.WebContainerAvailabilityConfig;
import com.sun.enterprise.ee.web.sessmgmt.EEPersistenceTypeResolver;
import com.sun.enterprise.tools.admingui.handlers.ConnectorsHandlers;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.tools.admingui.util.JMXUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.model.Option;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.faces.model.SelectItem;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ConfigurationHandlers {
    private static Class SUN_OPTION_CLASS = null;
    private static Constructor SUN_OPTION_CONSTRUCTOR = null;
    private static final String ATTRIBUTE_NAME = "jvm-options";
    private static final String JVM_OPTION_SECURITY_MANAGER = "-Djava.security.manager";
    private static final String JVM_OPTION_SECURITY_MANAGER_WITH_EQUAL = "-Djava.security.manager=";
    private static String[] providerTypes;
    private static String[] authSource;
    private static String[] authRecipient;
    private static String[] messageLayers;
    private static String[] persistenceFrequency;
    private static String[] persistenceScope;
    private static List vsSkipPropsList;
    private static List httpServiceSkipPropsList;
    private static final String ADMIN_LISTENER = "admin-listener";
    private static final String PROXIED_PROTOCOLS = "proxiedProtocols";
    private static final String PROXIED_PROTOCOLS_VALUE = "http";

    public static void getDiagnosticsSettings(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("configName");
        DiagnosticServiceConfig dgService = AMXUtil.getConfig(configName).getDiagnosticServiceConfig();
        boolean checkSum = dgService.getComputeChecksum();
        boolean verifyConfig = dgService.getVerifyConfig();
        boolean installLog = dgService.getCaptureInstallLog();
        boolean sysInfo = dgService.getCaptureSystemInfo();
        boolean appDeplDesc = dgService.getCaptureAppDD();
        String logLevel = dgService.getMinLogLevel();
        String logEntries = dgService.getMaxLogEntries();
        handlerCtx.setOutputValue("CheckSum", (Object)checkSum);
        handlerCtx.setOutputValue("VerifyConfig", (Object)verifyConfig);
        handlerCtx.setOutputValue("InstallLog", (Object)installLog);
        handlerCtx.setOutputValue("SysInfo", (Object)sysInfo);
        handlerCtx.setOutputValue("AppDeployDesc", (Object)appDeplDesc);
        handlerCtx.setOutputValue("LogLevel", (Object)logLevel);
        handlerCtx.setOutputValue("LogEntries", (Object)logEntries);
    }

    public static void saveDiagnosticsSettings(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("configName");
        try {
            DiagnosticServiceConfig dgService = AMXUtil.getConfig(configName).getDiagnosticServiceConfig();
            dgService.setComputeChecksum(((Boolean)handlerCtx.getInputValue("CheckSum")).booleanValue());
            dgService.setVerifyConfig(((Boolean)handlerCtx.getInputValue("VerifyConfig")).booleanValue());
            dgService.setCaptureInstallLog(((Boolean)handlerCtx.getInputValue("InstallLog")).booleanValue());
            dgService.setCaptureSystemInfo(((Boolean)handlerCtx.getInputValue("SysInfo")).booleanValue());
            dgService.setCaptureAppDD(((Boolean)handlerCtx.getInputValue("AppDeployDesc")).booleanValue());
            dgService.setMinLogLevel((String)handlerCtx.getInputValue("LogLevel"));
            dgService.setMaxLogEntries((String)handlerCtx.getInputValue("LogEntries"));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getConnectorServiceDefaults(HandlerContext handlerCtx) {
        String[] params = new String[]{"connector-service", null};
        String shutdTimeout = (String)ConfigurationHandlers.getDefaultAttributeValue(params);
        if (shutdTimeout != null) {
            handlerCtx.setOutputValue("ShutdownTimeout", (Object)shutdTimeout);
        }
    }

    public static void getConnectorServiceAttributes(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("cName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        ConnectorServiceConfig connService = config.getConnectorServiceConfig();
        if (connService != null) {
            String shutdTimeout = connService.getShutdownTimeoutInSeconds();
            handlerCtx.setOutputValue("ShutdownTimeout", (Object)shutdTimeout);
        }
    }

    public static void saveConnectorServiceAttributes(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("cName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        try {
            ConnectorServiceConfig connService = config.getConnectorServiceConfig();
            if (connService != null) {
                connService.setShutdownTimeoutInSeconds((String)handlerCtx.getInputValue("ShutdownTimeout"));
            } else {
                connService = config.createConnectorServiceConfig();
                connService.setShutdownTimeoutInSeconds((String)handlerCtx.getInputValue("ShutdownTimeout"));
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static Object getDefaultAttributeValue(String[] params) {
        Object defaultValue = null;
        String[] signature = new String[]{"java.lang.String", "[Ljava.lang.String;"};
        AttributeList attrList = (AttributeList)JMXUtil.invoke("com.sun.appserv:type=domain,category=config", "getDefaultAttributeValues", (Object[])params, signature);
        if (attrList != null) {
            for (Attribute attr : attrList) {
                defaultValue = attr.getValue();
            }
        }
        return defaultValue;
    }

    public static void getJaccs(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        SecurityServiceConfig sConfig = config.getSecurityServiceConfig();
        Map jacc = sConfig.getJACCProviderConfigMap();
        String[] jProvider = jacc.keySet().toArray(new String[jacc.size()]);
        SelectItem[] options = ConfigurationHandlers.getOptions(jProvider);
        handlerCtx.setOutputValue("Jacc", (Object)options);
    }

    public static void getJmsHosts(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        JMSServiceConfig jConfig = config.getJMSServiceConfig();
        Map hosts = jConfig.getJMSHostConfigMap();
        String[] jHosts = hosts.keySet().toArray(new String[hosts.size()]);
        SelectItem[] options = ConfigurationHandlers.getOptions(jHosts);
        handlerCtx.setOutputValue("Hosts", (Object)options);
    }

    public static void getAuditModules(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        SecurityServiceConfig sConfig = config.getSecurityServiceConfig();
        Map modules = sConfig.getAuditModuleConfigMap();
        String[] aModules = modules.keySet().toArray(new String[modules.size()]);
        SelectItem[] options = ConfigurationHandlers.getOptions(aModules);
        handlerCtx.setOutputValue("AuditModules", (Object)options);
    }

    public static void getSecurityManager(HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        Boolean status = ConfigurationHandlers.isSecurityManagerEnabled(objectName);
        handlerCtx.setOutputValue("securityManagerEnabled", (Object)status.toString());
    }

    public static void getSecuritySettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        SecurityServiceConfig sConfig = config.getSecurityServiceConfig();
        boolean audit = sConfig.getAuditEnabled();
        String principal = sConfig.getDefaultPrincipal();
        String password = sConfig.getDefaultPrincipalPassword();
        boolean roleMapping = sConfig.getActivateDefaultPrincipalToRoleMapping();
        String mapped = sConfig.getMappedPrincipalClass();
        String realm = sConfig.getDefaultRealm();
        String module = sConfig.getAuditModules();
        String jacc = sConfig.getJACC();
        Map props = sConfig.getProperties();
        handlerCtx.setOutputValue("Audit", (Object)audit);
        handlerCtx.setOutputValue("Principal", (Object)principal);
        handlerCtx.setOutputValue("Password", (Object)password);
        handlerCtx.setOutputValue("RoleMapping", (Object)roleMapping);
        handlerCtx.setOutputValue("Mapped", (Object)mapped);
        handlerCtx.setOutputValue("Realm", (Object)realm);
        handlerCtx.setOutputValue("Module", (Object)module);
        handlerCtx.setOutputValue("Jacc", (Object)jacc);
        handlerCtx.setOutputValue("Properties", (Object)props);
    }

    public static void saveSecuritySettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        SecurityServiceConfig sConfig = config.getSecurityServiceConfig();
        ArrayList removeProps = (ArrayList)handlerCtx.getInputValue("RemoveProps");
        Map addProps = (Map)handlerCtx.getInputValue("AddProps");
        String[] remove = removeProps.toArray(new String[removeProps.size()]);
        for (int i = 0; i < remove.length; ++i) {
            sConfig.removeProperty(remove[i]);
        }
        if (addProps != null) {
            for (Object key : addProps.keySet()) {
                String addvalue = (String)addProps.get(key);
                sConfig.setPropertyValue((String)key, addvalue);
            }
        }
        sConfig.setAuditEnabled(((Boolean)handlerCtx.getInputValue("Audit")).booleanValue());
        sConfig.setDefaultPrincipal((String)handlerCtx.getInputValue("Principal"));
        sConfig.setDefaultPrincipalPassword((String)handlerCtx.getInputValue("Password"));
        sConfig.setActivateDefaultPrincipalToRoleMapping(((Boolean)handlerCtx.getInputValue("RoleMapping")).booleanValue());
        sConfig.setMappedPrincipalClass((String)handlerCtx.getInputValue("Mapped"));
        sConfig.setJACC((String)handlerCtx.getInputValue("Jaccs"));
        sConfig.setAuditModules((String)handlerCtx.getInputValue("Modules"));
        sConfig.setDefaultRealm((String)handlerCtx.getInputValue("Realms"));
    }

    public static void saveSecurityManager(HandlerContext handlerCtx) {
        Boolean userValue;
        String objectName = (String)handlerCtx.getInputValue("ObjectName");
        String value = (String)handlerCtx.getInputValue("SecurityManager");
        Boolean status = ConfigurationHandlers.isSecurityManagerEnabled(objectName);
        if (status.equals(userValue = new Boolean(value))) {
            return;
        }
        ArrayList<String> newOptions = new ArrayList<String>();
        try {
            int i;
            String[] origOptions = (String[])JMXUtil.getAttribute(new ObjectName(objectName), ATTRIBUTE_NAME);
            if (userValue.booleanValue()) {
                for (i = 0; i < origOptions.length; ++i) {
                    newOptions.add(origOptions[i]);
                }
                newOptions.add(JVM_OPTION_SECURITY_MANAGER);
            } else {
                for (i = 0; i < origOptions.length; ++i) {
                    if (origOptions[i].trim().equals(JVM_OPTION_SECURITY_MANAGER) || origOptions[i].trim().startsWith(JVM_OPTION_SECURITY_MANAGER_WITH_EQUAL)) continue;
                    newOptions.add(origOptions[i]);
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        String[] jvmOptions = newOptions.toArray(new String[0]);
        try {
            Attribute attr = new Attribute(ATTRIBUTE_NAME, jvmOptions);
            JMXUtil.setAttribute(objectName, attr);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getSecurityDefaultAttributes(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        SecurityServiceConfig sConfig = config.getSecurityServiceConfig();
        String audit = sConfig.getDefaultValue("AuditEnabled");
        String principal = sConfig.getDefaultValue("DefaultPrincipal");
        String password = sConfig.getDefaultValue("DefaultPrincipalPassword");
        String roleMapping = sConfig.getDefaultValue("ActivateDefaultPrincipalToRoleMapping");
        String mapped = sConfig.getDefaultValue("MappedPrincipalClass");
        String jaccs = sConfig.getDefaultValue("JACC");
        String modules = sConfig.getDefaultValue("AuditModules");
        String realms = sConfig.getDefaultValue("DefaultRealm");
        if (audit.equals("true")) {
            handlerCtx.setOutputValue("Audit", (Object)true);
        } else {
            handlerCtx.setOutputValue("Audit", (Object)false);
        }
        handlerCtx.setOutputValue("Modules", (Object)modules);
        handlerCtx.setOutputValue("Principal", (Object)principal);
        if (roleMapping.equals("true")) {
            handlerCtx.setOutputValue("RoleMapping", (Object)true);
        } else {
            handlerCtx.setOutputValue("RoleMapping", (Object)false);
        }
        handlerCtx.setOutputValue("Password", (Object)password);
        handlerCtx.setOutputValue("Mapped", (Object)mapped);
        handlerCtx.setOutputValue("Jaccs", (Object)jaccs);
        handlerCtx.setOutputValue("Realms", (Object)realms);
    }

    private static Boolean isSecurityManagerEnabled(String objectName) {
        String[] jvmOptions = null;
        try {
            jvmOptions = (String[])JMXUtil.getAttribute(new ObjectName(objectName), ATTRIBUTE_NAME);
            if (jvmOptions != null) {
                for (int i = 0; i < jvmOptions.length; ++i) {
                    if (!jvmOptions[i].trim().equals(JVM_OPTION_SECURITY_MANAGER) && !jvmOptions[i].trim().startsWith(JVM_OPTION_SECURITY_MANAGER_WITH_EQUAL)) continue;
                    return Boolean.TRUE;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Boolean.FALSE;
    }

    public static void getTransactionServiceSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        TransactionServiceConfig tConfig = config.getTransactionServiceConfig();
        boolean onrestart = tConfig.getAutomaticRecovery();
        String timeout = tConfig.getTimeoutInSeconds();
        String retry = tConfig.getRetryTimeoutInSeconds();
        String loglocation = tConfig.getTxLogDir();
        String heuristic = tConfig.getHeuristicDecision();
        String keypoint = tConfig.getKeypointInterval();
        Map props = tConfig.getProperties();
        handlerCtx.setOutputValue("OnRestart", (Object)onrestart);
        handlerCtx.setOutputValue("Timeout", (Object)timeout);
        handlerCtx.setOutputValue("Retry", (Object)retry);
        handlerCtx.setOutputValue("LogLocation", (Object)loglocation);
        handlerCtx.setOutputValue("Heuristic", (Object)heuristic);
        handlerCtx.setOutputValue("KeyPoint", (Object)keypoint);
        handlerCtx.setOutputValue("Properties", (Object)props);
    }

    public static void saveTransactionServiceSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        TransactionServiceConfig tConfig = config.getTransactionServiceConfig();
        ArrayList removeProps = (ArrayList)handlerCtx.getInputValue("RemoveProps");
        Map addProps = (Map)handlerCtx.getInputValue("AddProps");
        String[] remove = removeProps.toArray(new String[removeProps.size()]);
        for (int i = 0; i < remove.length; ++i) {
            tConfig.removeProperty(remove[i]);
        }
        if (addProps != null) {
            for (Object key : addProps.keySet()) {
                String addvalue = (String)addProps.get(key);
                tConfig.setPropertyValue((String)key, addvalue);
            }
        }
        tConfig.setAutomaticRecovery(((Boolean)handlerCtx.getInputValue("OnRestart")).booleanValue());
        tConfig.setTimeoutInSeconds((String)handlerCtx.getInputValue("Timeout"));
        tConfig.setRetryTimeoutInSeconds((String)handlerCtx.getInputValue("Retry"));
        tConfig.setTxLogDir((String)handlerCtx.getInputValue("LogLocation"));
        tConfig.setHeuristicDecision((String)handlerCtx.getInputValue("Heuristic"));
        tConfig.setKeypointInterval((String)handlerCtx.getInputValue("KeyPoint"));
    }

    public static void getTransactionServiceDefaultSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        TransactionServiceConfig tConfig = config.getTransactionServiceConfig();
        String onrestart = tConfig.getDefaultValue("AutomaticRecovery");
        String timeout = tConfig.getDefaultValue("TimeoutInSeconds");
        String retry = tConfig.getDefaultValue("RetryTimeoutInSeconds");
        String loglocation = tConfig.getDefaultValue("TxLogDir");
        String heuristic = tConfig.getDefaultValue("HeuristicDecision");
        String keypoint = tConfig.getDefaultValue("KeypointInterval");
        handlerCtx.setOutputValue("OnRestart", (Object)onrestart);
        handlerCtx.setOutputValue("Timeout", (Object)timeout);
        handlerCtx.setOutputValue("Retry", (Object)retry);
        handlerCtx.setOutputValue("LogLocation", (Object)loglocation);
        handlerCtx.setOutputValue("Heuristic", (Object)heuristic);
        handlerCtx.setOutputValue("KeyPoint", (Object)keypoint);
    }

    public static void getJmsServiceSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        JMSServiceConfig jConfig = config.getJMSServiceConfig();
        String type = jConfig.getType();
        String timeout = jConfig.getInitTimeoutInSeconds();
        String arguments = jConfig.getStartArgs();
        boolean reconnect = jConfig.getReconnectEnabled();
        String interval = jConfig.getReconnectIntervalInSeconds();
        String attempts = jConfig.getReconnectAttempts();
        String host = jConfig.getDefaultJMSHost();
        String behavior = jConfig.getAddressListBehavior();
        String iterations = jConfig.getAddressListIterations();
        String scheme = jConfig.getMQScheme();
        String service = jConfig.getMQService();
        Map props = jConfig.getProperties();
        handlerCtx.setOutputValue("Type", (Object)type);
        handlerCtx.setOutputValue("Timeout", (Object)timeout);
        handlerCtx.setOutputValue("Arguments", (Object)arguments);
        handlerCtx.setOutputValue("Reconnect", (Object)reconnect);
        handlerCtx.setOutputValue("Interval", (Object)interval);
        handlerCtx.setOutputValue("Attempts", (Object)attempts);
        handlerCtx.setOutputValue("Host", (Object)host);
        handlerCtx.setOutputValue("Behavior", (Object)behavior);
        handlerCtx.setOutputValue("Iterations", (Object)iterations);
        handlerCtx.setOutputValue("Scheme", (Object)scheme);
        handlerCtx.setOutputValue("Service", (Object)service);
        handlerCtx.setOutputValue("Properties", (Object)props);
    }

    public static void getJmsServiceDefaultSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        JMSServiceConfig jConfig = config.getJMSServiceConfig();
        String type = jConfig.getDefaultValue("Type");
        String timeout = jConfig.getDefaultValue("InitTimeoutInSeconds");
        String arguments = jConfig.getDefaultValue("StartArgs");
        String reconnect = jConfig.getDefaultValue("ReconnectEnabled");
        String interval = jConfig.getDefaultValue("ReconnectIntervalInSeconds");
        String attempts = jConfig.getDefaultValue("ReconnectAttempts");
        String host = jConfig.getDefaultValue("DefaultJMSHost");
        String behavior = jConfig.getDefaultValue("AddressListBehavior");
        String iterations = jConfig.getDefaultValue("AddressListIterations");
        String scheme = jConfig.getDefaultValue("MQScheme");
        String service = jConfig.getDefaultValue("MQService");
        handlerCtx.setOutputValue("Type", (Object)type);
        handlerCtx.setOutputValue("Timeout", (Object)timeout);
        handlerCtx.setOutputValue("Arguments", (Object)arguments);
        handlerCtx.setOutputValue("Reconnect", (Object)reconnect);
        handlerCtx.setOutputValue("Interval", (Object)interval);
        handlerCtx.setOutputValue("Attempts", (Object)attempts);
        handlerCtx.setOutputValue("Host", (Object)host);
        handlerCtx.setOutputValue("Behavior", (Object)behavior);
        handlerCtx.setOutputValue("Iterations", (Object)iterations);
        handlerCtx.setOutputValue("Scheme", (Object)scheme);
        handlerCtx.setOutputValue("Service", (Object)service);
    }

    public static void saveJmsServiceSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        JMSServiceConfig jConfig = config.getJMSServiceConfig();
        ArrayList removeProps = (ArrayList)handlerCtx.getInputValue("RemoveProps");
        Map addProps = (Map)handlerCtx.getInputValue("AddProps");
        String[] remove = removeProps.toArray(new String[removeProps.size()]);
        for (int i = 0; i < remove.length; ++i) {
            jConfig.removeProperty(remove[i]);
        }
        if (addProps != null) {
            for (Object key : addProps.keySet()) {
                String addvalue = (String)addProps.get(key);
                jConfig.setPropertyValue((String)key, addvalue);
            }
        }
        jConfig.setType((String)handlerCtx.getInputValue("Type"));
        jConfig.setInitTimeoutInSeconds((String)handlerCtx.getInputValue("Timeout"));
        jConfig.setStartArgs((String)handlerCtx.getInputValue("Arguments"));
        jConfig.setReconnectEnabled(((Boolean)handlerCtx.getInputValue("Reconnect")).booleanValue());
        jConfig.setReconnectIntervalInSeconds((String)handlerCtx.getInputValue("Interval"));
        jConfig.setReconnectAttempts((String)handlerCtx.getInputValue("Attempts"));
        jConfig.setDefaultJMSHost((String)handlerCtx.getInputValue("Host"));
        jConfig.setAddressListBehavior((String)handlerCtx.getInputValue("Behavior"));
        jConfig.setAddressListIterations((String)handlerCtx.getInputValue("Iterations"));
        jConfig.setMQScheme((String)handlerCtx.getInputValue("Scheme"));
        jConfig.setMQService((String)handlerCtx.getInputValue("Service"));
    }

    public static void pingJMS(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("configName");
        Object[] params = new String[]{null};
        String[] signatures = new String[]{"java.lang.String"};
        try {
            Object result = JMXUtil.invoke("com.sun.appserv:type=resources,category=config", "JMSPing", params, signatures);
            if (result != null) {
                GuiUtil.prepareAlert(handlerCtx, "success", GuiUtil.getMessage("msg.JmsPingSucceed"), null);
            } else {
                GuiUtil.prepareAlert(handlerCtx, "error", GuiUtil.getMessage("msg.Error"), "msg.PingError");
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getMonitoringServiceSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        MonitoringServiceConfig mSConfig = config.getMonitoringServiceConfig();
        ModuleMonitoringLevelsConfig mConfig = mSConfig.getModuleMonitoringLevelsConfig();
        String jvm = mConfig.getJVM();
        String http = mConfig.getHTTPService();
        String transaction = mConfig.getTransactionService();
        String jms = mConfig.getJMSService();
        String orb = mConfig.getORB();
        String web = mConfig.getWebContainer();
        String ejb = mConfig.getEJBContainer();
        String jdbc = mConfig.getJDBCConnectionPool();
        String threadPool = mConfig.getThreadPool();
        Map props = mConfig.getProperties();
        handlerCtx.setOutputValue("Jvm", (Object)jvm);
        handlerCtx.setOutputValue("Http", (Object)http);
        handlerCtx.setOutputValue("Transaction", (Object)transaction);
        handlerCtx.setOutputValue("JmsConnector", (Object)jms);
        handlerCtx.setOutputValue("Orb", (Object)orb);
        handlerCtx.setOutputValue("Web", (Object)web);
        handlerCtx.setOutputValue("Ejb", (Object)ejb);
        handlerCtx.setOutputValue("Jdbc", (Object)jdbc);
        handlerCtx.setOutputValue("ThreadPool", (Object)threadPool);
        handlerCtx.setOutputValue("Properties", (Object)props);
    }

    public static void getMonitoringServiceDefaultSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        MonitoringServiceConfig mSConfig = config.getMonitoringServiceConfig();
        ModuleMonitoringLevelsConfig mConfig = mSConfig.getModuleMonitoringLevelsConfig();
        String jvm = mConfig.getDefaultValue("JVM");
        String http = mConfig.getDefaultValue("HTTPService");
        String transaction = mConfig.getDefaultValue("TransactionService");
        String jms = mConfig.getDefaultValue("JMSService");
        String orb = mConfig.getDefaultValue("ORB");
        String web = mConfig.getDefaultValue("WebContainer");
        String ejb = mConfig.getDefaultValue("EJBContainer");
        String jdbc = mConfig.getDefaultValue("JDBCConnectionPool");
        String threadPool = mConfig.getDefaultValue("ThreadPool");
        handlerCtx.setOutputValue("Jvm", (Object)jvm);
        handlerCtx.setOutputValue("Http", (Object)http);
        handlerCtx.setOutputValue("Transaction", (Object)transaction);
        handlerCtx.setOutputValue("JmsConnector", (Object)jms);
        handlerCtx.setOutputValue("Orb", (Object)orb);
        handlerCtx.setOutputValue("Web", (Object)web);
        handlerCtx.setOutputValue("Ejb", (Object)ejb);
        handlerCtx.setOutputValue("Jdbc", (Object)jdbc);
        handlerCtx.setOutputValue("ThreadPool", (Object)threadPool);
    }

    public static void saveMonitoringServiceSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        Map newProps = (Map)handlerCtx.getInputValue("newProps");
        MonitoringServiceConfig mSConfig = config.getMonitoringServiceConfig();
        ModuleMonitoringLevelsConfig mConfig = mSConfig.getModuleMonitoringLevelsConfig();
        AMXUtil.updateProperties((PropertiesAccess)mConfig, newProps, null);
        mConfig.setJVM((String)handlerCtx.getInputValue("Jvm"));
        mConfig.setHTTPService((String)handlerCtx.getInputValue("Http"));
        mConfig.setTransactionService((String)handlerCtx.getInputValue("Transaction"));
        mConfig.setJMSService((String)handlerCtx.getInputValue("JmsConnector"));
        mConfig.setORB((String)handlerCtx.getInputValue("Orb"));
        mConfig.setWebContainer((String)handlerCtx.getInputValue("Web"));
        mConfig.setEJBContainer((String)handlerCtx.getInputValue("Ejb"));
        mConfig.setJDBCConnectionPool((String)handlerCtx.getInputValue("Jdbc"));
        mConfig.setThreadPool((String)handlerCtx.getInputValue("ThreadPool"));
    }

    public static void getVirtualServerSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            if (!edit.booleanValue()) {
                ConfigurationHandlers.getDefaultVirtualServerAttributes(handlerCtx);
                return;
            }
            Map vservers = config.getHTTPServiceConfig().getVirtualServerConfigMap();
            VirtualServerConfig vs = (VirtualServerConfig)vservers.get((String)handlerCtx.getInputValue("Name"));
            handlerCtx.setOutputValue("Hosts", (Object)vs.getHosts());
            handlerCtx.setOutputValue("StateOption", (Object)vs.getState());
            handlerCtx.setOutputValue("Http", (Object)vs.getHTTPListeners());
            handlerCtx.setOutputValue("Web", (Object)vs.getDefaultWebModule());
            handlerCtx.setOutputValue("LogFile", (Object)vs.getLogFile());
            handlerCtx.setOutputValue("Properties", (Object)AMXUtil.getNonSkipPropertiesMap((PropertiesAccess)vs, vsSkipPropsList));
            Map origProps = vs.getProperties();
            handlerCtx.setOutputValue("accessLogBufferSize", origProps.get("accessLogBufferSize"));
            handlerCtx.setOutputValue("accessLogWriteInterval", origProps.get("accessLogWriteInterval"));
            handlerCtx.setOutputValue("accesslog", origProps.get("accesslog"));
            handlerCtx.setOutputValue("docroot", origProps.get("docroot"));
            String sso = (String)origProps.get("sso-enabled");
            Boolean ssoFlag = false;
            ssoFlag = GuiUtil.isEmpty(sso) ? Boolean.valueOf(false) : Boolean.valueOf(sso.equals("true"));
            handlerCtx.setOutputValue("sso", (Object)ssoFlag);
            String accessLoggingFlag = (String)origProps.get("accessLoggingEnabled");
            if (GuiUtil.isEmpty(accessLoggingFlag)) {
                handlerCtx.setOutputValue("accessLoggingFlag", (Object)"off");
            } else if ("true".equals(accessLoggingFlag)) {
                handlerCtx.setOutputValue("accessLoggingFlag", (Object)"true");
            } else {
                handlerCtx.setOutputValue("accessLoggingFlag", (Object)"false");
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static void getDefaultVirtualServerAttributes(HandlerContext handlerCtx) {
        Map defaultMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-VirtualServerConfig");
        handlerCtx.setOutputValue("Hosts", defaultMap.get("hosts"));
        handlerCtx.setOutputValue("StateOption", defaultMap.get("state"));
        handlerCtx.setOutputValue("Http", defaultMap.get("http-listeners"));
        handlerCtx.setOutputValue("Web", defaultMap.get("default-web-module"));
        handlerCtx.setOutputValue("LogFile", defaultMap.get("log-file"));
        handlerCtx.setOutputValue("docroot", (Object)"${com.sun.aas.instanceRoot}/docroot");
        Map dMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-HTTPAccessLogConfig");
        handlerCtx.setOutputValue("accesslog", dMap.get("log-directory"));
        handlerCtx.setOutputValue("sso", (Object)Boolean.FALSE);
        handlerCtx.setOutputValue("accessLoggingFlag", (Object)"off");
        handlerCtx.setOutputValue("Properties", new HashMap());
    }

    public static void getAllWebModules(HandlerContext handlerCtx) {
        Map webs = AMXUtil.getDomainConfig().getWebModuleConfigMap();
        ArrayList<String> result = new ArrayList<String>();
        result.add("");
        for (String nm : webs.keySet()) {
            result.add(nm);
        }
        Map ears = AMXUtil.getDomainConfig().getJ2EEApplicationConfigMap();
        try {
            for (String appName : ears.keySet()) {
                String[] modules = (String[])JMXUtil.invoke("com.sun.appserv:type=applications,category=config", "getModuleComponents", new Object[]{appName}, new String[]{"java.lang.String"});
                for (int j = 0; j < modules.length; ++j) {
                    ObjectName moduleName = new ObjectName(modules[j]);
                    String type = moduleName.getKeyProperty("j2eeType");
                    if (type == null || !type.equalsIgnoreCase("WebModule")) continue;
                    String name = moduleName.getKeyProperty("name");
                    String entry = appName + "#" + name;
                    result.add(entry);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        handlerCtx.setOutputValue("modules", result);
    }

    public static void getClassnames(HandlerContext handlerCtx) {
        String[] classnames = (String[])JMXUtil.invoke("com.sun.appserv:category=config,config=server-config,type=security-service", "getPredefinedAuthRealmClassNames", null, null);
        SelectItem[] options = ConfigurationHandlers.getOptions(classnames);
        handlerCtx.setOutputValue("Classnames", (Object)options);
    }

    public static void saveVirtualServerSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        Map newProps = (Map)handlerCtx.getInputValue("newProps");
        try {
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            if (!edit.booleanValue()) {
                Map convertedMap = AMXUtil.convertToPropertiesOptionMap(newProps, null);
                ConfigurationHandlers.putOptionalValue((String)handlerCtx.getInputValue("accesslog"), convertedMap, "accesslog");
                ConfigurationHandlers.putOptionalValue((String)handlerCtx.getInputValue("docroot"), convertedMap, "docroot");
                ConfigurationHandlers.putOptionalValue((String)handlerCtx.getInputValue("accessLogBufferSize"), convertedMap, "accessLogBufferSize");
                ConfigurationHandlers.putOptionalValue((String)handlerCtx.getInputValue("accessLogWriteInterval"), convertedMap, "accessLogWriteInterval");
                ConfigurationHandlers.putOptionalValue("" + handlerCtx.getInputValue("sso"), convertedMap, "sso-enabled");
                String accessLoggingFlag = (String)handlerCtx.getInputValue("accessLoggingFlag");
                if (!accessLoggingFlag.equals("off")) {
                    ConfigurationHandlers.putOptionalValue(accessLoggingFlag, convertedMap, "accessLoggingEnabled");
                }
                VirtualServerConfig server = config.getHTTPServiceConfig().createVirtualServerConfig((String)handlerCtx.getInputValue("Name"), (String)handlerCtx.getInputValue("Hosts"), convertedMap);
                server.setHosts((String)handlerCtx.getInputValue("Hosts"));
                server.setHTTPListeners((String)handlerCtx.getInputValue("Http"));
                server.setDefaultWebModule((String)handlerCtx.getInputValue("Web"));
                server.setLogFile((String)handlerCtx.getInputValue("LogFile"));
                String tmp = (String)handlerCtx.getInputValue("StateOption");
                server.setState(tmp);
                return;
            }
            Map vservers = config.getHTTPServiceConfig().getVirtualServerConfigMap();
            VirtualServerConfig vs = (VirtualServerConfig)vservers.get((String)handlerCtx.getInputValue("Name"));
            AMXUtil.updateProperties((PropertiesAccess)vs, newProps, vsSkipPropsList);
            vs.setHosts((String)handlerCtx.getInputValue("Hosts"));
            vs.setState((String)handlerCtx.getInputValue("StateOption"));
            vs.setHTTPListeners((String)handlerCtx.getInputValue("Http"));
            vs.setDefaultWebModule((String)handlerCtx.getInputValue("Web"));
            vs.setLogFile((String)handlerCtx.getInputValue("LogFile"));
            AMXUtil.changeProperty((PropertiesAccess)vs, "accesslog", (String)handlerCtx.getInputValue("accesslog"));
            AMXUtil.changeProperty((PropertiesAccess)vs, "accessLogBufferSize", (String)handlerCtx.getInputValue("accessLogBufferSize"));
            AMXUtil.changeProperty((PropertiesAccess)vs, "accessLogWriteInterval", (String)handlerCtx.getInputValue("accessLogWriteInterval"));
            AMXUtil.changeProperty((PropertiesAccess)vs, "docroot", (String)handlerCtx.getInputValue("docroot"));
            AMXUtil.changeProperty((PropertiesAccess)vs, "sso-enabled", "" + handlerCtx.getInputValue("sso"));
            String accessLoggingFlag = (String)handlerCtx.getInputValue("accessLoggingFlag");
            if (accessLoggingFlag.equals("off")) {
                accessLoggingFlag = null;
            }
            AMXUtil.changeProperty((PropertiesAccess)vs, "accessLoggingEnabled", accessLoggingFlag);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static void putOptionalValue(String value, Map convertedMap, String propName) {
        if (GuiUtil.isEmpty(value)) {
            return;
        }
        convertedMap.put("property." + propName, value);
    }

    public static void getJaccProviderSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            if (!edit.booleanValue()) {
                ConfigurationHandlers.getDefaultJaccProviderAttributes(handlerCtx);
                return;
            }
            Map jaccProviders = config.getSecurityServiceConfig().getJACCProviderConfigMap();
            JACCProviderConfig jacc = (JACCProviderConfig)jaccProviders.get((String)handlerCtx.getInputValue("Name"));
            Map props = jacc.getProperties();
            String jconfig = jacc.getPolicyConfigurationFactoryProvider();
            String policy = jacc.getPolicyProvider();
            handlerCtx.setOutputValue("PolicyConfig", (Object)jconfig);
            handlerCtx.setOutputValue("PolicyProvider", (Object)policy);
            handlerCtx.setOutputValue("Properties", (Object)props);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static void getDefaultJaccProviderAttributes(HandlerContext handlerCtx) {
        Map defaultMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-JACCProviderConfig");
        handlerCtx.setOutputValue("PolicyConfig", defaultMap.get("policy-configuration-factory-provider"));
        handlerCtx.setOutputValue("PolicyProvider", defaultMap.get("policy-provider"));
    }

    public static void saveJaccProviderSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            if (!edit.booleanValue()) {
                Map optionalMap = AMXUtil.convertToPropertiesOptionMap((Map)handlerCtx.getInputValue("AddProps"), null);
                config.getSecurityServiceConfig().createJACCProviderConfig((String)handlerCtx.getInputValue("Name"), (String)handlerCtx.getInputValue("PolicyProvider"), (String)handlerCtx.getInputValue("PolicyConfig"), optionalMap);
                return;
            }
            Map jaccProviders = config.getSecurityServiceConfig().getJACCProviderConfigMap();
            JACCProviderConfig jacc = (JACCProviderConfig)jaccProviders.get((String)handlerCtx.getInputValue("Name"));
            ArrayList removeProps = (ArrayList)handlerCtx.getInputValue("RemoveProps");
            Map addProps = (Map)handlerCtx.getInputValue("AddProps");
            String[] remove = removeProps.toArray(new String[removeProps.size()]);
            for (int i = 0; i < remove.length; ++i) {
                jacc.removeProperty(remove[i]);
            }
            if (addProps != null) {
                for (Object key : addProps.keySet()) {
                    String addvalue = (String)addProps.get(key);
                    jacc.setPropertyValue((String)key, addvalue);
                }
            }
            jacc.setPolicyConfigurationFactoryProvider((String)handlerCtx.getInputValue("PolicyConfig"));
            jacc.setPolicyProvider((String)handlerCtx.getInputValue("PolicyProvider"));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getAuditModuleSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            if (!edit.booleanValue()) {
                ConfigurationHandlers.getDefaultAuditModuleAttributes(handlerCtx);
                return;
            }
            Map auditModules = config.getSecurityServiceConfig().getAuditModuleConfigMap();
            AuditModuleConfig module = (AuditModuleConfig)auditModules.get((String)handlerCtx.getInputValue("Name"));
            Map props = module.getProperties();
            String classname = module.getClassname();
            handlerCtx.setOutputValue("Classname", (Object)classname);
            handlerCtx.setOutputValue("Properties", (Object)props);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static void getDefaultAuditModuleAttributes(HandlerContext handlerCtx) {
        Map defaultMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-AuditModuleConfig");
        handlerCtx.setOutputValue("Classname", defaultMap.get("classname"));
    }

    public static void saveAuditModuleSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            if (!edit.booleanValue()) {
                Map optionalMap = AMXUtil.convertToPropertiesOptionMap((Map)handlerCtx.getInputValue("AddProps"), null);
                config.getSecurityServiceConfig().createAuditModuleConfig((String)handlerCtx.getInputValue("Name"), (String)handlerCtx.getInputValue("Classname"), true, optionalMap);
                return;
            }
            Map modules = config.getSecurityServiceConfig().getAuditModuleConfigMap();
            AuditModuleConfig module = (AuditModuleConfig)modules.get((String)handlerCtx.getInputValue("Name"));
            ArrayList removeProps = (ArrayList)handlerCtx.getInputValue("RemoveProps");
            Map addProps = (Map)handlerCtx.getInputValue("AddProps");
            String[] remove = removeProps.toArray(new String[removeProps.size()]);
            for (int i = 0; i < remove.length; ++i) {
                module.removeProperty(remove[i]);
            }
            if (addProps != null) {
                for (Object key : addProps.keySet()) {
                    String addvalue = (String)addProps.get(key);
                    module.setPropertyValue((String)key, addvalue);
                }
            }
            module.setClassname((String)handlerCtx.getInputValue("Classname"));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getRealmSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            if (!edit.booleanValue()) {
                ConfigurationHandlers.getDefaultRealmAttributes(handlerCtx);
                return;
            }
            Map realms = config.getSecurityServiceConfig().getAuthRealmConfigMap();
            AuthRealmConfig realm = (AuthRealmConfig)realms.get((String)handlerCtx.getInputValue("Name"));
            Map props = realm.getProperties();
            String classname = realm.getClassname();
            String[] classnames = (String[])JMXUtil.invoke("com.sun.appserv:category=config,config=server-config,type=security-service", "getPredefinedAuthRealmClassNames", null, null);
            ArrayList<String> cn = new ArrayList<String>();
            for (int i = 0; i < classnames.length; ++i) {
                cn.add(classnames[i]);
            }
            if (cn.contains(classname)) {
                handlerCtx.setOutputValue("Classname", (Object)classname);
                handlerCtx.setOutputValue("ClassnameOption", (Object)"predefine");
                handlerCtx.setOutputValue("predefinedClassname", (Object)true);
            } else {
                handlerCtx.setOutputValue("ClassnameInput", (Object)classname);
                handlerCtx.setOutputValue("ClassnameOption", (Object)"input");
                handlerCtx.setOutputValue("predefinedClassname", (Object)false);
            }
            handlerCtx.setOutputValue("Properties", (Object)props);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static void getDefaultRealmAttributes(HandlerContext handlerCtx) {
        Map defaultMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-AuthRealmConfig");
        handlerCtx.setOutputValue("Classname", defaultMap.get("classname"));
        handlerCtx.setOutputValue("ClassnameOption", (Object)"predefine");
        handlerCtx.setOutputValue("predefinedClassname", (Object)true);
    }

    public static void saveRealmSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        String option = (String)handlerCtx.getInputValue("ClassnameOption");
        String classname = null;
        classname = option.equals("predefine") ? (String)handlerCtx.getInputValue("Classname") : (String)handlerCtx.getInputValue("ClassnameInput");
        try {
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            if (!edit.booleanValue()) {
                Map optionalMap = AMXUtil.convertToPropertiesOptionMap((Map)handlerCtx.getInputValue("AddProps"), null);
                config.getSecurityServiceConfig().createAuthRealmConfig((String)handlerCtx.getInputValue("Name"), classname, optionalMap);
                return;
            }
            Map realms = config.getSecurityServiceConfig().getAuthRealmConfigMap();
            AuthRealmConfig realm = (AuthRealmConfig)realms.get((String)handlerCtx.getInputValue("Name"));
            ArrayList removeProps = (ArrayList)handlerCtx.getInputValue("RemoveProps");
            Map addProps = (Map)handlerCtx.getInputValue("AddProps");
            String[] remove = removeProps.toArray(new String[removeProps.size()]);
            for (int i = 0; i < remove.length; ++i) {
                realm.removeProperty(remove[i]);
            }
            if (addProps != null) {
                for (Object key : addProps.keySet()) {
                    String addvalue = (String)addProps.get(key);
                    realm.setPropertyValue((String)key, addvalue);
                }
            }
            realm.setClassname(classname);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getJmsDestinationSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            if (!edit.booleanValue()) {
                ConfigurationHandlers.getJmsDestinationDefaults(handlerCtx);
                return;
            }
            String type = (String)JMXUtil.getAttribute(new ObjectName("com.sun.appserv:type=admin-object-resource,category=config,jndi-name=" + (String)handlerCtx.getInputValue("Name")), "res-type");
            handlerCtx.setOutputValue("Type", (Object)type);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getJmsDestinationDefaults(HandlerContext handlerCtx) {
        String[] params = new String[]{"res-type", null};
        String type = (String)ConfigurationHandlers.getDefaultAttributeValue(params);
        if (type != null) {
            handlerCtx.setOutputValue("Type", (Object)type);
        }
    }

    public static void savePhysicalDestinations(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            AttributeList list = new AttributeList();
            list.add(new Attribute("destName", (String)handlerCtx.getInputValue("Name")));
            list.add(new Attribute("destType", (String)handlerCtx.getInputValue("Type")));
            Properties props = new Properties();
            Map addProps = (Map)handlerCtx.getInputValue("AddProps");
            if (addProps != null) {
                for (Object key : addProps.keySet()) {
                    String addvalue = (String)addProps.get(key);
                    props.put(key, addvalue);
                }
            }
            String[] types = new String[]{"javax.management.AttributeList", "java.util.Properties", "java.lang.String"};
            Object[] params = new Object[]{list, props, null};
            Object obj = JMXUtil.invoke("com.sun.appserv:type=resources,category=config", "createPhysicalDestination", params, types);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getThreadPools(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        Map threadPools = config.getThreadPoolConfigMap();
        String[] poolIds = threadPools.keySet().toArray(new String[threadPools.size()]);
        SelectItem[] options = ConfigurationHandlers.getModOptions(poolIds);
        handlerCtx.setOutputValue("ThreadPools", (Object)options);
    }

    public static void getThreadPoolsList(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        Iterator iter = config.getThreadPoolConfigMap().values().iterator();
        List selectedList = (List)handlerCtx.getInputValue("selectedRows");
        boolean hasOrig = selectedList != null && selectedList.size() != 0;
        ArrayList result = new ArrayList();
        if (iter != null) {
            while (iter.hasNext()) {
                ThreadPoolConfig threadConfig = (ThreadPoolConfig)iter.next();
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                String name = threadConfig.getThreadPoolId();
                oneRow.put("name", name);
                oneRow.put("selected", hasOrig ? ConnectorsHandlers.isSelected(name, selectedList) : false);
                String maxSize = threadConfig.getMaxThreadPoolSize();
                String minSize = threadConfig.getMinThreadPoolSize();
                oneRow.put("maxSize", maxSize == null ? " " : maxSize);
                oneRow.put("minSize", minSize == null ? " " : minSize);
                result.add(oneRow);
            }
        }
        handlerCtx.setOutputValue("Result", result);
    }

    public static void deleteThreadPools(HandlerContext handlerCtx) {
        List obj;
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                String name = (String)oneRow.get("name");
                config.removeThreadPoolConfig(name);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getOrbValues(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        IIOPServiceConfig iiopConfig = config.getIIOPServiceConfig();
        ORBConfig orbConfig = iiopConfig.getORBConfig();
        String threadPoolId = orbConfig.getUseThreadPoolIds();
        String maxMsgSize = orbConfig.getMessageFragmentSize();
        String totalConns = orbConfig.getMaxConnections();
        boolean iiopClient = iiopConfig.getClientAuthenticationRequired();
        Map props = orbConfig.getProperties();
        handlerCtx.setOutputValue("ThreadPools", (Object)threadPoolId);
        handlerCtx.setOutputValue("MaxMsgSize", (Object)maxMsgSize);
        handlerCtx.setOutputValue("TotalConns", (Object)totalConns);
        handlerCtx.setOutputValue("IIOPClient", (Object)iiopClient);
        handlerCtx.setOutputValue("Properties", (Object)props);
    }

    public static void getDefaultOrbValues(HandlerContext handlerCtx) {
        Map orbAttrMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-ORBConfig");
        Map iiopAttrMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-IIOPServiceConfig");
        handlerCtx.setOutputValue("ThreadPools", orbAttrMap.get("use-thread-pool-ids"));
        handlerCtx.setOutputValue("MaxMsgSize", orbAttrMap.get("message-fragment-size"));
        handlerCtx.setOutputValue("TotalConns", orbAttrMap.get("max-connections"));
        handlerCtx.setOutputValue("IIOPClient", (Object)Boolean.valueOf((String)iiopAttrMap.get("client-authentication-required")));
    }

    public static void saveOrbValues(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        try {
            IIOPServiceConfig iiopConfig = config.getIIOPServiceConfig();
            ORBConfig orbConfig = iiopConfig.getORBConfig();
            orbConfig.setUseThreadPoolIds((String)handlerCtx.getInputValue("ThreadPools"));
            orbConfig.setMessageFragmentSize((String)handlerCtx.getInputValue("MaxMsgSize"));
            orbConfig.setMaxConnections((String)handlerCtx.getInputValue("TotalConns"));
            iiopConfig.setClientAuthenticationRequired(((Boolean)handlerCtx.getInputValue("IIOPClient")).booleanValue());
            AMXUtil.editProperties(handlerCtx, (PropertiesAccess)orbConfig);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getThreadPoolValues(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
        if (!edit.booleanValue()) {
            ConfigurationHandlers.getDefaultThreadPoolValues(handlerCtx);
            return;
        }
        String threadPoolId = (String)handlerCtx.getInputValue("ThreadPoolId");
        Map threadPoolsMap = config.getThreadPoolConfigMap();
        ThreadPoolConfig threadConfig = (ThreadPoolConfig)threadPoolsMap.get(threadPoolId);
        String minPoolSize = threadConfig.getMinThreadPoolSize();
        String maxPoolSize = threadConfig.getMaxThreadPoolSize();
        String idleTimeout = threadConfig.getIdleThreadTimeoutInSeconds();
        String noWorkQ = threadConfig.getNumWorkQueues();
        handlerCtx.setOutputValue("MinPoolSize", (Object)minPoolSize);
        handlerCtx.setOutputValue("MaxPoolSize", (Object)maxPoolSize);
        handlerCtx.setOutputValue("IdleTimeout", (Object)idleTimeout);
        handlerCtx.setOutputValue("NoWorkQ", (Object)noWorkQ);
    }

    public static void getDefaultThreadPoolValues(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        Map poolsAttrMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-ThreadPoolConfig");
        handlerCtx.setOutputValue("MinPoolSize", poolsAttrMap.get("min-thread-pool-size"));
        handlerCtx.setOutputValue("MaxPoolSize", poolsAttrMap.get("max-thread-pool-size"));
        handlerCtx.setOutputValue("IdleTimeout", poolsAttrMap.get("idle-thread-timeout-in-seconds"));
        handlerCtx.setOutputValue("NoWorkQ", poolsAttrMap.get("num-work-queues"));
    }

    public static void saveThreadPoolValues(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        String threadPoolId = (String)handlerCtx.getInputValue("ThreadPoolId");
        try {
            ThreadPoolConfig threadConfig = null;
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            if (!edit.booleanValue()) {
                threadConfig = config.createThreadPoolConfig(threadPoolId, new HashMap());
            } else {
                Map threadPoolsMap = config.getThreadPoolConfigMap();
                threadConfig = (ThreadPoolConfig)threadPoolsMap.get(threadPoolId);
            }
            threadConfig.setMinThreadPoolSize((String)handlerCtx.getInputValue("MinPoolSize"));
            threadConfig.setMaxThreadPoolSize((String)handlerCtx.getInputValue("MaxPoolSize"));
            threadConfig.setIdleThreadTimeoutInSeconds((String)handlerCtx.getInputValue("IdleTimeout"));
            threadConfig.setNumWorkQueues((String)handlerCtx.getInputValue("NoWorkQ"));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getAccessLogSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        AccessLogConfig al = config.getHTTPServiceConfig().getAccessLogConfig();
        String policy = "";
        String interval = "";
        String suffix = "";
        String format = "";
        boolean rotation = true;
        if (al != null) {
            rotation = al.getRotationEnabled();
            policy = al.getRotationPolicy();
            interval = al.getRotationIntervalInMinutes();
            suffix = al.getRotationSuffix();
            format = al.getFormat();
        } else {
            Map defaultMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-AccessLogConfig");
            policy = (String)defaultMap.get("rotation-policy");
            interval = (String)defaultMap.get("rotation-interval-in-minutes");
            suffix = (String)defaultMap.get("rotation-suffix");
            format = (String)defaultMap.get("format");
            String rotationKey = (String)defaultMap.get("rotation-enabled");
            rotation = rotationKey == null ? false : Boolean.valueOf(rotationKey);
        }
        handlerCtx.setOutputValue("Rotation", (Object)rotation);
        handlerCtx.setOutputValue("Policy", (Object)policy);
        handlerCtx.setOutputValue("Interval", (Object)interval);
        handlerCtx.setOutputValue("Suffix", (Object)suffix);
        handlerCtx.setOutputValue("Format", (Object)format);
    }

    public static void getAccessLogDefaultSettings(HandlerContext handlerCtx) {
        Map defaultMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-AccessLogConfig");
        String policy = (String)defaultMap.get("rotation-policy");
        String interval = (String)defaultMap.get("rotation-interval-in-minutes");
        String suffix = (String)defaultMap.get("rotation-suffix");
        String format = (String)defaultMap.get("format");
        String rotationKey = (String)defaultMap.get("rotation-enabled");
        boolean rotation = rotationKey == null ? false : Boolean.valueOf(rotationKey);
        handlerCtx.setOutputValue("Rotation", (Object)rotation);
        handlerCtx.setOutputValue("Policy", (Object)policy);
        handlerCtx.setOutputValue("Interval", (Object)interval);
        handlerCtx.setOutputValue("Suffix", (Object)suffix);
        handlerCtx.setOutputValue("Format", (Object)format);
    }

    public static void saveAccessLogSettings(HandlerContext handlerCtx) {
        try {
            Boolean temp;
            ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
            AccessLogConfig al = config.getHTTPServiceConfig().getAccessLogConfig();
            if (al == null) {
                al = config.getHTTPServiceConfig().createAccessLogConfig(new HashMap());
            }
            al.setRotationEnabled((temp = (Boolean)handlerCtx.getInputValue("Rotation")) == null ? false : temp);
            al.setRotationPolicy((String)handlerCtx.getInputValue("Policy"));
            al.setRotationIntervalInMinutes((String)handlerCtx.getInputValue("Interval"));
            al.setRotationSuffix((String)handlerCtx.getInputValue("Suffix"));
            al.setFormat((String)handlerCtx.getInputValue("Format"));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getRequestProcessingSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        RequestProcessingConfig rp = config.getHTTPServiceConfig().getRequestProcessingConfig();
        String count = rp.getThreadCount();
        String initial = rp.getInitialThreadCount();
        String increment = rp.getThreadIncrement();
        String timeout = rp.getRequestTimeoutInSeconds();
        String buffer = rp.getHeaderBufferLengthInBytes();
        handlerCtx.setOutputValue("Count", (Object)count);
        handlerCtx.setOutputValue("Initial", (Object)initial);
        handlerCtx.setOutputValue("Increment", (Object)increment);
        handlerCtx.setOutputValue("Timeout", (Object)timeout);
        handlerCtx.setOutputValue("Buffer", (Object)buffer);
    }

    public static void getRequestProcessingDefaultSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        RequestProcessingConfig rp = config.getHTTPServiceConfig().getRequestProcessingConfig();
        String count = rp.getDefaultValue("ThreadCount");
        String initial = rp.getDefaultValue("InitialThreadCount");
        String increment = rp.getDefaultValue("ThreadIncrement");
        String timeout = rp.getDefaultValue("RequestTimeoutInSeconds");
        String buffer = rp.getDefaultValue("HeaderBufferLengthInBytes");
        handlerCtx.setOutputValue("Count", (Object)count);
        handlerCtx.setOutputValue("Initial", (Object)initial);
        handlerCtx.setOutputValue("Increment", (Object)increment);
        handlerCtx.setOutputValue("Timeout", (Object)timeout);
        handlerCtx.setOutputValue("Buffer", (Object)buffer);
    }

    public static void saveRequestProcessingSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            RequestProcessingConfig rp = config.getHTTPServiceConfig().getRequestProcessingConfig();
            rp.setThreadCount((String)handlerCtx.getInputValue("Count"));
            rp.setInitialThreadCount((String)handlerCtx.getInputValue("Initial"));
            rp.setThreadIncrement((String)handlerCtx.getInputValue("Increment"));
            rp.setRequestTimeoutInSeconds((String)handlerCtx.getInputValue("Timeout"));
            rp.setHeaderBufferLengthInBytes((String)handlerCtx.getInputValue("Buffer"));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getKeepAliveSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        KeepAliveConfig rp = config.getHTTPServiceConfig().getKeepAliveConfig();
        String count = rp.getThreadCount();
        String connections = rp.getMaxConnections();
        String timeout = rp.getTimeoutInSeconds();
        handlerCtx.setOutputValue("Count", (Object)count);
        handlerCtx.setOutputValue("Connections", (Object)connections);
        handlerCtx.setOutputValue("Timeout", (Object)timeout);
    }

    public static void getKeepAliveDefaultSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        KeepAliveConfig rp = config.getHTTPServiceConfig().getKeepAliveConfig();
        String count = rp.getDefaultValue("ThreadCount");
        String connections = rp.getDefaultValue("MaxConnections");
        String timeout = rp.getDefaultValue("TimeoutInSeconds");
        handlerCtx.setOutputValue("Count", (Object)count);
        handlerCtx.setOutputValue("Connections", (Object)connections);
        handlerCtx.setOutputValue("Timeout", (Object)timeout);
    }

    public static void saveKeepAliveSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        KeepAliveConfig rp = config.getHTTPServiceConfig().getKeepAliveConfig();
        rp.setThreadCount((String)handlerCtx.getInputValue("Count"));
        rp.setMaxConnections((String)handlerCtx.getInputValue("Connections"));
        rp.setTimeoutInSeconds((String)handlerCtx.getInputValue("Timeout"));
    }

    public static void getHttpService(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        HTTPServiceConfig hConfig = config.getHTTPServiceConfig();
        try {
            handlerCtx.setOutputValue("Properties", (Object)AMXUtil.getNonSkipPropertiesMap((PropertiesAccess)hConfig, httpServiceSkipPropsList));
            Map origProps = hConfig.getProperties();
            handlerCtx.setOutputValue("accessLogBufferSize", origProps.get("accessLogBufferSize"));
            handlerCtx.setOutputValue("accessLogWriteInterval", origProps.get("accessLogWriteInterval"));
            String alog = (String)origProps.get("accessLoggingEnabled");
            Boolean accessLoggingEnabled = true;
            accessLoggingEnabled = GuiUtil.isEmpty(alog) ? Boolean.valueOf(true) : Boolean.valueOf(alog.equals("true"));
            handlerCtx.setOutputValue("accessLoggingEnabled", (Object)accessLoggingEnabled);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void saveHttpService(HandlerContext handlerCtx) {
        try {
            ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
            HTTPServiceConfig hConfig = config.getHTTPServiceConfig();
            Map newProps = (Map)handlerCtx.getInputValue("newProps");
            AMXUtil.updateProperties((PropertiesAccess)hConfig, newProps, httpServiceSkipPropsList);
            AMXUtil.changeProperty((PropertiesAccess)hConfig, "accessLogBufferSize", (String)handlerCtx.getInputValue("accessLogBufferSize"));
            AMXUtil.changeProperty((PropertiesAccess)hConfig, "accessLogWriteInterval", (String)handlerCtx.getInputValue("accessLogWriteInterval"));
            AMXUtil.changeProperty((PropertiesAccess)hConfig, "accessLoggingEnabled", "" + handlerCtx.getInputValue("accessLoggingEnabled"));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getJmsDestinationValues(HandlerContext handlerCtx) {
        try {
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            if (!edit.booleanValue()) {
                ConfigurationHandlers.getDefaultJmsHostAttributes(handlerCtx);
                return;
            }
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            ConfigConfig config = AMXUtil.getConfig(configName);
            String jmsHostName = (String)handlerCtx.getInputValue("JmsHostName");
            Map jmsHostsMap = config.getJMSServiceConfig().getJMSHostConfigMap();
            JMSHostConfig jmsHostConfig = (JMSHostConfig)jmsHostsMap.get(jmsHostName);
            String host = jmsHostConfig.getHost();
            String port = jmsHostConfig.getPort();
            String adminUser = jmsHostConfig.getAdminUserName();
            String adminPwd = jmsHostConfig.getAdminPassword();
            handlerCtx.setOutputValue("Host", (Object)host);
            handlerCtx.setOutputValue("Port", (Object)port);
            handlerCtx.setOutputValue("AdminUser", (Object)adminUser);
            handlerCtx.setOutputValue("AdminPwd", (Object)adminPwd);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static void getDefaultJmsHostAttributes(HandlerContext handlerCtx) {
        Map defaultMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-JMSHostConfig");
        handlerCtx.setOutputValue("Host", defaultMap.get("host"));
        handlerCtx.setOutputValue("Port", defaultMap.get("port"));
        handlerCtx.setOutputValue("AdminUser", defaultMap.get("admin-user-name"));
        handlerCtx.setOutputValue("AdminPwd", defaultMap.get("admin-password"));
    }

    public static void getDefaultJmsDestinationValues(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        String jmsHostName = (String)handlerCtx.getInputValue("JmsHostName");
        Map jmsHostsMap = config.getJMSServiceConfig().getJMSHostConfigMap();
        JMSHostConfig jmsHostConfig = (JMSHostConfig)jmsHostsMap.get(jmsHostName);
        String host = jmsHostConfig.getDefaultValue("Host");
        String port = jmsHostConfig.getDefaultValue("Port");
        String adminUser = jmsHostConfig.getDefaultValue("AdminUserName");
        String adminPwd = jmsHostConfig.getDefaultValue("AdminPassword");
        handlerCtx.setOutputValue("Host", (Object)host);
        handlerCtx.setOutputValue("Port", (Object)port);
        handlerCtx.setOutputValue("AdminUser", (Object)adminUser);
        handlerCtx.setOutputValue("AdminPwd", (Object)adminPwd);
    }

    public static void saveJmsHostValues(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        String jmsHostName = (String)handlerCtx.getInputValue("JmsHostName");
        try {
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            if (!edit.booleanValue()) {
                AttributeList attrList = new AttributeList();
                attrList.add(new Attribute("name", jmsHostName));
                attrList.add(new Attribute("host", (String)handlerCtx.getInputValue("Host")));
                attrList.add(new Attribute("port", (String)handlerCtx.getInputValue("Port")));
                attrList.add(new Attribute("admin-user-name", (String)handlerCtx.getInputValue("AdminUser")));
                attrList.add(new Attribute("admin-password", (String)handlerCtx.getInputValue("AdminPwd")));
                Object[] params = new Object[]{attrList, null, configName};
                String[] types = new String[]{"javax.management.AttributeList", "java.util.Properties", "java.lang.String"};
                JMXUtil.invoke("com.sun.appserv:category=config,type=configs", "createJmsHost", params, types);
                return;
            }
            Map jmsHostsMap = config.getJMSServiceConfig().getJMSHostConfigMap();
            JMSHostConfig jmsHostConfig = (JMSHostConfig)jmsHostsMap.get(jmsHostName);
            jmsHostConfig.setHost((String)handlerCtx.getInputValue("Host"));
            jmsHostConfig.setPort((String)handlerCtx.getInputValue("Port"));
            jmsHostConfig.setAdminUserName((String)handlerCtx.getInputValue("AdminUser"));
            jmsHostConfig.setAdminPassword((String)handlerCtx.getInputValue("AdminPwd"));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getConnectionPoolSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        ConnectionPoolConfig cp = config.getHTTPServiceConfig().getConnectionPoolConfig();
        String count = cp.getMaxPendingCount();
        String queue = cp.getQueueSizeInBytes();
        String receive = cp.getReceiveBufferSizeInBytes();
        String send = cp.getSendBufferSizeInBytes();
        handlerCtx.setOutputValue("Count", (Object)count);
        handlerCtx.setOutputValue("Queue", (Object)queue);
        handlerCtx.setOutputValue("Receive", (Object)receive);
        handlerCtx.setOutputValue("Send", (Object)send);
    }

    public static void getConnectionPoolDefaultSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        ConnectionPoolConfig cp = config.getHTTPServiceConfig().getConnectionPoolConfig();
        String count = cp.getDefaultValue("MaxPendingCount");
        String queue = cp.getDefaultValue("QueueSizeInBytes");
        String receive = cp.getDefaultValue("ReceiveBufferSizeInBytes");
        String send = cp.getDefaultValue("SendBufferSizeInBytes");
        handlerCtx.setOutputValue("Count", (Object)count);
        handlerCtx.setOutputValue("Queue", (Object)queue);
        handlerCtx.setOutputValue("Receive", (Object)receive);
        handlerCtx.setOutputValue("Send", (Object)send);
    }

    public static void saveConnectionPoolSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            ConnectionPoolConfig cp = config.getHTTPServiceConfig().getConnectionPoolConfig();
            cp.setMaxPendingCount((String)handlerCtx.getInputValue("Count"));
            cp.setQueueSizeInBytes((String)handlerCtx.getInputValue("Queue"));
            cp.setReceiveBufferSizeInBytes((String)handlerCtx.getInputValue("Receive"));
            cp.setSendBufferSizeInBytes((String)handlerCtx.getInputValue("Send"));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getHttpProtocolSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        HTTPProtocolConfig hp = config.getHTTPServiceConfig().getHTTPProtocolConfig();
        String version = hp.getVersion();
        boolean dns = hp.getDNSLookupEnabled();
        boolean ssl = hp.getSSLEnabled();
        String forced = hp.getForcedType();
        String defaultResponse = hp.getDefaultType();
        handlerCtx.setOutputValue("Version", (Object)version);
        handlerCtx.setOutputValue("DNS", (Object)dns);
        handlerCtx.setOutputValue("SSL", (Object)ssl);
        handlerCtx.setOutputValue("Forced", (Object)forced);
        handlerCtx.setOutputValue("Default", (Object)defaultResponse);
    }

    public static void getHttpProtocolDefaultSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        HTTPProtocolConfig hp = config.getHTTPServiceConfig().getHTTPProtocolConfig();
        String version = hp.getDefaultValue("Version");
        String dns = hp.getDefaultValue("DNSLookupEnabled");
        String ssl = hp.getDefaultValue("SSLEnabled");
        String forced = hp.getDefaultValue("ForcedType");
        String defaultResponse = hp.getDefaultValue("DefaultType");
        handlerCtx.setOutputValue("Version", (Object)version);
        if (dns.equals("true")) {
            handlerCtx.setOutputValue("DNS", (Object)true);
        } else {
            handlerCtx.setOutputValue("DNS", (Object)false);
        }
        if (ssl.equals("true")) {
            handlerCtx.setOutputValue("SSL", (Object)true);
        } else {
            handlerCtx.setOutputValue("SSL", (Object)false);
        }
        handlerCtx.setOutputValue("Forced", (Object)forced);
        handlerCtx.setOutputValue("Default", (Object)defaultResponse);
    }

    public static void saveHttpProtocolSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            HTTPProtocolConfig hp = config.getHTTPServiceConfig().getHTTPProtocolConfig();
            hp.setVersion((String)handlerCtx.getInputValue("Version"));
            hp.setDNSLookupEnabled(((Boolean)handlerCtx.getInputValue("DNS")).booleanValue());
            hp.setSSLEnabled(((Boolean)handlerCtx.getInputValue("SSL")).booleanValue());
            hp.setForcedType((String)handlerCtx.getInputValue("Forced"));
            hp.setDefaultType((String)handlerCtx.getInputValue("Default"));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getHttpFileCachingSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        HTTPFileCacheConfig hp = config.getHTTPServiceConfig().getHTTPFileCacheConfig();
        boolean globally = hp.getGloballyEnabled();
        boolean fileTransmission = hp.getFileTransmissionEnabled();
        String age = hp.getMaxAgeInSeconds();
        String fileCount = hp.getMaxFilesCount();
        String hashSize = hp.getHashInitSize();
        String medLimit = hp.getMediumFileSizeLimitInBytes();
        String medSize = hp.getMediumFileSpaceInBytes();
        String smLimit = hp.getSmallFileSizeLimitInBytes();
        String smSize = hp.getSmallFileSpaceInBytes();
        boolean fileCaching = hp.getFileCachingEnabled();
        if (fileCaching) {
            handlerCtx.setOutputValue("FileCaching", (Object)"ON");
        } else {
            handlerCtx.setOutputValue("FileCaching", (Object)"OFF");
        }
        handlerCtx.setOutputValue("Globally", (Object)globally);
        handlerCtx.setOutputValue("FileTransmission", (Object)fileTransmission);
        handlerCtx.setOutputValue("Age", (Object)age);
        handlerCtx.setOutputValue("FileCount", (Object)fileCount);
        handlerCtx.setOutputValue("HashSize", (Object)hashSize);
        handlerCtx.setOutputValue("MedLimit", (Object)medLimit);
        handlerCtx.setOutputValue("MedSize", (Object)medSize);
        handlerCtx.setOutputValue("SmLimit", (Object)smLimit);
        handlerCtx.setOutputValue("SmSize", (Object)smSize);
    }

    public static void getHttpFileCachingDefaultSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        HTTPFileCacheConfig hp = config.getHTTPServiceConfig().getHTTPFileCacheConfig();
        String globally = hp.getDefaultValue("GloballyEnabled");
        String fileTransmission = hp.getDefaultValue("FileTransmissionEnabled");
        String age = hp.getDefaultValue("MaxAgeInSeconds");
        String fileCount = hp.getDefaultValue("MaxFilesCount");
        String hashSize = hp.getDefaultValue("HashInitSize");
        String medLimit = hp.getDefaultValue("MediumFileSizeLimitInBytes");
        String medSize = hp.getDefaultValue("MediumFileSpaceInBytes");
        String smLimit = hp.getDefaultValue("SmallFileSizeLimitInBytes");
        String smSize = hp.getDefaultValue("SmallFileSpaceInBytes");
        String fileCaching = hp.getDefaultValue("FileCachingEnabled");
        if (globally.equals("true")) {
            handlerCtx.setOutputValue("Globally", (Object)true);
        } else {
            handlerCtx.setOutputValue("Globally", (Object)false);
        }
        if (fileTransmission.equals("true")) {
            handlerCtx.setOutputValue("FileTransmission", (Object)true);
        } else {
            handlerCtx.setOutputValue("FileTransmission", (Object)false);
        }
        if (fileCaching.equals("true")) {
            handlerCtx.setOutputValue("FileCaching", (Object)"ON");
        } else {
            handlerCtx.setOutputValue("FileCaching", (Object)"OFF");
        }
        handlerCtx.setOutputValue("Age", (Object)age);
        handlerCtx.setOutputValue("FileCount", (Object)fileCount);
        handlerCtx.setOutputValue("HashSize", (Object)hashSize);
        handlerCtx.setOutputValue("MedLimit", (Object)medLimit);
        handlerCtx.setOutputValue("MedSize", (Object)medSize);
        handlerCtx.setOutputValue("SmLimit", (Object)smLimit);
        handlerCtx.setOutputValue("SmSize", (Object)smSize);
    }

    public static void saveHttpFileCachingSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            HTTPFileCacheConfig hp = config.getHTTPServiceConfig().getHTTPFileCacheConfig();
            hp.setGloballyEnabled(((Boolean)handlerCtx.getInputValue("Globally")).booleanValue());
            hp.setFileTransmissionEnabled(((Boolean)handlerCtx.getInputValue("FileTransmission")).booleanValue());
            hp.setMaxAgeInSeconds((String)handlerCtx.getInputValue("Age"));
            hp.setMaxFilesCount((String)handlerCtx.getInputValue("FileCount"));
            hp.setHashInitSize((String)handlerCtx.getInputValue("HashSize"));
            hp.setMediumFileSizeLimitInBytes((String)handlerCtx.getInputValue("MedLimit"));
            hp.setMediumFileSpaceInBytes((String)handlerCtx.getInputValue("MedSize"));
            hp.setSmallFileSizeLimitInBytes((String)handlerCtx.getInputValue("SmLimit"));
            hp.setSmallFileSpaceInBytes((String)handlerCtx.getInputValue("SmSize"));
            String fileCaching = (String)handlerCtx.getInputValue("FileCaching");
            if (fileCaching.equals("ON")) {
                hp.setFileCachingEnabled(true);
            } else {
                hp.setFileCachingEnabled(false);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getConfigList(HandlerContext handlerCtx) {
        String type = (String)handlerCtx.getInputValue("type");
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        boolean isJms = false;
        boolean isVS = false;
        boolean isRealm = false;
        boolean isJacc = false;
        boolean isAudit = false;
        ArrayList result = new ArrayList();
        try {
            List selectedList;
            boolean hasOrig;
            if (config == null) {
                handlerCtx.setOutputValue("result", result);
                return;
            }
            Iterator iter = null;
            if ("jmsHost".equals(type)) {
                iter = config.getJMSServiceConfig().getJMSHostConfigMap().values().iterator();
                isJms = true;
            } else if ("virtualServer".equals(type)) {
                iter = config.getHTTPServiceConfig().getVirtualServerConfigMap().values().iterator();
                isVS = true;
            }
            if ("realm".equals(type)) {
                iter = config.getSecurityServiceConfig().getAuthRealmConfigMap().values().iterator();
                isRealm = true;
            }
            if ("jacc".equals(type)) {
                iter = config.getSecurityServiceConfig().getJACCProviderConfigMap().values().iterator();
                isJacc = true;
            }
            if ("audit".equals(type)) {
                iter = config.getSecurityServiceConfig().getAuditModuleConfigMap().values().iterator();
                isAudit = true;
            }
            boolean bl = hasOrig = (selectedList = (List)handlerCtx.getInputValue("selectedRows")) != null && selectedList.size() != 0;
            if (iter != null) {
                while (iter.hasNext()) {
                    String classname;
                    ConfigElement configE = (ConfigElement)iter.next();
                    HashMap<String, Object> oneRow = new HashMap<String, Object>();
                    String name = configE.getName();
                    oneRow.put("name", name);
                    oneRow.put("selected", hasOrig ? ConnectorsHandlers.isSelected(name, selectedList) : false);
                    if (isVS) {
                        String state = ((VirtualServerConfig)configE).getState();
                        String host = ((VirtualServerConfig)configE).getHosts();
                        oneRow.put("state", state == null ? " " : state);
                        oneRow.put("host", host == null ? " " : host);
                    } else if (isJms) {
                        String host = ((JMSHostConfig)configE).getHost();
                        String port = ((JMSHostConfig)configE).getPort();
                        oneRow.put("host", host == null ? " " : host);
                        oneRow.put("port", port == null ? " " : port);
                    }
                    if (isRealm) {
                        classname = ((AuthRealmConfig)configE).getClassname();
                        oneRow.put("classname", classname == null ? " " : classname);
                    }
                    if (isJacc) {
                        String policy = ((JACCProviderConfig)configE).getPolicyProvider();
                        oneRow.put("policy", policy == null ? " " : policy);
                    }
                    if (isAudit) {
                        classname = ((AuditModuleConfig)configE).getClassname();
                        oneRow.put("classname", classname == null ? " " : classname);
                    }
                    result.add(oneRow);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getPhysicalDestinations(HandlerContext handlerCtx) {
        ObjectName[] objectNames = null;
        Object[] params = new String[]{(String)handlerCtx.getInputValue("ConfigName")};
        String[] types = new String[]{"java.lang.String"};
        ArrayList result = new ArrayList();
        try {
            objectNames = (ObjectName[])JMXUtil.invoke("com.sun.appserv:type=resources,category=config", "listPhysicalDestinations", params, types);
            if (objectNames == null) {
                handlerCtx.setOutputValue("result", result);
                return;
            }
            List selectedList = (List)handlerCtx.getInputValue("selectedRows");
            boolean hasOrig = selectedList != null && selectedList.size() != 0;
            for (int i = 0; i < objectNames.length; ++i) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                oneRow.put("name", objectNames[i].getKeyProperty("destName"));
                oneRow.put("type", objectNames[i].getKeyProperty("destType"));
                oneRow.put("selected", hasOrig ? ConnectorsHandlers.isSelected(objectNames[i].getKeyProperty("destName"), selectedList) : false);
                result.add(oneRow);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void deleteConfig(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        List obj = (List)handlerCtx.getInputValue("selectedRows");
        String type = (String)handlerCtx.getInputValue("Type");
        List selectedRows = obj;
        try {
            for (Map oneRow : selectedRows) {
                String[] types;
                Object[] params;
                String name = (String)oneRow.get("name");
                if ("virtualServer".equals(type)) {
                    config.getHTTPServiceConfig().removeVirtualServerConfig(name);
                    continue;
                }
                if ("jmsHost".equals(type)) {
                    params = new Object[]{name, configName};
                    types = new String[]{"java.lang.String", "java.lang.String"};
                    JMXUtil.invoke("com.sun.appserv:category=config,type=configs", "deleteJmsHost", params, types);
                    continue;
                }
                if ("realm".equals(type)) {
                    config.getSecurityServiceConfig().removeAuthRealmConfig(name);
                    continue;
                }
                if ("jacc".equals(type)) {
                    config.getSecurityServiceConfig().removeJACCProviderConfig(name);
                    continue;
                }
                if ("audit".equals(type)) {
                    config.getSecurityServiceConfig().removeAuditModuleConfig(name);
                    continue;
                }
                if (!"jmsPhysicalDestination".equals(type)) continue;
                params = new Object[]{name, (String)oneRow.get("type"), (String)handlerCtx.getInputValue("ConfigName")};
                types = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
                JMXUtil.invoke("com.sun.appserv:type=resources,category=config", "deletePhysicalDestination", params, types);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void flushJMSDestination(HandlerContext handlerCtx) {
        List obj;
        List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                String name = (String)oneRow.get("name");
                String type = (String)oneRow.get("type");
                Object[] params = new Object[]{name, type, (String)handlerCtx.getInputValue("ConfigName")};
                String[] types = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
                JMXUtil.invoke("com.sun.appserv:type=resources,category=config", "flushJMSDestination", params, types);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getIiopListenerSettings(HandlerContext handlerCtx) {
        try {
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            Boolean fromStep2 = (Boolean)handlerCtx.getInputValue("FromStep2");
            if (!edit.booleanValue()) {
                if (fromStep2 == null || !fromStep2.booleanValue()) {
                    handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("iiopProps", new HashMap());
                    handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("sslProps", null);
                    ConfigurationHandlers.getDefaultIiopListenerSettings(handlerCtx);
                    handlerCtx.setOutputValue("Properties", new HashMap());
                } else {
                    Map props = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("iiopProps");
                    handlerCtx.setOutputValue("NetwkAddr", props.get("address"));
                    handlerCtx.setOutputValue("ListenerPort", props.get("port"));
                    handlerCtx.setOutputValue("Listener", props.get("listener"));
                    handlerCtx.setOutputValue("security", props.get("security"));
                    handlerCtx.setOutputValue("Properties", props.get("options"));
                }
                return;
            }
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            String iiopListenerName = (String)handlerCtx.getInputValue("IiopName");
            ConfigConfig config = AMXUtil.getConfig(configName);
            IIOPListenerConfig iiopListConfig = (IIOPListenerConfig)config.getIIOPServiceConfig().getIIOPListenerConfigMap().get(iiopListenerName);
            handlerCtx.setOutputValue("NetwkAddr", (Object)iiopListConfig.getAddress());
            handlerCtx.setOutputValue("ListenerPort", (Object)iiopListConfig.getPort());
            handlerCtx.setOutputValue("Listener", (Object)iiopListConfig.getEnabled());
            handlerCtx.setOutputValue("security", (Object)iiopListConfig.getSecurityEnabled());
            handlerCtx.setOutputValue("Properties", (Object)iiopListConfig.getProperties());
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getDefaultIiopListenerSettings(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        Map iiopAttrMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-IIOPListenerConfig");
        handlerCtx.setOutputValue("NetwkAddr", iiopAttrMap.get("Address"));
        handlerCtx.setOutputValue("ListenerPort", iiopAttrMap.get("port"));
        handlerCtx.setOutputValue("Listener", iiopAttrMap.get("enabled"));
    }

    public static void saveIiopListenerSettings(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        String iiopListenerName = (String)handlerCtx.getInputValue("IiopName");
        String address = (String)handlerCtx.getInputValue("NetwkAddr");
        String port = (String)handlerCtx.getInputValue("ListenerPort");
        boolean listener = (Boolean)handlerCtx.getInputValue("Listener");
        boolean security = (Boolean)handlerCtx.getInputValue("security");
        ConfigConfig config = AMXUtil.getConfig(configName);
        try {
            IIOPListenerConfig iiopListConfig = null;
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            if (!edit.booleanValue()) {
                HashMap<String, Object> iiopPropsMap = new HashMap<String, Object>();
                iiopPropsMap.put("iiopName", iiopListenerName);
                iiopPropsMap.put("address", address);
                iiopPropsMap.put("options", (Map)handlerCtx.getInputValue("AddProps"));
                iiopPropsMap.put("port", port);
                iiopPropsMap.put("listener", listener);
                iiopPropsMap.put("security", security);
                handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("iiopProps", iiopPropsMap);
            } else {
                Map iiopMap = config.getIIOPServiceConfig().getIIOPListenerConfigMap();
                iiopListConfig = (IIOPListenerConfig)iiopMap.get(iiopListenerName);
                iiopListConfig.setAddress(address);
                AMXUtil.editProperties(handlerCtx, (PropertiesAccess)iiopListConfig);
                iiopListConfig.setPort(port);
                iiopListConfig.setEnabled(listener);
                iiopListConfig.setSecurityEnabled(security);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getListenersList(HandlerContext handlerCtx) {
        String type = (String)handlerCtx.getInputValue("Type");
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        ArrayList result = new ArrayList();
        boolean isIIOP = false;
        boolean isHTTP = false;
        Iterator iter = null;
        try {
            boolean hasOrig;
            if ("iiopListener".equals(type)) {
                iter = config.getIIOPServiceConfig().getIIOPListenerConfigMap().values().iterator();
                isIIOP = true;
            } else if ("httpListener".equals(type)) {
                iter = config.getHTTPServiceConfig().getHTTPListenerConfigMap().values().iterator();
                isHTTP = true;
            }
            List selectedList = (List)handlerCtx.getInputValue("selectedRows");
            boolean bl = hasOrig = selectedList != null && selectedList.size() != 0;
            if (iter != null) {
                while (iter.hasNext()) {
                    String listPort;
                    String ntwkAddress;
                    boolean enabled;
                    ConfigElement configE = (ConfigElement)iter.next();
                    HashMap<String, Object> oneRow = new HashMap<String, Object>();
                    String name = configE.getName();
                    oneRow.put("name", name);
                    oneRow.put("selected", hasOrig ? ConnectorsHandlers.isSelected(name, selectedList) : false);
                    if (isIIOP) {
                        IIOPListenerConfig listConfig = (IIOPListenerConfig)configE;
                        enabled = listConfig.getEnabled();
                        ntwkAddress = listConfig.getAddress();
                        listPort = listConfig.getPort();
                        oneRow.put("enabled", enabled);
                        oneRow.put("ntwkAddress", ntwkAddress == null ? " " : ntwkAddress);
                        oneRow.put("listPort", listPort == null ? " " : listPort);
                    } else if (isHTTP) {
                        HTTPListenerConfig httpConfig = (HTTPListenerConfig)configE;
                        enabled = httpConfig.getEnabled();
                        ntwkAddress = httpConfig.getAddress();
                        listPort = httpConfig.getPort();
                        String virtualServer = httpConfig.getDefaultVirtualServer();
                        oneRow.put("enabled", enabled);
                        oneRow.put("ntwkAddress", ntwkAddress == null ? " " : ntwkAddress);
                        oneRow.put("listPort", listPort == null ? " " : listPort);
                        oneRow.put("defVirtualServer", virtualServer == null ? " " : virtualServer);
                    }
                    result.add(oneRow);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("Result", result);
    }

    public static void deleteListeners(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        List obj = (List)handlerCtx.getInputValue("selectedRows");
        String type = (String)handlerCtx.getInputValue("Type");
        List selectedRows = obj;
        try {
            for (Map oneRow : selectedRows) {
                String name = (String)oneRow.get("name");
                if ("iiopListener".equals(type)) {
                    config.getIIOPServiceConfig().removeIIOPListenerConfig(name);
                    continue;
                }
                if (!"httpListener".equals(type)) continue;
                String[] types = new String[]{"java.lang.String", "java.lang.String"};
                Object[] params = new Object[]{name, configName};
                JMXUtil.invoke("com.sun.appserv:type=configs,category=config", "deleteHttpListener", params, types);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getDefaultVirtualServers(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        Map virtServers = config.getHTTPServiceConfig().getVirtualServerConfigMap();
        String[] virtualServers = virtServers.keySet().toArray(new String[virtServers.size()]);
        SelectItem[] options = ConfigurationHandlers.getModOptions(virtualServers);
        handlerCtx.setOutputValue("DefaultVirtualServers", (Object)options);
    }

    public static void getHttpListenerValues(HandlerContext handlerCtx) {
        try {
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            Boolean fromStep2 = (Boolean)handlerCtx.getInputValue("FromStep2");
            if (!edit.booleanValue()) {
                if (fromStep2 == null || !fromStep2.booleanValue()) {
                    handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("httpProps", new HashMap());
                    handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("sslProps", null);
                    Map httpAttrMap = AMXUtil.getDomainConfig().getDefaultAttributeValues("X-HTTPListenerConfig");
                    handlerCtx.setOutputValue("Listener", httpAttrMap.get("enabled"));
                    handlerCtx.setOutputValue("security", httpAttrMap.get("security-enabled"));
                    handlerCtx.setOutputValue("Acceptor", httpAttrMap.get("acceptor-threads"));
                    handlerCtx.setOutputValue("PoweredBy", httpAttrMap.get("xpowered-by"));
                    handlerCtx.setOutputValue("Blocking", httpAttrMap.get("blocking-enabled"));
                } else {
                    Map props = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("httpProps");
                    handlerCtx.setOutputValue("Listener", props.get("enabled"));
                    handlerCtx.setOutputValue("security", props.get("securityEnabled"));
                    handlerCtx.setOutputValue("NetwkAddr", props.get("address"));
                    handlerCtx.setOutputValue("ListenerPort", props.get("port"));
                    handlerCtx.setOutputValue("DefaultVirtServer", props.get("virtualServer"));
                    handlerCtx.setOutputValue("ServerName", props.get("serverName"));
                    handlerCtx.setOutputValue("RedirectPort", props.get("redirectPort"));
                    handlerCtx.setOutputValue("Acceptor", props.get("acceptor-threads"));
                    handlerCtx.setOutputValue("PoweredBy", props.get("xpowered-by"));
                    handlerCtx.setOutputValue("Blocking", props.get("blocking-enabled"));
                    handlerCtx.setOutputValue("Properties", props.get("options"));
                }
                return;
            }
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            String httpListenerName = (String)handlerCtx.getInputValue("HttpName");
            ConfigConfig config = AMXUtil.getConfig(configName);
            HTTPListenerConfig httpListConfig = (HTTPListenerConfig)config.getHTTPServiceConfig().getHTTPListenerConfigMap().get(httpListenerName);
            handlerCtx.setOutputValue("Listener", (Object)httpListConfig.getEnabled());
            handlerCtx.setOutputValue("security", (Object)httpListConfig.getSecurityEnabled());
            handlerCtx.setOutputValue("NetwkAddr", (Object)httpListConfig.getAddress());
            handlerCtx.setOutputValue("ListenerPort", (Object)httpListConfig.getPort());
            handlerCtx.setOutputValue("DefaultVirtServer", (Object)httpListConfig.getDefaultVirtualServer());
            handlerCtx.setOutputValue("ServerName", (Object)httpListConfig.getServerName());
            handlerCtx.setOutputValue("RedirectPort", (Object)httpListConfig.getRedirectPort());
            handlerCtx.setOutputValue("Acceptor", (Object)httpListConfig.getAcceptorThreads());
            handlerCtx.setOutputValue("PoweredBy", (Object)httpListConfig.getXpoweredBy());
            handlerCtx.setOutputValue("Blocking", (Object)httpListConfig.getBlockingEnabled());
            Map pMap = httpListConfig.getProperties();
            handlerCtx.setOutputValue("Properties", (Object)pMap);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void saveHttpListenerValues(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        String httpListenerName = (String)handlerCtx.getInputValue("HttpName");
        String listPort = (String)handlerCtx.getInputValue("ListenerPort");
        String address = (String)handlerCtx.getInputValue("NetwkAddr");
        String virtualServer = (String)handlerCtx.getInputValue("DefaultVirtServer");
        String serverName = (String)handlerCtx.getInputValue("ServerName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        try {
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            if (!edit.booleanValue()) {
                HashMap<String, Object> httpPropsMap = new HashMap<String, Object>();
                httpPropsMap.put("httpName", httpListenerName);
                httpPropsMap.put("address", address);
                httpPropsMap.put("port", listPort);
                httpPropsMap.put("virtualServer", virtualServer);
                httpPropsMap.put("serverName", serverName);
                httpPropsMap.put("options", (Map)handlerCtx.getInputValue("AddProps"));
                httpPropsMap.put("enabled", (Boolean)handlerCtx.getInputValue("Listener"));
                httpPropsMap.put("securityEnabled", (Boolean)handlerCtx.getInputValue("security"));
                httpPropsMap.put("redirectPort", (String)handlerCtx.getInputValue("RedirectPort"));
                httpPropsMap.put("acceptor-threads", (String)handlerCtx.getInputValue("Acceptor"));
                httpPropsMap.put("xpowered-by", (Boolean)handlerCtx.getInputValue("PoweredBy"));
                httpPropsMap.put("blocking-enabled", (Boolean)handlerCtx.getInputValue("Blocking"));
                handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("httpProps", httpPropsMap);
            } else {
                HTTPListenerConfig httpListConfig = (HTTPListenerConfig)config.getHTTPServiceConfig().getHTTPListenerConfigMap().get(httpListenerName);
                String previousVSName = httpListConfig.getDefaultVirtualServer();
                httpListConfig.setAddress(address);
                httpListConfig.setPort((String)handlerCtx.getInputValue("ListenerPort"));
                httpListConfig.setDefaultVirtualServer(virtualServer);
                httpListConfig.setServerName(serverName);
                httpListConfig.setEnabled(((Boolean)handlerCtx.getInputValue("Listener")).booleanValue());
                httpListConfig.setSecurityEnabled(((Boolean)handlerCtx.getInputValue("security")).booleanValue());
                httpListConfig.setRedirectPort((String)handlerCtx.getInputValue("RedirectPort"));
                httpListConfig.setAcceptorThreads((String)handlerCtx.getInputValue("Acceptor"));
                httpListConfig.setXpoweredBy(((Boolean)handlerCtx.getInputValue("PoweredBy")).booleanValue());
                httpListConfig.setBlockingEnabled(((Boolean)handlerCtx.getInputValue("Blocking")).booleanValue());
                AMXUtil.editProperties(handlerCtx, (PropertiesAccess)httpListConfig);
                if (httpListenerName.equals(ADMIN_LISTENER)) {
                    if (httpListConfig.getSecurityEnabled()) {
                        if (httpListConfig.existsProperty(PROXIED_PROTOCOLS)) {
                            httpListConfig.setPropertyValue(PROXIED_PROTOCOLS, PROXIED_PROTOCOLS_VALUE);
                        } else {
                            httpListConfig.createProperty(PROXIED_PROTOCOLS, PROXIED_PROTOCOLS_VALUE);
                        }
                    } else if (httpListConfig.existsProperty(PROXIED_PROTOCOLS)) {
                        httpListConfig.removeProperty(PROXIED_PROTOCOLS);
                    }
                }
                Map vservers = config.getHTTPServiceConfig().getVirtualServerConfigMap();
                VirtualServerConfig previousVS = (VirtualServerConfig)vservers.get(previousVSName);
                VirtualServerConfig newVS = (VirtualServerConfig)vservers.get(virtualServer);
                String hl = previousVS.getHTTPListeners();
                String[] hlArray = GuiUtil.stringToArray(hl, ",");
                String tmp = "";
                for (int i = 0; i < hlArray.length; ++i) {
                    if (hlArray[i].equals(httpListenerName)) continue;
                    tmp = tmp == "" ? hlArray[i] : tmp + "," + hlArray[i];
                }
                previousVS.setHTTPListeners(tmp);
                tmp = newVS.getHTTPListeners();
                if (GuiUtil.isEmpty(tmp)) {
                    newVS.setHTTPListeners(httpListenerName);
                } else {
                    tmp = newVS.getHTTPListeners() + "," + httpListenerName;
                    newVS.setHTTPListeners(tmp);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getMsgSecurityList(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        Iterator iter = config.getSecurityServiceConfig().getMessageSecurityConfigMap().values().iterator();
        List selectedList = (List)handlerCtx.getInputValue("selectedRows");
        boolean hasOrig = selectedList != null && selectedList.size() != 0;
        ArrayList result = new ArrayList();
        if (iter != null) {
            while (iter.hasNext()) {
                MessageSecurityConfig msgSecurityConfig = (MessageSecurityConfig)iter.next();
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                String name = msgSecurityConfig.getAuthLayer();
                oneRow.put("name", name);
                oneRow.put("selected", hasOrig ? ConnectorsHandlers.isSelected(name, selectedList) : false);
                String defaultProv = msgSecurityConfig.getDefaultProvider();
                String defaultClientProv = msgSecurityConfig.getDefaultClientProvider();
                oneRow.put("defaultProv", defaultProv == null ? " " : defaultProv);
                oneRow.put("defaultClientProv", defaultClientProv == null ? " " : defaultClientProv);
                result.add(oneRow);
            }
        }
        boolean showNew = true;
        if (result.size() == 2) {
            showNew = false;
        }
        handlerCtx.setOutputValue("Result", result);
        handlerCtx.setOutputValue("ShowNew", (Object)showNew);
    }

    public static void deleteMsgSecurities(HandlerContext handlerCtx) {
        List obj;
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                String name = (String)oneRow.get("name");
                config.getSecurityServiceConfig().removeMessageSecurityConfig(name);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getMsgSecurityConfigValues(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        String authLayerName = (String)handlerCtx.getInputValue("AuthLayer");
        try {
            MessageSecurityConfig msgSecConfig = (MessageSecurityConfig)config.getSecurityServiceConfig().getMessageSecurityConfigMap().get(authLayerName);
            handlerCtx.setOutputValue("DefaultProvider", (Object)msgSecConfig.getDefaultProvider());
            handlerCtx.setOutputValue("DefaultClProvider", (Object)msgSecConfig.getDefaultClientProvider());
            Map providersMap = msgSecConfig.getProviderConfigMap();
            String[] providers = providersMap.keySet().toArray(new String[providersMap.size()]);
            if (providers != null) {
                SelectItem[] options = ConfigurationHandlers.getModOptions(providers);
                handlerCtx.setOutputValue("Providers", (Object)options);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void saveMsgSecurityConfigValues(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        String authLayerName = (String)handlerCtx.getInputValue("AuthLayer");
        try {
            MessageSecurityConfig msgSecConfig = (MessageSecurityConfig)config.getSecurityServiceConfig().getMessageSecurityConfigMap().get(authLayerName);
            msgSecConfig.setDefaultProvider((String)handlerCtx.getInputValue("DefaultProvider"));
            msgSecConfig.setDefaultClientProvider((String)handlerCtx.getInputValue("DefaultClProvider"));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getProvidersList(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        String msgSecurityName = (String)handlerCtx.getInputValue("MsgSecurityName");
        Map providerMap = ((MessageSecurityConfig)config.getSecurityServiceConfig().getMessageSecurityConfigMap().get(msgSecurityName)).getProviderConfigMap();
        Iterator iter = providerMap.values().iterator();
        List selectedList = (List)handlerCtx.getInputValue("selectedRows");
        boolean hasOrig = selectedList != null && selectedList.size() != 0;
        ArrayList result = new ArrayList();
        if (iter != null) {
            while (iter.hasNext()) {
                ProviderConfig providerConfig = (ProviderConfig)iter.next();
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                String name = providerConfig.getProviderId();
                oneRow.put("name", name);
                oneRow.put("selected", hasOrig ? ConnectorsHandlers.isSelected(name, selectedList) : false);
                String providerType = providerConfig.getProviderType();
                String className = providerConfig.getClassName();
                oneRow.put("provType", providerType == null ? " " : providerType);
                oneRow.put("className", className == null ? " " : className);
                result.add(oneRow);
            }
        }
        handlerCtx.setOutputValue("Result", result);
    }

    public static void deleteProviders(HandlerContext handlerCtx) {
        List obj;
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        String msgSecurityName = (String)handlerCtx.getInputValue("MsgSecurityName");
        MessageSecurityConfig msgConfig = (MessageSecurityConfig)config.getSecurityServiceConfig().getMessageSecurityConfigMap().get(msgSecurityName);
        List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                String currDefProvider;
                String name = (String)oneRow.get("name");
                if (name.equals(currDefProvider = msgConfig.getDefaultClientProvider())) {
                    msgConfig.setDefaultClientProvider("");
                }
                Object[] params = new Object[]{name};
                String[] types = new String[]{"java.lang.String"};
                String objName = "com.sun.appserv:type=message-security-config,category=config,name=" + msgSecurityName + ",config=" + configName;
                JMXUtil.invoke(objName, "removeProviderConfigByProviderId", params, types);
            }
            if (File.separatorChar == '\\') {
                Thread.sleep(2000L);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getProviderValues(HandlerContext handlerCtx) {
        try {
            ResponsePolicyConfig responseConfig;
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            String msgSecurityName = (String)handlerCtx.getInputValue("MsgSecurityName");
            ConfigConfig config = AMXUtil.getConfig(configName);
            MessageSecurityConfig msgConfig = (MessageSecurityConfig)config.getSecurityServiceConfig().getMessageSecurityConfigMap().get(msgSecurityName);
            if (!edit.booleanValue()) {
                handlerCtx.setOutputValue("DefaultProvider", (Object)false);
                return;
            }
            String providerId = (String)handlerCtx.getInputValue("ProviderId");
            ProviderConfig provConfig = (ProviderConfig)msgConfig.getProviderConfigMap().get(providerId);
            handlerCtx.setOutputValue("ProviderType", (Object)provConfig.getProviderType());
            handlerCtx.setOutputValue("ClassName", (Object)provConfig.getClassName());
            RequestPolicyConfig requestConfig = provConfig.getRequestPolicyConfig();
            if (requestConfig != null) {
                handlerCtx.setOutputValue("AuthSourceRequest", (Object)requestConfig.getAuthSource());
                handlerCtx.setOutputValue("AuthRecpRequest", (Object)requestConfig.getAuthRecipient());
            }
            if ((responseConfig = provConfig.getResponsePolicyConfig()) != null) {
                handlerCtx.setOutputValue("AuthSourceResponse", (Object)responseConfig.getAuthSource());
                handlerCtx.setOutputValue("AuthRecpResponse", (Object)responseConfig.getAuthRecipient());
            }
            handlerCtx.setOutputValue("Properties", (Object)provConfig.getProperties());
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getProviderLists(HandlerContext handlerCtx) {
        SelectItem[] types = ConfigurationHandlers.getOptions(providerTypes);
        SelectItem[] sources = ConfigurationHandlers.getModOptions(authSource);
        SelectItem[] recepients = ConfigurationHandlers.getModOptions(authRecipient);
        handlerCtx.setOutputValue("ProviderTypes", (Object)types);
        handlerCtx.setOutputValue("AuthSources", (Object)sources);
        handlerCtx.setOutputValue("AuthRecepients", (Object)recepients);
    }

    public static void saveProviderValues(HandlerContext handlerCtx) {
        try {
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            String msgSecurityName = (String)handlerCtx.getInputValue("MsgSecurityName");
            String providerId = (String)handlerCtx.getInputValue("ProviderId");
            String providerType = (String)handlerCtx.getInputValue("ProviderType");
            String className = (String)handlerCtx.getInputValue("ClassName");
            ConfigConfig config = AMXUtil.getConfig(configName);
            MessageSecurityConfig msgConfig = (MessageSecurityConfig)config.getSecurityServiceConfig().getMessageSecurityConfigMap().get(msgSecurityName);
            ProviderConfig provConfig = null;
            if (!edit.booleanValue()) {
                boolean isDefault = (Boolean)handlerCtx.getInputValue("DefaultProvider");
                String msgObjName = "com.sun.appserv:type=configs,category=config";
                String createOperName = "createMessageSecurityProvider";
                String[] types = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "boolean", "java.util.Properties", "java.lang.String"};
                Object[] createParams = new Object[]{msgSecurityName, providerId, providerType, className, null, null, null, null, isDefault, null, configName};
                JMXUtil.invoke(msgObjName, createOperName, createParams, types);
                if (File.separatorChar == '\\') {
                    Thread.sleep(2000L);
                }
                provConfig = (ProviderConfig)msgConfig.getProviderConfigMap().get(providerId);
                AMXUtil.editProperties(handlerCtx, (PropertiesAccess)provConfig);
            } else {
                provConfig = (ProviderConfig)msgConfig.getProviderConfigMap().get(providerId);
                provConfig.setProviderType((String)handlerCtx.getInputValue("ProviderType"));
                provConfig.setClassName((String)handlerCtx.getInputValue("ClassName"));
                AMXUtil.editProperties(handlerCtx, (PropertiesAccess)provConfig);
            }
            String objName = "com.sun.appserv:type=provider-config,config=" + configName + ",category=config,message-security-config=" + msgSecurityName + ",name=" + providerId;
            String[] signature = new String[]{"javax.management.AttributeList"};
            String requestOperation = "createRequestPolicy";
            AttributeList requestAttrList = new AttributeList();
            requestAttrList.add(new Attribute("auth-source", (String)handlerCtx.getInputValue("AuthSourceRequest")));
            requestAttrList.add(new Attribute("auth-recipient", (String)handlerCtx.getInputValue("AuthRecpRequest")));
            String responseOperation = "createResponsePolicy";
            AttributeList responseAttrList = new AttributeList();
            responseAttrList.add(new Attribute("auth-source", (String)handlerCtx.getInputValue("AuthSourceResponse")));
            responseAttrList.add(new Attribute("auth-recipient", (String)handlerCtx.getInputValue("AuthRecpResponse")));
            Object[] requestParams = new Object[]{requestAttrList};
            Object[] responseParams = new Object[]{responseAttrList};
            JMXUtil.invoke(objName, requestOperation, requestParams, signature);
            JMXUtil.invoke(objName, responseOperation, responseParams, signature);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getDefaultMessageAndProviderValues(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        Map configs = config.getSecurityServiceConfig().getMessageSecurityConfigMap();
        Vector<String> layers = new Vector<String>(Arrays.asList(messageLayers));
        for (MessageSecurityConfig msgConfig : configs.values()) {
            String layerName = msgConfig.getAuthLayer();
            if (layerName == null || !layers.contains(msgConfig.getAuthLayer())) continue;
            layers.remove(layerName);
        }
        SelectItem[] authLayers = ConfigurationHandlers.getOptions(layers.toArray(new String[layers.size()]));
        SelectItem[] types = ConfigurationHandlers.getOptions(providerTypes);
        handlerCtx.setOutputValue("AuthLayers", (Object)authLayers);
        handlerCtx.setOutputValue("DefaultProvider", (Object)false);
        handlerCtx.setOutputValue("ProviderTypes", (Object)types);
    }

    public static void saveMessageAndProviderValues(HandlerContext handlerCtx) {
        try {
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            String authLayer = (String)handlerCtx.getInputValue("AuthLayer");
            String providerId = (String)handlerCtx.getInputValue("ProviderId");
            String providerType = (String)handlerCtx.getInputValue("ProviderType");
            String className = (String)handlerCtx.getInputValue("ClassName");
            boolean isDefault = (Boolean)handlerCtx.getInputValue("DefaultProvider");
            ConfigConfig config = AMXUtil.getConfig(configName);
            MessageSecurityConfig msgConfig = config.getSecurityServiceConfig().createMessageSecurityConfig(authLayer, providerId, providerType, className, new HashMap());
            if (isDefault) {
                msgConfig.setDefaultClientProvider(providerId);
            }
            AMXUtil.editProperties(handlerCtx, (PropertiesAccess)msgConfig.getProviderConfigMap().get(providerId));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void deleteManagementRules(HandlerContext handlerCtx) {
        List obj;
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        ManagementRulesConfig mgRulesConfig = config.getManagementRulesConfig();
        List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                String name = (String)oneRow.get("name");
                mgRulesConfig.removeManagementRuleConfig(name);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void enableDisableManagementRules(HandlerContext handlerCtx) {
        List obj;
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        boolean enable = (Boolean)handlerCtx.getInputValue("Enable");
        ManagementRulesConfig mgRulesConfig = config.getManagementRulesConfig();
        List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                String name = (String)oneRow.get("name");
                ManagementRuleConfig ruleConfig = (ManagementRuleConfig)mgRulesConfig.getManagementRuleConfigMap().get(name);
                ruleConfig.setEnabled(enable);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getDefaultAvailabilityServiceSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        AvailabilityServiceConfig availConfig = config.getAvailabilityServiceConfig();
        boolean availEnabled = Boolean.valueOf(availConfig.getDefaultValue("AvailabilityEnabled"));
        String storePoolName = availConfig.getDefaultValue("StorePoolName");
        String haStoreName = availConfig.getDefaultValue("HAStoreName");
        String haAgentHosts = availConfig.getDefaultValue("HAAgentHosts");
        String haAgentPort = availConfig.getDefaultValue("HAAgentPort");
        String haAgentPwd = availConfig.getDefaultValue("HAAgentPassword");
        boolean autoMgStore = Boolean.valueOf(availConfig.getDefaultValue("AutoManageHAStore"));
        boolean storeHealthChk = Boolean.valueOf(availConfig.getDefaultValue("HAStoreHealthcheckEnabled"));
        String haStoreHealthChk = availConfig.getDefaultValue("HAStoreHealthcheckIntervalSeconds");
        handlerCtx.setOutputValue("AvailabilityEnabled", (Object)availEnabled);
        handlerCtx.setOutputValue("StorePoolName", (Object)storePoolName);
        handlerCtx.setOutputValue("HAStoreName", (Object)haStoreName);
        handlerCtx.setOutputValue("HAAgentHosts", (Object)haAgentHosts);
        handlerCtx.setOutputValue("HAAgentPort", (Object)haAgentPort);
        handlerCtx.setOutputValue("HAAgentPassword", (Object)haAgentPwd);
        handlerCtx.setOutputValue("AutoManage", (Object)autoMgStore);
        handlerCtx.setOutputValue("StoreHealthCheck", (Object)storeHealthChk);
        handlerCtx.setOutputValue("HAStoreHealthCheck", (Object)haStoreHealthChk);
    }

    public static void getAvailabilityServiceSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        AvailabilityServiceConfig availConfig = config.getAvailabilityServiceConfig();
        boolean availEnabled = availConfig.getAvailabilityEnabled();
        String storePoolName = availConfig.getStorePoolName();
        String haStoreName = availConfig.getHAStoreName();
        String haAgentHosts = availConfig.getHAAgentHosts();
        String haAgentPort = availConfig.getHAAgentPort();
        String haAgentPwd = availConfig.getHAAgentPassword();
        boolean autoMgStore = availConfig.getAutoManageHAStore();
        boolean storeHealthChk = availConfig.getHAStoreHealthcheckEnabled();
        String haStoreHealthChk = availConfig.getHAStoreHealthcheckIntervalSeconds();
        Map props = availConfig.getProperties();
        handlerCtx.setOutputValue("AvailabilityEnabled", (Object)availEnabled);
        handlerCtx.setOutputValue("StorePoolName", (Object)storePoolName);
        handlerCtx.setOutputValue("HAStoreName", (Object)haStoreName);
        handlerCtx.setOutputValue("HAAgentHosts", (Object)haAgentHosts);
        handlerCtx.setOutputValue("HAAgentPort", (Object)haAgentPort);
        handlerCtx.setOutputValue("HAAgentPassword", (Object)haAgentPwd);
        handlerCtx.setOutputValue("AutoManage", (Object)autoMgStore);
        handlerCtx.setOutputValue("StoreHealthCheck", (Object)storeHealthChk);
        handlerCtx.setOutputValue("HAStoreHealthCheck", (Object)haStoreHealthChk);
        handlerCtx.setOutputValue("Properties", (Object)props);
    }

    public static void saveAvailabilityServiceSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            AvailabilityServiceConfig availConfig = config.getAvailabilityServiceConfig();
            availConfig.setAvailabilityEnabled(((Boolean)handlerCtx.getInputValue("AvailabilityEnabled")).booleanValue());
            availConfig.setStorePoolName((String)handlerCtx.getInputValue("StorePoolName"));
            availConfig.setHAStoreName((String)handlerCtx.getInputValue("HAStoreName"));
            availConfig.setHAAgentHosts((String)handlerCtx.getInputValue("HAAgentHosts"));
            availConfig.setHAAgentPort((String)handlerCtx.getInputValue("HAAgentPort"));
            availConfig.setHAAgentPassword((String)handlerCtx.getInputValue("HAAgentPassword"));
            availConfig.setAutoManageHAStore(((Boolean)handlerCtx.getInputValue("AutoManage")).booleanValue());
            availConfig.setHAStoreHealthcheckEnabled(((Boolean)handlerCtx.getInputValue("StoreHealthCheck")).booleanValue());
            availConfig.setHAStoreHealthcheckIntervalSeconds((String)handlerCtx.getInputValue("HAStoreHealthCheck"));
            AMXUtil.editProperties(handlerCtx, (PropertiesAccess)availConfig);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getDefaultWebAvailabilitySettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        WebContainerAvailabilityConfig webConfig = config.getAvailabilityServiceConfig().getWebContainerAvailabilityConfig();
        boolean availEnabled = Boolean.valueOf(webConfig.getDefaultValue("AvailabilityEnabled"));
        String persistenceType = webConfig.getDefaultValue("PersistenceType");
        String persistenceFreq = webConfig.getDefaultValue("PersistenceFrequency");
        String persistenceScope = webConfig.getDefaultValue("PersistenceScope");
        boolean singleSignOn = Boolean.valueOf(webConfig.getDefaultValue("SSOFailoverEnabled"));
        String httpSessionStore = webConfig.getDefaultValue("HTTPSessionStorePoolName");
        boolean persistenceHealthChk = Boolean.valueOf(webConfig.getDefaultValue("PersistenceStoreHealthCheckEnabled"));
        handlerCtx.setOutputValue("AvailabilityEnabled", (Object)availEnabled);
        handlerCtx.setOutputValue("PersistenceType", (Object)persistenceType);
        handlerCtx.setOutputValue("PersistenceFrequency", (Object)persistenceFreq);
        handlerCtx.setOutputValue("PersistenceScope", (Object)persistenceScope);
        handlerCtx.setOutputValue("SingleSignOn", (Object)singleSignOn);
        handlerCtx.setOutputValue("HttpSessionStore", (Object)httpSessionStore);
        handlerCtx.setOutputValue("PersistenceHealthCheck", (Object)persistenceHealthChk);
    }

    public static void getWebAvailabilitySettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        WebContainerAvailabilityConfig webConfig = config.getAvailabilityServiceConfig().getWebContainerAvailabilityConfig();
        boolean availEnabled = webConfig.getAvailabilityEnabled();
        String persistenceType = webConfig.getPersistenceType();
        String persistenceFreq = webConfig.getPersistenceFrequency();
        String persistenceScope = webConfig.getPersistenceScope();
        boolean singleSignOn = webConfig.getSSOFailoverEnabled();
        String httpSessionStore = webConfig.getHTTPSessionStorePoolName();
        boolean persistenceHealthChk = webConfig.getPersistenceStoreHealthCheckEnabled();
        Map props = webConfig.getProperties();
        handlerCtx.setOutputValue("AvailabilityEnabled", (Object)availEnabled);
        handlerCtx.setOutputValue("PersistenceType", (Object)persistenceType);
        handlerCtx.setOutputValue("PersistenceFrequency", (Object)persistenceFreq);
        handlerCtx.setOutputValue("PersistenceScope", (Object)persistenceScope);
        handlerCtx.setOutputValue("SingleSignOn", (Object)singleSignOn);
        handlerCtx.setOutputValue("HttpSessionStore", (Object)httpSessionStore);
        handlerCtx.setOutputValue("PersistenceHealthCheck", (Object)persistenceHealthChk);
        handlerCtx.setOutputValue("Properties", (Object)props);
    }

    public static void saveWebAvailabilitySettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            WebContainerAvailabilityConfig webConfig = config.getAvailabilityServiceConfig().getWebContainerAvailabilityConfig();
            webConfig.setAvailabilityEnabled(((Boolean)handlerCtx.getInputValue("AvailabilityEnabled")).booleanValue());
            webConfig.setPersistenceType((String)handlerCtx.getInputValue("PersistenceType"));
            webConfig.setPersistenceFrequency((String)handlerCtx.getInputValue("PersistenceFrequency"));
            webConfig.setPersistenceScope((String)handlerCtx.getInputValue("PersistenceScope"));
            webConfig.setSSOFailoverEnabled(((Boolean)handlerCtx.getInputValue("SingleSignOn")).booleanValue());
            webConfig.setHTTPSessionStorePoolName((String)handlerCtx.getInputValue("HttpSessionStore"));
            webConfig.setPersistenceStoreHealthCheckEnabled(((Boolean)handlerCtx.getInputValue("PersistenceHealthCheck")).booleanValue());
            AMXUtil.editProperties(handlerCtx, (PropertiesAccess)webConfig);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getWebAvailabilityLists(HandlerContext handlerCtx) {
        EEPersistenceTypeResolver resolver = new EEPersistenceTypeResolver();
        List persistenceList = resolver.getWebDefinedPersistenceTypes();
        String[] persistenceTypes = persistenceList.toArray(new String[persistenceList.size()]);
        handlerCtx.setOutputValue("PersistenceTypeList", (Object)ConfigurationHandlers.getOptions(persistenceTypes));
        handlerCtx.setOutputValue("PersistenceFrequencyList", (Object)ConfigurationHandlers.getOptions(persistenceFrequency));
        handlerCtx.setOutputValue("PersistenceScopeList", (Object)ConfigurationHandlers.getOptions(persistenceScope));
    }

    public static void getDefaultEjbAvailabilitySettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        EJBContainerAvailabilityConfig ejbConfig = config.getAvailabilityServiceConfig().getEJBContainerAvailabilityConfig();
        boolean availEnabled = Boolean.valueOf(ejbConfig.getDefaultValue("AvailabilityEnabled"));
        String haPersistenceType = ejbConfig.getDefaultValue("SFSBHAPersistenceType");
        String sfsbPersistenceType = ejbConfig.getDefaultValue("SFSBPersistenceType");
        String sfsbStoreName = ejbConfig.getDefaultValue("SFSBStorePoolName");
        handlerCtx.setOutputValue("AvailabilityEnabled", (Object)availEnabled);
        handlerCtx.setOutputValue("HAPersistenceType", (Object)haPersistenceType);
        handlerCtx.setOutputValue("SFSBPersistenceType", (Object)sfsbPersistenceType);
        handlerCtx.setOutputValue("SFSBStoreName", (Object)sfsbStoreName);
    }

    public static void getEjbAvailabilitySettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        EJBContainerAvailabilityConfig ejbConfig = config.getAvailabilityServiceConfig().getEJBContainerAvailabilityConfig();
        boolean availEnabled = ejbConfig.getAvailabilityEnabled();
        String haPersistenceType = ejbConfig.getSFSBHAPersistenceType();
        String sfsbPersistenceType = ejbConfig.getSFSBPersistenceType();
        String sfsbStoreName = ejbConfig.getSFSBStorePoolName();
        Map props = ejbConfig.getProperties();
        handlerCtx.setOutputValue("AvailabilityEnabled", (Object)availEnabled);
        handlerCtx.setOutputValue("HAPersistenceType", (Object)haPersistenceType);
        handlerCtx.setOutputValue("SFSBPersistenceType", (Object)sfsbPersistenceType);
        handlerCtx.setOutputValue("SFSBStoreName", (Object)sfsbStoreName);
        handlerCtx.setOutputValue("Properties", (Object)props);
    }

    public static void saveEjbAvailabilitySettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            EJBContainerAvailabilityConfig ejbConfig = config.getAvailabilityServiceConfig().getEJBContainerAvailabilityConfig();
            ejbConfig.setAvailabilityEnabled(((Boolean)handlerCtx.getInputValue("AvailabilityEnabled")).booleanValue());
            ejbConfig.setSFSBHAPersistenceType((String)handlerCtx.getInputValue("HAPersistenceType"));
            ejbConfig.setSFSBPersistenceType((String)handlerCtx.getInputValue("SFSBPersistenceType"));
            ejbConfig.setSFSBStorePoolName((String)handlerCtx.getInputValue("SFSBStoreName"));
            AMXUtil.editProperties(handlerCtx, (PropertiesAccess)ejbConfig);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getEjbAvailabilityLists(HandlerContext handlerCtx) {
        EEPersistenceTypeResolver resolver = new EEPersistenceTypeResolver();
        List persistenceList = resolver.getEjbDefinedPersistenceTypes();
        String[] persistenceTypes = persistenceList.toArray(new String[persistenceList.size()]);
        handlerCtx.setOutputValue("PersistenceTypeList", (Object)ConfigurationHandlers.getOptions(persistenceTypes));
    }

    public static void getDefaultJmsAvailabilitySettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        JMSAvailabilityConfig jmsConfig = config.getAvailabilityServiceConfig().getJMSAvailabilityConfig();
        boolean availEnabled = Boolean.valueOf(jmsConfig.getDefaultValue("AvailabilityEnabled"));
        String storePoolName = jmsConfig.getDefaultValue("MQStorePoolName");
        handlerCtx.setOutputValue("AvailabilityEnabled", (Object)availEnabled);
        handlerCtx.setOutputValue("StorePoolName", (Object)storePoolName);
    }

    public static void getJmsAvailabilitySettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        JMSAvailabilityConfig jmsConfig = config.getAvailabilityServiceConfig().getJMSAvailabilityConfig();
        boolean availEnabled = jmsConfig.getAvailabilityEnabled();
        String storePoolName = jmsConfig.getMQStorePoolName();
        Map props = jmsConfig.getProperties();
        handlerCtx.setOutputValue("AvailabilityEnabled", (Object)availEnabled);
        handlerCtx.setOutputValue("StorePoolName", (Object)storePoolName);
        handlerCtx.setOutputValue("Properties", (Object)props);
    }

    public static void saveJmsAvailabilitySettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            JMSAvailabilityConfig jmsConfig = config.getAvailabilityServiceConfig().getJMSAvailabilityConfig();
            jmsConfig.setAvailabilityEnabled(((Boolean)handlerCtx.getInputValue("AvailabilityEnabled")).booleanValue());
            jmsConfig.setMQStorePoolName((String)handlerCtx.getInputValue("StorePoolName"));
            AMXUtil.editProperties(handlerCtx, (PropertiesAccess)jmsConfig);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static SelectItem[] getOptions(String[] values) {
        SelectItem[] options = (SelectItem[])Array.newInstance(SUN_OPTION_CLASS, values.length);
        for (int i = 0; i < values.length; ++i) {
            SelectItem option;
            options[i] = option = ConfigurationHandlers.getSunOption(values[i], values[i]);
        }
        return options;
    }

    public static Option[] getOptionsArray(String[] values) {
        Option[] options = (Option[])Array.newInstance(SUN_OPTION_CLASS, values.length);
        for (int i = 0; i < values.length; ++i) {
            Option option;
            options[i] = option = ConfigurationHandlers.getOption(values[i], values[i]);
        }
        return options;
    }

    public static Option getOption(String value, String label) {
        try {
            return (Option)SUN_OPTION_CONSTRUCTOR.newInstance(value, label);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static SelectItem[] getOptions(String[] values, String[] labels) {
        SelectItem[] options = (SelectItem[])Array.newInstance(SUN_OPTION_CLASS, values.length);
        for (int i = 0; i < values.length; ++i) {
            SelectItem option;
            options[i] = option = ConfigurationHandlers.getSunOption(values[i], labels[i]);
        }
        return options;
    }

    public static SelectItem[] getModOptions(String[] values) {
        SelectItem[] options = (SelectItem[])Array.newInstance(SUN_OPTION_CLASS, values.length + 1);
        options[0] = ConfigurationHandlers.getSunOption("", "");
        for (int i = 0; i < values.length; ++i) {
            SelectItem option;
            options[i + 1] = option = ConfigurationHandlers.getSunOption(values[i], values[i]);
        }
        return options;
    }

    public static SelectItem getSunOption(String value, String label) {
        try {
            return (SelectItem)SUN_OPTION_CONSTRUCTOR.newInstance(value, label);
        }
        catch (Exception ex) {
            return null;
        }
    }

    static {
        try {
            SUN_OPTION_CLASS = Class.forName("com.sun.webui.jsf.model.Option");
            SUN_OPTION_CONSTRUCTOR = SUN_OPTION_CLASS.getConstructor(Object.class, String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        providerTypes = new String[]{"client", "server", "client-server"};
        authSource = new String[]{"sender", "content"};
        authRecipient = new String[]{"before-content", "after-content"};
        messageLayers = new String[]{"SOAP", "HttpServlet"};
        persistenceFrequency = new String[]{"time-based", "web-method"};
        persistenceScope = new String[]{"session", "modified-session", "modified-attribute"};
        vsSkipPropsList = new ArrayList();
        httpServiceSkipPropsList = new ArrayList();
        vsSkipPropsList.add("accesslog");
        vsSkipPropsList.add("docroot");
        vsSkipPropsList.add("sso-enabled");
        vsSkipPropsList.add("sso-enabled");
        vsSkipPropsList.add("accessLogBufferSize");
        vsSkipPropsList.add("accessLogWriteInterval");
        vsSkipPropsList.add("accessLoggingEnabled");
        httpServiceSkipPropsList.add("accessLogBufferSize");
        httpServiceSkipPropsList.add("accessLogWriteInterval");
        httpServiceSkipPropsList.add("accessLoggingEnabled");
    }
}

