/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsservice.JMSPacket;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jms.ra.ConvertValue;
import com.sun.messaging.jms.ra.DirectPacket;
import com.sun.messaging.jms.ra.DirectSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;

public class DirectMapPacket
extends DirectPacket
implements MapMessage {
    private HashMap<String, Object> hashMap = new HashMap();
    private byte[] messageBody = null;
    private ByteArrayOutputStream byteArrayOutputStream = null;
    private ObjectOutputStream objectOutputStream = null;
    private ByteArrayInputStream byteArrayInputStream = null;
    private ObjectInputStream objectInputStream = null;
    private static final transient String _className = "com.sun.messaging.jms.ra.DirectMapPacket";

    public DirectMapPacket(DirectSession directSession, JMSService jMSService) throws JMSException {
        super(directSession, jMSService);
        if (_logFINE) {
            Object[] objectArray = new Object[]{directSession, jMSService};
            _loggerOC.entering(_className, "constructor()", objectArray);
        }
    }

    public DirectMapPacket(JMSPacket jMSPacket, long l, DirectSession directSession, JMSService jMSService) throws JMSException {
        super(jMSPacket, l, directSession, jMSService);
        this._getMessageBodyFromPacket();
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.hashMap.clear();
    }

    public boolean getBoolean(String string) throws JMSException {
        return ConvertValue.toBoolean(this.hashMap.get(string));
    }

    public byte getByte(String string) throws JMSException {
        return ConvertValue.toByte(this.hashMap.get(string));
    }

    public byte[] getBytes(String string) throws JMSException {
        Object object = this.hashMap.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        String string2 = "MQJMSRA_DM4001: :MapMessage:getBytes[]:Key=" + string + ":cannot be rea as a byte array.";
        _loggerJM.severe(string2);
        MessageFormatException messageFormatException = new MessageFormatException(string2);
        throw messageFormatException;
    }

    public char getChar(String string) throws JMSException {
        return ConvertValue.toChar(this.hashMap.get(string));
    }

    public double getDouble(String string) throws JMSException {
        return ConvertValue.toDouble(this.hashMap.get(string));
    }

    public float getFloat(String string) throws JMSException {
        return ConvertValue.toFloat(this.hashMap.get(string));
    }

    public int getInt(String string) throws JMSException {
        return ConvertValue.toInt(this.hashMap.get(string));
    }

    public long getLong(String string) throws JMSException {
        return ConvertValue.toLong(this.hashMap.get(string));
    }

    public Enumeration getMapNames() throws JMSException {
        return Collections.enumeration(this.hashMap.keySet());
    }

    public Object getObject(String string) throws JMSException {
        return this.hashMap.get(string);
    }

    public short getShort(String string) throws JMSException {
        return ConvertValue.toShort(this.hashMap.get(string));
    }

    public String getString(String string) throws JMSException {
        return ConvertValue.toString(this.hashMap.get(string));
    }

    public boolean itemExists(String string) throws JMSException {
        return this.hashMap.containsKey(string);
    }

    public void setBoolean(String string, boolean bl) throws JMSException {
        String string2 = "setBoolean()";
        this._checkValidKeyAndReadOnlyBody(string2, string);
        this.hashMap.put(string, bl);
    }

    public void setByte(String string, byte by) throws JMSException {
        String string2 = "setByte()";
        this._checkValidKeyAndReadOnlyBody(string2, string);
        this.hashMap.put(string, by);
    }

    public void setBytes(String string, byte[] byArray) throws JMSException {
        String string2 = "setBytes(byte[])";
        this._checkValidKeyAndReadOnlyBody(string2, string);
        this.hashMap.put(string, byArray);
    }

    public void setBytes(String string, byte[] byArray, int n, int n2) throws JMSException {
        String string2 = "setBytes(byte[], offset, length)";
        this._checkValidKeyAndReadOnlyBody(string2, string);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.hashMap.put(string, byArray2);
    }

    public void setChar(String string, char c) throws JMSException {
        String string2 = "setChar()";
        this._checkValidKeyAndReadOnlyBody(string2, string);
        this.hashMap.put(string, Character.valueOf(c));
    }

    public void setDouble(String string, double d) throws JMSException {
        String string2 = "setDouble()";
        this._checkValidKeyAndReadOnlyBody(string2, string);
        this.hashMap.put(string, d);
    }

    public void setFloat(String string, float f) throws JMSException {
        String string2 = "setFloat()";
        this._checkValidKeyAndReadOnlyBody(string2, string);
        this.hashMap.put(string, Float.valueOf(f));
    }

    public void setInt(String string, int n) throws JMSException {
        String string2 = "setInt()";
        this._checkValidKeyAndReadOnlyBody(string2, string);
        this.hashMap.put(string, n);
    }

    public void setLong(String string, long l) throws JMSException {
        String string2 = "setLong()";
        this._checkValidKeyAndReadOnlyBody(string2, string);
        this.hashMap.put(string, l);
    }

    public void setObject(String string, Object object) throws JMSException {
        String string2 = "setLong()";
        this._checkValidKeyAndReadOnlyBody(string2, string);
        this._checkValidObjectType(object, string);
        this.hashMap.put(string, object);
    }

    public void setShort(String string, short s) throws JMSException {
        String string2 = "setShort()";
        this._checkValidKeyAndReadOnlyBody(string2, string);
        this.hashMap.put(string, s);
    }

    public void setString(String string, String string2) throws JMSException {
        String string3 = "setString()";
        this._checkValidKeyAndReadOnlyBody(string3, string);
        this.hashMap.put(string, string2);
    }

    protected void _setDefaultValues() throws JMSException {
        super._setDefaultValues();
        this.pkt.setPacketType(3);
    }

    protected void _setBodyToPacket() throws JMSException {
        try {
            this.byteArrayOutputStream = new ByteArrayOutputStream();
            this.objectOutputStream = new ObjectOutputStream(this.byteArrayOutputStream);
            this.objectOutputStream.writeObject(this.hashMap);
            this.objectOutputStream.flush();
            this.messageBody = this.byteArrayOutputStream.toByteArray();
            this.objectOutputStream.close();
            this.byteArrayOutputStream.close();
            super._setMessageBodyOfPacket(this.messageBody);
        }
        catch (Exception exception) {
            String string = "MQJMSRA_DM4001: :MapMessage:Exception setting MapMessage body on send:" + exception.getMessage();
            _loggerJM.severe(string);
            JMSException jMSException = new JMSException(string);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
    }

    protected void _getMessageBodyFromPacket() throws JMSException {
        try {
            this.messageBody = super._getMessageBodyByteArray();
            this.byteArrayInputStream = new ByteArrayInputStream(this.messageBody);
            this.objectInputStream = new ObjectInputStream(this.byteArrayInputStream);
            this.hashMap = (HashMap)this.objectInputStream.readObject();
        }
        catch (Exception exception) {
            String string = "MQJMSRA_DM4001: :MapMessage:Exception deserializing on deliver:" + exception.getMessage();
            _loggerJM.severe(string);
            JMSException jMSException = new JMSException(string);
            jMSException.initCause((Throwable)exception);
            throw jMSException;
        }
    }

    private void _checkValidKeyAndReadOnlyBody(String string, String string2) throws IllegalArgumentException, JMSException {
        this.checkForReadOnlyMessageBody(string);
        if (string2 == null || "".equals(string2)) {
            throw new IllegalArgumentException("MapMessage:" + string + ":name parameter is not allowed to be NULL or empty");
        }
    }

    private void _checkValidObjectType(Object object, String string) throws MessageFormatException {
        if (!(object != null && (object instanceof Boolean || object instanceof Byte || object instanceof Short || object instanceof Character || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof String || object instanceof byte[]))) {
            String string2 = "MQJMSRA_DM4001: :MapMessage:setObject():Invalid type:name=" + string + ":type=" + (object == null ? "NULL" : object.getClass().getName());
            _loggerJM.severe(string2);
            MessageFormatException messageFormatException = new MessageFormatException(string2);
            throw messageFormatException;
        }
    }
}

