/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver;

import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerNotification;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQDirectService;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsservice.BrokerEventListener;
import com.sun.messaging.jmq.jmsservice.JMSBroker;
import com.sun.messaging.jmq.jmsservice.JMSService;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class BrokerProcess
implements JMSBroker {
    private static final String DEFAULT_DIRECTMODE_SERVICE_NAME = "jmsdirect";
    Broker b = Broker.getBroker();
    private static BrokerProcess bp = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BrokerProcess getBrokerProcess() {
        Class<BrokerProcess> clazz = BrokerProcess.class;
        synchronized (BrokerProcess.class) {
            if (bp == null) {
                bp = new BrokerProcess();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return bp;
        }
    }

    public static Properties convertArgs(String[] stringArray) throws IllegalArgumentException {
        Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("-varhome")) {
                properties.setProperty("imq.varhome", stringArray[i + 1]);
                ++i;
                continue;
            }
            if (string.equals("-imqhome")) {
                properties.setProperty("imq.home", stringArray[i + 1]);
                ++i;
                continue;
            }
            if (!string.equals("-libhome")) continue;
            properties.setProperty("imq.libhome", stringArray[i + 1]);
            ++i;
        }
        Globals.pathinit(properties);
        return BrokerProcess.getBrokerProcess().b.convertArgs(stringArray);
    }

    public Properties parseArgs(String[] stringArray) throws IllegalArgumentException {
        return BrokerProcess.convertArgs(stringArray);
    }

    public static String usage() {
        return BrokerProcess.getBrokerProcess().b.usage();
    }

    public boolean isRunning() {
        return true;
    }

    public int start(boolean bl, Properties properties, BrokerNotification brokerNotification) throws OutOfMemoryError, IllegalStateException, IllegalArgumentException {
        return BrokerProcess.getBrokerProcess().b.start(bl, properties, brokerNotification);
    }

    public int start(boolean bl, Properties properties, BrokerEventListener brokerEventListener) throws OutOfMemoryError, IllegalStateException, IllegalArgumentException {
        return BrokerProcess.getBrokerProcess().b.start(bl, properties, brokerEventListener);
    }

    public int init(boolean bl, Properties properties, BrokerNotification brokerNotification) throws OutOfMemoryError, IllegalStateException, IllegalArgumentException {
        return BrokerProcess.getBrokerProcess().b.init(bl, properties, brokerNotification);
    }

    public int init(boolean bl, Properties properties, BrokerEventListener brokerEventListener) throws OutOfMemoryError, IllegalStateException, IllegalArgumentException {
        return BrokerProcess.getBrokerProcess().b.init(bl, properties, brokerEventListener);
    }

    public void stop(boolean bl) throws IllegalStateException {
        Broker.destroyBroker(bl);
        this.b = null;
        bp = null;
    }

    public JMSService getJMSService() throws IllegalStateException {
        ServiceManager serviceManager = Globals.getServiceManager();
        JMSService jMSService = this.getJMSService(DEFAULT_DIRECTMODE_SERVICE_NAME);
        if (jMSService != null) {
            return jMSService;
        }
        List list = serviceManager.getAllServiceNames();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            jMSService = this.getJMSService((String)iterator.next());
            if (jMSService == null) continue;
            return jMSService;
        }
        return null;
    }

    public JMSService getJMSService(String string) throws IllegalStateException {
        ServiceManager serviceManager = Globals.getServiceManager();
        if (serviceManager == null) {
            return null;
        }
        Service service = serviceManager.getService(string);
        if (service == null) {
            return null;
        }
        if (!(service instanceof IMQService)) {
            return null;
        }
        IMQService iMQService = (IMQService)service;
        if (!iMQService.isDirect()) {
            return null;
        }
        if (!(iMQService instanceof IMQDirectService)) {
            return null;
        }
        IMQDirectService iMQDirectService = (IMQDirectService)iMQService;
        return iMQDirectService;
    }

    public static void main(String[] stringArray) {
        try {
            BrokerProcess brokerProcess = BrokerProcess.getBrokerProcess();
            BrokerNotification brokerNotification = new BrokerNotification(){

                public boolean exitRequested(int n, String string, Throwable throwable) {
                    System.out.println("EXIT REQUESTED " + n);
                    return false;
                }

                public void brokerShutdown() {
                    System.err.println("XXX should never be called");
                }

                public void brokerStarted() {
                    System.err.println("XXX hey broker started");
                }
            };
            String[] stringArray2 = new String[stringArray.length + 4];
            int n = 0;
            for (n = 0; n < stringArray.length; ++n) {
                stringArray2[n] = stringArray[n];
            }
            stringArray2[n++] = "-varhome";
            stringArray2[n++] = "../../../solaris/opt/var";
            stringArray2[n++] = "-imqhome";
            stringArray2[n++] = "../../../solaris/opt/";
            Properties properties = BrokerProcess.convertArgs(stringArray2);
            System.err.println("HEY INIT");
            int n2 = brokerProcess.init(true, properties, brokerNotification);
            System.err.println("HEY START");
            n2 = brokerProcess.start(true, properties, brokerNotification);
            System.err.println("HEY STARTED");
            Thread.currentThread();
            Thread.sleep(10000L);
            System.out.println("HEY SHUTTING DOWN");
            brokerProcess.stop(true);
            System.out.println("Sleeping");
            Thread.currentThread();
            Thread.sleep(10000L);
            System.out.println("Restarting");
            n2 = brokerProcess.start(true, properties, (BrokerNotification)null);
            System.out.println("Sleeping");
            Thread.currentThread();
            Thread.sleep(10000L);
            brokerProcess.stop(true);
            System.out.println("HEY SHUTTING DOWN");
            System.out.println("Sleeping");
            Thread.currentThread();
            Thread.sleep(60000L);
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

