/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.VRFileWarning;
import com.sun.messaging.jmq.io.VRecord;
import com.sun.messaging.jmq.resources.SharedResources;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class VRFile {
    private static boolean DEBUG = Boolean.getBoolean("vrfile.debug");
    public static final short FILE_VERSION_1 = 1;
    public static final int FILE_HEADER_SIZE_1 = 16;
    public static final short STATE_LAST_1 = 0;
    public static final short STATE_FREE_1 = 1;
    public static final short STATE_ALLOCATED_1 = 2;
    public static final short FILE_VERSION = 2;
    public static final int FILE_HEADER_SIZE = 24;
    public static final int FILE_MAGIC_NUMBER = 0x5555AAAA;
    public static final short RESERVED_SHORT = 0;
    public static final int RECORD_HEADER_SIZE = 12;
    public static final int RECORD_MAGIC_NUMBER = -1431677611;
    public static final int RECORD_CAPACITY_OFFSET = 4;
    public static final int RECORD_STATE_OFFSET = 8;
    public static final int RECORD_COOKIE_OFFSET = 10;
    public static final short STATE_CUTOFF = -1;
    public static final short STATE_BAD_MAGIC_NUMBER = -2;
    public static final short STATE_BAD_STATE = -3;
    public static final short STATE_BAD_CAPACITY_TOO_SMALL = -4;
    public static final short STATE_BAD_NEXT_MAGIC_NUMBER = -5;
    public static final short STATE_BAD_CAPACITY = -6;
    public static final short STATE_BAD_TRUNCATED_HEADER = -7;
    public static final short STATE_FREE = 1;
    public static final short STATE_ALLOCATED = 2;
    public static final short STATE_LAST = 3;
    public static final short STATE_PROPERTIES = 4;
    protected static final short _STATE_LAST = 1001;
    public static final int SHORT_LEN = 2;
    public static final int INT_LEN = 4;
    public static final int LONG_LEN = 8;
    public static final int DEFAULT_BLOCK_SIZE = 128;
    public static final long DEFAULT_INITIAL_FILE_SIZE = 0xA00000L;
    public static final long MINIMUM_INITIAL_FILE_SIZE = 36L;
    public static final float DEFAULT_GROWTH_FACTOR = 0.5f;
    public static final float DEFAULT_THRESHOLD_FACTOR = 0.0f;
    public static final long DEFAULT_THRESHOLD = 0L;
    protected long threshold = 0L;
    protected float thresholdFactor = 0.0f;
    protected int blockSize = 128;
    protected long initialFileSize = 0xA00000L;
    protected float growthFactor = 0.5f;
    protected boolean safe = false;
    protected short fileversion = (short)2;
    protected long fileSize = 0L;
    protected long filePointer = 0L;
    protected File backingFile = null;
    protected HashSet allocated = null;
    protected long bytesAllocated = 0L;
    protected TreeMap freeMap = null;
    protected int numFree = 0;
    protected long cookie = 0L;
    protected byte[] lastRecordHeader = null;
    protected boolean opened = false;
    protected VRFileWarning warning = null;
    protected int hits = 0;
    protected int misses = 0;

    protected VRFile(File file, long l) {
        if (DEBUG) {
            System.out.println("backing file: " + file);
        }
        this.backingFile = file;
        this.initialFileSize = l < 36L ? 36L : l;
        this.lastRecordHeader = new byte[12];
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.lastRecordHeader);
        byteBuffer.putInt(-1431677611);
        byteBuffer.putInt(0);
        byteBuffer.putShort((short)3);
        byteBuffer.putShort((short)0);
        this.allocated = new HashSet(1000);
        this.freeMap = new TreeMap();
    }

    public File getFile() {
        return this.backingFile;
    }

    public short getFileVersion() {
        this.checkOpen();
        return this.fileversion;
    }

    public abstract void open() throws IOException, VRFileWarning;

    public abstract void close();

    protected void reset() {
        this.allocated.clear();
        this.freeMap.clear();
        this.opened = false;
        this.numFree = 0;
        this.bytesAllocated = 0L;
        this.hits = 0;
        this.misses = 0;
    }

    public void setSafe(boolean bl) {
        this.safe = bl;
    }

    public boolean getSafe() {
        return this.safe;
    }

    public void setBlockSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Block size must be postive. Illegal block size: " + n);
        }
        this.blockSize = n;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setGrowthFactor(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Growth factor must be postive. Illegal growth factor: " + f);
        }
        this.growthFactor = f;
    }

    public float getGrowthFactor() {
        return this.growthFactor;
    }

    public int getNRecords() {
        this.checkOpen();
        return this.allocated.size();
    }

    public int getNFreeRecords() {
        this.checkOpen();
        return this.numFree;
    }

    public long getBytesUsed() {
        this.checkOpen();
        return this.bytesAllocated;
    }

    public long getBytesFree() {
        this.checkOpen();
        int n = this.fileversion == 2 ? 24 : 16;
        return this.filePointer - this.getBytesUsed() - (long)n;
    }

    public int getHits() {
        return this.hits;
    }

    public int getMisses() {
        return this.misses;
    }

    public float getHitRatio() {
        if (this.hits + this.misses == 0) {
            return 0.0f;
        }
        return (float)((double)this.hits * 1.0) / (float)(this.hits + this.misses);
    }

    public float getFragmentationRatio() {
        throw new UnsupportedOperationException();
    }

    public float getUtilizationRatio() {
        int n = this.fileversion == 2 ? 24 : 16;
        long l = this.filePointer - (long)n;
        if (l == 0L) {
            return 1.0f;
        }
        float f = (float)((double)this.getBytesUsed() * 1.0) / (float)l;
        return f;
    }

    public abstract int[] getMap() throws IOException;

    public abstract VRecord allocate(int var1) throws IOException;

    protected VRecord findFreeRecord(int n) {
        Integer n2 = new Integer(n);
        LinkedList linkedList = (LinkedList)this.freeMap.get(n2);
        if (linkedList != null && !linkedList.isEmpty()) {
            return (VRecord)linkedList.removeLast();
        }
        SortedMap sortedMap = this.freeMap.tailMap(n2);
        for (Map.Entry entry : sortedMap.entrySet()) {
            linkedList = (LinkedList)entry.getValue();
            if (linkedList == null || linkedList.isEmpty()) continue;
            return (VRecord)linkedList.removeLast();
        }
        return null;
    }

    public synchronized void free(VRecord vRecord) throws IOException {
        boolean bl;
        this.checkOpenAndWrite();
        if (DEBUG) {
            System.out.println("free record:" + vRecord);
        }
        if (!(bl = this.allocated.remove(vRecord))) {
            String string = this.backingFile.toString() + ":" + vRecord;
            throw new IllegalStateException(SharedResources.getResources().getString("S3016", string));
        }
        this.bytesAllocated -= (long)vRecord.getCapacity();
        this.putFreeList(vRecord, false);
        try {
            vRecord.free();
            if (this.safe) {
                vRecord.force();
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            String string = "Failed to free vrecord:" + this.backingFile.toString() + ":" + vRecord + ":";
            throw new IOException(string + bufferOverflowException.toString());
        }
    }

    public synchronized Set getRecords() {
        this.checkOpen();
        return (Set)this.allocated.clone();
    }

    public synchronized void compact() throws IOException, VRFileWarning {
        File file;
        if (this.opened) {
            throw new IllegalStateException(SharedResources.getResources().getString("S3009"));
        }
        if (this.fileversion < 2) {
            throw new IllegalStateException(this.backingFile + "Cannot compact a file of version " + this.fileversion);
        }
        if (!this.backingFile.exists() || this.backingFile.length() == 0L) {
            return;
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.backingFile, "r");
        byte[] byArray = new byte[24];
        int n = randomAccessFile.read(byArray);
        if (n != 24) {
            throw new IOException(SharedResources.getResources().getString("S3017", this.backingFile, new Integer(n)));
        }
        this.checkFileHeader(ByteBuffer.wrap(byArray));
        File file2 = new File(this.backingFile.getParentFile(), this.backingFile.getName() + ".temp");
        RandomAccessFile randomAccessFile2 = new RandomAccessFile(file2, "rw");
        randomAccessFile2.write(byArray);
        int n2 = 0;
        int n3 = 0;
        long l = randomAccessFile.length();
        long l2 = randomAccessFile.getFilePointer();
        boolean bl = false;
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[12]);
        while (!bl) {
            int n4 = 0;
            short s = this.getRecordState(randomAccessFile, byteBuffer, l2, l);
            switch (s) {
                case 2: 
                case 4: {
                    n4 = byteBuffer.getInt(4);
                    byte[] byArray2 = new byte[n4];
                    randomAccessFile.seek(l2);
                    randomAccessFile.read(byArray2);
                    randomAccessFile2.write(byArray2);
                    ++n2;
                    break;
                }
                case 1: {
                    n4 = byteBuffer.getInt(4);
                    ++n3;
                    break;
                }
                case 1001: {
                    this.writeLastRecordHeader(randomAccessFile2);
                    bl = true;
                    break;
                }
                case -7: 
                case -6: 
                case -5: 
                case -4: 
                case -3: 
                case -2: {
                    long l3 = this.findGoodRecord(randomAccessFile, l2, l);
                    if (l3 == l) {
                        this.writeLastRecordHeader(randomAccessFile2);
                        bl = true;
                    } else {
                        l2 = l3;
                    }
                    VRFile.addCompactWarning(this.getNewWarning(), s, l2, byteBuffer, l3);
                }
            }
            randomAccessFile.seek(l2 += (long)n4);
        }
        randomAccessFile2.close();
        randomAccessFile.close();
        if (DEBUG) {
            System.out.println("compact(): size of original file is " + this.backingFile.length());
            System.out.println("compact(): size of new file is " + file2.length());
        }
        if (!this.backingFile.renameTo(file = new File(this.backingFile.getParentFile(), this.backingFile.getName() + ".bak"))) {
            throw new IOException(SharedResources.getResources().getString("S3011", this.backingFile, file));
        }
        if (!file2.renameTo(this.backingFile)) {
            throw new IOException(SharedResources.getResources().getString("S3012", file2, this.backingFile));
        }
        if (!file.delete()) {
            throw new IOException(SharedResources.getResources().getString("S3013", file));
        }
        this.hits = 0;
        this.misses = 0;
        if (DEBUG) {
            System.out.println("compact(): number of records written is " + n2);
            System.out.println("compact(): number of free records skipped is " + n3);
        }
        if (this.warning != null) {
            throw this.warning;
        }
    }

    protected short adjustRecordState(short s, short s2) {
        if (s == 1 ? s2 < 0 || s2 > 2 : s2 < 1 || s2 > 4) {
            return -3;
        }
        if (s == 1 && s2 == 0) {
            return 1001;
        }
        if (s == 2 && s2 == 3) {
            return 1001;
        }
        return s2;
    }

    short getRecordState(RandomAccessFile randomAccessFile, ByteBuffer byteBuffer, long l, long l2) throws IOException {
        int n = randomAccessFile.read(byteBuffer.array());
        if (n != 12) {
            return -7;
        }
        byteBuffer.rewind();
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        short s = this.adjustRecordState(this.fileversion, byteBuffer.getShort());
        if (n2 != -1431677611) {
            if (DEBUG) {
                System.out.println("BAD RECORD(" + l + "): BAD MAGIC NUMER:" + n2);
            }
            return -2;
        }
        if (s == -3) {
            return s;
        }
        if (s == 1001) {
            if (n3 != 0) {
                if (DEBUG) {
                    System.out.println("BAD RECORD(" + l + "): LAST RECORD WOTH CAP=" + n3);
                }
                return -6;
            }
            return s;
        }
        if (n3 <= 12) {
            if (DEBUG) {
                System.out.println("BAD RECORD(" + l + "): CAP<RECORD_HEADER:" + n3);
            }
            return -4;
        }
        if (l + (long)n3 <= l2 - 4L) {
            randomAccessFile.seek(l + (long)n3);
            n2 = randomAccessFile.readInt();
            randomAccessFile.seek(l);
            if (n2 != -1431677611) {
                return -5;
            }
            return s;
        }
        return -6;
    }

    public abstract void force() throws IOException;

    public synchronized void setCookie(long l) throws IOException {
        this.cookie = l;
    }

    public synchronized long getCookie() {
        return this.cookie;
    }

    public abstract void clear(boolean var1) throws IOException;

    public VRFileWarning getWarning() {
        return this.warning;
    }

    protected void writeLastRecordHeader(RandomAccessFile randomAccessFile) throws IOException {
        if (randomAccessFile.length() < this.initialFileSize) {
            randomAccessFile.setLength(this.initialFileSize);
        }
        randomAccessFile.write(this.lastRecordHeader);
    }

    protected void writeFileHeader(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.putInt(0x5555AAAA);
        byteBuffer.putShort((short)2);
        byteBuffer.putShort((short)0);
        byteBuffer.putLong(this.cookie);
        byteBuffer.putLong(0L);
    }

    protected void writeFileHeader(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(0x5555AAAA);
        dataOutput.writeShort(2);
        dataOutput.writeShort(0);
        dataOutput.writeLong(this.cookie);
        dataOutput.writeLong(0L);
    }

    protected short checkFileHeader(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.getInt();
        if (n != 0x5555AAAA) {
            Object[] objectArray = new Object[]{this.backingFile, Integer.toString(n), Integer.toString(0x5555AAAA)};
            throw new StreamCorruptedException(SharedResources.getResources().getString("S3014", objectArray));
        }
        this.fileversion = byteBuffer.getShort();
        if (this.fileversion != 1 && this.fileversion != 2) {
            Object[] objectArray = new Object[]{this.backingFile, Short.toString(this.fileversion), Short.toString((short)2)};
            throw new IOException(SharedResources.getResources().getString("S3015", objectArray));
        }
        byteBuffer.getShort();
        long l = byteBuffer.getLong();
        return this.fileversion;
    }

    protected void doForce() throws IOException {
        if (this.safe) {
            this.force();
        }
    }

    protected void putAllocatedList(VRecord vRecord) {
        this.allocated.add(vRecord);
        this.bytesAllocated += (long)vRecord.getCapacity();
    }

    protected void putFreeList(VRecord vRecord, boolean bl) {
        Integer n = new Integer(vRecord.getCapacity());
        LinkedList<VRecord> linkedList = (LinkedList<VRecord>)this.freeMap.get(n);
        if (linkedList == null) {
            linkedList = new LinkedList<VRecord>();
            this.freeMap.put(n, linkedList);
        }
        if (bl) {
            linkedList.addFirst(vRecord);
        } else {
            linkedList.add(vRecord);
        }
        ++this.numFree;
    }

    protected long findGoodRecord(RandomAccessFile randomAccessFile, long l, long l2) {
        while (l < l2) {
            try {
                randomAccessFile.seek(l);
                int n = randomAccessFile.readInt();
                if (n == -1431677611) {
                    int n2 = randomAccessFile.readInt();
                    short s = this.adjustRecordState(this.fileversion, randomAccessFile.readShort());
                    long l3 = l + (long)n2;
                    if (s != -3 && (s == 1001 || n2 > 12)) {
                        if (s == 1001) {
                            if (n2 == 0) {
                                return l;
                            }
                        } else if (l3 < l2) {
                            randomAccessFile.seek(l3);
                            n = randomAccessFile.readInt();
                            if (n == -1431677611) {
                                return l;
                            }
                        }
                    }
                }
                l += 4L;
            }
            catch (IOException iOException) {
                l = l2;
            }
        }
        return l;
    }

    protected void checkOpen() {
        if (!this.opened) {
            throw new IllegalStateException(SharedResources.getResources().getString("S3010"));
        }
    }

    protected void checkOpenAndWrite() {
        if (!this.opened) {
            throw new IllegalStateException(SharedResources.getResources().getString("S3010"));
        }
        if (this.fileversion < 2) {
            throw new IllegalStateException(this.backingFile + "Cannot write to a file of version " + this.fileversion);
        }
    }

    VRFileWarning getNewWarning() {
        if (this.warning == null) {
            this.warning = new VRFileWarning("Found bad record while loading " + this.backingFile + "(length=" + this.backingFile.length() + ")");
        }
        return this.warning;
    }

    static StringBuffer getWarningPrefix(short s, long l, ByteBuffer byteBuffer) {
        StringBuffer stringBuffer = new StringBuffer("\n    Bad record found:");
        stringBuffer.append("\n    =================");
        stringBuffer.append("\n      At file position: \n        " + l);
        if (s != -7) {
            byteBuffer.rewind();
            stringBuffer.append("\n      Record header loaded:");
            stringBuffer.append("\n        magic number: " + byteBuffer.getInt());
            stringBuffer.append("\n        capacity: " + byteBuffer.getInt());
            stringBuffer.append("\n        state: " + byteBuffer.getShort());
        }
        stringBuffer.append("\n      Reason: " + VRFile.getReason(s));
        return stringBuffer;
    }

    static VRFileWarning addCompactWarning(VRFileWarning vRFileWarning, short s, long l, ByteBuffer byteBuffer, long l2) {
        StringBuffer stringBuffer = VRFile.getWarningPrefix(s, l, byteBuffer);
        stringBuffer.append("\n      Skipped to:" + l2);
        vRFileWarning.addWarning(stringBuffer.toString());
        return vRFileWarning;
    }

    static VRFileWarning addWarning(VRFileWarning vRFileWarning, short s, long l, ByteBuffer byteBuffer, VRecord vRecord) {
        StringBuffer stringBuffer = VRFile.getWarningPrefix(s, l, byteBuffer);
        if (vRecord == null) {
            stringBuffer.append("\n      Resolution:\n        Could not find any valid records beyond this file position.\n        Any data stored after this position is lost.");
        } else {
            long l2 = l + (long)vRecord.getCapacity();
            stringBuffer.append("\n      Resolution:\n        A valid record is found at file position " + l2 + "." + "\n        The block between " + l + " and " + l2 + "\n        will be returned to the free record pool." + "\n        Any data stored between them is lost.");
        }
        vRFileWarning.addWarning(stringBuffer.toString());
        return vRFileWarning;
    }

    static String getReason(short s) {
        switch (s) {
            case -2: {
                return "\n        bad magic number, expected -1431677611";
            }
            case -5: {
                return "\n        bad magic number found at the next record, possibly due to\n        corrupted capacity or the next record was corrupted";
            }
            case -3: {
                return "\n        bad state";
            }
            case -6: {
                return "\n        bad capacity - either found non-zero capacity in the last record\n        header or the capacity makes the record span beyond the end of file";
            }
            case -4: {
                return "\n        bad capacity: it's less than the size of record header";
            }
            case -7: {
                return "\n        record header truncated; end of file reached";
            }
        }
        return "\n        unknown error code found: " + s;
    }

    public long getThreshold() {
        return this.threshold;
    }

    public void setThreshold(long l) {
        if (DEBUG) {
            System.out.println("VRFile.setThreshold: " + l);
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Threshold must be postive. Illegal threshold: " + l);
        }
        this.threshold = l;
    }

    public float getThresholdFactor() {
        return this.thresholdFactor;
    }

    public void setThresholdFactor(float f) {
        if (DEBUG) {
            System.out.println("VRFile.setThresholdFactor: " + f);
        }
        if (f < 0.0f) {
            throw new IllegalArgumentException("Threshold factor must be postive. Illegal threshold factor: " + f);
        }
        this.thresholdFactor = f;
    }

    public boolean isThresholdReached() {
        if (this.threshold > 0L) {
            return this.threshold <= this.fileSize;
        }
        return false;
    }

    public void checkGrowthFactorSanity() throws IllegalStateException {
        if (this.threshold <= 0L || !(this.thresholdFactor > 0.0f)) {
            this.threshold = 0L;
            this.thresholdFactor = 0.0f;
            String string = "Illegal values. Both threshold and threshold_factor must be greater than zero. Broker will continue using default values.";
            throw new IllegalStateException(string);
        }
    }
}

