/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.enterprise.ee.web.sessmgmt.FederatedRequestProcessor;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationResponseRepositoryEntry;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationState;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ReplicationResponseRepository
implements Runnable {
    private static int _sleepIntervalSeconds = 10;
    private static ReplicationResponseRepository _soleInstance = new ReplicationResponseRepository();
    protected Thread thread = null;
    protected volatile boolean threadDone = false;
    protected String _threadName = "ReplicationResponseRepository";
    protected boolean started = false;
    private ConcurrentHashMap _repository = new ConcurrentHashMap();
    private ConcurrentLinkedQueue _queueForQueues = new ConcurrentLinkedQueue();
    private ConcurrentHashMap _federatedQueryRepository = new ConcurrentHashMap();

    public ConcurrentHashMap getRepository() {
        return this._repository;
    }

    public static LinkedBlockingQueue putEmptyQueueEntry(ReplicationState state) {
        ReplicationResponseRepository repos = ReplicationResponseRepository.getInstance();
        LinkedBlockingQueue aQueue = repos.getClearedQueueEntry((String)state.getId());
        repos.getRepository().put(state.getId(), new ReplicationResponseRepositoryEntry(aQueue));
        return aQueue;
    }

    public static FederatedRequestProcessor putWrappedEmptyQueueEntry(ReplicationState state, FederatedRequestProcessor aWrapper) {
        LinkedBlockingQueue aQueue = ReplicationResponseRepository.putEmptyQueueEntry(state);
        ReplicationResponseRepository repos = ReplicationResponseRepository.getInstance();
        repos.getFederatedQueryWrapperMap().put(state.getId(), aWrapper);
        return aWrapper;
    }

    private LinkedBlockingQueue getClearedQueueEntry(String id) {
        ReplicationResponseRepository repos = ReplicationResponseRepository.getInstance();
        ConcurrentHashMap reposMap = repos.getMap();
        ReplicationResponseRepositoryEntry entry = (ReplicationResponseRepositoryEntry)reposMap.get(id);
        if (entry == null) {
            return repos.getQueue();
        }
        LinkedBlockingQueue aQueue = entry.getQueue();
        this.removeEntry(id, entry);
        if (aQueue != null) {
            return aQueue;
        }
        return repos.getQueue();
    }

    private void removeEntry(String id, ReplicationResponseRepositoryEntry entry) {
        ReplicationResponseRepository repos = ReplicationResponseRepository.getInstance();
        ConcurrentHashMap reposMap = repos.getMap();
        entry.clean();
        reposMap.remove(id);
    }

    public static void removeEntry(String id) {
        ReplicationResponseRepository repos = ReplicationResponseRepository.getInstance();
        ConcurrentHashMap reposMap = repos.getMap();
        Object entry = reposMap.get(id);
        if (entry != null && entry instanceof ReplicationResponseRepositoryEntry) {
            ReplicationResponseRepositoryEntry reposEntry = (ReplicationResponseRepositoryEntry)entry;
            reposEntry.clean();
        }
        reposMap.remove(id);
    }

    public static void returnQueueEntry(String id, LinkedBlockingQueue aQueue) {
        ReplicationResponseRepository repos = ReplicationResponseRepository.getInstance();
        ConcurrentHashMap reposMap = repos.getMap();
        reposMap.remove(id);
        if (aQueue != null) {
            aQueue.clear();
            repos.getQueueForQueues().offer(aQueue);
        }
    }

    public static void putEntry(ReplicationState state) {
        ReplicationResponseRepository repos = ReplicationResponseRepository.getInstance();
        ConcurrentHashMap reposMap = repos.getMap();
        ReplicationResponseRepositoryEntry entry = (ReplicationResponseRepositoryEntry)reposMap.get(state.getId());
        if (entry == null) {
            return;
        }
        LinkedBlockingQueue aQueue = entry.getQueue();
        if (aQueue == null) {
            return;
        }
        if (aQueue.size() > 0) {
            aQueue.clear();
        }
        aQueue.add(state);
    }

    public static void putFederatedEntry(ReplicationState state) {
        ReplicationResponseRepository repos = ReplicationResponseRepository.getInstance();
        ConcurrentHashMap wrapperMap = repos.getFederatedQueryWrapperMap();
        FederatedRequestProcessor aWrapper = (FederatedRequestProcessor)wrapperMap.get(state.getId());
        if (aWrapper == null) {
            return;
        }
        aWrapper.processQueryResponse(state);
    }

    public static ReplicationState getEntry(String id) {
        return ReplicationResponseRepository.getEntry(id, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReplicationState getEntry(String id, long waitTime) {
        ReplicationState result = null;
        ReplicationResponseRepository repos = ReplicationResponseRepository.getInstance();
        ConcurrentHashMap reposMap = repos.getMap();
        ReplicationResponseRepositoryEntry entry = (ReplicationResponseRepositoryEntry)reposMap.get(id);
        if (entry == null) {
            return result;
        }
        LinkedBlockingQueue aQueue = entry.getQueue();
        try {
            result = (ReplicationState)aQueue.poll(waitTime, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            System.out.println("ReplicationResponseRepository>>getEntry timed out");
            ex.printStackTrace();
        }
        finally {
            reposMap.remove(id);
            if (aQueue != null) {
                aQueue.clear();
                repos.getQueueForQueues().offer(aQueue);
            }
        }
        return result;
    }

    private LinkedBlockingQueue getQueue() {
        LinkedBlockingQueue result = null;
        result = (LinkedBlockingQueue)this._queueForQueues.poll();
        if (result == null) {
            result = this.getNewQueue();
        }
        return result;
    }

    private LinkedBlockingQueue getNewQueue() {
        return new LinkedBlockingQueue();
    }

    private ConcurrentHashMap getMap() {
        return this._repository;
    }

    private ConcurrentHashMap getFederatedQueryWrapperMap() {
        return this._federatedQueryRepository;
    }

    private ConcurrentLinkedQueue getQueueForQueues() {
        return this._queueForQueues;
    }

    public static ReplicationResponseRepository getInstance() {
        return _soleInstance;
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.doCleanup();
        }
    }

    protected void doCleanup() {
        ArrayList idsToRemove = new ArrayList(100);
        ConcurrentHashMap myMap = this.getRepository();
        Set entries = myMap.entrySet();
        for (Map.Entry nextEntry : entries) {
            ReplicationResponseRepositoryEntry nextReposEntry;
            Object nextValue = nextEntry.getValue();
            if (!(nextValue instanceof ReplicationResponseRepositoryEntry) || !(nextReposEntry = (ReplicationResponseRepositoryEntry)nextValue).mayBeRemoved()) continue;
            nextReposEntry.cleanAndReturn(this.getQueueForQueues());
            idsToRemove.add(nextEntry.getKey());
        }
        for (int i = 0; i < idsToRemove.size(); ++i) {
            myMap.remove((String)idsToRemove.get(i));
        }
    }

    protected void threadSleep() {
        try {
            Thread.sleep((long)_sleepIntervalSeconds * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.threadStart();
        this.started = true;
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        this.threadStop();
        this.started = false;
    }

    protected void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        this.thread = new Thread((Runnable)this, this.getThreadName());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    public String getThreadName() {
        return this._threadName;
    }
}

