/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.appserv.ha.spi.AttributeMetadata;
import com.sun.appserv.ha.spi.BackingStore;
import com.sun.appserv.ha.spi.BackingStoreException;
import com.sun.appserv.ha.spi.BackingStoreFactory;
import com.sun.appserv.ha.spi.BackingStoreRegistry;
import com.sun.appserv.ha.spi.CompositeMetadata;
import com.sun.appserv.ha.spi.SimpleMetadata;
import com.sun.appserv.util.cache.BaseCache;
import com.sun.enterprise.ee.web.initialization.ServerConfigReader;
import com.sun.enterprise.ee.web.sessmgmt.BaseHASession;
import com.sun.enterprise.ee.web.sessmgmt.HASession;
import com.sun.enterprise.ee.web.sessmgmt.HAStoreBase;
import com.sun.enterprise.ee.web.sessmgmt.HAStorePoolElement;
import com.sun.enterprise.ee.web.sessmgmt.JxtaBackingStoreFactory;
import com.sun.enterprise.ee.web.sessmgmt.JxtaBackingStoreImpl;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationHealthChecker;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationMessageRouter;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationResponseRepository;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationState;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationStateQueryResponse;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationStore;
import com.sun.enterprise.ee.web.sessmgmt.SessionFactory;
import com.sun.enterprise.ee.web.sessmgmt.StorePool;
import com.sun.enterprise.ee.web.sessmgmt.WebModuleStatistics;
import com.sun.enterprise.web.MonitorStatsCapable;
import com.sun.enterprise.web.ServerConfigLookup;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReplicationManagerBase
extends PersistentManagerBase
implements MonitorStatsCapable {
    public static final String LOGGER_MEM_REP = "com.sun.enterprise.ee.web.sessmgmt";
    private static final Level TRACE_LEVEL = Level.FINE;
    static final String DUPLICATE_IDS_SEMANTICS_PROPERTY = "duplicate_ids_semantics_property";
    private static final Logger _logger = Logger.getLogger("com.sun.enterprise.ee.web.sessmgmt");
    protected static int _maxBaseCacheSize = 4096;
    protected static float _loadFactor = 0.75f;
    protected static final String MODE_WEB = "web";
    protected BaseCache replicatedSessions = null;
    protected BaseCache replicatedSessionUpdates = null;
    protected BackingStore backingStore = null;
    protected BackingStore compositeBackingStore = null;
    protected String _passedInPersistenceType = null;
    protected boolean _duplicateIdsSemanticsAllowed = false;
    protected SessionFactory _sessionFactory = null;
    protected WebModuleStatistics _statistics = new WebModuleStatistics();
    StorePool _pool = null;

    protected static boolean checkSessionCacheProperties() {
        boolean result = false;
        try {
            String loadFactor;
            Properties props = System.getProperties();
            String cacheSize = props.getProperty("HTTP_SESSION_CACHE_MAX_BASE_CACHE_SIZE");
            if (null != cacheSize) {
                _maxBaseCacheSize = new Integer(cacheSize);
            }
            if (null != (loadFactor = props.getProperty("HTTP_SESSION_CACHE_MAX_BASE_LOAD_FACTOR"))) {
                _loadFactor = new Float(loadFactor).floatValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public ReplicationManagerBase() {
        this.replicatedSessions = new BaseCache();
        this.replicatedSessions.init(_maxBaseCacheSize, _loadFactor, null);
        this.replicatedSessionUpdates = new BaseCache();
        this.replicatedSessionUpdates.init(_maxBaseCacheSize, _loadFactor, null);
    }

    public void clearSessions() {
        System.out.println("ReplicationManagerBase>>clearSessions:getApplicationId()" + this.getApplicationId());
        ReplicationMessageRouter.createInstance().removeReplicationManager(this.getApplicationId());
    }

    public void clearStore() {
    }

    public BaseCache getReplicatedSessions() {
        return this.replicatedSessions;
    }

    void printReplicatedSessionIds() {
        Iterator it = this.replicatedSessions.keys();
        while (it.hasNext()) {
            String nextId = (String)it.next();
            System.out.println("nextSessionId = " + nextId);
        }
    }

    public void setReplicatedSessions(BaseCache sesstable) {
        this.replicatedSessions = sesstable;
    }

    protected synchronized void putInReplicationCache(ReplicationState sessionState) {
        String id;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in " + ((Object)((Object)this)).getClass().getName() + ">>putInReplicationCache id: " + sessionState.getId());
        }
        if ((id = (String)sessionState.getId()) == null) {
            return;
        }
        ReplicationState currentState = (ReplicationState)this.replicatedSessions.get((Object)id);
        if (_logger.isLoggable(Level.FINE) && currentState != null) {
            _logger.fine("currentVersion: " + currentState.getVersion() + " newVersion: " + sessionState.getVersion());
        }
        if (currentState != null && currentState.getVersion() > sessionState.getVersion()) {
            return;
        }
        this.replicatedSessions.put(sessionState.getId(), (Object)sessionState);
        if (_logger.isLoggable(TRACE_LEVEL)) {
            _logger.log(TRACE_LEVEL, "in " + ((Object)((Object)this)).getClass().getName() + ">>putInReplicationCache complete id: " + sessionState.getId() + "[ver:" + sessionState.getVersion() + "]");
        }
    }

    protected synchronized void putInReplicationUpdateCache(ReplicationStateUpdate sessionStateUpdate) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in " + ((Object)((Object)this)).getClass().getName() + ">>putInReplicationUpdateCache id: " + sessionStateUpdate.getId());
        }
        if (sessionStateUpdate == null) {
            return;
        }
        String id = sessionStateUpdate.getId();
        if (id == null) {
            return;
        }
        ReplicationStateUpdate currentStateUpdate = this.getFromReplicationUpdatesCache(id);
        if (_logger.isLoggable(Level.FINE) && currentStateUpdate != null) {
            _logger.fine("currentVersion: " + currentStateUpdate.getVersion() + " newVersion: " + sessionStateUpdate.getVersion());
        }
        if (currentStateUpdate != null && currentStateUpdate.getVersion() > sessionStateUpdate.getVersion()) {
            return;
        }
        this.replicatedSessionUpdates.put((Object)sessionStateUpdate.getId(), (Object)sessionStateUpdate);
    }

    protected ReplicationState getFromReplicationCache(String id) {
        ReplicationStateUpdate returnStateUpdate;
        ReplicationState returnState = (ReplicationState)this.replicatedSessions.get((Object)id);
        if (returnState != null && (returnStateUpdate = this.getFromReplicationUpdatesCache(id)) != null) {
            if (returnStateUpdate.getVersion() > returnState.getVersion()) {
                returnState.setVersion(returnStateUpdate.getVersion());
                returnState.setLastAccess(returnStateUpdate.getLastAccess());
            }
            this.removeFromReplicationUpdateCache(returnStateUpdate.getId());
        }
        return returnState;
    }

    protected ReplicationStateUpdate getFromReplicationUpdatesCache(String id) {
        return (ReplicationStateUpdate)this.replicatedSessionUpdates.get((Object)id);
    }

    protected void removeFromReplicationCache(ReplicationState sessionState) {
        if (sessionState == null) {
            return;
        }
        this.replicatedSessions.remove(sessionState.getId());
        this.removeFromReplicationUpdateCache((String)sessionState.getId());
    }

    protected ReplicationState removeFromReplicationCache(String id) {
        if (id == null) {
            return null;
        }
        this.removeFromReplicationUpdateCache(id);
        return (ReplicationState)this.replicatedSessions.remove((Object)id);
    }

    protected void removeFromReplicationUpdateCache(String id) {
        if (id == null) {
            return;
        }
        this.replicatedSessionUpdates.remove((Object)id);
    }

    protected ReplicationState transferFromReplicationCache(String id) {
        return this.removeFromReplicationCache(id);
    }

    public BackingStore getBackingStore() {
        if (this.backingStore == null) {
            this.createBackingStore();
        }
        return this.backingStore;
    }

    public BackingStore getCompositeBackingStore() {
        if (this.compositeBackingStore == null) {
            this.createCompositeBackingStore();
        }
        return this.compositeBackingStore;
    }

    public void setBackingStore(BackingStore aBackingStore) {
        this.backingStore = aBackingStore;
    }

    public void setCompositeBackingStore(BackingStore aBackingStore) {
        this.compositeBackingStore = aBackingStore;
    }

    void createBackingStore() {
        JxtaBackingStoreFactory storeFactory = new JxtaBackingStoreFactory();
        BackingStoreRegistry backingStoreRegistry = BackingStoreRegistry.getInstance();
        Properties env = backingStoreRegistry.getFactoryClassEnv(this.getPassedInPersistenceType());
        env.put(DUPLICATE_IDS_SEMANTICS_PROPERTY, (Object)this.isDuplicateIdsSemanticsAllowed());
        BackingStore backingStore = null;
        try {
            backingStore = storeFactory.createBackingStore(SimpleMetadata.class, this.getApplicationId(), env);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("backingStore: " + backingStore);
        }
        if (backingStore != null) {
            if (backingStore instanceof JxtaBackingStoreImpl) {
                ((JxtaBackingStoreImpl)backingStore).setMode(MODE_WEB);
            }
            this.setBackingStore(backingStore);
        }
    }

    void createCompositeBackingStore() {
        JxtaBackingStoreFactory storeFactory = new JxtaBackingStoreFactory();
        BackingStoreRegistry backingStoreRegistry = BackingStoreRegistry.getInstance();
        Properties env = backingStoreRegistry.getFactoryClassEnv(this.getPassedInPersistenceType());
        env.put(DUPLICATE_IDS_SEMANTICS_PROPERTY, (Object)this.isDuplicateIdsSemanticsAllowed());
        BackingStore compositeBackingStore = null;
        try {
            compositeBackingStore = storeFactory.createBackingStore(CompositeMetadata.class, this.getApplicationId(), env);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("compositeBackingStore: " + compositeBackingStore);
        }
        if (compositeBackingStore != null) {
            if (compositeBackingStore instanceof JxtaBackingStoreImpl) {
                ((JxtaBackingStoreImpl)compositeBackingStore).setMode(MODE_WEB);
            }
            this.setCompositeBackingStore(compositeBackingStore);
        }
    }

    protected BackingStoreFactory getBackingStoreFactory() {
        BackingStoreRegistry backingStoreRegistry = BackingStoreRegistry.getInstance();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("getBackingStoreFactory:passedInPersistenceType=" + this.getPassedInPersistenceType());
        }
        String factoryClassName = backingStoreRegistry.getFactoryClassName(this.getPassedInPersistenceType());
        return this.getBackingStoreFactoryFromName(factoryClassName);
    }

    private BackingStoreFactory getBackingStoreFactoryFromName(String className) {
        BackingStoreFactory backingStoreFactory;
        block3: {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("getBackingStoreFactoryFromName:className: " + className);
            }
            backingStoreFactory = null;
            try {
                backingStoreFactory = (BackingStoreFactory)Class.forName(className).newInstance();
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.FINE)) break block3;
                _logger.fine("unable to create backing store factory");
            }
        }
        return backingStoreFactory;
    }

    protected Session createNewSession() {
        Session sess = this.getSessionFactory().createSession((Manager)this);
        return sess;
    }

    public Session createEmptySession() {
        Session sess = this.getSessionFactory().createSession((Manager)this);
        return sess;
    }

    public String getApplicationId() {
        HAStoreBase store = (HAStoreBase)this.getStore();
        return store.getApplicationId();
    }

    public String getInstanceName() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        return lookup.getServerName();
    }

    public String getMonitorAttributeValues() {
        return "testing..1..2..3";
    }

    public int getSessionsCacheSize() {
        return this.sessions.size();
    }

    public Session findSession(String id) throws IOException {
        if (!this.isSessionIdValid(id)) {
            return null;
        }
        WebModuleStatistics stats = this.getWebModuleStatistics();
        Session session = this.findSessionFromCacheOnly(id);
        if (session != null) {
            if (this.isMonitoringEnabled()) {
                stats.processCacheHit(true);
            }
            return session;
        }
        if (this.isMonitoringEnabled()) {
            stats.processCacheHit(false);
        }
        session = this.swapIn(id);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("IN ReplicationManagerBase>>findSession: returned sess = " + (BaseHASession)session);
        }
        return session;
    }

    public Session findSession(String id, boolean removeCachedCopy) throws IOException {
        if (!this.isSessionIdValid(id)) {
            return null;
        }
        Session theSession = this.findSession(id);
        return theSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session findSessionFromCacheOnly(String id) throws IOException {
        if (id == null) {
            return null;
        }
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            Session session = (Session)this.sessions.get(id);
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repair(long repairStartTime) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationManager>>repair");
        }
        if (ReplicationHealthChecker.isStopping()) {
            return;
        }
        Session[] sessions = this.findSessions();
        for (int i = 0; i < sessions.length; ++i) {
            StandardSession session = (StandardSession)sessions[i];
            if (!session.getIsValid() || session.getIdInternal() == null || session.hasExpired() || !this.isSessionOlderThan(session, repairStartTime) || !session.lockBackground()) continue;
            try {
                ((HASession)session).setPersistent(false);
                ((HASession)session).setDirty(true);
                this.doValveSave((Session)session);
                continue;
            }
            finally {
                session.unlockBackground();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repair(long repairStartTime, boolean checkForStopping) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationManagerBase>>repair: checkForStopping: " + checkForStopping);
        }
        if (checkForStopping && ReplicationHealthChecker.isStopping()) {
            return;
        }
        Session[] sessions = this.findSessions();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationManagerBase>>repair sessions size = " + sessions.length);
        }
        for (int i = 0; i < sessions.length; ++i) {
            StandardSession session = (StandardSession)sessions[i];
            boolean condition = true;
            if (checkForStopping) {
                condition = session.getIsValid() && session.getIdInternal() != null && !session.hasExpired() && this.isSessionOlderThan(session, repairStartTime);
            } else {
                boolean bl = condition = session.getIsValid() && session.getIdInternal() != null && !session.hasExpired();
            }
            if (!condition || !session.lockBackground()) continue;
            try {
                ((HASession)session).setPersistent(false);
                ((HASession)session).setDirty(true);
                this.doValveSave((Session)session);
                continue;
            }
            catch (Throwable t) {
                System.out.println("Throwable during force flush");
                break;
            }
            finally {
                session.unlockBackground();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doValveSave(Session session) {
        block22: {
            long startTime = 0L;
            if (this.isMonitoringEnabled()) {
                startTime = System.currentTimeMillis();
            }
            StorePool storePool = this.getStorePool();
            HAStorePoolElement repStore = null;
            try {
                repStore = (HAStorePoolElement)storePool.take();
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("GOT ReplicationStore from pool");
                }
                repStore.setManager((Manager)this);
                repStore.valveSave(session);
                Object var8_5 = null;
                repStore.setManager(null);
                if (repStore == null) break block22;
                try {
                    storePool.put(repStore);
                    if (this.isMonitoringEnabled()) {
                        long endTime = System.currentTimeMillis();
                        long elapsedTime = endTime - startTime;
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("VALVE_TIME MILLIS = " + elapsedTime);
                        }
                        WebModuleStatistics stats = this.getWebModuleStatistics();
                        stats.processValveSave(elapsedTime);
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.finest("VALVE_TIME MILLIS = " + (endTime - startTime));
                        }
                    }
                    break block22;
                }
                catch (InterruptedException ex1) {}
                break block22;
                {
                    catch (Exception ex) {
                        ex.printStackTrace();
                        Object var8_6 = null;
                        repStore.setManager(null);
                        if (repStore == null) break block22;
                        try {
                            storePool.put(repStore);
                            if (this.isMonitoringEnabled()) {
                                long endTime = System.currentTimeMillis();
                                long elapsedTime = endTime - startTime;
                                if (_logger.isLoggable(Level.FINEST)) {
                                    _logger.finest("VALVE_TIME MILLIS = " + elapsedTime);
                                }
                                WebModuleStatistics stats = this.getWebModuleStatistics();
                                stats.processValveSave(elapsedTime);
                                if (_logger.isLoggable(Level.FINEST)) {
                                    _logger.finest("VALVE_TIME MILLIS = " + (endTime - startTime));
                                }
                            }
                            break block22;
                        }
                        catch (InterruptedException ex1) {}
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    repStore.setManager(null);
                    if (repStore != null) {
                        try {
                            storePool.put(repStore);
                            if (this.isMonitoringEnabled()) {
                                long endTime = System.currentTimeMillis();
                                long elapsedTime = endTime - startTime;
                                if (_logger.isLoggable(Level.FINEST)) {
                                    _logger.finest("VALVE_TIME MILLIS = " + elapsedTime);
                                }
                                WebModuleStatistics stats = this.getWebModuleStatistics();
                                stats.processValveSave(elapsedTime);
                                if (_logger.isLoggable(Level.FINEST)) {
                                    _logger.finest("VALVE_TIME MILLIS = " + (endTime - startTime));
                                }
                            }
                        }
                        catch (InterruptedException ex1) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRemove(String sessionId) {
        long startTime = 0L;
        StorePool storePool = this.getStorePool();
        HAStorePoolElement haStore = null;
        try {
            haStore = (HAStorePoolElement)storePool.take();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("GOT HAStore from pool");
            }
            try {
                haStore.setManager((Manager)this);
                ((HAStoreBase)((Object)haStore)).doRemove(sessionId);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                haStore.setManager(null);
                if (haStore != null) {
                    try {
                        storePool.put(haStore);
                    }
                    catch (InterruptedException ex1) {}
                }
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSessionIdsFromManagerCache(String[] sessionIds) {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            for (int i = 0; i < sessionIds.length; ++i) {
                String nextId = sessionIds[i];
                if (nextId == null) continue;
                this.sessions.remove(nextId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionFromManagerCache(Session session) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in " + ((Object)((Object)this)).getClass().getName() + ">>removeSessionFromManagerCache:session = " + session);
        }
        if (session == null) {
            return;
        }
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.remove(session.getIdInternal());
        }
    }

    public void processSave(ReplicationState message) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("IN" + ((Object)((Object)this)).getClass().getName() + ">>processSave");
        }
        this.putInReplicationCache(message);
    }

    public ReplicationState processSize(ReplicationState message) {
        int result = this.replicatedSessions.getEntryCount();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("processSize: entryCount=" + result);
        }
        ReplicationState resultState = ReplicationState.createQueryStateResponse(MODE_WEB, message.getAppId(), message.getAppId(), message.getInstanceName(), result);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("processSize:resultState=" + resultState);
        }
        return resultState;
    }

    public void processValvesave(ReplicationState message) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("IN" + ((Object)((Object)this)).getClass().getName() + ">>processValvesave");
            _logger.fine("processValvesave:id:" + message.getId());
            _logger.fine("processValvesave:version:" + message.getVersion());
        }
        this.putInReplicationCache(message);
    }

    public void processCompositesave(ReplicationState message) {
        ReplicationState currentState;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("IN" + ((Object)((Object)this)).getClass().getName() + ">>processCompositesave");
            _logger.fine("processCompositesave:version:" + message.getVersion());
        }
        if ((currentState = this.getFromReplicationCache((String)message.getId())) == null) {
            this.putInReplicationCache(message);
            return;
        }
        ReplicationState updatedState = this.updateReplicationState(currentState, message);
        this.putInReplicationCache(updatedState);
    }

    private ReplicationState updateReplicationState(ReplicationState currentState, ReplicationState newState) {
        CompositeMetadata currentComposite = ReplicationState.createCompositeMetadataFrom(currentState);
        CompositeMetadata newComposite = ReplicationState.createCompositeMetadataFrom(newState);
        CompositeMetadata resultComposite = this.applyCompositeMetadataDeltas(currentComposite, newComposite);
        byte[] resultAttributeState = null;
        try {
            resultAttributeState = ReplicationState.getByteArrayFromCollection(resultComposite.getEntries());
        }
        catch (IOException ex) {
            // empty catch block
        }
        ReplicationState updatedState = ReplicationState.createUpdatedStateFrom(newState, resultAttributeState);
        return updatedState;
    }

    private CompositeMetadata applyCompositeMetadataDeltas(CompositeMetadata current, CompositeMetadata deltas) {
        Collection currentCollection = current.getEntries();
        Collection deltasCollection = deltas.getEntries();
        for (AttributeMetadata nextAttributeMetadata : deltasCollection) {
            this.applyCompositeMetadataDelta(nextAttributeMetadata, currentCollection);
        }
        return current;
    }

    private void applyCompositeMetadataDelta(AttributeMetadata nextAttributeMetadata, Collection<AttributeMetadata> currentCollection) {
        switch (nextAttributeMetadata.getOperation()) {
            case DELETE: {
                currentCollection.remove(nextAttributeMetadata);
            }
            case ADD: {
                currentCollection.add(nextAttributeMetadata);
            }
            case UPDATE: {
                if (currentCollection.contains(nextAttributeMetadata)) {
                    currentCollection.remove(nextAttributeMetadata);
                }
                currentCollection.add(nextAttributeMetadata);
            }
        }
    }

    public void processUpdatelastaccesstime(ReplicationState message) {
        String id;
        ReplicationState state;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("IN" + ((Object)((Object)this)).getClass().getName() + ">>processUpdatelastaccesstime");
            _logger.fine("processUpdatelastaccesstime:version:" + message.getVersion());
        }
        if ((state = this.getFromReplicationCache(id = (String)message.getId())) != null) {
            state.setLastAccess(message.getLastAccess());
            state.setVersion(message.getVersion());
            this.putInReplicationCache(state);
        } else {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("processUpdatelastaccesstime: attempting to update a session not yet stored:id:" + message.getId());
            }
            this.putInReplicationUpdateCache(new ReplicationStateUpdate(id, message.getVersion(), message.getLastAccess()));
        }
    }

    public void processRemove(ReplicationState message) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("IN" + ((Object)((Object)this)).getClass().getName() + ">>processRemove");
        }
        this.removeFromReplicationCache(message);
    }

    public void processRemoveids(ReplicationState message) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("IN" + ((Object)((Object)this)).getClass().getName() + ">>processRemoveids");
        }
        byte[] idsToRemoveState = message.getState();
        List removedIdsList = new ArrayList();
        try {
            removedIdsList = (List)ReplicationState.getObjectValue(idsToRemoveState);
        }
        catch (Exception ex) {
            // empty catch block
        }
        for (int i = 0; i < removedIdsList.size(); ++i) {
            String nextIdToRemove = (String)removedIdsList.get(i);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(">>processRemoveids:nextIdToRemove=" + nextIdToRemove);
            }
            this.replicatedSessions.remove((Object)nextIdToRemove);
        }
    }

    public void processAssociate(ReplicationState message) {
        ReplicationState storedReplica = this.getFromReplicationCache((String)message.getId());
        storedReplica.setExtraParam(message.getExtraParam());
    }

    public void processMessage(ReplicationState message) {
        if (ReplicationState.isBroadcastState(message)) {
            this.processBroadcastMessage(message);
            return;
        }
        ReplicationStateQueryResponse queryResult = null;
        if (!message.isResponseState() && !message.isVoidMethodReturnState()) {
            queryResult = this.doProcessQueryMessage(message);
            ReplicationState qResponse = queryResult.getState();
            if (qResponse != null) {
                ReplicationState response = ReplicationState.createResponseFrom(qResponse);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("RepMgrBase:responseState=" + response);
                }
                this.doSendResponse(response);
            }
            return;
        }
        boolean isResponse = this.doProcessMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSendResponse(ReplicationState sessionState) {
        StorePool storePool = this.getStorePool();
        HAStorePoolElement repStore = null;
        if (storePool == null) {
            return;
        }
        try {
            repStore = (HAStorePoolElement)storePool.take();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.fine("GOT ReplicationStore from pool");
            }
            try {
                repStore.setManager((Manager)this);
                ((ReplicationStore)repStore).sendResponse(sessionState);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                repStore.setManager(null);
                if (repStore != null) {
                    try {
                        storePool.put(repStore);
                    }
                    catch (InterruptedException ex1) {}
                }
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    public boolean doProcessMessage(ReplicationState message) {
        boolean result = false;
        String methodName = this.getProcessMethodName(message);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in " + ((Object)((Object)this)).getClass().getName() + ">>doProcessMessageName=" + methodName);
        }
        try {
            Class<?> myClass = ((Object)((Object)this)).getClass();
            myClass.getMethod(methodName, message.getClass()).invoke((Object)this, message);
        }
        catch (IllegalAccessException ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("in " + ((Object)((Object)this)).getClass().getName() + ">>doProcessMessage:methodName=" + methodName + "illegalAccessException");
            }
        }
        catch (NoSuchMethodException ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("in " + ((Object)((Object)this)).getClass().getName() + ">>doProcessMessage:methodName=" + methodName + "noSuchMethodException");
            }
        }
        catch (InvocationTargetException ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("in " + ((Object)((Object)this)).getClass().getName() + ">>doProcessMessage:methodName=" + methodName + "invocationTargetException");
            }
            System.out.println("in " + ((Object)((Object)this)).getClass().getName() + ">>doProcessMessage:methodName=" + methodName + "invocationTargetException");
            System.out.println("invocationException.getCause()= " + ex.getCause());
            ex.printStackTrace();
        }
        if (methodName.equals("processResponse")) {
            result = true;
        }
        return result;
    }

    public ReplicationStateQueryResponse doProcessQueryMessage(ReplicationState message) {
        ReplicationState resultState = null;
        String methodName = this.getProcessMethodName(message);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in " + ((Object)((Object)this)).getClass().getName() + ">>doProcessQueryMessage:methodName=" + methodName);
            _logger.fine("in " + ((Object)((Object)this)).getClass().getName() + ">>doProcessQueryMessage:thisInstance=" + this.getInstanceName() + "SASEreturnInstance=" + message.getInstanceName());
        }
        try {
            Class<?> myClass = ((Object)((Object)this)).getClass();
            resultState = (ReplicationState)myClass.getMethod(methodName, message.getClass()).invoke((Object)this, message);
        }
        catch (IllegalAccessException ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("in " + ((Object)((Object)this)).getClass().getName() + ">>doProcessQueryMessage:methodName=" + methodName + "illegalAccessException");
            }
        }
        catch (NoSuchMethodException ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("in " + ((Object)((Object)this)).getClass().getName() + ">>doProcessQueryMessage:methodName=" + methodName + "noSuchMethodException");
            }
        }
        catch (InvocationTargetException ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("in " + ((Object)((Object)this)).getClass().getName() + ">>doProcessQueryMessage:methodName=" + methodName + "invocationTargetException");
            }
            System.out.println("in " + ((Object)((Object)this)).getClass().getName() + ">>doProcessQueryMessage:methodName=" + methodName + "invocationTargetException");
            System.out.println("invocationException.getCause()= " + ex.getCause());
            ex.printStackTrace();
        }
        boolean isResponse = methodName.equals("processBroadcastresponse");
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in " + ((Object)((Object)this)).getClass().getName() + ">>doProcessQueryMessage:resultState=" + resultState);
        }
        return new ReplicationStateQueryResponse(resultState, isResponse);
    }

    public void processBroadcastMessage(ReplicationState message) {
        ReplicationStateQueryResponse response = this.doProcessQueryMessage(message);
        boolean isResponse = response.isResponse();
        ReplicationState responseState = response.getState();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("processBroadcastMessage:after doProcessQueryMessage:response=" + isResponse);
            _logger.fine("processBroadcastMessage:after doProcessQueryMessage:responseState=" + responseState);
            _logger.fine("processBroadcastMessage:after doProcessQueryMessage:responseStateTrunk=" + responseState.getTrunkState());
            _logger.fine("processBroadcastMessage:after doProcessQueryMessage:responseStateAttr=" + responseState.getState());
            _logger.fine("processBroadcastMessage:after doProcessQueryMessage:responseStateVer=" + responseState.getVersion());
        }
        if (!isResponse) {
            this.doSendQueryResponse(responseState, message.getInstanceName());
        }
    }

    public void processQueryMessage(ReplicationState message, String returnInstance) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in " + ((Object)((Object)this)).getClass().getName() + ">>processQueryMessage:returnInstance= " + returnInstance);
        }
        ReplicationStateQueryResponse response = this.doProcessQueryMessage(message);
        boolean isResponse = response.isResponse();
        ReplicationState responseState = response.getState();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("processQueryMessage:after doProcessQueryMessage:response=" + isResponse);
            _logger.fine("processQueryMessage:after doProcessQueryMessage:responseState=" + responseState);
        }
        if (!isResponse && responseState != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("processQueryMessage - need to send back result to " + returnInstance);
            }
            this.doSendQueryResponse(responseState, returnInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSendQueryResponse(ReplicationState sessionState, String instanceName) {
        StorePool storePool = this.getStorePool();
        HAStorePoolElement repStore = null;
        try {
            repStore = (HAStorePoolElement)storePool.take();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("GOT ReplicationStore from pool");
            }
            try {
                repStore.setManager((Manager)this);
                ((ReplicationStore)repStore).sendQueryResponse(sessionState, instanceName);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                repStore.setManager(null);
                if (repStore != null) {
                    try {
                        storePool.put(repStore);
                    }
                    catch (InterruptedException ex1) {}
                }
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    private String getProcessMethodName(ReplicationState message) {
        String command = message.getCommand();
        return "process" + this.camelCase(command);
    }

    private String camelCase(String inputString) {
        String strippedString = this.stripNonAlphas(inputString);
        String firstLetter = strippedString.substring(0, 1).toUpperCase();
        String remainingPart = strippedString.substring(1, strippedString.length()).toLowerCase();
        return firstLetter + remainingPart;
    }

    private String stripNonAlphas(String inputString) {
        StringBuffer sb = new StringBuffer(50);
        for (int i = 0; i < inputString.length(); ++i) {
            char nextChar = inputString.charAt(i);
            if (!Character.isLetter(nextChar)) continue;
            sb.append(nextChar);
        }
        return sb.toString();
    }

    public void processResponse(ReplicationState message) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("IN" + ((Object)((Object)this)).getClass().getName() + ">>processResponse");
        }
        ReplicationResponseRepository.putEntry(message);
    }

    public ReplicationState processBroadcastresponse(ReplicationState queryResponseState) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in " + ((Object)((Object)this)).getClass().getName() + ">>processBroadcastresponse:queryResponseState=" + queryResponseState);
        }
        ReplicationResponseRepository.putFederatedEntry(queryResponseState);
        return queryResponseState;
    }

    void processExpiredReplicas() {
        ReplicationState nextState;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in " + ((Object)((Object)this)).getClass().getName() + ">>processExpiredReplicas");
        }
        ArrayList<ReplicationState> expiredReplicas = new ArrayList<ReplicationState>(30);
        BaseCache replicasCache = this.getReplicatedSessions();
        Iterator it = replicasCache.values();
        while (it.hasNext()) {
            nextState = (ReplicationState)it.next();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("in " + ((Object)((Object)this)).getClass().getName() + "nextState=" + nextState);
            }
            if (!nextState.isExpired()) continue;
            expiredReplicas.add(nextState);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("processExpiredReplicas:expiredReplicas.size=" + expiredReplicas.size());
        }
        for (int i = 0; i < expiredReplicas.size(); ++i) {
            nextState = (ReplicationState)expiredReplicas.get(i);
            this.removeFromReplicationCache(nextState);
        }
    }

    public ReplicationState processBroadcastfindsession(ReplicationState queryState) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in " + ((Object)((Object)this)).getClass().getName() + ">>processBroadcastfindSession:instance: " + this.getInstanceName());
            _logger.fine("in " + ((Object)((Object)this)).getClass().getName() + ">>processBroadcastfindSession:id=" + queryState.getId());
        }
        ReplicationState replicaState = this.findReplicatedState(queryState);
        ReplicationState returnState = null;
        if (replicaState != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("processBroadcastfindsession:REPLICA_FOUND:replicaStateVersion:" + replicaState.getVersion());
                _logger.fine("processBroadcastfindsession:REPLICA_FOUND:replicaState:" + replicaState.getTrunkState());
                _logger.fine("processBroadcastfindsession:REPLICA_FOUND:replicaAttrState" + replicaState.getState());
            }
            returnState = ReplicationState.createQueryResponseFrom(replicaState);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("processBroadcastfindsession:replicaStateResponseVersion:" + returnState.getVersion());
            }
            this.clearFromManagerCache((String)queryState.getId());
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in " + ((Object)((Object)this)).getClass().getName() + ">>processBroadcastfindSession:returnState=" + returnState);
        }
        return returnState;
    }

    public ReplicationState createQueryResponse(Session session) {
        String command = "broadcastResponse";
        ReplicationStore store = (ReplicationStore)this.getStore();
        ReplicationState transmitState = null;
        try {
            transmitState = store.createReplicationState(session, command);
        }
        catch (IOException ex) {
            // empty catch block
        }
        return transmitState;
    }

    protected ReplicationState findReplicatedState(ReplicationState queryState) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("findReplicatedState:id = " + queryState.getId());
        }
        return this.getFromReplicationCache((String)queryState.getId());
    }

    protected void clearFromManagerCache(String id) {
        Session sess = null;
        try {
            sess = this.findSessionFromCacheOnly(id);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (sess != null) {
            this.removeSessionFromManagerCache(sess);
        }
    }

    public Session findSession(String id, String version) throws IOException {
        Session cachedSession;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in new findSession: version=" + version);
        }
        if (!this.isSessionIdValid(id) || version == null) {
            return null;
        }
        Session session = null;
        long requiredVersion = 0L;
        long cachedVersion = -1L;
        try {
            requiredVersion = Long.valueOf(version);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("findSession:requiredVersion=" + requiredVersion);
        }
        if ((cachedSession = this.findSessionFromCacheOnly(id)) != null) {
            cachedVersion = ((HASession)cachedSession).getVersion();
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("findSession:cachedVersion=" + cachedVersion);
        }
        if (cachedVersion == requiredVersion) {
            return cachedSession;
        }
        if (cachedVersion < requiredVersion) {
            this.removeSessionFromManagerCache(cachedSession);
            cachedSession = null;
            cachedVersion = -1L;
        }
        session = requiredVersion != -1L ? this.swapIn(id, version) : this.swapIn(id);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("findSession:swappedInSession=" + session);
        }
        if (session == null || ((HASession)session).getVersion() < cachedVersion) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ReplicationManagerBase>>findSession:returning cached version:" + cachedVersion);
            }
            return cachedSession;
        }
        if (((HASession)session).getVersion() < requiredVersion) {
            session = null;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationManagerBase>>findSession:returning:" + session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session doSwapIn(String id, String version) throws IOException {
        ReplicationStore store = null;
        try {
            Session session;
            block17: {
                store = this.getReplicationStore();
                if (store == null) {
                    Session session2 = null;
                    return session2;
                }
                session = null;
                try {
                    if (SecurityUtil.isPackageProtectionEnabled()) {
                        try {
                            session = (Session)AccessController.doPrivileged(new PrivilegedStoreLoad(id, version, store));
                            break block17;
                        }
                        catch (PrivilegedActionException ex) {
                            Exception exception = ex.getException();
                            if (exception instanceof IOException) {
                                throw (IOException)exception;
                            }
                            if (exception instanceof ClassNotFoundException) {
                                throw (ClassNotFoundException)exception;
                            }
                            break block17;
                        }
                    }
                    session = version != null ? store.load(id, version) : store.load(id);
                }
                catch (ClassNotFoundException e) {
                    _logger.log(Level.SEVERE, sm.getString("persistentManager.deserializeError", (Object)id, (Object)e));
                    throw new IllegalStateException(sm.getString("persistentManager.deserializeError", (Object)id, (Object)e));
                }
            }
            if (session == null) {
                Session session3 = null;
                return session3;
            }
            if (!session.isValid()) {
                _logger.log(Level.INFO, "session swapped in is invalid or expired");
                Session session4 = null;
                return session4;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(sm.getString("persistentManager.swapIn", (Object)id));
            }
            session.setManager((Manager)this);
            ((StandardSession)session).tellNew();
            this.add(session);
            ((StandardSession)session).activate();
            Session session5 = session;
            return session5;
        }
        finally {
            this.putReplicationStore(store);
        }
    }

    protected ReplicationStore getReplicationStore() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering("ReplicationManagerBase", "getReplicationStore");
        }
        ReplicationStore store = null;
        try {
            store = (ReplicationStore)this._pool.take();
            store.setManager((Manager)this);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "ReplicationManagerBase unable to get store from pool", e);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.exiting("ReplicationManagerBase", "getReplicationStore", store);
        }
        return store;
    }

    private void putReplicationStore(ReplicationStore store) {
        if (store != null) {
            store.setManager(null);
            try {
                StorePool storePool = this.getStorePool();
                if (storePool != null) {
                    storePool.put(store);
                }
            }
            catch (InterruptedException ex1) {
                _logger.log(Level.SEVERE, "ReplicationManagerBase unable to return store to pool", ex1);
            }
        }
    }

    protected boolean isSessionOlderThan(StandardSession session, long aTime) {
        return session.getLastAccessedTime() <= aTime;
    }

    protected boolean isMonitoringEnabled() {
        return ServerConfigReader.isMonitoringEnabled();
    }

    public void resetMonitorStats() {
        WebModuleStatistics stats = this.getWebModuleStatistics();
        stats.resetStats();
    }

    public StorePool getStorePool() {
        return this._pool;
    }

    public void setStorePool(StorePool pool) {
        this._pool = pool;
    }

    SessionFactory getSessionFactory() {
        return this._sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this._sessionFactory = sessionFactory;
    }

    public WebModuleStatistics getWebModuleStatistics() {
        return this._statistics;
    }

    public void setWebModuleStatistics(WebModuleStatistics statistics) {
        this._statistics = statistics;
    }

    public boolean isSessionVersioningSupported() {
        return true;
    }

    public String getPassedInPersistenceType() {
        return this._passedInPersistenceType;
    }

    public void setPassedInPersistenceType(String persistenceType) {
        this._passedInPersistenceType = persistenceType;
    }

    public boolean isDuplicateIdsSemanticsAllowed() {
        return this._duplicateIdsSemanticsAllowed;
    }

    public void setDuplicateIdsSemanticsAllowed(boolean value) {
        this._duplicateIdsSemanticsAllowed = value;
    }

    static {
        ReplicationManagerBase.checkSessionCacheProperties();
    }

    private class PrivilegedStoreLoad
    implements PrivilegedExceptionAction {
        private String id;
        private String version;
        private ReplicationStore store;

        PrivilegedStoreLoad(String id, String version, ReplicationStore store) {
            this.id = id;
            this.version = version;
            this.store = store;
        }

        public Object run() throws Exception {
            return this.store.load(this.id, this.version);
        }
    }

    private class ReplicationStateUpdate {
        private String _id = null;
        private long _lastAccess = 0L;
        private long _version = -1L;

        String getId() {
            return this._id;
        }

        long getLastAccess() {
            return this._lastAccess;
        }

        long getVersion() {
            return this._version;
        }

        public ReplicationStateUpdate(String id, long version, long lastAccess) {
            this._id = id;
            this._version = version;
            this._lastAccess = lastAccess;
        }
    }
}

