/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.jxtamgmt.JxtaUtil;
import com.sun.enterprise.jxtamgmt.NetworkManager;
import com.sun.enterprise.jxtamgmt.NetworkManagerProxy;
import com.sun.enterprise.web.ServerConfigLookup;
import java.io.IOException;
import java.util.HashMap;
import net.jxta.exception.PeerGroupException;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.PipeID;
import net.jxta.rendezvous.RendezVousService;

public class JxtaStarter {
    private PeerGroup netPeerGroup = null;
    private RendezVousService rendezvous;
    private boolean starting = false;
    private boolean started = false;
    private static final String TIE_BREAK_STRING = "::123";
    private static Object _monitor = new Object();
    private static JxtaStarter _soleInstance = null;
    NetworkManager networkManager = null;
    NetworkManagerProxy networkManagerProxy = null;
    String instanceName = null;
    String clusterName = null;
    static boolean gmsStartedJxta = false;

    public JxtaStarter() {
    }

    public JxtaStarter(String instanceName, String certpass) {
        String clusterName = this.getClusterName();
        this.instanceName = instanceName;
    }

    private static String getInstanceName() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        return lookup.getServerName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JxtaStarter createInstance() {
        Object object = _monitor;
        synchronized (object) {
            String instanceName = JxtaStarter.getInstanceName();
            if (_soleInstance == null) {
                _soleInstance = new JxtaStarter(instanceName, "password");
            }
            return _soleInstance;
        }
    }

    private String getClusterName() {
        if (this.clusterName == null) {
            ServerConfigLookup lookup = new ServerConfigLookup();
            this.clusterName = lookup.getClusterName();
        }
        return this.clusterName;
    }

    boolean checkGMS() {
        NetworkManagerProxy nmp;
        boolean result = false;
        if (GMSFactory.isGMSEnabled((String)this.getClusterName()) && (nmp = this.getJxtaFacade(this.getClusterName())).isStarted()) {
            this.networkManagerProxy = nmp;
            result = true;
        }
        return result;
    }

    private NetworkManagerProxy getJxtaFacade(String groupName) {
        return JxtaUtil.getNetworkManagerProxy((String)groupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startJxta() {
        if (this.started) {
            return;
        }
        if (this.starting) {
            return;
        }
        this.starting = true;
        JxtaStarter jxtaStarter = this;
        synchronized (jxtaStarter) {
            gmsStartedJxta = this.checkGMS();
            if (gmsStartedJxta) {
                this.starting = false;
                return;
            }
        }
        try {
            this.networkManager = this.getNetworkManager();
            this.networkManager.start();
        }
        catch (PeerGroupException pge) {
            pge.printStackTrace();
        }
        catch (IOException iOException) {
        }
        finally {
            this.starting = false;
        }
    }

    void startJxta(boolean isServer) {
        this.startJxta();
    }

    public PeerGroup getNetPeerGroupLastGood() {
        if (this.networkManager != null) {
            return this.networkManager.getNetPeerGroup();
        }
        return null;
    }

    public PeerGroup getNetPeerGroup() {
        if (gmsStartedJxta) {
            return JxtaStarter.createInstance().getNetworkManagerProxy().getNetPeerGroup();
        }
        return JxtaStarter.createInstance().getNetworkManager().getNetPeerGroup();
    }

    public synchronized RendezVousService getRendezvous() {
        if (this.rendezvous == null && this.getNetPeerGroup() != null) {
            this.rendezvous = this.getNetPeerGroup().getRendezVousService();
        }
        return this.rendezvous;
    }

    public static PeerID getPeerIDLastGood(String instanceName) {
        NetworkManager mgr = JxtaStarter.createInstance().getNetworkManager();
        return mgr.getPeerID(instanceName);
    }

    public static PeerID getPeerID(String instanceName) {
        if (gmsStartedJxta) {
            return JxtaStarter.createInstance().getNetworkManagerProxy().getPeerID(instanceName);
        }
        return JxtaStarter.createInstance().getNetworkManager().getPeerID(instanceName);
    }

    public static PipeID getPipeIDLastGood(String instanceName) {
        NetworkManager mgr = JxtaStarter.createInstance().getNetworkManager();
        return mgr.getPipeID(instanceName);
    }

    public static PipeID getPipeID(String instanceName) {
        if (gmsStartedJxta) {
            return JxtaStarter.createInstance().getNetworkManagerProxy().getPipeID(instanceName);
        }
        return JxtaStarter.createInstance().getNetworkManager().getPipeID(instanceName);
    }

    public static PipeID getSessionQueryPipeIDLastGood() {
        NetworkManager mgr = JxtaStarter.createInstance().getNetworkManager();
        return mgr.getSessionQueryPipeID();
    }

    public static PipeID getSessionQueryPipeID() {
        if (gmsStartedJxta) {
            return JxtaStarter.createInstance().getNetworkManagerProxy().getSessionQueryPipeID();
        }
        return JxtaStarter.createInstance().getNetworkManager().getSessionQueryPipeID();
    }

    public NetworkManager getNetworkManagerPrevious() {
        return this.networkManager;
    }

    public synchronized NetworkManager getNetworkManager() {
        if (this.networkManager == null) {
            this.networkManager = new NetworkManager(this.getClusterName(), this.instanceName, new HashMap());
        }
        return this.networkManager;
    }

    public NetworkManagerProxy getNetworkManagerProxy() {
        return this.networkManagerProxy;
    }
}

