/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.enterprise.ee.web.sessmgmt.FederatedRequestProcessor;
import com.sun.enterprise.ee.web.sessmgmt.JxtaSenderPipeManager;
import com.sun.enterprise.ee.web.sessmgmt.JxtaStarter;
import com.sun.enterprise.ee.web.sessmgmt.JxtaUtil;
import com.sun.enterprise.ee.web.sessmgmt.PipePool;
import com.sun.enterprise.ee.web.sessmgmt.PipePoolElement;
import com.sun.enterprise.ee.web.sessmgmt.PipeWrapper;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationHealthChecker;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationResponseRepository;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationState;
import com.sun.enterprise.ee.web.sessmgmt.TestSender;
import com.sun.enterprise.web.ServerConfigLookup;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.OutgoingMessageEventListener;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.util.JxtaBiDiPipe;
import org.apache.catalina.LifecycleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JxtaReplicationSender
implements Runnable {
    private static final String ID = "id";
    private static final Level TRACE_LEVEL = Level.FINE;
    private final int NTHREADS = this.getNumberOfSenderThreads() * 2;
    private final Executor exec = Executors.newFixedThreadPool(this.NTHREADS);
    public static final String LOGGER_MEM_REP = "com.sun.enterprise.ee.web.sessmgmt";
    private static final Logger _logger = Logger.getLogger("com.sun.enterprise.ee.web.sessmgmt");
    private static final JxtaReplicationSender _soleInstance = new JxtaReplicationSender();
    protected boolean started = false;
    protected Thread thread = null;
    protected volatile boolean threadDone = false;
    protected String _threadName = "JxtaReplicationSender";
    private TimerTask timerTask = new TimerDispatchThread();
    private Timer timer = new Timer();
    protected AtomicInteger _latencyCheckCounter = new AtomicInteger(-1);
    private volatile int _latencyCount = -1;
    private Boolean _waitForAckConfigured = null;
    private Boolean _waitForFastAckConfigured = null;
    private static int NUMBER_OF_REQUESTS_BEFORE_FLUSH = 100;
    private static final int NUMBER_OF_SESSIONS_PER_MESSAGE = 20;
    private static final int BULK_MESSAGE_LIMIT = 32768;
    private static final int INITIAL_CAPACITY = 2048;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int CONCURRENCY_LEVEL = 100;
    private DispatchThread dispatchThread = new DispatchThread();
    private DispatchThreadNoDupsAllowed dispatchThreadNoDupsAllowed = new DispatchThreadNoDupsAllowed();
    private Object dispatchThreadMonitorObject = new Object();
    private Object dispatchThreadNoDupsAllowedMonitorObject = new Object();
    private ReentrantReadWriteLock rwLock;
    private Lock rLock;
    private Lock wLock;
    AtomicReference currentMap = new AtomicReference(new ConcurrentHashMap(2048, 0.75f, 100));
    AtomicReference currentMapNoDupsAllowed = new AtomicReference(new ConcurrentHashMap(2048, 0.75f, 100));
    private AtomicBoolean timeToChange = new AtomicBoolean(false);
    private AtomicBoolean timeToChangeNoDupsAllowed = new AtomicBoolean(false);
    private AtomicLong lastChangeTime = new AtomicLong(System.currentTimeMillis() - 1000L);
    private AtomicLong lastChangeTimeNoDupsAllowed = new AtomicLong(System.currentTimeMillis() - 1000L);
    private static AtomicInteger requestCounter = new AtomicInteger(0);
    private static AtomicInteger requestCounterNoDupsAllowed = new AtomicInteger(0);
    private static AtomicInteger _messageIDCounter = new AtomicInteger(0);
    private static long DEFAULT_TIME_THRESHOLD = 100L;

    private int getNumberOfSenderThreads() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        return lookup.getNumberOfReplicationPipesFromConfig();
    }

    private int getLatencyCountLimit() {
        if (this._latencyCount == -1) {
            ServerConfigLookup lookup = new ServerConfigLookup();
            this._latencyCount = lookup.getLatencyCountPropertyFromConfig();
        }
        return this._latencyCount;
    }

    public String getThreadName() {
        return this._threadName;
    }

    public JxtaReplicationSender() {
        this.rwLock = new ReentrantReadWriteLock();
        this.rLock = this.rwLock.readLock();
        this.wLock = this.rwLock.writeLock();
    }

    public static JxtaReplicationSender createInstance() {
        return _soleInstance;
    }

    private boolean isWaitForAckConfigured() {
        if (this._waitForAckConfigured == null) {
            ServerConfigLookup lookup = new ServerConfigLookup();
            boolean waitForAckProp = lookup.getWaitForAckPropertyFromConfig();
            this._waitForAckConfigured = new Boolean(waitForAckProp);
        }
        return this._waitForAckConfigured;
    }

    public boolean isWaitForFastAckConfigured() {
        if (this._waitForFastAckConfigured == null) {
            ServerConfigLookup lookup = new ServerConfigLookup();
            boolean waitForFastAckProp = lookup.getWaitForFastAckPropertyFromConfig();
            this._waitForFastAckConfigured = new Boolean(waitForFastAckProp);
        }
        return this._waitForFastAckConfigured;
    }

    public ReplicationState sendReplicationState(ReplicationState state) {
        state.setSendStartTime(System.currentTimeMillis());
        LinkedBlockingQueue aQueue = ReplicationResponseRepository.putEmptyQueueEntry(state);
        boolean success = this.sendOverPipe(state);
        if (!success && _logger.isLoggable(Level.FINE)) {
            _logger.fine("JxtaReplicationSender>>sendOverPipe failed - likely pool over-utilized");
        }
        ReplicationState returnState = null;
        if (success) {
            returnState = ReplicationResponseRepository.getEntry((String)state.getId());
        }
        return returnState;
    }

    public ReplicationState sendReplicationState(ReplicationState state, boolean wait) {
        this.sendReplicationState(state, wait, false);
        return null;
    }

    public ReplicationState sendReplicationState(ReplicationState state, boolean wait, boolean dupsAllowed) {
        this.replicateState(state, wait, dupsAllowed);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationState sendReplicationStateKeepPrevious(ReplicationState state, boolean wait) {
        PipeWrapper pipeWrapper;
        ReplicationState returnState;
        block19: {
            int latencyCount;
            int latencyCountLimit;
            block18: {
                ReplicationState iex2;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("JxtaReplicationSender>>sendReplicationState:wait:" + wait);
                }
                state.setSendStartTime(System.currentTimeMillis());
                returnState = null;
                if (!ReplicationHealthChecker.isOkToProceed()) {
                    System.out.println("health check bypassing replication now");
                    return returnState;
                }
                latencyCountLimit = this.getLatencyCountLimit();
                latencyCount = this.incrementLatencyCheckCount();
                if (wait || latencyCount == latencyCountLimit) {
                    state.setAckRequired(true);
                }
                pipeWrapper = null;
                try {
                    LinkedBlockingQueue aQueue = ReplicationResponseRepository.putEmptyQueueEntry(state);
                    try {
                        pipeWrapper = this.getPipeWrapper();
                    }
                    catch (InterruptedException iex2) {
                        // empty catch block
                    }
                    if (pipeWrapper == null) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.fine("JxtaReplicationSender>>sendReplicationState failed - likely pool over-utilized");
                        }
                        System.out.println("JxtaReplicationSender>>sendReplicationState failed - likely pool over-utilized");
                    }
                    if (pipeWrapper == null || !pipeWrapper.isPipeClosed()) break block18;
                    ReplicationHealthChecker.setReplicationCommunicationOperational(false);
                    ReplicationHealthChecker.reportError("sendReplicationState failed - pipeWrapper closed");
                    iex2 = returnState;
                }
                catch (Throwable throwable) {
                    try {
                        this.putPipeWrapper(pipeWrapper);
                    }
                    catch (InterruptedException iex3) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    this.putPipeWrapper(pipeWrapper);
                }
                catch (InterruptedException iex4) {
                    // empty catch block
                }
                return iex2;
            }
            boolean success = this.sendOverPipe(pipeWrapper, state);
            if (!success) {
                ReplicationHealthChecker.reportError("simple sendOverPipe failed, not a pool issue");
            }
            if (wait || latencyCount == latencyCountLimit) {
                returnState = ReplicationResponseRepository.getEntry((String)state.getId());
                break block19;
            }
            ReplicationResponseRepository.removeEntry((String)state.getId());
        }
        try {
            this.putPipeWrapper(pipeWrapper);
        }
        catch (InterruptedException iex) {}
        return returnState;
    }

    private int incrementLatencyCheckCount() {
        return Math.abs(this._latencyCheckCounter.incrementAndGet());
    }

    private boolean shouldWait(boolean wait, int latencyCount, int latencyCountLimit) {
        if (!wait && latencyCountLimit == 0) {
            return false;
        }
        return wait || latencyCount % latencyCountLimit == 0;
    }

    private synchronized int incrementLatencyCheckCountPrevious() {
        int latencyCountLimit = this.getLatencyCountLimit();
        int latencyCount = this._latencyCheckCounter.incrementAndGet();
        if (latencyCount == latencyCountLimit) {
            this._latencyCheckCounter.set(-1);
            return latencyCountLimit;
        }
        return this._latencyCheckCounter.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationState sendReplicationStateSuveen(ReplicationState state, boolean wait) {
        ReplicationState returnState = null;
        if (!ReplicationHealthChecker.isOkToProceed()) {
            System.out.println("health check bypassing replication now");
            return returnState;
        }
        state.setSendStartTime(System.currentTimeMillis());
        PipeWrapper pipeWrapper = null;
        try {
            try {
                pipeWrapper = this.getPipeWrapper();
            }
            catch (InterruptedException iex) {
                // empty catch block
            }
            if (pipeWrapper == null) {
                System.out.println("sendReplicationState failed - likely pool over-utilized");
            }
            if (pipeWrapper != null && pipeWrapper.isPipeClosed()) {
                ReplicationHealthChecker.setReplicationCommunicationOperational(false);
                ReplicationHealthChecker.reportError("sendReplicationState failed - pipeWrapper closed");
            }
            boolean success = this.sendOverPipe(pipeWrapper, state);
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (!success) {
                ReplicationHealthChecker.reportError("simple sendOverPipe failed, not a pool issue");
            }
            if (wait) {
                returnState = ReplicationResponseRepository.getEntry((String)state.getId());
            }
        }
        finally {
            try {
                this.putPipeWrapper(pipeWrapper);
            }
            catch (InterruptedException iex) {}
        }
        return returnState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationState sendReplicationStateHC(ReplicationState state) {
        PipeWrapper pipeWrapper;
        ReplicationState returnState;
        block16: {
            ReplicationState iex2;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JxtaReplicationSender>>sendReplicationStateHC");
            }
            returnState = null;
            if (!ReplicationHealthChecker.isOkToProceed()) {
                System.out.println("health check bypassing replication now");
                return returnState;
            }
            state.setSendStartTime(System.currentTimeMillis());
            pipeWrapper = null;
            try {
                LinkedBlockingQueue aQueue = ReplicationResponseRepository.putEmptyQueueEntry(state);
                try {
                    pipeWrapper = this.getPipeWrapper();
                }
                catch (InterruptedException iex2) {
                    // empty catch block
                }
                if (pipeWrapper == null) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("JxtaReplicationSender>>sendReplicationState failed - likely pool over-utilized");
                    }
                    System.out.println("JxtaReplicationSender>>sendReplicationState failed - likely pool over-utilized");
                }
                if (pipeWrapper == null || !pipeWrapper.isPipeClosed()) break block16;
                ReplicationHealthChecker.setReplicationCommunicationOperational(false);
                ReplicationHealthChecker.reportError("sendReplicationState failed - pipeWrapper closed");
                iex2 = returnState;
            }
            catch (Throwable throwable) {
                try {
                    this.putPipeWrapper(pipeWrapper);
                }
                catch (InterruptedException iex3) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.putPipeWrapper(pipeWrapper);
            }
            catch (InterruptedException iex4) {
                // empty catch block
            }
            return iex2;
        }
        boolean success = this.sendOverPipe(pipeWrapper, state);
        if (!success) {
            ReplicationHealthChecker.reportError("simple sendOverPipe failed, not a pool issue");
        }
        returnState = ReplicationResponseRepository.getEntry((String)state.getId());
        try {
            this.putPipeWrapper(pipeWrapper);
        }
        catch (InterruptedException iex) {}
        return returnState;
    }

    private boolean sendOverPipeLastGood(PipeWrapper pipeWrapper, ReplicationState state, boolean isResponse) {
        boolean result = false;
        if (!ReplicationHealthChecker.isOkToProceed()) {
            return false;
        }
        if (pipeWrapper == null) {
            return false;
        }
        JxtaBiDiPipe thePipe = pipeWrapper.getPipe();
        Message theMsg = this.createMessage(state, isResponse);
        if (pipeWrapper.isPipeClosed()) {
            return false;
        }
        try {
            thePipe.sendMessage(theMsg);
            result = true;
        }
        catch (NullPointerException ex1) {
            result = false;
        }
        catch (IOException ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("IOException sending message: " + ex.getMessage());
            }
            result = false;
        }
        return result;
    }

    private boolean sendOverPipe(PipeWrapper pipeWrapper, ReplicationState state, boolean isResponse) {
        boolean result = false;
        if (!ReplicationHealthChecker.isOkToProceed()) {
            return false;
        }
        if (pipeWrapper == null) {
            return false;
        }
        JxtaBiDiPipe thePipe = pipeWrapper.getPipe();
        Message theMsg = this.createMessage(state, isResponse);
        if (pipeWrapper.isPipeClosed()) {
            return false;
        }
        result = this.sendMessageOverPipe(theMsg, thePipe, pipeWrapper);
        return result;
    }

    private boolean sendOverPipe(PipeWrapper pipeWrapper, ReplicationState state) {
        return this.sendOverPipe(pipeWrapper, state, false);
    }

    private boolean sendMessageOverPipe(Message theMsg, JxtaBiDiPipe thePipe, PipeWrapper thePipeWrapper) {
        boolean result = true;
        try {
            result = thePipe.sendMessage(theMsg);
            if (result) {
                thePipeWrapper.messageSendSucceeded(theMsg);
            }
        }
        catch (NullPointerException ex1) {
            result = false;
            System.out.println("JxtaReplicationSender:caught NPE");
            ex1.printStackTrace();
            thePipeWrapper.messageSendFailed(theMsg);
        }
        catch (IOException ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("IOException sending message: " + ex.getMessage());
            }
            thePipeWrapper.messageSendFailed(theMsg);
            System.out.println("IOException sending message: " + ex.getMessage());
            result = false;
        }
        if (!result) {
            thePipeWrapper.messageSendFailed(theMsg);
            System.out.println("JxtaReplicationSender>>sendMessageOverPipe returning: " + result);
        }
        return result;
    }

    private boolean sendMessageOverPipePrevious(Message theMsg, JxtaBiDiPipe thePipe, PipeWrapper thePipeWrapper) {
        boolean result = true;
        boolean continueTrying = true;
        long waitTime = 5L;
        while (continueTrying) {
            waitTime *= 2L;
            try {
                result = thePipe.sendMessage(theMsg);
                if (!result && waitTime < 1000L) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(waitTime);
                    }
                    catch (InterruptedException ex) {}
                    continue;
                }
                continueTrying = false;
                if (waitTime >= 1000L) {
                    result = false;
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("JxtaReplicationSender:timed out trying to send message");
                    }
                    System.out.println("JxtaReplicationSender:timed out trying to send message");
                    continue;
                }
                result = true;
            }
            catch (NullPointerException ex1) {
                result = false;
                continueTrying = false;
                System.out.println("JxtaReplicationSender:caught NPE");
                break;
            }
            catch (IOException ex) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("IOException sending message: " + ex.getMessage());
                }
                System.out.println("IOException sending message: " + ex.getMessage());
                result = false;
                continueTrying = false;
                break;
            }
        }
        if (!result) {
            System.out.println("JxtaReplicationSender>>sendMessageOverPipe returning: " + result);
        }
        return result;
    }

    public ReplicationState sendReplicationStateNonBatch(ReplicationState state, boolean wait) {
        boolean success;
        ReplicationState returnState = null;
        state.setSendStartTime(System.currentTimeMillis());
        if (wait) {
            LinkedBlockingQueue aQueue = ReplicationResponseRepository.putEmptyQueueEntry(state);
        }
        if (!(success = this.sendOverPipe(state))) {
            System.out.println("sendOverPipe failed - likely pool over-utilized");
        }
        if (wait) {
            returnState = ReplicationResponseRepository.getEntry((String)state.getId());
        }
        return returnState;
    }

    public ReplicationState sendReplicationStateNonBatch(ReplicationState state, boolean wait, boolean dupsAllowed) {
        return this.sendReplicationStateNonBatch(state, wait);
    }

    private boolean sendOverPipe(ReplicationState state) {
        return this.sendOverPipe(state, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendOverPipe(ReplicationState state, boolean isResponse) {
        JxtaBiDiPipe thePipe = null;
        boolean result = false;
        if (!ReplicationHealthChecker.isOkToProceed()) {
            return false;
        }
        PipeWrapper thePipeWrapper = null;
        try {
            thePipeWrapper = this.getPipeWrapper();
            if (thePipeWrapper == null) {
                return false;
            }
            thePipe = thePipeWrapper.getPipe();
            if (thePipe == null) {
                return false;
            }
            Message theMsg = this.createMessage(state, isResponse);
            try {
                result = this.sendMessageOverPipe(theMsg, thePipe, thePipeWrapper);
            }
            finally {
                try {
                    this.putPipeWrapper(thePipeWrapper);
                }
                catch (InterruptedException iex) {}
            }
        }
        catch (InterruptedException iex2) {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendOverPipeLastGood(ReplicationState state, boolean isResponse) {
        JxtaBiDiPipe thePipe = null;
        boolean result = false;
        if (!ReplicationHealthChecker.isOkToProceed()) {
            return false;
        }
        PipeWrapper thePipeWrapper = null;
        try {
            thePipeWrapper = this.getPipeWrapper();
            if (thePipeWrapper == null) {
                return false;
            }
            thePipe = thePipeWrapper.getPipe();
            if (thePipe == null) {
                return false;
            }
            Message theMsg = this.createMessage(state, isResponse);
            try {
                thePipe.sendMessage(theMsg);
                result = true;
            }
            catch (IOException ex) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("IOException sending message: " + ex.getMessage());
                }
                result = false;
            }
            finally {
                try {
                    this.putPipeWrapper(thePipeWrapper);
                }
                catch (InterruptedException iex) {}
            }
        }
        catch (InterruptedException iex2) {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendOverPipePrevious(ReplicationState state, boolean isResponse) {
        JxtaBiDiPipe thePipe = null;
        PipeWrapper thePipeWrapper = null;
        try {
            thePipeWrapper = this.getPipeWrapper();
            if (thePipeWrapper == null) {
                return;
            }
            thePipe = thePipeWrapper.getPipe();
            if (thePipe == null) {
                return;
            }
            Message theMsg = this.createMessage(state, isResponse);
            try {
                thePipe.sendMessage(theMsg);
            }
            catch (IOException ex) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("IOException sending message: " + ex.getMessage());
                }
            }
            finally {
                try {
                    this.putPipeWrapper(thePipeWrapper);
                }
                catch (InterruptedException iex) {}
            }
        }
        catch (InterruptedException iex2) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendOverPipe(Message theMsg) {
        boolean result = false;
        if (!ReplicationHealthChecker.isOkToProceed()) {
            return false;
        }
        JxtaBiDiPipe thePipe = null;
        PipeWrapper thePipeWrapper = null;
        try {
            thePipeWrapper = this.getPipeWrapper();
            if (thePipeWrapper == null) {
                return false;
            }
            thePipe = thePipeWrapper.getPipe();
            if (thePipe == null) {
                return false;
            }
            try {
                if (this.isWaitForFastAckConfigured()) {
                    thePipeWrapper.incrementQueuedMessageCount();
                    result = thePipe.sendMessage(theMsg, (OutgoingMessageEventListener)thePipeWrapper);
                } else {
                    result = thePipe.sendMessage(theMsg);
                }
            }
            catch (IOException ex) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("IOException sending message: " + ex.getMessage());
                }
            }
            finally {
                try {
                    this.putPipeWrapper(thePipeWrapper);
                }
                catch (InterruptedException iex) {}
            }
        }
        catch (InterruptedException iex2) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendOverPipeLastGood(Message theMsg) {
        boolean result = false;
        if (!ReplicationHealthChecker.isOkToProceed()) {
            return false;
        }
        JxtaBiDiPipe thePipe = null;
        PipeWrapper thePipeWrapper = null;
        try {
            thePipeWrapper = this.getPipeWrapper();
            if (thePipeWrapper == null) {
                return false;
            }
            thePipe = thePipeWrapper.getPipe();
            if (thePipe == null) {
                return false;
            }
            try {
                if (this.isWaitForFastAckConfigured()) {
                    thePipeWrapper.incrementQueuedMessageCount();
                    result = thePipe.sendMessage(theMsg, (OutgoingMessageEventListener)thePipeWrapper);
                } else {
                    result = thePipe.sendMessage(theMsg);
                }
            }
            catch (IOException ex) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("IOException sending message: " + ex.getMessage());
                }
            }
            finally {
                try {
                    this.putPipeWrapper(thePipeWrapper);
                }
                catch (InterruptedException iex) {}
            }
        }
        catch (InterruptedException iex2) {
            // empty catch block
        }
        return result;
    }

    private PipeWrapper getPipeWrapper() throws InterruptedException {
        JxtaSenderPipeManager senderPipeManager = JxtaSenderPipeManager.createInstance();
        PipePool pool = senderPipeManager.getPipePool();
        if (pool == null) {
            return null;
        }
        PipeWrapper pipeWrapper = null;
        boolean goodPipeFound = false;
        while (!goodPipeFound) {
            PipePoolElement poolElement = pool.take();
            pipeWrapper = (PipeWrapper)poolElement;
            if (!pipeWrapper.isPipeOverStressed()) {
                goodPipeFound = true;
                break;
            }
            pool.put(poolElement);
        }
        return pipeWrapper;
    }

    private void putPipeWrapper(PipeWrapper thePipeWrapper) throws InterruptedException {
        if (thePipeWrapper == null || thePipeWrapper.isPipeClosed()) {
            return;
        }
        JxtaSenderPipeManager senderPipeManager = JxtaSenderPipeManager.createInstance();
        PipePool pool = senderPipeManager.getPipePool();
        pool.put(thePipeWrapper);
    }

    private Message createMessage(ReplicationState state, boolean isResponse) {
        return ReplicationState.createMessage(state, isResponse);
    }

    public ReplicationState sendReplicationStateResponse(ReplicationState state) {
        this.sendOverPipe(state, true);
        return state;
    }

    public ReplicationState sendReplicationStateQueryResponse(ReplicationState state, String instanceName) {
        this.sendOverPropagatedPipe(state, instanceName, true);
        return state;
    }

    private void sendOverPropagatedPipe(ReplicationState state, String instanceName, boolean isResponse) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JxtaReplicationSender>>sendOverPropagatedPipe:toInstance=" + instanceName);
        }
        OutputPipe outputPipe = this.createPropagatedOutputPipe(instanceName);
        Message theMsg = this.createBroadcastMessage(state, isResponse, instanceName);
        boolean needsRetry = true;
        int retryCount = 0;
        boolean sendResult = false;
        while (needsRetry) {
            needsRetry = false;
            try {
                sendResult = outputPipe.send(theMsg);
                if (sendResult) continue;
                needsRetry = true;
            }
            catch (IOException ex) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("IOException sending unicast message: " + ex.getMessage());
                }
                System.out.println("IOException sending unicast message: " + ex.getMessage());
                if (++retryCount >= 2) continue;
                System.out.println("propagated unicast pipe send retrying");
                needsRetry = true;
                try {
                    Thread.currentThread();
                    Thread.sleep(750L);
                }
                catch (InterruptedException iex) {}
            }
        }
    }

    private OutputPipe createPropagatedOutputPipe(String instanceName) {
        OutputPipe op;
        block2: {
            JxtaStarter jxtaStarter = JxtaStarter.createInstance();
            PeerGroup netPeerGroup = jxtaStarter.getNetPeerGroup();
            PipeService pipeService = netPeerGroup.getPipeService();
            PipeAdvertisement pipeAdv = JxtaUtil.getPropagatedPipeAdvertisement();
            op = null;
            try {
                op = pipeService.createOutputPipe(pipeAdv, Collections.singleton(JxtaStarter.getPeerID(instanceName)), 10000L);
            }
            catch (IOException ex) {
                if (!_logger.isLoggable(Level.FINE)) break block2;
                _logger.fine("IOException creating propagated pipe: " + ex.getMessage());
            }
        }
        return op;
    }

    public ReplicationState sendReplicationStateResponsePrevious(ReplicationState state) {
        TestSender testSender = new TestSender(state);
        testSender.run();
        return state;
    }

    public ReplicationState sendReplicationStateQueryLastGood(ReplicationState state) {
        LinkedBlockingQueue aQueue = ReplicationResponseRepository.putEmptyQueueEntry(state);
        this.sendBroadcastQuery(state);
        ReplicationState returnState = ReplicationResponseRepository.getEntry((String)state.getId());
        return returnState;
    }

    private int getNumberExpectedRespondants() {
        ReplicationHealthChecker healthChecker = ReplicationHealthChecker.getInstance();
        List conservativeList = healthChecker.getConservativeMemberList(null);
        if (conservativeList == null) {
            return 0;
        }
        return conservativeList.size() - 1;
    }

    public ReplicationState sendReplicationStateQuery(ReplicationState state) {
        int numberExpectedResults = this.getNumberExpectedRespondants();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("expected respondants = " + numberExpectedResults);
        }
        long startTime = System.currentTimeMillis();
        FederatedRequestProcessor federatedRequestProcessor = new FederatedRequestProcessor(state, numberExpectedResults, 4000L, state.getVersion());
        ReplicationResponseRepository.putWrappedEmptyQueueEntry(state, federatedRequestProcessor);
        ReplicationState result = federatedRequestProcessor.doFederatedQuery();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("federated query took " + (System.currentTimeMillis() - startTime) + " millis");
        }
        return result;
    }

    void sendBroadcastQuery(ReplicationState state) {
        Message broadcastMsg = this.createBroadcastMessage(state, false);
        this.sendOverPropagatedPipe(broadcastMsg);
    }

    private OutputPipe getPropagatedOutputPipe() {
        return JxtaSenderPipeManager.createInstance().getPropagatedOutputPipe();
    }

    void sendOverPropagatedPipe(Message theMsg) {
        block3: {
            OutputPipe outputPipe = this.getPropagatedOutputPipe();
            if (outputPipe != null) {
                try {
                    outputPipe.send(theMsg);
                }
                catch (IOException ex) {
                    if (!_logger.isLoggable(Level.FINE)) break block3;
                    _logger.fine("IOException sending message over propagated pipe: " + ex.getMessage());
                }
            }
        }
    }

    private Message createBroadcastMessage(ReplicationState state, boolean isResponse) {
        return ReplicationState.createBroadcastMessage(state, isResponse);
    }

    private Message createBroadcastMessage(ReplicationState state, boolean isResponse, String instanceName) {
        return ReplicationState.createBroadcastMessage(state, isResponse, instanceName);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        this.started = true;
    }

    protected void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        this.thread = new Thread((Runnable)this, this.getThreadName());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.started = false;
    }

    protected void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    @Override
    public void run() {
        while (!this.threadDone) {
        }
    }

    private boolean addToMap(Map map, ReplicationState state, boolean dupsAllowed) {
        boolean result = false;
        String id = state.getId().toString();
        ArrayList<ReplicationState> stateList = (ArrayList<ReplicationState>)map.get(id);
        if (stateList == null) {
            stateList = new ArrayList<ReplicationState>();
            map.put(id, stateList);
        }
        if (!dupsAllowed && !stateList.isEmpty()) {
            ReplicationState previousState = (ReplicationState)stateList.get(0);
            if (previousState.isAckRequired()) {
                state.setAckRequired(true);
            }
            stateList.set(0, state);
        } else {
            if (this.doesListContainAckRequiredState(stateList)) {
                state.setAckRequired(false);
            }
            stateList.add(state);
        }
        return result;
    }

    private boolean addToMapDupsAllowed(AtomicReference map, ReplicationState state, boolean wait) {
        state.setAckRequired(wait);
        String id = state.getId().toString();
        Map tempMap = (Map)map.get();
        boolean currentThreadShouldWait = false;
        boolean shouldContinue = true;
        do {
            ArrayList<ReplicationState> stateList;
            if ((stateList = (ArrayList<ReplicationState>)tempMap.get(id)) == null) {
                stateList = new ArrayList<ReplicationState>();
                tempMap.put(id, stateList);
            }
            boolean listAlreadyContainsAck = this.doesListContainAckRequiredState(stateList);
            if (state.isRemoveMethodState()) {
                stateList.clear();
                state.setAckRequired(listAlreadyContainsAck || wait);
            } else if (listAlreadyContainsAck) {
                state.setAckRequired(false);
            } else {
                state.setAckRequired(wait);
            }
            boolean bl = currentThreadShouldWait = wait && !listAlreadyContainsAck;
            if (currentThreadShouldWait) {
                LinkedBlockingQueue aQueue = ReplicationResponseRepository.putEmptyQueueEntry(state);
            }
            stateList.add(state);
            if (_logger.isLoggable(TRACE_LEVEL)) {
                _logger.log(TRACE_LEVEL, "addToMapDupsAllowed added state id: " + state.getId() + "[ver: " + state.getVersion() + "] to mapHashCode: " + System.identityHashCode(tempMap));
            }
            if (tempMap == this.currentMap.get()) {
                shouldContinue = false;
                if (!_logger.isLoggable(TRACE_LEVEL)) continue;
                _logger.log(TRACE_LEVEL, "addToMapDupsAllowed exiting... ");
                continue;
            }
            tempMap = (Map)this.currentMap.get();
        } while (shouldContinue);
        return currentThreadShouldWait;
    }

    private boolean addToMapNoDups(AtomicReference map, ReplicationState state, boolean wait) {
        Map tempMap = (Map)map.get();
        boolean currentThreadShouldWait = wait;
        boolean shouldContinue = true;
        do {
            currentThreadShouldWait = wait;
            boolean threadAlreadyWaiting = false;
            ReplicationState currentState = (ReplicationState)tempMap.get(state);
            if (currentState != null && currentState.isAckRequired()) {
                threadAlreadyWaiting = true;
                state.setAckRequired(true);
            } else {
                state.setAckRequired(wait);
                if (wait) {
                    LinkedBlockingQueue aQueue = ReplicationResponseRepository.putEmptyQueueEntry(state);
                    currentThreadShouldWait = true;
                }
            }
            tempMap.put(state, state);
            if (_logger.isLoggable(TRACE_LEVEL)) {
                _logger.log(TRACE_LEVEL, "addToMapNoDups added state id: " + state.getId() + "[ver: " + state.getVersion() + "] to mapHashCode: " + System.identityHashCode(tempMap));
            }
            if (tempMap == this.currentMapNoDupsAllowed.get()) {
                shouldContinue = false;
                if (!_logger.isLoggable(TRACE_LEVEL)) continue;
                _logger.log(TRACE_LEVEL, "addToMapNoDups exiting... ");
                continue;
            }
            tempMap = (Map)this.currentMapNoDupsAllowed.get();
        } while (shouldContinue);
        return currentThreadShouldWait;
    }

    private boolean doesListContainAckRequiredState(List stateList) {
        boolean result = false;
        for (int i = 0; i < stateList.size(); ++i) {
            ReplicationState nextState = (ReplicationState)stateList.get(i);
            if (nextState.isAckRequired()) {
                result = true;
            }
            if (result) break;
        }
        return result;
    }

    private boolean doesMapContainAckRequiredState(Map currentMap, ReplicationState state) {
        String id = state.getId().toString();
        List listForId = (List)currentMap.get(id);
        if (listForId == null) {
            return false;
        }
        return this.doesListContainAckRequiredState(listForId);
    }

    private void replicateState(ReplicationState state, boolean wait, boolean dupsAllowed) {
        if (dupsAllowed) {
            this.replicateStateDupsAllowed(state, wait);
        } else {
            this.replicateStateNoDupsAllowed(state, wait);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void replicateStateDupsAllowed(ReplicationState state, boolean wait) {
        ReplicationState returnState;
        boolean wakeupDispatcher;
        boolean messageInBulkAlreadyWaiting = false;
        boolean needsToWait = false;
        int latencyCountLimit = this.getLatencyCountLimit();
        int latencyCount = this.incrementLatencyCheckCount();
        needsToWait = this.shouldWait(wait, latencyCount, latencyCountLimit);
        if (needsToWait) {
            state.setAckRequired(needsToWait);
        }
        boolean thisThreadShouldWait = this.addToMapDupsAllowed(this.currentMap, state, needsToWait);
        if (((Map)this.currentMap.get()).size() >= 20 && (wakeupDispatcher = this.timeToChange.compareAndSet(false, true))) {
            this.dispatchThread.wakeup();
        }
        if (thisThreadShouldWait && (returnState = ReplicationResponseRepository.getEntry((String)state.getId())) != null) return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void replicateStateNoDupsAllowed(ReplicationState state, boolean wait) {
        ReplicationState returnState;
        boolean wakeupDispatcher;
        boolean needsToWait = false;
        int latencyCountLimit = this.getLatencyCountLimit();
        int latencyCount = this.incrementLatencyCheckCount();
        needsToWait = this.shouldWait(wait, latencyCount, latencyCountLimit);
        if (needsToWait) {
            state.setAckRequired(needsToWait);
        }
        boolean thisThreadShouldWait = this.addToMapNoDups(this.currentMapNoDupsAllowed, state, needsToWait);
        if (((Map)this.currentMapNoDupsAllowed.get()).size() >= 20 && (wakeupDispatcher = this.timeToChangeNoDupsAllowed.compareAndSet(false, true))) {
            this.dispatchThreadNoDupsAllowed.wakeup();
        }
        if (thisThreadShouldWait && (returnState = ReplicationResponseRepository.getEntry((String)state.getId())) != null) return;
    }

    private boolean timeThresholdExceeded(long thresholdDuration, long previousTime) {
        return System.currentTimeMillis() - previousTime > thresholdDuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushAllMessagesFromCurrentMap(boolean waitForAck) {
        boolean needBulkAck;
        Map oldMap = null;
        oldMap = (Map)this.currentMap.get();
        this.currentMap.set(new ConcurrentHashMap(2048, 0.75f, 100));
        this.lastChangeTime.set(System.currentTimeMillis());
        if (_logger.isLoggable(TRACE_LEVEL)) {
            _logger.log(TRACE_LEVEL, "flushAllMessagesFromCurrentMap flipped maps oldMapKey: " + System.identityHashCode(oldMap) + "currentMap.get()Key):" + System.identityHashCode(this.currentMap.get()));
        }
        this.timeToChange.set(false);
        ArrayList<ReplicationState> list = new ArrayList<ReplicationState>(oldMap.size() + 1);
        Iterator iter = oldMap.values().iterator();
        int totalMessageSize = 0;
        while (iter.hasNext()) {
            needBulkAck = false;
            List nextIdList = (List)iter.next();
            for (int i = 0; i < nextIdList.size(); ++i) {
                ReplicationState state = (ReplicationState)nextIdList.get(i);
                int stateSize = 0;
                if (state != null && !state.isSent()) {
                    if (state.isAckRequired()) {
                        needBulkAck = true;
                    }
                    if (state.getState() != null) {
                        stateSize = state.getState().length;
                    }
                }
                if (totalMessageSize + stateSize > 32768) {
                    this.doThreadedCreateMessageAndSend(list, needBulkAck);
                    list = new ArrayList(oldMap.size() + 1);
                    totalMessageSize = 0;
                }
                if (state == null || state.isSent()) continue;
                state.setSent(true);
                list.add(state);
                totalMessageSize += stateSize;
            }
        }
        if (list.size() > 0) {
            needBulkAck = this.doesListContainAckRequiredState(list);
            this.doThreadedCreateMessageAndSend(list, needBulkAck);
        }
        oldMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushAllMessagesFromCurrentMapNoDupsAllowed(boolean waitForAck) {
        boolean needBulkAck;
        Map oldMap = null;
        oldMap = (Map)this.currentMapNoDupsAllowed.get();
        this.currentMapNoDupsAllowed.set(new ConcurrentHashMap(2048, 0.75f, 100));
        this.lastChangeTimeNoDupsAllowed.set(System.currentTimeMillis());
        if (_logger.isLoggable(TRACE_LEVEL)) {
            _logger.log(TRACE_LEVEL, "flushAllMessagesFromCurrentMapNoDupsAllowed flipped maps oldMapKey: " + System.identityHashCode(oldMap) + "currentMapNoDupsAllowed.get()Key):" + System.identityHashCode(this.currentMapNoDupsAllowed.get()));
        }
        this.timeToChangeNoDupsAllowed.set(false);
        ArrayList<ReplicationState> list = new ArrayList<ReplicationState>(oldMap.size() + 1);
        Iterator iter = oldMap.values().iterator();
        int totalMessageSize = 0;
        while (iter.hasNext()) {
            needBulkAck = false;
            ReplicationState state = (ReplicationState)iter.next();
            int stateSize = 0;
            if (state != null && !state.isSent()) {
                if (state.isAckRequired()) {
                    needBulkAck = true;
                }
                if (state.getState() != null) {
                    stateSize = state.getState().length;
                }
            }
            if (totalMessageSize + stateSize > 32768) {
                this.doThreadedCreateMessageAndSend(list, needBulkAck);
                list = new ArrayList(oldMap.size() + 1);
                totalMessageSize = 0;
            }
            if (state != null && !state.isSent()) {
                state.setSent(true);
                list.add(state);
            }
            totalMessageSize += stateSize;
        }
        if (list.size() > 0) {
            needBulkAck = this.doesListContainAckRequiredState(list);
            this.doThreadedCreateMessageAndSend(list, needBulkAck);
        }
        oldMap.clear();
    }

    private void doThreadedCreateMessageAndSend(List list, boolean needBulkAck) {
        BulkMessageSender bulkMessageSender = new BulkMessageSender(list, needBulkAck);
        this.exec.execute(bulkMessageSender);
    }

    private void doThreadedMessageCallback(Message sentMessage, PipeWrapper pipeWrapper, boolean success) {
        BulkMessageAcker bulkMessageAcker = new BulkMessageAcker(sentMessage, pipeWrapper, success);
        this.exec.execute(bulkMessageAcker);
    }

    private static void displayList(List aList, String listName) {
        _logger.log(Level.INFO, "displaying " + listName + " list");
        for (int i = 0; i < aList.size(); ++i) {
            _logger.log(Level.INFO, "displayStringList:elem[" + i + "] = " + aList.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMessageAndSend(List<ReplicationState> list, boolean waitForAck, Object signalObject) {
        List<String> ackIdsList = ReplicationState.extractAckIdsList(list);
        byte[] data = null;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(list);
            oos.flush();
        }
        catch (IOException ioEx) {
        }
        finally {
            if (oos != null) {
                try {
                    oos.flush();
                    oos.close();
                }
                catch (Exception ex) {}
            }
            if (bos != null) {
                try {
                    bos.flush();
                    data = bos.toByteArray();
                    bos.close();
                }
                catch (Exception ex) {}
            }
        }
        if (_logger.isLoggable(TRACE_LEVEL)) {
            List<String> allIdsList = ReplicationState.extractAllIdsList(list);
            JxtaReplicationSender.displayList(allIdsList, "ids about to be sent");
        }
        int bulkMsgId = Math.abs(_messageIDCounter.incrementAndGet());
        this.sendBulkMessage(bulkMsgId, ackIdsList, data, waitForAck);
    }

    private boolean sendState(ReplicationState state) {
        return this.sendState(state, false);
    }

    private boolean sendState(ReplicationState state, boolean isResponse) {
        boolean result = true;
        state.setSendStartTime(System.currentTimeMillis());
        Message theMsg = this.createMessage(state, isResponse);
        boolean continueTrying = true;
        long waitTime = 5L;
        int counter = 0;
        while (continueTrying) {
            ++counter;
            waitTime *= 2L;
            try {
                result = this.sendOverPipe(theMsg);
                if (!result && waitTime < 1000L) continue;
                continueTrying = false;
                if (waitTime >= 1000L) {
                    result = false;
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("JxtaReplicationSender>>sendState:timed out trying to send message after trying to send on " + counter + " pipes");
                    }
                    System.out.println("JxtaReplicationSender>>sendState:timed out trying to send message after trying to send on " + counter + " pipes");
                    continue;
                }
                result = true;
            }
            catch (NullPointerException ex1) {
                result = false;
                continueTrying = false;
                System.out.println("JxtaReplicationSender>>sendState:caught NPE");
                break;
            }
        }
        if (!result) {
            System.out.println("JxtaReplicationSender>>sendState returning: " + result);
        }
        return result;
    }

    private ReplicationState sendBulkMessage(long msgID, List<String> ackIdsList, byte[] data, boolean wait) {
        boolean success;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JxtaReplicationSender>>sendBulkMessage:wait:" + wait);
        }
        ReplicationState returnState = null;
        if (!ReplicationHealthChecker.isOkToProceed()) {
            System.out.println("health check bypassing replication now");
            return returnState;
        }
        boolean ackRequired = wait;
        ReplicationState state = ReplicationState.createBulkReplicationState(msgID, ackIdsList, data, ackRequired);
        if (wait && !this.isWaitForFastAckConfigured() || ReplicationHealthChecker.isFlushThreadWaiting()) {
            LinkedBlockingQueue aQueue = ReplicationResponseRepository.putEmptyQueueEntry(state);
        }
        if (!(success = this.sendState(state))) {
            ReplicationHealthChecker.reportError("JxtaReplicationSender>>sendState failed");
        }
        if (wait && !this.isWaitForFastAckConfigured()) {
            returnState = ReplicationResponseRepository.getEntry((String)state.getId(), 5000L);
        }
        return returnState;
    }

    private class BulkMessageAcker
    implements Runnable {
        private Message sentMessage = null;
        private PipeWrapper pipeWrapper = null;
        private boolean success = false;

        public BulkMessageAcker(Message sentMessage, PipeWrapper pipeWrapper, boolean success) {
            this.sentMessage = sentMessage;
            this.pipeWrapper = pipeWrapper;
            this.success = success;
        }

        public void run() {
            if (this.success) {
                this.pipeWrapper.messageSendSucceeded(this.sentMessage);
            } else {
                this.pipeWrapper.messageSendFailed(this.sentMessage);
            }
        }
    }

    private class BulkMessageSender
    implements Runnable {
        private List list = null;
        private boolean needBulkAck = false;

        public BulkMessageSender(List list, boolean needBulkAck) {
            this.list = list;
            this.needBulkAck = needBulkAck;
        }

        public void run() {
            JxtaReplicationSender.this.createMessageAndSend(this.list, this.needBulkAck, null);
            this.list.clear();
        }
    }

    private class TimerDispatchThread
    extends TimerTask {
        public void run() {
            boolean wakeupDispatcher;
            boolean wakeupDispatcher2;
            long lastChangeTimeNoDups = JxtaReplicationSender.this.lastChangeTimeNoDupsAllowed.get();
            if (((Map)JxtaReplicationSender.this.currentMapNoDupsAllowed.get()).size() > 0 && JxtaReplicationSender.this.timeThresholdExceeded(DEFAULT_TIME_THRESHOLD, lastChangeTimeNoDups) && (wakeupDispatcher2 = JxtaReplicationSender.this.timeToChangeNoDupsAllowed.compareAndSet(false, true))) {
                JxtaReplicationSender.this.dispatchThreadNoDupsAllowed.wakeup();
            }
            long lastChangeTimeDups = JxtaReplicationSender.this.lastChangeTime.get();
            if (((Map)JxtaReplicationSender.this.currentMap.get()).size() > 0 && JxtaReplicationSender.this.timeThresholdExceeded(DEFAULT_TIME_THRESHOLD, lastChangeTimeDups) && (wakeupDispatcher = JxtaReplicationSender.this.timeToChange.compareAndSet(false, true))) {
                JxtaReplicationSender.this.dispatchThread.wakeup();
            }
        }
    }

    private class DispatchThreadNoDupsAllowed
    implements Runnable {
        private volatile boolean done = false;
        private Thread thread;
        private LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue();

        public DispatchThreadNoDupsAllowed() {
            this.thread = new Thread(this);
            this.thread.setDaemon(true);
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void wakeup() {
            Object object = JxtaReplicationSender.this.dispatchThreadNoDupsAllowedMonitorObject;
            synchronized (object) {
                JxtaReplicationSender.this.dispatchThreadNoDupsAllowedMonitorObject.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ReplicationHealthChecker.incrementDispatchThreadCount();
            boolean hasSignaled = false;
            while (!this.done) {
                try {
                    Object object = JxtaReplicationSender.this.dispatchThreadNoDupsAllowedMonitorObject;
                    synchronized (object) {
                        JxtaReplicationSender.this.dispatchThreadNoDupsAllowedMonitorObject.wait(50L);
                    }
                    long lastChangeTimeNoDups = JxtaReplicationSender.this.lastChangeTimeNoDupsAllowed.get();
                    if (!ReplicationHealthChecker.isFlushThreadWaiting()) {
                        if (((Map)JxtaReplicationSender.this.currentMapNoDupsAllowed.get()).size() <= 0 || !JxtaReplicationSender.this.timeThresholdExceeded(DEFAULT_TIME_THRESHOLD, lastChangeTimeNoDups)) continue;
                        JxtaReplicationSender.this.flushAllMessagesFromCurrentMapNoDupsAllowed(JxtaReplicationSender.this.isWaitForAckConfigured());
                        continue;
                    }
                    try {
                        if (((Map)JxtaReplicationSender.this.currentMapNoDupsAllowed.get()).size() <= 0) continue;
                        JxtaReplicationSender.this.flushAllMessagesFromCurrentMapNoDupsAllowed(JxtaReplicationSender.this.isWaitForAckConfigured());
                    }
                    finally {
                        if (hasSignaled) continue;
                        CountDownLatch doneSignal = ReplicationHealthChecker.getDoneSignal();
                        doneSignal.countDown();
                        hasSignaled = true;
                    }
                }
                catch (InterruptedException inEx) {
                    this.done = true;
                }
                catch (Throwable t) {
                    _logger.log(Level.INFO, "nodup thread exception:", t);
                }
                finally {
                    if (!this.done || hasSignaled) continue;
                    CountDownLatch doneSignal = ReplicationHealthChecker.getDoneSignal();
                    doneSignal.countDown();
                    hasSignaled = true;
                }
            }
        }
    }

    private class DispatchThread
    implements Runnable {
        private volatile boolean done = false;
        private Thread thread;
        private LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue();

        public DispatchThread() {
            this.thread = new Thread(this);
            this.thread.setDaemon(true);
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void wakeup() {
            Object object = JxtaReplicationSender.this.dispatchThreadMonitorObject;
            synchronized (object) {
                JxtaReplicationSender.this.dispatchThreadMonitorObject.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ReplicationHealthChecker.incrementDispatchThreadCount();
            boolean hasSignaled = false;
            while (!this.done) {
                try {
                    Object object = JxtaReplicationSender.this.dispatchThreadMonitorObject;
                    synchronized (object) {
                        JxtaReplicationSender.this.dispatchThreadMonitorObject.wait(50L);
                    }
                    long lastChangeTimeDups = JxtaReplicationSender.this.lastChangeTime.get();
                    if (!ReplicationHealthChecker.isFlushThreadWaiting()) {
                        if (((Map)JxtaReplicationSender.this.currentMap.get()).size() <= 0 || !JxtaReplicationSender.this.timeThresholdExceeded(DEFAULT_TIME_THRESHOLD, lastChangeTimeDups)) continue;
                        JxtaReplicationSender.this.flushAllMessagesFromCurrentMap(JxtaReplicationSender.this.isWaitForAckConfigured());
                        continue;
                    }
                    try {
                        if (((Map)JxtaReplicationSender.this.currentMap.get()).size() <= 0) continue;
                        JxtaReplicationSender.this.flushAllMessagesFromCurrentMap(JxtaReplicationSender.this.isWaitForAckConfigured());
                    }
                    finally {
                        if (hasSignaled) continue;
                        CountDownLatch doneSignal = ReplicationHealthChecker.getDoneSignal();
                        doneSignal.countDown();
                        hasSignaled = true;
                    }
                }
                catch (InterruptedException inEx) {
                    this.done = true;
                }
                catch (Throwable t) {
                    _logger.log(Level.INFO, "dups allowed thread exception:", t);
                }
                finally {
                    if (!this.done || hasSignaled) continue;
                    CountDownLatch doneSignal = ReplicationHealthChecker.getDoneSignal();
                    doneSignal.countDown();
                    hasSignaled = true;
                }
            }
        }
    }
}

