/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.web.sessmgmt.JxtaReplicationReceiver;
import com.sun.enterprise.ee.web.sessmgmt.PendingJoin;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationHealthChecker;
import com.sun.enterprise.web.ServerConfigLookup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class JoinNotificationEventHandler
implements CallBack {
    protected static final String SENDER_PIPE = "S";
    protected static final String RECEIVER_PIPE = "R";
    private static HashMap pendingJoinsOld = new HashMap();
    private static HashMap pendingJoins = new HashMap();
    private static AtomicBoolean processingJoinFlag = new AtomicBoolean(false);

    public void processNotification(Signal notification) {
        String newPartnerInstance = notification.getMemberToken();
        System.out.println("Received Join Notification: " + newPartnerInstance);
        System.out.println("Received Join Notification: adding pending join for" + newPartnerInstance);
        JoinNotificationEventHandler.addPendingJoin(newPartnerInstance);
    }

    static boolean isJoinPendingOld(String instanceName) {
        long timeNow = System.currentTimeMillis();
        Long pendingJoinTimeMillis = (Long)pendingJoinsOld.get(instanceName);
        if (pendingJoinTimeMillis != null && timeNow - pendingJoinTimeMillis < 300000L) {
            System.out.println("join is pending");
            JoinNotificationEventHandler.removePendingJoinOld(instanceName);
            return true;
        }
        System.out.println("join is not pending or more than 5 min old");
        return false;
    }

    static void addPendingJoinOld(String instanceName) {
        pendingJoinsOld.put(instanceName, new Long(System.currentTimeMillis()));
    }

    static void removePendingJoinOld(String instanceName) {
        pendingJoinsOld.remove(instanceName);
    }

    static void checkAndDoJoinForOld(String newPartnerInstance) {
        if (!JoinNotificationEventHandler.isJoinPendingOld(newPartnerInstance)) {
            return;
        }
        if (!ReplicationHealthChecker.isStopping()) {
            JxtaReplicationReceiver jxtaReplicationReceiver = (JxtaReplicationReceiver)ReplicationHealthChecker.getReplicationReceiver();
            System.out.println("join notification AND readiness causing call to reconnect sender side");
            jxtaReplicationReceiver.connectSenderSideToNew(newPartnerInstance);
        }
    }

    static boolean isJoinPending(String instanceName) {
        long timeNow = System.currentTimeMillis();
        PendingJoin pendingJoin = (PendingJoin)pendingJoins.get(instanceName);
        if (pendingJoin == null) {
            return false;
        }
        long pendingJoinTimeMillis = pendingJoin.getCreationTime();
        if (pendingJoin.isValid() || timeNow - pendingJoinTimeMillis < 300000L) {
            System.out.println("join is pending");
            pendingJoin.setValid(true);
            return true;
        }
        System.out.println("join is not pending or more than 5 min old");
        JoinNotificationEventHandler.removePendingJoin(instanceName);
        return false;
    }

    static void addPendingJoin(String instanceName) {
        PendingJoin pendingJoin = new PendingJoin(instanceName, System.currentTimeMillis());
        pendingJoins.put(instanceName, pendingJoin);
    }

    static void removePendingJoin(String instanceName) {
        pendingJoins.remove(instanceName);
    }

    static void checkAndDoJoinFor(String newPartnerInstance) {
        if (ReplicationHealthChecker.isStopping()) {
            return;
        }
        if (!JoinNotificationEventHandler.isJoinPending(newPartnerInstance)) {
            JoinNotificationEventHandler.addPendingJoin(newPartnerInstance);
        }
        if (JoinNotificationEventHandler.reserveProcessingJoin()) {
            System.out.println("got reservation:entering doProcessJoin:instanceName:" + newPartnerInstance);
            JoinNotificationEventHandler.doProcessJoin(newPartnerInstance);
        } else {
            System.out.println("refused reservation:entering doPollCheckForJoinProcessing");
            JoinNotificationEventHandler.doPollCheckForJoinProcessing(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doProcessJoin(String newPartnerInstance) {
        long startTime = System.currentTimeMillis();
        System.out.println("In doProcessJoin:newPartnerInstance = " + newPartnerInstance + " this instance = " + JoinNotificationEventHandler.getInstanceName());
        JxtaReplicationReceiver jxtaReplicationReceiver = (JxtaReplicationReceiver)ReplicationHealthChecker.getReplicationReceiver();
        System.out.println("join notification AND readiness causing call to reconnect sender side");
        try {
            jxtaReplicationReceiver.connectSenderSideToNew(newPartnerInstance);
        }
        finally {
            JoinNotificationEventHandler.removePendingJoin(newPartnerInstance);
            JoinNotificationEventHandler.setProcessingJoin(false);
            System.out.println("doProcessJoin: this instance = " + JoinNotificationEventHandler.getInstanceName() + " for: " + newPartnerInstance + " took " + (System.currentTimeMillis() - startTime) + " millis");
        }
    }

    private static void doPollCheckForJoinProcessing(long sleepTime) {
        System.out.println("In doPollCheckForJoinProcessing");
        boolean shouldContinue = true;
        while (shouldContinue) {
            try {
                Thread.currentThread().wait(sleepTime);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            PendingJoin nextPendingJoin = JoinNotificationEventHandler.getNextPendingJoin();
            if (nextPendingJoin == null) {
                shouldContinue = false;
                break;
            }
            String nextPartnerInstance = nextPendingJoin.getInstanceName();
            JoinNotificationEventHandler.checkAndDoJoinFor(nextPartnerInstance);
        }
    }

    private static PendingJoin getNextPendingJoin() {
        PendingJoin result = null;
        ArrayList<String> pendingJoinsToBeRemoved = new ArrayList<String>();
        Collection pendJoins = pendingJoins.values();
        for (PendingJoin nextPendingJoin : pendJoins) {
            if (nextPendingJoin.isCandidateForRemoval(30000L)) {
                pendingJoinsToBeRemoved.add(nextPendingJoin.getInstanceName());
                continue;
            }
            if (result == null) {
                result = nextPendingJoin;
                continue;
            }
            if (nextPendingJoin.getCreationTime() >= result.getCreationTime()) continue;
            result = nextPendingJoin;
        }
        JoinNotificationEventHandler.removeAll(pendingJoinsToBeRemoved);
        return result;
    }

    private static void removeAll(ArrayList removeList) {
        for (int i = 0; i < removeList.size(); ++i) {
            String nextInstanceName = (String)removeList.get(i);
            JoinNotificationEventHandler.removePendingJoin(nextInstanceName);
        }
    }

    public static boolean isProcessingJoin() {
        return processingJoinFlag.get();
    }

    public static boolean reserveProcessingJoin() {
        return processingJoinFlag.compareAndSet(false, true);
    }

    public static void setProcessingJoin(boolean value) {
        processingJoinFlag.set(value);
    }

    static String getInstanceName() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        return lookup.getServerName();
    }
}

