/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.enterprise.ee.web.initialization.ServerConfigReader;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationManagerBase;
import com.sun.enterprise.ee.web.sessmgmt.WebModuleStatistics;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.logging.LogDomains;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.session.IOUtilsCaller;
import org.apache.catalina.session.StoreBase;
import org.apache.catalina.session.WebIOUtilsFactory;

public abstract class HAStoreBase
extends StoreBase {
    protected int _debug = 0;
    protected Level _logLevel = null;
    protected String applicationId = null;
    protected String clusterId = null;
    private IOUtilsCaller webUtilsCaller = null;
    protected static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");

    protected void debug(String message) {
        this.log(message);
        System.out.println(message);
    }

    protected void setLogLevel() {
        Level level;
        this._logLevel = level = _logger.getLevel();
        this._debug = level.equals(Level.FINE) ? 1 : (level.equals(Level.FINER) ? 2 : (level.equals(Level.FINEST) ? 5 : 0));
    }

    public String getApplicationId() {
        if (this.applicationId != null) {
            return this.applicationId;
        }
        StringBuffer sb = new StringBuffer(50);
        sb.append(this.getClusterId());
        ArrayList<String> list = new ArrayList<String>();
        for (Container container = this.manager.getContainer(); container != null; container = container.getParent()) {
            if (container.getName() == null) continue;
            list.add(":" + container.getName());
        }
        for (int i = list.size() - 1; i > -1; --i) {
            String nextString = (String)list.get(i);
            sb.append(nextString);
        }
        this.applicationId = sb.toString();
        return this.applicationId;
    }

    protected String getClusterIdFromConfig() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        return lookup.getClusterIdFromConfig();
    }

    protected String getClusterId() {
        if (this.clusterId == null) {
            this.clusterId = this.getClusterIdFromConfig();
        }
        return this.clusterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getByteArray(Session session) throws IOException {
        byte[] obs;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        IOUtilsCaller utilsCaller = null;
        try {
            bos = new ByteArrayOutputStream();
            utilsCaller = this.getWebUtilsCaller();
            if (utilsCaller != null) {
                try {
                    oos = utilsCaller.createObjectOutputStream((OutputStream)new BufferedOutputStream(bos), true);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (oos == null) {
                oos = new ObjectOutputStream(new BufferedOutputStream(bos));
            }
            this.writeSession(session, oos);
            oos.close();
            oos = null;
            obs = bos.toByteArray();
            boolean isMonitoringEnabled = ServerConfigReader.isMonitoringEnabled();
            if (isMonitoringEnabled) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("IN HAStoreBase>>getInputStream for monitoring");
                }
                ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
                WebModuleStatistics stats = mgr.getWebModuleStatistics();
                stats.processSessionSize(obs.length);
            }
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
        return obs;
    }

    public void remove(String id) throws IOException {
        if (this._debug > 0) {
            this.debug("in remove");
        }
        if (id == null) {
            if (this._debug > 0) {
                this.debug("In remove, got a null id");
            }
            return;
        }
        Manager mgr = this.getManager();
        if (mgr instanceof ReplicationManagerBase) {
            ReplicationManagerBase pMgr = (ReplicationManagerBase)mgr;
            pMgr.doRemove(id);
        } else {
            this.removeSynchronized(id);
        }
    }

    public void doRemove(String id) throws IOException {
    }

    public synchronized void removeSynchronized(String id) throws IOException {
    }

    public int getSize() throws IOException {
        return 0;
    }

    protected IOUtilsCaller getWebUtilsCaller() {
        if (this.webUtilsCaller == null) {
            WebIOUtilsFactory factory = new WebIOUtilsFactory();
            this.webUtilsCaller = factory.createWebIOUtil();
        }
        return this.webUtilsCaller;
    }
}

